/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.CancellableStage;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyTaskCallback;
import com.ibm.ws.threading.PolicyTaskFuture;
import com.ibm.ws.threading.StartTimeoutException;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.PolicyTaskFutureImpl;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ReduceableSemaphore;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PolicyExecutorImpl
implements PolicyExecutor {
    private static final TraceComponent tc = Tr.register(PolicyExecutorImpl.class, (String)"concurrencyPolicy", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    private final AtomicReference<Callback> cbConcurrency = new AtomicReference();
    private final AtomicReference<Callback> cbLateStart = new AtomicReference();
    private final AtomicReference<Callback> cbQueueSize = new AtomicReference();
    private final Integer configLock = new Integer(0);
    private int expedite;
    private final AtomicInteger expeditesAvailable = new AtomicInteger();
    ExecutorServiceImpl globalExecutor;
    String identifier;
    private int maxConcurrency;
    private final ReduceableSemaphore maxConcurrencyConstraint = new ReduceableSemaphore(0, false);
    private volatile PolicyExecutor.MaxPolicy maxPolicy = PolicyExecutor.MaxPolicy.loose;
    private int maxQueueSize;
    final ReduceableSemaphore maxQueueSizeConstraint = new ReduceableSemaphore(0, false);
    private final AtomicLong maxWaitForEnqueueNS = new AtomicLong();
    public final String owner;
    private final ConcurrentHashMap<String, PolicyExecutorImpl> policyExecutors;
    final ConcurrentLinkedQueue<PolicyTaskFutureImpl<?>> queue = new ConcurrentLinkedQueue();
    private volatile boolean runIfQueueFull;
    private final Set<PolicyTaskFutureImpl<?>> running = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger runningCount = new AtomicInteger();
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final CountDownLatch shutdownNowLatch = new CountDownLatch(1);
    private volatile long startTimeout = -1L;
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACTIVE);
    private final AtomicInteger withheldConcurrency = new AtomicInteger();
    static final long serialVersionUID = 1907336888054813595L;

    public PolicyExecutorImpl(ExecutorServiceImpl globalExecutor, String identifier, String owner, ConcurrentHashMap<String, PolicyExecutorImpl> policyExecutors) {
        this.globalExecutor = globalExecutor;
        this.identifier = identifier;
        this.owner = owner;
        this.policyExecutors = policyExecutors;
        this.maxConcurrency = Integer.MAX_VALUE;
        this.maxConcurrencyConstraint.release(Integer.MAX_VALUE);
        this.maxQueueSize = Integer.MAX_VALUE;
        this.maxQueueSizeConstraint.release(Integer.MAX_VALUE);
        if (policyExecutors.putIfAbsent(this.identifier, this) != null) {
            throw new IllegalStateException(this.identifier);
        }
    }

    private int acquireExpedite() {
        int a;
        while ((a = this.expeditesAvailable.get()) > 0 && !this.expeditesAvailable.compareAndSet(a, a - 1)) {
        }
        return a;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long remaining;
        long start = System.nanoTime();
        switch (this.state.get()) {
            case TASKS_CANCELING: {
                if (this.shutdownNowLatch.await(timeout, unit)) break;
                return false;
            }
            case ACTIVE: 
            case ENQUEUE_STOPPING: {
                if (this.shutdownLatch.await(timeout, unit)) break;
                return false;
            }
        }
        long pollInterval = TimeUnit.MILLISECONDS.toNanos(500L);
        timeout = timeout < 0L ? 0L : unit.toNanos(timeout);
        boolean firstTime = true;
        long waitTime = System.nanoTime() - start;
        while ((remaining = timeout - waitTime) > 0L || firstTime) {
            if (firstTime) {
                firstTime = false;
            }
            State currentState = this.state.get();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"awaitTermination", (Object[])new Object[]{remaining, currentState});
            }
            switch (currentState) {
                case TERMINATED: {
                    return true;
                }
                case TASKS_CANCELING: 
                case ENQUEUE_STOPPED: 
                case TASKS_CANCELED: {
                    if (this.queue.isEmpty()) {
                        if (!(remaining > 0L ? this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency, remaining < pollInterval ? remaining : pollInterval, TimeUnit.NANOSECONDS) : this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency))) break;
                        State previous = this.state.getAndSet(State.TERMINATED);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("state: " + (Object)((Object)previous) + " --> TERMINATED"), (Object[])new Object[0]);
                        }
                        return true;
                    }
                    if (remaining <= 0L) break;
                    TimeUnit.NANOSECONDS.sleep(remaining < pollInterval ? remaining : pollInterval);
                    break;
                }
            }
            waitTime = System.nanoTime() - start;
        }
        return this.state.get() == State.TERMINATED;
    }

    @Override
    public int cancel(String identifier, boolean interruptIfRunning) {
        int count = 0;
        PolicyTaskFutureImpl<?> f = this.queue.poll();
        while (f != null) {
            if (f.cancel(false)) {
                ++count;
            }
            f = this.queue.poll();
        }
        Iterator<PolicyTaskFutureImpl<?>> it = this.running.iterator();
        while (it.hasNext()) {
            if (!it.next().cancel(interruptIfRunning)) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor expedite(int num) {
        int a;
        if (num == -1) {
            num = Integer.MAX_VALUE;
        } else if (num < 0) {
            throw new IllegalArgumentException(Integer.toString(num));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (num > this.maxConcurrency) {
                throw new IllegalArgumentException("expedite: " + num + " > maxConcurrency: " + this.maxConcurrency);
            }
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"expedite", this.identifier}));
            }
            a = this.expeditesAvailable.addAndGet(num - this.expedite);
            this.expedite = num;
        }
        if (a > 0) {
            while (a-- > 0 && this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
                if (this.acquireExpedite() > 0) {
                    this.decrementWithheldConcurrency();
                    this.expediteGlobal(new GlobalPoolTask());
                    continue;
                }
                this.maxConcurrencyConstraint.release();
                break;
            }
        }
        return this;
    }

    @Trivial
    private void decrementWithheldConcurrency() {
        int w;
        while ((w = this.withheldConcurrency.get()) > 0 && !this.withheldConcurrency.compareAndSet(w, w - 1)) {
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("withheld concurrency " + w + " --> " + (w == 0 ? 0 : w - 1)), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class, RejectedExecutionException.class})
    private boolean enqueue(PolicyTaskFutureImpl<?> policyTaskFuture, long wait, Boolean runIfQueueFullOverride) {
        boolean enqueued;
        block29: {
            try {
                boolean haveQueuePermit = this.maxQueueSizeConstraint.tryAcquire();
                if (!haveQueuePermit && this.state.get() == State.ACTIVE) {
                    long now;
                    long nextTimeout = now = System.nanoTime();
                    long waitEnd = wait > 0L ? now + wait : now;
                    do {
                        Iterator<PolicyTaskFutureImpl<?>> it = this.queue.iterator();
                        while (!haveQueuePermit && it.hasNext()) {
                            PolicyTaskFutureImpl<?> future = it.next();
                            long startBy = future.nsStartBy;
                            if (startBy == future.nsAcceptBegin - 1L) continue;
                            if (now - startBy >= 0L) {
                                if (!this.queue.remove(future)) continue;
                                future.nsRunEnd = future.nsQueueEnd = System.nanoTime();
                                future.abort(false, new StartTimeoutException(future.getIdentifier(), future.getTaskName(), future.nsQueueEnd - future.nsAcceptBegin, future.nsStartBy - future.nsAcceptBegin));
                                this.maxQueueSizeConstraint.release();
                                haveQueuePermit = this.maxQueueSizeConstraint.tryAcquire();
                                continue;
                            }
                            if (nextTimeout - startBy <= 0L && nextTimeout != now) continue;
                            nextTimeout = startBy;
                        }
                        if (haveQueuePermit) continue;
                        long remain = waitEnd - System.nanoTime();
                        if (remain <= 0L) break;
                        long w = nextTimeout == now || nextTimeout - now > remain ? remain : nextTimeout - now;
                        long l = w = w < TimeUnit.SECONDS.toNanos(1L) ? w : TimeUnit.SECONDS.toNanos(1L);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("incremental wait for enqueue of " + w + "ns"), (Object[])new Object[0]);
                        }
                        haveQueuePermit = this.maxQueueSizeConstraint.tryAcquire(w, TimeUnit.NANOSECONDS);
                        nextTimeout = now = System.nanoTime();
                    } while (!haveQueuePermit && waitEnd - now > 0L);
                }
                if (haveQueuePermit) {
                    Callback callback = this.cbQueueSize.get();
                    if (callback != null && (long)this.maxQueueSizeConstraint.availablePermits() < callback.threshold && this.cbQueueSize.compareAndSet(callback, null)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: queue capacity < " + callback.threshold), (Object[])new Object[]{callback.runnable});
                        }
                        this.globalExecutor.submit(callback.runnable);
                    }
                    policyTaskFuture.accept(false);
                    enqueued = this.queue.offer(policyTaskFuture);
                    int w = this.withheldConcurrency.incrementAndGet();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("withheld concurrency --> " + w), (Object[])new Object[0]);
                    }
                    if (this.maxConcurrencyConstraint.tryAcquire()) {
                        this.decrementWithheldConcurrency();
                        if (this.acquireExpedite() > 0) {
                            this.expediteGlobal(new GlobalPoolTask());
                        } else {
                            this.enqueueGlobal(new GlobalPoolTask());
                        }
                    }
                    if (this.state.get() != State.ACTIVE && this.queue.remove(policyTaskFuture)) {
                        policyTaskFuture.nsRunEnd = policyTaskFuture.nsQueueEnd = System.nanoTime();
                        throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{policyTaskFuture.getIdentifier()}));
                    }
                    break block29;
                }
                if (this.state.get() == State.ACTIVE) {
                    boolean haveConcurrencyPermit = false;
                    if (policyTaskFuture.nsStartBy != policyTaskFuture.nsAcceptBegin - 1L && System.nanoTime() - policyTaskFuture.nsStartBy >= 0L) {
                        throw new RejectedExecutionException(new StartTimeoutException(policyTaskFuture.getIdentifier(), policyTaskFuture.getTaskName(), policyTaskFuture.nsQueueEnd - policyTaskFuture.nsAcceptBegin, policyTaskFuture.nsStartBy - policyTaskFuture.nsAcceptBegin));
                    }
                    if (Boolean.TRUE.equals(runIfQueueFullOverride) || !Boolean.FALSE.equals(runIfQueueFullOverride) && this.runIfQueueFull && (this.maxPolicy == PolicyExecutor.MaxPolicy.loose || (haveConcurrencyPermit = this.maxConcurrencyConstraint.tryAcquire()))) {
                        try {
                            policyTaskFuture.accept(true);
                            this.runTask(policyTaskFuture);
                            enqueued = false;
                            break block29;
                        }
                        finally {
                            if (haveConcurrencyPermit) {
                                this.transferOrReleasePermit();
                            }
                        }
                    }
                    throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1201.queue.full.abort", (Object[])new Object[]{policyTaskFuture.getIdentifier(), this.maxQueueSize, wait}));
                }
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{policyTaskFuture.getIdentifier()}));
            }
            catch (InterruptedException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                policyTaskFuture.abort(false, x);
                throw new RejectedExecutionException(x);
            }
            catch (RejectedExecutionException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                policyTaskFuture.abort(false, x);
                throw x;
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"532", (Object)this, (Object[])new Object[]{policyTaskFuture, wait, runIfQueueFullOverride});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                policyTaskFuture.abort(true, x);
                throw x;
            }
            catch (Error x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"537", (Object)this, (Object[])new Object[]{policyTaskFuture, wait, runIfQueueFullOverride});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                policyTaskFuture.abort(true, x);
                throw x;
            }
        }
        return enqueued;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void enqueueGlobal(GlobalPoolTask globalTask) {
        globalTask.expedite = false;
        boolean submitted = false;
        try {
            this.globalExecutor.executeWithoutInterceptors(globalTask);
            return;
        }
        catch (Throwable throwable) {
            if (submitted) throw throwable;
            this.maxConcurrencyConstraint.release();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw throwable;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"expedites/maxConcurrency available", (Object[])new Object[]{this.expeditesAvailable, this.maxConcurrencyConstraint.availablePermits()});
            throw throwable;
        }
    }

    @Override
    public void execute(Runnable command) {
        this.enqueue(new PolicyTaskFutureImpl<Object>(this, command, null, null, this.startTimeout), this.maxWaitForEnqueueNS.get(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expediteGlobal(GlobalPoolTask globalTask) {
        block5: {
            int cca;
            globalTask.expedite = true;
            boolean submitted = false;
            try {
                this.globalExecutor.executeWithoutInterceptors(globalTask);
                submitted = true;
                if (submitted) break block5;
                cca = this.expeditesAvailable.incrementAndGet();
            }
            catch (Throwable throwable) {
                if (!submitted) {
                    int cca2 = this.expeditesAvailable.incrementAndGet();
                    this.maxConcurrencyConstraint.release();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"expedites/maxConcurrency available", (Object[])new Object[]{cca2, this.maxConcurrencyConstraint.availablePermits()});
                    }
                }
                throw throwable;
            }
            this.maxConcurrencyConstraint.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"expedites/maxConcurrency available", (Object[])new Object[]{cca, this.maxConcurrencyConstraint.availablePermits()});
            }
        }
    }

    @Override
    @Trivial
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRunningTaskCount() {
        return this.runningCount.get();
    }

    @Override
    @Trivial
    public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, null);
    }

    @Override
    @Trivial
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.invokeAll(tasks, null, timeout, unit);
    }

    @Override
    @FFDCIgnore(value={RejectedExecutionException.class})
    public <T> List<PolicyTaskFuture<T>> invokeAll(Collection<? extends Callable<T>> tasks, PolicyTaskCallback[] callbacks) throws InterruptedException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int taskCount = tasks.size();
        boolean havePermit = false;
        boolean useCurrentThread = this.maxPolicy == PolicyExecutor.MaxPolicy.loose || (havePermit = taskCount > 0 && this.maxConcurrencyConstraint.tryAcquire());
        ArrayList<PolicyTaskFuture<T>> futures = new ArrayList<PolicyTaskFuture<T>>(taskCount);
        try {
            int t = 0;
            for (Callable<T> callable : tasks) {
                PolicyTaskCallback policyTaskCallback = callbacks == null ? null : callbacks[t++];
                PolicyExecutorImpl executor = policyTaskCallback == null ? this : (PolicyExecutorImpl)policyTaskCallback.getExecutor(this);
                long startTimeoutNS = policyTaskCallback == null ? this.startTimeout : policyTaskCallback.getStartTimeout(executor.startTimeout);
                futures.add(new PolicyTaskFutureImpl<T>(executor, callable, policyTaskCallback, startTimeoutNS));
            }
            int numToSubmitAsync = useCurrentThread ? taskCount - 1 : taskCount;
            t = 0;
            for (PolicyTaskFutureImpl policyTaskFutureImpl : futures) {
                if (t++ < numToSubmitAsync || policyTaskFutureImpl.executor != this) {
                    boolean enqueued = useCurrentThread && policyTaskFutureImpl.executor == this ? policyTaskFutureImpl.executor.enqueue(policyTaskFutureImpl, 0L, true) : policyTaskFutureImpl.executor.enqueue(policyTaskFutureImpl, policyTaskFutureImpl.executor.maxWaitForEnqueueNS.get(), null);
                    if (enqueued) continue;
                    policyTaskFutureImpl.throwIfInterrupted();
                    continue;
                }
                policyTaskFutureImpl.accept(true);
            }
            if (useCurrentThread) {
                for (t = numToSubmitAsync; t >= 0; --t) {
                    PolicyTaskFutureImpl policyTaskFutureImpl = (PolicyTaskFutureImpl)futures.get(t);
                    State state = policyTaskFutureImpl.executor.state.get();
                    if (policyTaskFutureImpl.executor == this && t == numToSubmitAsync) {
                        if (state != State.ACTIVE) {
                            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{policyTaskFutureImpl.getIdentifier()}));
                        }
                    } else if (policyTaskFutureImpl.executor == this && !policyTaskFutureImpl.isDone() && state.canStartTask && this.queue.remove(policyTaskFutureImpl)) {
                        this.maxQueueSizeConstraint.release();
                        policyTaskFutureImpl.nsQueueEnd = System.nanoTime();
                    } else {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"no longer in queue, or this executor is unable to run it", (Object[])new Object[]{policyTaskFutureImpl});
                        continue;
                    }
                    if (policyTaskFutureImpl.nsStartBy != policyTaskFutureImpl.nsAcceptBegin - 1L && policyTaskFutureImpl.nsStartBy - policyTaskFutureImpl.nsQueueEnd <= 0L) {
                        policyTaskFutureImpl.nsRunEnd = policyTaskFutureImpl.nsQueueEnd;
                        RejectedExecutionException x = new RejectedExecutionException(new StartTimeoutException(policyTaskFutureImpl.getIdentifier(), policyTaskFutureImpl.getTaskName(), policyTaskFutureImpl.nsQueueEnd - policyTaskFutureImpl.nsAcceptBegin, policyTaskFutureImpl.nsStartBy - policyTaskFutureImpl.nsAcceptBegin));
                        policyTaskFutureImpl.abort(false, x);
                        throw x;
                    }
                    this.runTask(policyTaskFutureImpl);
                    policyTaskFutureImpl.throwIfInterrupted();
                }
            }
            for (PolicyTaskFutureImpl policyTaskFutureImpl : futures) {
                policyTaskFutureImpl.await();
                --taskCount;
            }
        }
        catch (RejectedExecutionException x) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rejected", (Object[])new Object[]{x});
            }
            if (x.getCause() instanceof InterruptedException) {
                throw (InterruptedException)x.getCause();
            }
            throw x;
        }
        finally {
            if (havePermit) {
                this.transferOrReleasePermit();
            }
            if (taskCount != 0) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        ArrayList<PolicyTaskFuture<T>> list = futures;
        return list;
    }

    @Override
    @FFDCIgnore(value={RejectedExecutionException.class})
    public <T> List<PolicyTaskFuture<T>> invokeAll(Collection<? extends Callable<T>> tasks, PolicyTaskCallback[] callbacks, long timeout, TimeUnit unit) throws InterruptedException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int taskCount = tasks.size();
        long stop = System.nanoTime() + unit.toNanos(timeout);
        ArrayList<PolicyTaskFuture<T>> futures = new ArrayList<PolicyTaskFuture<T>>(taskCount);
        try {
            PolicyTaskFutureImpl policyTaskFutureImpl;
            int t = 0;
            for (Callable<T> callable : tasks) {
                PolicyTaskCallback callback = callbacks == null ? null : callbacks[t++];
                PolicyExecutorImpl executor = callback == null ? this : (PolicyExecutorImpl)callback.getExecutor(this);
                long startTimeoutNS = callback == null ? this.startTimeout : callback.getStartTimeout(executor.startTimeout);
                futures.add(new PolicyTaskFutureImpl<T>(executor, callable, callback, startTimeoutNS));
            }
            for (PolicyTaskFutureImpl policyTaskFutureImpl2 : futures) {
                long remaining = stop - System.nanoTime();
                if (remaining <= 0L) {
                    throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1204.unable.to.invoke", (Object[])new Object[]{policyTaskFutureImpl2.getIdentifier(), taskCount - futures.indexOf(policyTaskFutureImpl2) + 1, taskCount, timeout, unit}));
                }
                long qWait = policyTaskFutureImpl2.executor.maxWaitForEnqueueNS.get();
                policyTaskFutureImpl2.executor.enqueue(policyTaskFutureImpl2, qWait < remaining ? qWait : remaining, false);
            }
            Iterator<Callable<Object>> iterator = futures.iterator();
            while (iterator.hasNext() && (policyTaskFutureImpl = (PolicyTaskFutureImpl)((Object)iterator.next())).await(stop - System.nanoTime(), TimeUnit.NANOSECONDS) > 2) {
                --taskCount;
            }
        }
        catch (RejectedExecutionException x) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rejected", (Object[])new Object[]{x});
            }
            if (x.getCause() instanceof InterruptedException) {
                throw (InterruptedException)x.getCause();
            }
            throw x;
        }
        finally {
            if (taskCount != 0) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        ArrayList<PolicyTaskFuture<T>> list = futures;
        return list;
    }

    @Override
    @Trivial
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.invokeAny(tasks, null);
    }

    @Override
    @Trivial
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(tasks, null, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={RejectedExecutionException.class})
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, PolicyTaskCallback[] callbacks) throws InterruptedException, ExecutionException {
        int taskCount = tasks.size();
        if (taskCount == 1) {
            boolean havePermit = false;
            if (this.maxPolicy == PolicyExecutor.MaxPolicy.loose || (havePermit = this.maxConcurrencyConstraint.tryAcquire())) {
                try {
                    if (this.state.get() != State.ACTIVE) {
                        throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{this.identifier}));
                    }
                    PolicyTaskFutureImpl<T> taskFuture = new PolicyTaskFutureImpl<T>(this, tasks.iterator().next(), callbacks == null ? null : callbacks[0], -1L);
                    taskFuture.accept(true);
                    this.runTask(taskFuture);
                    taskFuture.throwIfInterrupted();
                    T t = taskFuture.get();
                    return t;
                }
                finally {
                    if (havePermit) {
                        this.transferOrReleasePermit();
                    }
                }
            }
        } else if (taskCount == 0) {
            throw new IllegalArgumentException();
        }
        PolicyTaskFutureImpl.InvokeAnyLatch latch = new PolicyTaskFutureImpl.InvokeAnyLatch(taskCount);
        ArrayList futures = new ArrayList(taskCount);
        try {
            int t = 0;
            for (Callable<T> callable : tasks) {
                PolicyTaskCallback callback = callbacks == null ? null : callbacks[t++];
                PolicyExecutorImpl executor = callback == null ? this : (PolicyExecutorImpl)callback.getExecutor(this);
                long startTimeoutNS = callback == null ? this.startTimeout : callback.getStartTimeout(executor.startTimeout);
                futures.add(new PolicyTaskFutureImpl<T>(executor, callable, callback, startTimeoutNS, latch));
            }
            for (PolicyTaskFutureImpl policyTaskFutureImpl : futures) {
                if (latch.getCount() == 0) break;
                policyTaskFutureImpl.executor.enqueue(policyTaskFutureImpl, policyTaskFutureImpl.executor.maxWaitForEnqueueNS.get(), false);
            }
            Iterator<Callable<Object>> iterator = latch.await(-1L, futures);
            return (T)iterator;
        }
        catch (RejectedExecutionException x) {
            if (x.getCause() instanceof InterruptedException) {
                throw (InterruptedException)x.getCause();
            }
            throw x;
        }
        catch (TimeoutException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"855", (Object)this, (Object[])new Object[]{tasks, callbacks});
            throw new RuntimeException(x);
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    @Override
    @FFDCIgnore(value={RejectedExecutionException.class})
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, PolicyTaskCallback[] callbacks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        int taskCount = tasks.size();
        long stop = System.nanoTime() + unit.toNanos(timeout);
        if (taskCount == 0) {
            throw new IllegalArgumentException();
        }
        PolicyTaskFutureImpl.InvokeAnyLatch latch = new PolicyTaskFutureImpl.InvokeAnyLatch(taskCount);
        ArrayList futures = new ArrayList(taskCount);
        try {
            long remaining;
            int t = 0;
            for (Callable<T> callable : tasks) {
                remaining = stop - System.nanoTime();
                PolicyTaskCallback callback = callbacks == null ? null : callbacks[t++];
                PolicyExecutorImpl executor = callback == null ? this : (PolicyExecutorImpl)callback.getExecutor(this);
                long startTimeoutNS = callback == null ? this.startTimeout : callback.getStartTimeout(executor.startTimeout);
                PolicyTaskFutureImpl<T> taskFuture = new PolicyTaskFutureImpl<T>(executor, callable, callback, startTimeoutNS, latch);
                futures.add(taskFuture);
                if (remaining > 0L) continue;
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1204.unable.to.invoke", (Object[])new Object[]{taskFuture.getIdentifier(), taskCount - futures.size(), taskCount, timeout, unit}));
            }
            for (PolicyTaskFutureImpl policyTaskFutureImpl : futures) {
                remaining = stop - System.nanoTime();
                if (latch.getCount() == 0) break;
                if (remaining <= 0L) {
                    throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1204.unable.to.invoke", (Object[])new Object[]{policyTaskFutureImpl.getIdentifier(), taskCount - futures.size(), taskCount, timeout, unit}));
                }
                long qWait = policyTaskFutureImpl.executor.maxWaitForEnqueueNS.get();
                policyTaskFutureImpl.executor.enqueue(policyTaskFutureImpl, qWait < remaining ? qWait : remaining, false);
            }
            Iterator<Callable<Object>> iterator = latch.await((remaining = stop - System.nanoTime()) < 0L ? 0L : remaining, futures);
            return (T)iterator;
        }
        catch (RejectedExecutionException x) {
            if (x.getCause() instanceof InterruptedException) {
                throw (InterruptedException)x.getCause();
            }
            throw x;
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return this.state.get() != State.ACTIVE;
    }

    @Override
    public boolean isTerminated() {
        State currentState = this.state.get();
        switch (currentState) {
            case TERMINATED: {
                return true;
            }
            case TASKS_CANCELING: 
            case ENQUEUE_STOPPED: 
            case TASKS_CANCELED: {
                if (this.queue.isEmpty() && this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency)) {
                    State previous = this.state.getAndSet(State.TERMINATED);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("state: " + (Object)((Object)previous) + " --> TERMINATED"), (Object[])new Object[0]);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor maxConcurrency(int max) {
        if (max == -1) {
            max = Integer.MAX_VALUE;
        } else if (max < 1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (max < this.expedite) {
                throw new IllegalArgumentException("maxConcurrency: " + max + " < expedite: " + this.expedite);
            }
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxConcurrency", this.identifier}));
            }
            int increase = max - this.maxConcurrency;
            if (increase > 0) {
                this.maxConcurrencyConstraint.release(increase);
            } else if (increase < 0) {
                this.maxConcurrencyConstraint.reducePermits(-increase);
            }
            this.maxConcurrency = max;
        }
        while (this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
            this.decrementWithheldConcurrency();
            this.enqueueGlobal(new GlobalPoolTask());
        }
        return this;
    }

    @Override
    public PolicyExecutor maxPolicy(PolicyExecutor.MaxPolicy policy) {
        if (policy == null) {
            throw new NullPointerException();
        }
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxPolicy", this.identifier}));
        }
        this.maxPolicy = policy;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor maxQueueSize(int max) {
        Callback callback;
        int increase;
        if (max == -1) {
            max = Integer.MAX_VALUE;
        } else if (max < 1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxQueueSize", this.identifier}));
            }
            increase = max - this.maxQueueSize;
            if (increase > 0) {
                this.maxQueueSizeConstraint.release(increase);
            } else if (increase < 0) {
                this.maxQueueSizeConstraint.reducePermits(-increase);
            }
            this.maxQueueSize = max;
        }
        if (increase < 0 && (callback = this.cbQueueSize.get()) != null && (long)this.maxQueueSizeConstraint.availablePermits() < callback.threshold && this.cbQueueSize.compareAndSet(callback, null)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: queue capacity < " + callback.threshold), (Object[])new Object[]{callback.runnable});
            }
            this.globalExecutor.submit(callback.runnable);
        }
        return this;
    }

    @Override
    public PolicyExecutor maxWaitForEnqueue(long ms) {
        if (ms < 0L) {
            throw new IllegalArgumentException(Long.toString(ms));
        }
        long current = this.maxWaitForEnqueueNS.get();
        while (current != -1L) {
            if (this.maxWaitForEnqueueNS.compareAndSet(current, TimeUnit.MILLISECONDS.toNanos(ms))) {
                return this;
            }
            current = this.maxWaitForEnqueueNS.get();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxWaitForEnqueue", this.identifier}));
    }

    @Override
    public int queueCapacityRemaining() {
        int capacity = this.maxQueueSizeConstraint.availablePermits();
        return capacity < 0 ? 0 : capacity;
    }

    @Override
    public Runnable registerConcurrencyCallback(int max, Runnable runnable) {
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(this.state.toString());
        }
        Callback callback = new Callback(max, runnable);
        Callback previous = this.cbConcurrency.getAndSet(callback);
        if (runnable != null && this.runningCount.get() > max && this.cbConcurrency.compareAndSet(callback, null)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: concurrency > " + max), (Object[])new Object[]{runnable});
            }
            this.globalExecutor.submit(runnable);
        }
        return previous == null ? null : previous.runnable;
    }

    @Override
    public Runnable registerLateStartCallback(long maxDelay, TimeUnit unit, Runnable runnable) {
        long ns = unit.toNanos(maxDelay);
        if (ns == Long.MAX_VALUE) {
            throw new IllegalArgumentException(maxDelay + " " + (Object)((Object)unit));
        }
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(this.state.toString());
        }
        Callback callback = new Callback(ns, runnable);
        Callback previous = this.cbLateStart.getAndSet(callback);
        return previous == null ? null : previous.runnable;
    }

    @Override
    public Runnable registerQueueSizeCallback(int minAvailable, Runnable runnable) {
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(this.state.toString());
        }
        Callback callback = new Callback(minAvailable, runnable);
        Callback previous = this.cbQueueSize.getAndSet(callback);
        if (runnable != null && this.maxQueueSizeConstraint.availablePermits() < minAvailable && this.cbQueueSize.compareAndSet(callback, null)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: queue capacity < " + minAvailable), (Object[])new Object[]{runnable});
            }
            this.globalExecutor.submit(runnable);
        }
        return previous == null ? null : previous.runnable;
    }

    @Override
    public PolicyExecutor runIfQueueFull(boolean runIfFull) {
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"runIfQueueFull", this.identifier}));
        }
        this.runIfQueueFull = runIfFull;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTask(PolicyTaskFutureImpl<?> future) {
        this.running.add(future);
        int runCount = this.runningCount.incrementAndGet();
        try {
            long delay;
            Callback callback = this.cbLateStart.get();
            if (callback != null && (delay = future.nsQueueEnd - future.nsAcceptBegin) > callback.threshold && this.cbLateStart.compareAndSet(callback, null)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: late start " + delay + "ns > " + callback.threshold + "ns"), (Object[])new Object[]{callback.runnable});
                }
                this.globalExecutor.submit(callback.runnable);
            }
            if ((callback = this.cbConcurrency.get()) != null && (long)runCount > callback.threshold && this.cbConcurrency.compareAndSet(callback, null)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: concurrency > " + callback.threshold), (Object[])new Object[]{callback.runnable});
                }
                this.globalExecutor.submit(callback.runnable);
            }
            if (this.state.get().canStartTask) {
                future.run();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Cancel task due to policy executor state " + this.state), (Object[])new Object[0]);
                }
                future.nsRunEnd = System.nanoTime();
                future.cancel(false);
                if (future.callback != null) {
                    future.callback.onEnd(future.task, future, null, true, 0, null);
                }
            }
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"1144", (Object)this, (Object[])new Object[]{future});
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"1146", (Object)this, (Object[])new Object[]{future});
        }
        finally {
            this.runningCount.decrementAndGet();
            this.running.remove(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        if (this.state.compareAndSet(State.ACTIVE, State.ENQUEUE_STOPPING)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ACTIVE --> ENQUEUE_STOPPING", (Object[])new Object[0]);
            }
            this.cbConcurrency.set(null);
            this.cbLateStart.set(null);
            this.cbQueueSize.set(null);
            this.maxWaitForEnqueueNS.set(-1L);
            Integer n = this.configLock;
            synchronized (n) {
                this.maxQueueSize = 0;
                this.maxQueueSizeConstraint.drainPermits();
                this.maxQueueSizeConstraint.reducePermits(Integer.MAX_VALUE);
            }
            if (this.state.compareAndSet(State.ENQUEUE_STOPPING, State.ENQUEUE_STOPPED) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ENQUEUE_STOPPING --> ENQUEUE_STOPPED", (Object[])new Object[0]);
            }
            this.policyExecutors.remove(this.identifier);
            this.shutdownLatch.countDown();
        } else {
            while (this.state.get() == State.ENQUEUE_STOPPING) {
                try {
                    this.shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    void x;
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"1185", (Object)this, (Object[])new Object[0]);
                    throw new RuntimeException((Throwable)x);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.shutdown();
        LinkedList<Runnable> queuedTasks = new LinkedList<Runnable>();
        if (this.state.compareAndSet(State.ENQUEUE_STOPPED, State.TASKS_CANCELING)) {
            if (trace && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ENQUEUE_STOPPED --> TASKS_CANCELING", (Object[])new Object[0]);
            }
            PolicyTaskFutureImpl<?> f = this.queue.poll();
            while (f != null) {
                if (f.cancel(false)) {
                    if (f.task instanceof Runnable) {
                        queuedTasks.add((Runnable)f.task);
                    } else {
                        queuedTasks.add(new RunnableFromCallable((Callable)f.task));
                    }
                }
                f = this.queue.poll();
            }
            Iterator<PolicyTaskFutureImpl<?>> it = this.running.iterator();
            while (it.hasNext()) {
                it.next().cancel(true);
            }
            if (this.state.compareAndSet(State.TASKS_CANCELING, State.TASKS_CANCELED) && trace && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: TASKS_CANCELING --> TASKS_CANCELED", (Object[])new Object[0]);
            }
            this.shutdownNowLatch.countDown();
        } else {
            while (this.state.get() == State.TASKS_CANCELING) {
                try {
                    this.shutdownNowLatch.await();
                }
                catch (InterruptedException it) {
                    void x;
                    FFDCFilter.processException((Throwable)it, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"1227", (Object)this, (Object[])new Object[0]);
                    throw new RuntimeException((Throwable)x);
                }
            }
        }
        return queuedTasks;
    }

    @Override
    public PolicyExecutor startTimeout(long ms) {
        if (ms < -1L || ms > TimeUnit.NANOSECONDS.toMillis(Long.MAX_VALUE)) {
            throw new IllegalArgumentException(Long.toString(ms));
        }
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"startTimeout", this.identifier}));
        }
        this.startTimeout = ms == -1L ? -1L : TimeUnit.MILLISECONDS.toNanos(ms);
        return this;
    }

    @Override
    public PolicyTaskFuture<Void> submit(CancellableStage cancellable, Runnable task) {
        PolicyTaskFutureImpl<Void> policyTaskFuture = new PolicyTaskFutureImpl<Void>(this, task, cancellable, this.startTimeout);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        PolicyTaskFutureImpl<T> policyTaskFuture = new PolicyTaskFutureImpl<T>(this, task, null, this.startTimeout);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public <T> PolicyTaskFuture<T> submit(Callable<T> task, PolicyTaskCallback callback) {
        long startTimeoutNS = callback == null ? this.startTimeout : callback.getStartTimeout(this.startTimeout);
        PolicyTaskFutureImpl<T> policyTaskFuture = new PolicyTaskFutureImpl<T>(this, task, callback, startTimeoutNS);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public Future<?> submit(Runnable task) {
        PolicyTaskFutureImpl<Object> policyTaskFuture = new PolicyTaskFutureImpl<Object>(this, task, null, null, this.startTimeout);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        PolicyTaskFutureImpl<T> policyTaskFuture = new PolicyTaskFutureImpl<T>(this, task, result, null, this.startTimeout);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public <T> PolicyTaskFuture<T> submit(Runnable task, T result, PolicyTaskCallback callback) {
        long startTimeoutNS = callback == null ? this.startTimeout : callback.getStartTimeout(this.startTimeout);
        PolicyTaskFutureImpl<T> policyTaskFuture = new PolicyTaskFutureImpl<T>(this, task, result, callback, startTimeoutNS);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Trivial
    private void transferOrReleasePermit() {
        this.maxConcurrencyConstraint.release();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"expedites/maxConcurrency available", (Object[])new Object[]{this.expeditesAvailable, this.maxConcurrencyConstraint.availablePermits()});
        }
        if (!this.queue.isEmpty() && this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
            this.decrementWithheldConcurrency();
            if (this.acquireExpedite() > 0) {
                this.expediteGlobal(new GlobalPoolTask());
            } else {
                this.enqueueGlobal(new GlobalPoolTask());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfig(Map<String, Object> props) {
        Callback callback;
        int queueCapacityAdded;
        int a;
        long u_startTimeout;
        long maxMS = TimeUnit.NANOSECONDS.toMillis(Long.MAX_VALUE);
        int u_expedite = (Integer)props.get("expedite");
        Object v = props.get("max");
        int u_max = null == v ? Integer.MAX_VALUE : (Integer)v;
        PolicyExecutor.MaxPolicy u_maxPolicy = PolicyExecutor.MaxPolicy.valueOf((String)props.get("maxPolicy"));
        v = props.get("maxQueueSize");
        int u_maxQueueSize = null == v ? Integer.MAX_VALUE : (Integer)v;
        long u_maxWaitForEnqueue = (Long)props.get("maxWaitForEnqueue");
        boolean u_runIfQueueFull = (Boolean)props.get("runIfQueueFull");
        v = props.get("startTimeout");
        long l = u_startTimeout = null == v ? -1L : (Long)v;
        if (u_expedite > u_max) {
            throw new IllegalArgumentException("expedite: " + u_expedite + " > max: " + u_max);
        }
        if (u_maxWaitForEnqueue < 0L || u_maxWaitForEnqueue > maxMS) {
            throw new IllegalArgumentException("maxWaitForEnqueue: " + u_maxWaitForEnqueue);
        }
        if (u_startTimeout < -1L || u_startTimeout > maxMS) {
            throw new IllegalArgumentException("startTimeout: " + u_startTimeout);
        }
        long current = this.maxWaitForEnqueueNS.get();
        while (current != -1L && !this.maxWaitForEnqueueNS.compareAndSet(current, TimeUnit.MILLISECONDS.toNanos(u_maxWaitForEnqueue))) {
            current = this.maxWaitForEnqueueNS.get();
        }
        this.maxPolicy = u_maxPolicy;
        this.runIfQueueFull = u_runIfQueueFull;
        this.startTimeout = u_startTimeout == -1L ? -1L : TimeUnit.MILLISECONDS.toNanos(u_startTimeout);
        Integer n = this.configLock;
        synchronized (n) {
            a = this.expeditesAvailable.addAndGet(u_expedite - this.expedite);
            this.expedite = u_expedite;
            int increase = u_max - this.maxConcurrency;
            if (increase > 0) {
                this.maxConcurrencyConstraint.release(increase);
            } else if (increase < 0) {
                this.maxConcurrencyConstraint.reducePermits(-increase);
            }
            this.maxConcurrency = u_max;
            queueCapacityAdded = u_maxQueueSize - this.maxQueueSize;
            if (queueCapacityAdded > 0) {
                this.maxQueueSizeConstraint.release(queueCapacityAdded);
            } else if (queueCapacityAdded < 0) {
                this.maxQueueSizeConstraint.reducePermits(-queueCapacityAdded);
            }
            this.maxQueueSize = u_maxQueueSize;
        }
        if (queueCapacityAdded < 0 && (callback = this.cbQueueSize.get()) != null && (long)this.maxQueueSizeConstraint.availablePermits() < callback.threshold && this.cbQueueSize.compareAndSet(callback, null)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("callback: queue capacity < " + callback.threshold), (Object[])new Object[]{callback.runnable});
            }
            this.globalExecutor.submit(callback.runnable);
        }
        while (this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
            this.decrementWithheldConcurrency();
            if (a-- > 0 && this.acquireExpedite() > 0) {
                this.expediteGlobal(new GlobalPoolTask());
                continue;
            }
            this.enqueueGlobal(new GlobalPoolTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter out) {
        int numRunningPrioritizedThreads;
        int numRunningThreads;
        String INDENT = "  ";
        String DOUBLEINDENT = "    ";
        out.println(this.identifier);
        out.println("  expedite = " + this.expedite);
        out.println("  maxConcurrency = " + this.maxConcurrency + " (" + (Object)((Object)this.maxPolicy) + ')');
        out.println("  maxQueueSize = " + this.maxQueueSize);
        out.println("  maxWaitForEnqueue = " + TimeUnit.NANOSECONDS.toMillis(this.maxWaitForEnqueueNS.get()) + " ms");
        out.println("  runIfQueueFull = " + this.runIfQueueFull);
        out.println("  startTimeout = " + (this.startTimeout == -1L ? "None" : TimeUnit.NANOSECONDS.toMillis(this.startTimeout) + " ms"));
        Integer n = this.configLock;
        synchronized (n) {
            numRunningThreads = this.maxConcurrency - this.maxConcurrencyConstraint.availablePermits();
            numRunningPrioritizedThreads = this.expedite - this.expeditesAvailable.get();
        }
        out.println("  Total Enqueued to Global Executor = " + numRunningThreads + " (" + numRunningPrioritizedThreads + " expedited)");
        out.println("  withheldConcurrency = " + this.withheldConcurrency.get());
        out.println("  Remaining Queue Capacity = " + this.maxQueueSizeConstraint.availablePermits());
        out.println("  state = " + this.state.toString());
        out.println("  concurrency callback = " + this.cbConcurrency.get());
        out.println("  late start callback = " + this.cbLateStart.get());
        out.println("  queue capacity callback = " + this.cbQueueSize.get());
        out.println("  Running Task Count = " + this.runningCount);
        out.println("  Running Task Futures:");
        if (this.running.isEmpty()) {
            out.println("    None");
        } else {
            for (PolicyTaskFutureImpl policyTaskFutureImpl : this.running) {
                out.println("    " + policyTaskFutureImpl.toString());
            }
        }
        int counter = 50;
        out.println("  Queued Task Futures (up to first " + counter + "):");
        if (this.queue.isEmpty()) {
            out.println("    None");
        } else {
            for (PolicyTaskFutureImpl<?> task : this.queue) {
                if (counter-- <= 0) break;
                out.println("    " + task.toString());
            }
        }
        out.println();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class RunnableFromCallable
    implements Runnable {
        private final Callable<?> callable;
        static final long serialVersionUID = -5567018484392606170L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RunnableFromCallable(Callable<?> callable) {
            this.callable = callable;
        }

        @Override
        @FFDCIgnore(value={Exception.class, RuntimeException.class})
        public void run() {
            try {
                this.callable.call();
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RunnableFromCallable.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class GlobalPoolTask
    implements QueueItem,
    Runnable {
        private boolean expedite;
        static final long serialVersionUID = -4781151920218137189L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GlobalPoolTask() {
        }

        @Override
        public boolean isExpedited() {
            return this.expedite;
        }

        @Override
        public void run() {
            boolean canRun;
            PolicyTaskFutureImpl<?> next;
            while ((next = (canRun = ((State)((Object)((PolicyExecutorImpl)PolicyExecutorImpl.this).state.get())).canStartTask) ? PolicyExecutorImpl.this.queue.poll() : null) != null) {
                PolicyExecutorImpl.this.maxQueueSizeConstraint.release();
                long nsQueueEnd = System.nanoTime();
                if (next.isCancelled()) {
                    next.nsRunEnd = next.nsQueueEnd = nsQueueEnd;
                    if (next.callback == null) continue;
                    next.callback.onEnd(next.task, next, null, true, 0, null);
                    continue;
                }
                if (next.nsStartBy == next.nsAcceptBegin - 1L || next.nsStartBy - nsQueueEnd > 0L) {
                    next.nsQueueEnd = nsQueueEnd;
                    PolicyExecutorImpl.this.runTask(next);
                    break;
                }
                next.nsRunEnd = next.nsQueueEnd = nsQueueEnd;
                next.abort(false, new StartTimeoutException(next.getIdentifier(), next.getTaskName(), nsQueueEnd - next.nsAcceptBegin, next.nsStartBy - next.nsAcceptBegin));
            }
            if (this.expedite) {
                PolicyExecutorImpl.this.expeditesAvailable.incrementAndGet();
            }
            PolicyExecutorImpl.this.maxConcurrencyConstraint.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)PolicyExecutorImpl.this, (TraceComponent)tc, (String)"expedites/maxConcurrency available", (Object[])new Object[]{PolicyExecutorImpl.this.expeditesAvailable, PolicyExecutorImpl.this.maxConcurrencyConstraint.availablePermits(), canRun});
            }
            if (canRun && PolicyExecutorImpl.this.withheldConcurrency.get() > 0 && PolicyExecutorImpl.this.maxConcurrencyConstraint.tryAcquire()) {
                PolicyExecutorImpl.this.decrementWithheldConcurrency();
                if (PolicyExecutorImpl.this.acquireExpedite() > 0) {
                    PolicyExecutorImpl.this.expediteGlobal(this);
                } else {
                    PolicyExecutorImpl.this.enqueueGlobal(this);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(GlobalPoolTask.class);
        }
    }

    @Trivial
    private static enum State {
        ACTIVE(true),
        ENQUEUE_STOPPING(true),
        ENQUEUE_STOPPED(true),
        TASKS_CANCELING(false),
        TASKS_CANCELED(false),
        TERMINATED(false);

        boolean canStartTask;

        private State(boolean canStartTask) {
            this.canStartTask = canStartTask;
        }
    }

    @Trivial
    private static class Callback {
        private final Runnable runnable;
        private final long threshold;

        private Callback(long threshold, Runnable runnable) {
            this.runnable = runnable;
            this.threshold = threshold;
        }

        public String toString() {
            return "Callback@" + Integer.toHexString(this.hashCode()) + " threshold " + this.threshold + " for " + this.runnable;
        }
    }
}

