/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serialization.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationContext;
import com.ibm.ws.serialization.DeserializationObjectResolver;
import com.ibm.ws.serialization.internal.DeserializationObjectInputStreamImpl;
import com.ibm.ws.serialization.internal.SerializationServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DeserializationContextImpl
implements DeserializationContext {
    private final SerializationServiceImpl service;
    private List<DeserializationObjectResolver> resolvers;
    static final long serialVersionUID = 5133321402076495394L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DeserializationContextImpl(SerializationServiceImpl service) {
        this.service = service;
    }

    @Override
    public void addObjectResolver(DeserializationObjectResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList<DeserializationObjectResolver>();
        }
        this.resolvers.add(resolver);
    }

    @Override
    public ObjectInputStream createObjectInputStream(InputStream input, ClassLoader classLoader) throws IOException {
        return new DeserializationObjectInputStreamImpl(input, classLoader, this);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.service.loadClass(name);
    }

    public boolean isResolveObjectNeeded() {
        return this.resolvers != null || this.service.isResolveObjectNeeded();
    }

    @Sensitive
    public Object resolveObject(@Sensitive Object object) throws IOException {
        if (this.resolvers != null) {
            for (DeserializationObjectResolver resolver : this.resolvers) {
                Object resolvedObject = resolver.resolveObject(object);
                if (resolvedObject == null) continue;
                return resolvedObject;
            }
        }
        return this.service.resolveObjectWithException(object);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DeserializationContextImpl.class);
    }
}

