/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MappingTable {
    public static final int METRIC_NAME = 0;
    public static final int METRIC_DISPLAYNAME = 1;
    public static final int METRIC_DESCRIPTION = 2;
    public static final int METRIC_TYPE = 3;
    public static final int METRIC_UNIT = 4;
    public static final int MBEAN_ATTRIBUTE = 5;
    public static final int MBEAN_SUBATTRIBUTE = 6;
    public static final String COUNTER;
    public static final String GAUGE;
    private static MappingTable singleton;
    private Map<String, String[][]> mappingTable = new HashMap<String, String[][]>();
    static final long serialVersionUID = -1181257153624798000L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static MappingTable getInstance() {
        if (singleton == null) {
            singleton = new MappingTable();
        }
        return singleton;
    }

    private MappingTable() {
        String[][] threadPoolTable = new String[][]{{"threadpool.%s.activeThreads", "Active Threads", "threadpool.activeThreads.description", GAUGE, "none", "ActiveThreads", null}, {"threadpool.%s.size", "Thread Pool Size", "threadpool.size.description", GAUGE, "none", "PoolSize", null}};
        this.mappingTable.put("WebSphere:type=ThreadPoolStats,name=*", threadPoolTable);
        String[][] servletTable = new String[][]{{"servlet.%s.request.total", "Total Request", "servlet.request.total.description", COUNTER, "none", "RequestCount", null}, {"servlet.%s.responseTime.total", "Total Response Time", "servlet.responseTime.total.description", GAUGE, "nanoseconds", "ResponseTimeDetails", "total"}};
        this.mappingTable.put("WebSphere:type=ServletStats,name=*", servletTable);
        String[][] connectionPoolTable = new String[][]{{"connectionpool.%s.create.total", "Create Count", "connectionpool.create.total.description", COUNTER, "none", "CreateCount", null}, {"connectionpool.%s.destroy.total", "Destroy Count", "connectionpool.destroy.total.description", COUNTER, "none", "DestroyCount", null}, {"connectionpool.%s.managedConnections", "Managed Connections Count", "connectionpool.managedConnections.description", GAUGE, "none", "ManagedConnectionCount", null}, {"connectionpool.%s.connectionHandles", "Connection Handles Count", "connectionpool.connectionHandles.description", GAUGE, "none", "ConnectionHandleCount", null}, {"connectionpool.%s.freeConnections", "Free Connections Count", "connectionpool.freeConnections.description", GAUGE, "none", "FreeConnectionCount", null}, {"connectionpool.%s.waitTime.total", "Total Wait Time", "connectionpool.waitTime.total.description", GAUGE, "milliseconds", "WaitTimeDetails", "total"}, {"connectionpool.%s.inUseTime.total", "Total In Use Time", "connectionpool.inUseTime.total.description", GAUGE, "milliseconds", "InUseTimeDetails", "total"}, {"connectionpool.%s.queuedRequests.total", "Queued Connection Request Count", "connectionpool.queuedRequests.total.description", COUNTER, "none", "WaitTimeDetails", "count"}, {"connectionpool.%s.usedConnections.total", "Used Connections", "connectionpool.usedConnections.total.description", COUNTER, "none", "InUseTimeDetails", "count"}};
        this.mappingTable.put("WebSphere:type=ConnectionPoolStats,name=*", connectionPoolTable);
        String[][] sessionTable = new String[][]{{"session.%s.create.total", "Total Create Count", "session.create.total.description", GAUGE, "none", "CreateCount", null}, {"session.%s.liveSessions", "Live Sessions Count", "session.liveSessions.description", GAUGE, "none", "LiveCount", null}, {"session.%s.activeSessions", "Active Sessions Count", "session.activeSessions.description", GAUGE, "none", "ActiveCount", null}, {"session.%s.invalidated.total", "Total Invalidated Sessions Count", "session.invalidated.total.description", COUNTER, "none", "InvalidatedCount", null}, {"session.%s.invalidatedbyTimeout.total", "Total Invalidated Sessions by Timeout Count", "session.invalidatedbyTimeout.total.description", COUNTER, "none", "InvalidatedCountbyTimeout", null}};
        this.mappingTable.put("WebSphere:type=SessionStats,name=*", sessionTable);
        String[][] jaxwsServerTable = new String[][]{{"jaxws.server.%s.invocations.total", "Total Endpoint Invocations Count", "jaxws.invocations.total.description", COUNTER, "none", "NumInvocations", null}, {"jaxws.server.%s.checkedApplicationFaults.total", "Total Checked Application Faults Count", "jaxws.checkedApplicationFaults.total.description", COUNTER, "none", "NumCheckedApplicationFaults", null}, {"jaxws.server.%s.logicalRuntimeFaults.total", "Total Logical Runtime Faults Count", "jaxws.logicalRuntimeFaults.total.description", COUNTER, "none", "NumLogicalRuntimeFaults", null}, {"jaxws.server.%s.runtimeFaults.total", "Total Runtime Faults Count", "jaxws.runtimeFaults.total.description", COUNTER, "none", "NumRuntimeFaults", null}, {"jaxws.server.%s.uncheckedApplicationFaults.total ", "Total Unchecked Application Faults Count", "jaxws.uncheckedApplicationFaults.total.description", COUNTER, "none", "NumUnCheckedApplicationFaults", null}, {"jaxws.server.%s.responseTime.total", "Total Response Time", "jaxws.responseTime.total.description", GAUGE, "milliseconds", "TotalHandlingTime", null}};
        this.mappingTable.put("WebSphere:feature=jaxws,*,type=Performance.Counter.Server", jaxwsServerTable);
        String[][] jaxwsClientTable = new String[][]{{"jaxws.client.%s.invocations.total", "Total Endpoint Invocations Count", "jaxws.invocations.total.description", COUNTER, "none", "NumInvocations", null}, {"jaxws.client.%s.checkedApplicationFaults.total", "Total Checked Application Faults Count", "jaxws.checkedApplicationFaults.total.description", COUNTER, "none", "NumCheckedApplicationFaults", null}, {"jaxws.client.%s.logicalRuntimeFaults.total", "Total Logical Runtime Faults Count", "jaxws.logicalRuntimeFaults.total.description", COUNTER, "none", "NumLogicalRuntimeFaults", null}, {"jaxws.client.%s.runtimeFaults.total", "Total Runtime Faults Count", "jaxws.runtimeFaults.total.description", COUNTER, "none", "NumRuntimeFaults", null}, {"jaxws.client.%s.uncheckedApplicationFaults.total ", "Total Unchecked Application Faults Count", "jaxws.uncheckedApplicationFaults.total.description", COUNTER, "none", "NumUnCheckedApplicationFaults", null}, {"jaxws.client.%s.responseTime.total", "Total Response Time", "jaxws.responseTime.total.description", GAUGE, "milliseconds", "TotalHandlingTime", null}};
        this.mappingTable.put("WebSphere:feature=jaxws,*,type=Performance.Counter.Client", jaxwsClientTable);
    }

    private String getType(String objectName) {
        for (String subString : objectName.split(",")) {
            if (!(subString = subString.trim()).contains("type=")) continue;
            return subString.split("=")[1];
        }
        return "notype";
    }

    public String[][] getData(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return this.mappingTable.get(k);
        }
        return null;
    }

    public boolean contains(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return true;
        }
        return false;
    }

    public Set<String> getKeys() {
        return this.mappingTable.keySet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MappingTable.class);
        COUNTER = MetricType.COUNTER.toString().toUpperCase();
        GAUGE = MetricType.GAUGE.toString().toUpperCase();
        singleton = null;
    }
}

