/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.opentracing.OpenTracingService;
import com.ibm.ws.opentracing.OpentracingConfiguration;
import com.ibm.ws.opentracing.OpentracingFilterHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true)
public class OpenTracingFilterHelper
implements OpentracingFilterHelper {
    private static final TraceComponent tc = Tr.register(OpenTracingFilterHelper.class);
    static final long serialVersionUID = 3344376287125860633L;

    public String getBuildSpanName(ClientRequestContext clientRequestContext) {
        return clientRequestContext.getMethod();
    }

    public String getBuildSpanName(ContainerRequestContext incomingRequestContext, ResourceInfo resourceInfo) {
        String operationName;
        String methodName = "getBuildSpanName";
        String methodOperationName = OpenTracingService.getMethodOperationName(resourceInfo.getResourceMethod());
        String classOperationName = OpenTracingService.getClassOperationName(resourceInfo.getResourceMethod());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " operation names"), (Object[])new Object[]{classOperationName, methodOperationName});
        }
        if (OpenTracingService.isNotTraced(classOperationName, methodOperationName)) {
            return null;
        }
        if (OpenTracingService.hasExplicitOperationName(methodOperationName)) {
            operationName = methodOperationName;
        } else if (OpenTracingService.hasExplicitOperationName(classOperationName)) {
            operationName = classOperationName;
        } else if (OpentracingConfiguration.isOperationNameProviderHttpPath()) {
            StringBuilder operationNameSB = new StringBuilder();
            String classPathValue = null;
            if (resourceInfo.getResourceClass().isAnnotationPresent(Path.class)) {
                classPathValue = resourceInfo.getResourceClass().getAnnotation(Path.class).value();
            }
            String methodPathValue = null;
            if (resourceInfo.getResourceMethod().isAnnotationPresent(Path.class)) {
                methodPathValue = resourceInfo.getResourceMethod().getAnnotation(Path.class).value();
            }
            operationNameSB.append(incomingRequestContext.getMethod().toUpperCase());
            boolean isColonAdded = false;
            if (classPathValue != null && classPathValue.length() > 0) {
                if (!isColonAdded) {
                    operationNameSB.append(":");
                    isColonAdded = true;
                }
                if (!classPathValue.startsWith("/")) {
                    operationNameSB.append("/");
                }
                operationNameSB.append(classPathValue);
            }
            if (methodPathValue != null && methodPathValue.length() > 0) {
                if (!isColonAdded) {
                    operationNameSB.append(":");
                }
                if (!methodPathValue.startsWith("/")) {
                    operationNameSB.append("/");
                }
                operationNameSB.append(methodPathValue);
            }
            operationName = operationNameSB.toString();
        } else {
            operationName = incomingRequestContext.getMethod() + ":" + resourceInfo.getResourceClass().getName() + "." + resourceInfo.getResourceMethod().getName();
        }
        return operationName;
    }
}

