/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.NotSupportedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogCursorImpl
implements LogCursor {
    private static final TraceComponent tc;
    private Lock _controlLock;
    private int _initialSize;
    private boolean _empty = true;
    private Iterator _iterator1;
    private Iterator _iterator2;
    private Iterator _removeIterator;
    private Object _removeObject;
    private Object _singleObject;
    private boolean _removeSupported;
    private LogCursorCallback _callback;
    private static final int LOCK_REQUEST_ID_LCI = 12;
    static final long serialVersionUID = 6777348316162621658L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public LogCursorImpl(Lock controlLock, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{controlLock, object});
        }
        this._controlLock = controlLock;
        this._singleObject = object;
        this._removeSupported = false;
        this._callback = null;
        if (object != null) {
            this._initialSize = 1;
            this._empty = false;
        } else {
            this._initialSize = 0;
            this._empty = true;
        }
        if (this._controlLock != null) {
            this._controlLock.getSharedLock(12);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{new Integer(this._initialSize), this});
        }
    }

    public LogCursorImpl(Lock controlLock, Collection collection, boolean removeSupported, LogCursorCallback callback) {
        this(controlLock, collection, null, removeSupported, callback);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{controlLock, collection, new Boolean(removeSupported), callback});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{new Integer(this._initialSize), this});
        }
    }

    public LogCursorImpl(Lock controlLock, Collection collection1, Collection collection2, boolean removeSupported, LogCursorCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{controlLock, collection1, collection2, new Boolean(removeSupported), callback});
        }
        int collection1Size = 0;
        int collection2Size = 0;
        if (collection1 != null) {
            collection1Size = collection1.size();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Collection 1 size: " + collection1Size));
            }
            this._iterator1 = collection1.iterator();
            this._empty = false;
        }
        if (collection2 != null) {
            collection2Size = collection2.size();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Collection 2 size: " + collection2Size));
            }
            this._iterator2 = collection2.iterator();
            this._empty = false;
        }
        this._singleObject = null;
        this._controlLock = controlLock;
        this._initialSize = collection1Size + collection2Size;
        this._removeSupported = removeSupported;
        this._callback = this._removeSupported ? callback : null;
        if (this._controlLock != null) {
            this._controlLock.getSharedLock(12);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogCursorImpl", (Object)new Object[]{new Integer(this._initialSize), this});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object next() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"next", (Object)this);
        }
        Object nextObject = null;
        this._removeIterator = null;
        if (!this._empty) {
            if (this._singleObject != null) {
                nextObject = this._singleObject;
                this._singleObject = null;
                this._empty = true;
            } else {
                try {
                    if (this._iterator1 != null && this._iterator1.hasNext()) {
                        nextObject = this._iterator1.next();
                        this._removeIterator = this._iterator1;
                    } else if (this._iterator2 != null && this._iterator2.hasNext()) {
                        nextObject = this._iterator2.next();
                        this._removeIterator = this._iterator2;
                    } else {
                        this._empty = true;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    void exc;
                    FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl", (String)"322", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl.next", (String)"328", (Object)this);
                    this._empty = true;
                }
            }
        }
        this._removeObject = nextObject;
        Object preprocessedResult = this.preprocessResult(nextObject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"next", (Object)preprocessedResult);
        }
        return preprocessedResult;
    }

    @Override
    public boolean hasNext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasNext", (Object)this);
        }
        boolean hasNext = false;
        if (!this._empty && (this._singleObject != null || this._iterator1 != null && this._iterator1.hasNext() || this._iterator2 != null && this._iterator2.hasNext())) {
            hasNext = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(hasNext));
        }
        return hasNext;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object)this);
        }
        if (this._controlLock != null) {
            try {
                this._controlLock.releaseSharedLock(12);
            }
            catch (NoSharedLockException noSharedLockException) {
                void exc;
                FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl", (String)"393", (Object)this, (Object[])new Object[0]);
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl.close", (String)"401", (Object)this);
            }
        }
        this._iterator1 = null;
        this._iterator2 = null;
        this._removeIterator = null;
        this._controlLock = null;
        this._singleObject = null;
        this._empty = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public int initialSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialSize", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialSize", (Object)new Integer(this._initialSize));
        }
        return this._initialSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove() throws NotSupportedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)this);
        }
        if (!this._removeSupported) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"remove", (Object)"NotSupportedException");
            }
            throw new NotSupportedException(null);
        }
        if (this._removeIterator != null) {
            if (this._callback != null) {
                this._removeIterator.remove();
                try {
                    this._callback.removing(this._removeObject);
                }
                catch (Exception exception) {
                    void exc;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl", (String)"463", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogCursorImpl.remove", (String)"469", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst attempting to remove an object from the cursor");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"remove", (Object)"InternalLogException");
                    }
                    throw new InternalLogException((Throwable)exc);
                }
            }
            this._removeIterator = null;
            this._removeObject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    @Override
    public Object last() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"last", (Object)this);
        }
        Object lastObject = null;
        while (this.hasNext()) {
            lastObject = this.next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"last", (Object)lastObject);
        }
        return this.preprocessResult(lastObject);
    }

    private Object preprocessResult(Object result) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preprocessResult", (Object)new Object[]{result, this});
        }
        Object processedResult = null;
        processedResult = result instanceof DataItem ? (Object)((DataItem)result).getData() : result;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preprocessResult", (Object)processedResult);
        }
        return processedResult;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(LogCursorImpl.class);
        tc = Tr.register(LogCursorImpl.class, (String)"Transaction", null);
    }
}

