/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class BootstrapAgent {
    static Instrumentation instrumentation;
    static String arg;

    public static void premain(String arg, Instrumentation inst) throws Exception {
        BootstrapAgent.arg = arg;
        instrumentation = inst;
        BootstrapAgent.setSystemProperties();
        if (arg == null || arg.length() == 0) {
            return;
        }
        int separator = arg.indexOf(61);
        String targetAgent = separator < 0 ? arg : arg.substring(0, separator);
        String targetAgentArgs = separator < 0 ? "" : arg.substring(separator + 1);
        try {
            BootstrapAgent.loadAgentJar(targetAgent, targetAgentArgs);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void loadAgent(String agentJarName, String arg) throws Exception {
        BootstrapAgent.loadAgentJar(agentJarName, arg);
    }

    private static void loadAgentJar(String agentJarName, String arg) throws Exception {
        CodeSource bootstrapCodeSource = BootstrapAgent.class.getProtectionDomain().getCodeSource();
        URI bootstrapLocationURI = bootstrapCodeSource.getLocation().toURI();
        assert ("file".equals(bootstrapLocationURI.getScheme()));
        URI agentURI = bootstrapLocationURI.resolve(agentJarName);
        File agentFile = new File(agentURI);
        if (!agentFile.isDirectory() && agentFile.exists()) {
            JarFile jarFile = new JarFile(agentFile);
            Manifest manifest = jarFile.getManifest();
            jarFile.close();
            Attributes attrs = manifest.getMainAttributes();
            String agentClassName = attrs.getValue("Premain-Class");
            if (agentClassName == null) {
                return;
            }
            String agentClassPath = attrs.getValue("Class-Path");
            ArrayList<URL> classpath = new ArrayList<URL>();
            classpath.add(agentURI.toURL());
            if (agentClassPath != null) {
                for (String pathEntry : agentClassPath.split("\\s+")) {
                    URI pathURI = agentURI.resolve(pathEntry.trim());
                    classpath.add(pathURI.toURL());
                }
            }
            URLClassLoader loader = URLClassLoader.newInstance(classpath.toArray(new URL[0]));
            Class<?> clazz = Class.forName(agentClassName, true, loader);
            try {
                Method premain = clazz.getMethod("premain", String.class, Instrumentation.class);
                premain.invoke(null, arg, instrumentation);
            }
            catch (NoSuchMethodException e) {
                Method premain = clazz.getMethod("premain", String.class);
                premain.invoke(null, arg);
            }
        } else {
            throw new FileNotFoundException(agentFile.getAbsolutePath());
        }
    }

    private static void setSystemProperties() {
        String managementBuilderInitial;
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null) {
            System.setProperty("java.util.logging.manager", "com.ibm.ws.kernel.boot.logging.WsLogManager");
        }
        if ((managementBuilderInitial = System.getProperty("javax.management.builder.initial")) == null) {
            System.setProperty("javax.management.builder.initial", "com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilder");
        }
    }

    public static void main(String[] args) {
        System.out.println("entering main");
        System.out.println("    instrumentation = " + instrumentation);
        System.out.println("exiting main");
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }
}

