/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={MetricsConfig.class}, configurationPid={"com.ibm.ws.microprofile.metrics"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class MetricsConfig {
    private static final TraceComponent tc = Tr.register(MetricsConfig.class);
    public static final String CONFIG_AUTHENTICATION = "authentication";
    private static final String MP_METRICS_ENDPOINT_URL = "/metrics";
    private static final String PUBLIC_MP_METRICS_VAR_NAME = "publicMetricsURL";
    private static final String PRIVATE_MP_METRICS_VAR_NAME = "privateMetricsURL";
    private Boolean authentication;
    private final WABConfigManager publicWabConfigMgr = new WABConfigManager("publicMetricsURL", "/metrics");
    private final WABConfigManager privateWabConfigMgr = new WABConfigManager("privateMetricsURL", "/metrics");
    static final long serialVersionUID = -7523289487313481863L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Activate MetricsConfig", (Object[])new Object[]{properties});
        }
        this.processConfig(context, properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Modified MetricsConfig", (Object[])new Object[]{properties});
        }
        this.processConfig(context, properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Deactivate MetricsConfig with reason=" + reason), (Object[])new Object[0]);
        }
        this.publicWabConfigMgr.deactivate();
        this.privateWabConfigMgr.deactivate();
    }

    private synchronized void processConfig(ComponentContext context, Map<String, Object> properties) {
        Boolean authenticationOld = this.authentication;
        this.authentication = (Boolean)properties.get(CONFIG_AUTHENTICATION);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Processing configuration - " + this.toString()), (Object[])new Object[0]);
        }
        if (this.valueChanged(authenticationOld, this.authentication)) {
            if (this.authentication.booleanValue()) {
                this.publicWabConfigMgr.processEnableAuthentication(context, false);
                this.privateWabConfigMgr.processEnableAuthentication(context, true);
            } else {
                this.privateWabConfigMgr.processEnableAuthentication(context, false);
                this.publicWabConfigMgr.processEnableAuthentication(context, true);
            }
        }
    }

    private boolean valueChanged(Object oldValue, Object newValue) {
        return oldValue == null ? newValue != null : !oldValue.equals(newValue);
    }

    public String toString() {
        return "MetricsConfig [authentication=" + this.authentication + "]";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class WABConfigManager {
        private final String contextPath;
        private final String contextName;
        ServiceRegistration<WABConfiguration> wabConfigReg;
        static final long serialVersionUID = -9208594994609069114L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WABConfigManager(String contextName, String contextPath) {
            this.contextName = contextName;
            this.contextPath = contextPath;
        }

        public final void deactivate() {
            if (this.wabConfigReg != null) {
                this.wabConfigReg.unregister();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    this.deactivateEvent();
                }
                this.wabConfigReg = null;
            }
        }

        public void processEnableAuthentication(ComponentContext context, boolean enabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("mpMetrics authentication attribute updated: " + enabled + " WAB config=" + this.wabConfigReg), (Object[])new Object[0]);
            }
            if (this.wabConfigReg == null && !enabled) {
                return;
            }
            if (enabled) {
                this.pushConfiguration(context, this.contextPath);
            } else {
                this.deactivate();
            }
        }

        private final void pushConfiguration(ComponentContext context, String path) {
            BundleContext bundleContext = context.getBundleContext();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("contextName", this.contextName);
            ((Dictionary)props).put("contextPath", path);
            if (this.wabConfigReg == null) {
                this.wabConfigReg = bundleContext.registerService(WABConfiguration.class, (Object)new WABConfiguration(){
                    static final long serialVersionUID = -4080926963322362993L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                }, props);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    this.registerEvent(props);
                }
            } else {
                this.wabConfigReg.setProperties(props);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    this.modifiedEvent(props);
                }
            }
        }

        public void registerEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)"Registered web app bundle", (Object[])new Object[]{this.toString(), "props=" + props + " }"});
        }

        public void modifiedEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)"Modified web app bundle", (Object[])new Object[]{this.toString(), "props=" + props + " }"});
        }

        public void deactivateEvent() {
            Tr.event((TraceComponent)tc, (String)"Unregistered web app bundle", (Object[])new Object[]{this.toString()});
        }

        public String toString() {
            return "WABConfigManager [contextPath=" + this.contextPath + ", contextName=" + this.contextName + ", wabConfigReg=" + this.wabConfigReg + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABConfigManager.class);
        }
    }
}

