/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.modules.CommonLoginModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSLoginModuleProxy
extends CommonLoginModule
implements LoginModule {
    static final TraceComponent tc = Tr.register(WSLoginModuleProxy.class);
    private LoginModule loginModule;
    static final long serialVersionUID = 464830938612419287L;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.checkForNoOptions(options);
        Class target = (Class)options.get("delegate");
        if (target == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"JAAS_WSLOGIN_MODULE_PROXY_DELEGATE_NOT_SET", (Object[])new Object[0]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("target class: " + target), (Object[])new Object[0]);
        }
        try {
            this.loginModule = (LoginModule)target.newInstance();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jaas.common.modules.WSLoginModuleProxy", (String)"95", (Object)this, (Object[])new Object[]{subject, callbackHandler, sharedState, options});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Un-expect exception:", (Object[])new Object[]{e});
            }
            throw new RuntimeException(e.getMessage());
        }
        Map<String, Object> origOptions = this.excludeInternalOption(options);
        this.checkForNoOptions(options);
        this.loginModule.initialize(subject, callbackHandler, sharedState, this.excludeInternalOption(origOptions));
    }

    private void checkForNoOptions(Map<String, ?> opts) {
        if (opts == null || opts.isEmpty()) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"JAAS_WSLOGIN_MODULE_PROXY_NULL_OPTIONS", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> excludeInternalOption(Map<String, ?> options) {
        HashMap<String, Object> cutomLoginModuleOptions = new HashMap<String, Object>();
        cutomLoginModuleOptions.putAll(options);
        cutomLoginModuleOptions.remove("delegate");
        cutomLoginModuleOptions.remove("kernelDelegate");
        cutomLoginModuleOptions.remove("WAS_LM_SHAREDLIB");
        return cutomLoginModuleOptions;
    }

    @Override
    public boolean login() throws LoginException {
        return this.loginModule.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.loginModule.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.loginModule.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.loginModule.logout();
    }

    protected Callback[] getRequiredCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        return null;
    }
}

