/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.common.callback.AuthenticationHelper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSCallbackHandlerImpl
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSCallbackHandlerImpl.class);
    private String userName;
    private String realm;
    private String password;
    private byte[] credToken;
    private Map appContext;
    static final long serialVersionUID = 7579135109473131318L;

    public WSCallbackHandlerImpl(String userName, @Sensitive String password) {
        this.userName = userName;
        this.password = password;
    }

    public WSCallbackHandlerImpl(String userName, String realmName, @Sensitive String password) {
        this.userName = userName;
        this.password = password;
        this.realm = realmName;
    }

    public WSCallbackHandlerImpl(String userName, String realmName, @Sensitive String password, Map appContext) {
        this.userName = userName;
        this.password = password;
        this.realm = realmName;
        this.appContext = appContext;
    }

    public WSCallbackHandlerImpl(@Sensitive byte[] credToken) {
        this.credToken = AuthenticationHelper.copyCredToken(credToken);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.debug((TraceComponent)tc, (String)("handle(callbacks = \"" + sb.toString() + "\")"), (Object[])new Object[0]);
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)c).setCredToken(this.credToken);
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realm);
                continue;
            }
            if (c instanceof WSAppContextCallback) {
                ((WSAppContextCallback)c).setContext(this.appContext);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Un-use handle(callbacks = \"" + callbacks[i].getClass().getName() + "\")"), (Object[])new Object[0]);
        }
    }
}

