/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.opentracing.OpentracingFilterHelper;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.opentracing.util.AutoFinishScope;
import io.opentracing.util.AutoFinishScopeManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpentracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingClientFilter.class);
    public static final String CLIENT_CONTINUATION_PROP_ID = OpentracingClientFilter.class.getName() + ".Span";
    public static final String CLIENT_SPAN_SKIPPED_ID = OpentracingClientFilter.class.getName() + ".Skipped";
    private static final String TAG_COMPONENT_JAXRS = "jaxrs";
    private static final AutoFinishScopeManager AUTO_FINISH_SCOPE_MANAGER = new AutoFinishScopeManager();
    private OpentracingFilterHelper helper;
    static final long serialVersionUID = 8850730926147154060L;

    OpentracingClientFilter(OpentracingFilterHelper helper) {
        this.setFilterHelper(helper);
    }

    void setFilterHelper(OpentracingFilterHelper helper) {
        this.helper = helper;
    }

    /*
     * Unable to fully structure code
     */
    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        methodName = "filter(outgoing)";
        tracer = OpentracingTracerManager.getTracer();
        if (tracer == null) {
            if (TraceComponent.isAnyTracingEnabled() && OpentracingClientFilter.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)OpentracingClientFilter.tc, (String)(methodName + " no tracer"), (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && OpentracingClientFilter.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)OpentracingClientFilter.tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
        }
        outgoingUri = clientRequestContext.getUri();
        outgoingURL = outgoingUri.toURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && OpentracingClientFilter.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)OpentracingClientFilter.tc, (String)(methodName + " outgoing URL"), (Object[])new Object[]{outgoingURL});
        }
        if (process = true) {
            buildSpanName = this.helper != null ? this.helper.getBuildSpanName(clientRequestContext) : outgoingURL;
            spanBuilder = tracer.buildSpan(buildSpanName);
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client");
            spanBuilder.withTag(Tags.HTTP_URL.getKey(), outgoingURL);
            spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), clientRequestContext.getMethod());
            spanBuilder.withTag(Tags.COMPONENT.getKey(), "jaxrs");
            parentSpanContext = (SpanContext)clientRequestContext.getProperty("child_of");
            if (parentSpanContext != null) {
                spanBuilder.ignoreActiveSpan().asChildOf(parentSpanContext);
            }
            span = spanBuilder.start();
            if (TraceComponent.isAnyTracingEnabled() && OpentracingClientFilter.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)OpentracingClientFilter.tc, (String)(methodName + " span"), (Object[])new Object[]{span});
            }
            scope = OpentracingClientFilter.AUTO_FINISH_SCOPE_MANAGER.activate(span, true);
            try {
                continuation = scope.capture();
                tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
                clientRequestContext.setProperty(OpentracingClientFilter.CLIENT_CONTINUATION_PROP_ID, (Object)continuation);
                if (scope == null) ** GOTO lbl52
                scope.close();
            }
            catch (Throwable var12_14) {
                FFDCFilter.processException((Throwable)var12_14, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"137", (Object)this, (Object[])new Object[]{clientRequestContext});
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable var13_15) {
                        FFDCFilter.processException((Throwable)var13_15, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"137", (Object)this, (Object[])new Object[]{clientRequestContext});
                        var12_14.addSuppressed(var13_15);
                    }
                }
                throw var12_14;
            }
        } else {
            currentSpan = tracer.activeSpan();
            if (currentSpan != null) {
                tracer.inject(currentSpan.context(), Format.Builtin.HTTP_HEADERS, new MultivaluedMapToTextMap((MultivaluedMap<String, Object>)clientRequestContext.getHeaders()));
            }
        }
lbl52:
        // 5 sources

        clientRequestContext.setProperty(OpentracingClientFilter.CLIENT_SPAN_SKIPPED_ID, (Object)(process == false));
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        String methodName = "filter(incoming)";
        Boolean skip = (Boolean)clientRequestContext.getProperty(CLIENT_SPAN_SKIPPED_ID);
        if (skip != null && skip.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"skipped"});
            }
            clientRequestContext.removeProperty(CLIENT_SPAN_SKIPPED_ID);
            return;
        }
        AutoFinishScope.Continuation continuation = (AutoFinishScope.Continuation)clientRequestContext.getProperty(CLIENT_CONTINUATION_PROP_ID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{continuation});
        }
        if (continuation == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " no continuation span"), (Object[])new Object[0]);
            }
            return;
        }
        clientRequestContext.removeProperty(CLIENT_CONTINUATION_PROP_ID);
        AutoFinishScope scope = continuation.activate();
        try {
            Integer httpStatus = clientResponseContext.getStatus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
            }
            scope.span().setTag(Tags.HTTP_STATUS.getKey(), httpStatus);
            if (clientResponseContext.getStatus() >= 400) {
                scope.span().setTag(Tags.ERROR.getKey(), true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{clientResponseContext.getStatus()});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " finish span"), (Object[])new Object[]{scope.span()});
            }
            if (scope != null) {
                scope.close();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"200", (Object)this, (Object[])new Object[]{clientRequestContext, clientResponseContext});
            if (scope != null) {
                try {
                    scope.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.opentracing.OpentracingClientFilter", (String)"200", (Object)this, (Object[])new Object[]{clientRequestContext, clientResponseContext});
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, Object> mvMap;
        static final long serialVersionUID = 4322697928672580337L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, Object> mvMap) {
            this.mvMap = mvMap;
        }

        @Override
        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Trivial
        public void put(String key, String value) {
            this.mvMap.add((Object)key, (Object)value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MultivaluedMapToTextMap.class);
        }
    }
}

