/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.plugin.merge.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.plugin.merge.PluginMergeTool;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="traceComponent", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={PluginMergeTool.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class PluginMergeToolImpl
implements PluginMergeTool {
    private static final TraceComponent traceComponent = Tr.register(PluginMergeToolImpl.class);
    private static final String NO_MERGE_ERR = "Error encountered, no merged file was written";
    private boolean isXdOnly = true;
    private boolean debug = false;
    private int seqNum = 0;
    private final boolean failOver = true;
    private static boolean precedence = false;
    private Element mergeConfigNode;
    private static Element mergeConfigNode2;
    private PluginInfo[] plugins;
    private final ArrayList<PluginInfo> sharedPlugins = new ArrayList();
    private final HashSet<String> emptyServerClusters = new HashSet();
    private String encoding = null;
    private String tc = null;
    private boolean sortVhostGrp = false;
    private int paramCnt = 0;
    public ArrayList<String> G_primaryServers = new ArrayList();
    public ArrayList<String> G_backupServers = new ArrayList();
    private boolean setMatchUriAppVhost = false;
    private static boolean matchUriAppVhost;
    static final long serialVersionUID = -371976861552113117L;

    @Activate
    protected void activate(ComponentContext cc) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    private boolean removeComments(DocumentBuilder parser, Document doc) {
        try {
            DOMImplementation impl = parser.getDOMImplementation();
            if (!impl.hasFeature("traversal", "2.0")) {
                return false;
            }
            Element root = doc.getDocumentElement();
            DocumentTraversal traversable = (DocumentTraversal)((Object)doc);
            NodeIterator iterator = traversable.createNodeIterator(root, 128, null, true);
            Node node = null;
            while ((node = iterator.nextNode()) != null) {
                if (node.getNodeValue().trim().compareTo("Properties") == 0) continue;
                root.removeChild(node);
            }
        }
        catch (FactoryConfigurationError impl) {
            FFDCFilter.processException((Throwable)impl, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"138", (Object)this, (Object[])new Object[]{parser, doc});
            return false;
        }
        return true;
    }

    private void printMergedCopy(String output) throws IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        int i;
        int i2;
        int i3;
        int i4;
        this.tc = "printMergedCopy - ";
        if (this.debug) {
            Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Output File: " + output), (Object[])new Object[0]);
        }
        this.cleanPlugins();
        FileOutputStream fos = new FileOutputStream(output);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = dbf.newDocumentBuilder();
        Document mergeDoc = parser.newDocument();
        Comment comment = mergeDoc.createComment(" This config file was generated by plugin's merge tool v1.0.0.2 on " + new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z").format(new Date()) + " ");
        mergeDoc.appendChild(comment);
        mergeDoc.appendChild(mergeDoc.importNode(this.mergeConfigNode, true));
        this.mergeConfigNode = mergeDoc.getDocumentElement();
        this.removeComments(parser, mergeDoc);
        this.mergeConfigNode.appendChild(mergeDoc.importNode(mergeDoc.createComment(" Server Clusters "), true));
        Node[] sc = null;
        this.sharedPlugins.trimToSize();
        Iterator<PluginInfo> itrSharedPlugins = this.sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            sc = itrSharedPlugins.next().getFailOverServerClusters();
            for (i4 = 0; i4 < sc.length; ++i4) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(sc[i4], true));
            }
        }
        for (i4 = 0; i4 < this.plugins.length - this.paramCnt; ++i4) {
            if (this.plugins[i4].getUniquePluginRep().isEmpty()) continue;
            sc = this.plugins[i4].getUnsharedServerClusters();
            for (int j = 0; j < sc.length; ++j) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(sc[j], true));
            }
        }
        this.mergeConfigNode.appendChild(mergeDoc.createComment(" Virtual Host Groups "));
        Node[] vhgs = null;
        itrSharedPlugins = this.sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            vhgs = itrSharedPlugins.next().getSharedVHostGrps();
            for (i3 = 0; i3 < vhgs.length; ++i3) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(vhgs[i3], true));
            }
        }
        vhgs = null;
        for (i3 = 0; i3 < this.plugins.length - this.paramCnt; ++i3) {
            vhgs = this.plugins[i3].getUnsharedVHostGrp();
            for (int j = 0; j < vhgs.length; ++j) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(vhgs[j], true));
            }
        }
        this.mergeConfigNode.appendChild(mergeDoc.createComment(" URI Groups "));
        Node[] uriGrps = null;
        itrSharedPlugins = this.sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            uriGrps = itrSharedPlugins.next().getUriGrps();
            for (i2 = 0; i2 < uriGrps.length; ++i2) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[i2], true));
            }
        }
        for (i2 = 0; i2 < this.plugins.length - this.paramCnt; ++i2) {
            int j;
            uriGrps = this.plugins[i2].getUriGrps();
            for (j = 0; j < uriGrps.length; ++j) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[j], true));
            }
            uriGrps = this.plugins[i2].getUniqueUriGrps();
            for (j = 0; j < uriGrps.length; ++j) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(uriGrps[j], true));
            }
        }
        this.mergeConfigNode.appendChild(mergeDoc.createComment(" Routes "));
        Node[] routes = null;
        itrSharedPlugins = this.sharedPlugins.iterator();
        while (itrSharedPlugins.hasNext()) {
            routes = itrSharedPlugins.next().getRoutes();
            for (i = 0; i < routes.length; ++i) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(routes[i], true));
            }
        }
        for (i = 0; i < this.plugins.length - this.paramCnt; ++i) {
            routes = this.plugins[i].getRoutes();
            for (int j = 0; j < routes.length; ++j) {
                this.mergeConfigNode.appendChild(mergeDoc.importNode(routes[j], true));
            }
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("encoding", this.encoding);
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(mergeDoc);
        trans.transform(source, result);
        fos.flush();
        fos.close();
        Tr.info((TraceComponent)traceComponent, (String)("Merged plugin config file written to " + output), (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void cleanPlugins() {
        this.sharedPlugins.trimToSize();
        Iterator<PluginInfo> itrSharedPlugins = this.sharedPlugins.iterator();
        try {
            while (itrSharedPlugins.hasNext()) {
                itrSharedPlugins.next().cleanPlugin();
            }
            for (int i = 0; i < this.plugins.length - this.paramCnt; ++i) {
                this.plugins[i].cleanPlugin();
            }
        }
        catch (ParserConfigurationException i) {
            void e;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"276", (Object)this, (Object[])new Object[0]);
            Tr.info((TraceComponent)traceComponent, (String)NO_MERGE_ERR, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
    }

    private void lfMerge() throws ParserConfigurationException {
        this.tc = "lfMerge - ";
        if (this.debug) {
            Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Merging plugins."), (Object[])new Object[0]);
        }
        Iterator<PluginInfo> itrShared = null;
        Hashtable<String, AppInfo> p2 = null;
        AppInfo p2AppInfo = null;
        Enumeration<String> p1Uids = null;
        String uid = null;
        if (this.debug) {
            Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Looping through all input files"), (Object[])new Object[0]);
        }
        for (int i = 1; i < this.plugins.length - this.paramCnt; ++i) {
            Hashtable<String, AppInfo> p1;
            p2 = this.plugins[i].getUniquePluginRep();
            this.sharedPlugins.trimToSize();
            PluginInfo sharedPlugin2 = null;
            for (PluginInfo sharedPlugin2 : this.sharedPlugins) {
                p1 = sharedPlugin2.getUniquePluginRep();
                p1Uids = p1.keys();
                while (p1Uids.hasMoreElements()) {
                    uid = p1Uids.nextElement();
                    if (this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)(this.tc + "UID: " + uid), (Object[])new Object[0]);
                    }
                    if (!p2.containsKey(uid)) continue;
                    if (this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Adding UID to shared: " + uid), (Object[])new Object[0]);
                    }
                    p2AppInfo = p2.get(uid);
                    sharedPlugin2.addSharedServers(this.plugins[i].getSeqNum(), p2AppInfo.getServerCluster(), p1.get(uid), true);
                    p2.remove(uid);
                }
            }
            PluginInfo newSharedPlugin = null;
            for (int j = 0; j < i; ++j) {
                p1 = this.plugins[j].getUniquePluginRep();
                p1Uids = p1.keys();
                while (p1Uids.hasMoreElements()) {
                    uid = p1Uids.nextElement();
                    if (!p2.containsKey(uid)) continue;
                    AppInfo p1AppInfo = p1.get(uid);
                    p2AppInfo = p2.get(uid);
                    if (newSharedPlugin == null) {
                        newSharedPlugin = new PluginInfo(this.seqNum, p1AppInfo.getServerCluster());
                        ++this.seqNum;
                    }
                    newSharedPlugin.addMatch(uid, p1AppInfo.getAppName(), p1AppInfo.getServerCluster(), this.plugins[j].getSeqNum(), p2AppInfo.getServerCluster(), this.plugins[i].getSeqNum(), p1AppInfo.getUri(), p1AppInfo.getVh());
                    p1.remove(uid);
                    p2.remove(uid);
                }
                this.setReasonForUniqueness(this.plugins[j], p2);
                this.setReasonForUniqueness(this.plugins[i], p1);
                this.tc = "lfMerge - ";
            }
            if (newSharedPlugin != null) {
                this.sharedPlugins.add(newSharedPlugin);
            }
            if (!this.debug) continue;
            Tr.info((TraceComponent)traceComponent, (String)" ", (Object[])new Object[0]);
        }
    }

    private void pMerge() {
        for (int i = 1; i < this.plugins.length - this.paramCnt; ++i) {
            for (int j = 0; j < i; ++j) {
                Hashtable<String, AppInfo> p1 = this.plugins[j].getUniquePluginRep();
                Hashtable<String, AppInfo> p2 = this.plugins[i].getUniquePluginRep();
                Enumeration<String> p1Uids = p1.keys();
                while (p1Uids.hasMoreElements()) {
                    String uid = p1Uids.nextElement();
                    if (!p2.containsKey(uid)) continue;
                    p2.remove(uid);
                }
                this.setReasonForUniqueness(this.plugins[j], p2);
                this.setReasonForUniqueness(this.plugins[i], p1);
            }
        }
    }

    private void setReasonForUniqueness(PluginInfo pgi1, Hashtable<String, AppInfo> p2) {
        this.tc = "setReasonForUniqueness - ";
        if (this.debug) {
            Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Checking Uniqueness."), (Object[])new Object[0]);
        }
        AppInfo info = null;
        Enumeration<AppInfo> enumP2 = p2.elements();
        while (enumP2.hasMoreElements()) {
            info = enumP2.nextElement();
            String uriName = info.getUri().getAttribute("Name");
            if (!pgi1.containedUris.contains(uriName)) {
                info.uniqueVhgNeeded = true;
                continue;
            }
            if (matchUriAppVhost && !pgi1.containedApps.contains(info.getAppName())) {
                info.uniqueVhgNeeded = true;
                continue;
            }
            info.uniqueVhgNeeded = false;
        }
    }

    public static void nodeListRemoveAll(Element xEml, NodeList nodes) {
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            xEml.removeChild(nodes.item(0));
        }
    }

    public static ArrayList<Node> nodeListToDeadArray(NodeList nodes) {
        ArrayList<Node> rtnNodes = null;
        if (nodes != null) {
            rtnNodes = new ArrayList<Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                rtnNodes.add(nodes.item(i).cloneNode(true));
            }
            rtnNodes.trimToSize();
        }
        return rtnNodes;
    }

    private void loadData(String[] files) throws SAXException, IOException, ParserConfigurationException {
        this.tc = "loadData - ";
        this.plugins = new PluginInfo[files.length - 1];
        int plgFile = 0;
        String fileName = null;
        for (int j = 0; j < files.length - 1; ++j) {
            if (!files[j].equals("-debug")) continue;
            this.debug = true;
        }
        if (this.debug) {
            Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Loading parameters and files"), (Object[])new Object[0]);
        }
        for (int i = 0; i < files.length - 1; ++i) {
            if (this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)(this.tc + " "), (Object[])new Object[0]);
            }
            if ((fileName = files[i]).indexOf("-", 0) == 0) {
                if (fileName.equals("-sortVhostGrp")) {
                    if (this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)(this.tc + "sortVhostGrp requested"), (Object[])new Object[0]);
                    }
                    this.sortVhostGrp = true;
                }
                if (fileName.equals("-setMatchUriAppVhost")) {
                    this.setMatchUriAppVhost = true;
                    if (this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)(this.tc + "setMatchUriAppVhost requested"), (Object[])new Object[0]);
                    }
                }
                if (fileName.equals("-debug") && this.debug) {
                    Tr.info((TraceComponent)traceComponent, (String)(this.tc + "debug requested"), (Object[])new Object[0]);
                }
                if (!(fileName.equals("-debug") || fileName.equals("-sortVhostGrp") || fileName.equals("-setMatchUriAppVhost"))) {
                    Tr.info((TraceComponent)traceComponent, (String)("Parameter: " + fileName + " is not valid.  It will be ignored"), (Object[])new Object[0]);
                }
                ++this.paramCnt;
                continue;
            }
            if (this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)(this.tc + "Processing file:  " + files[i]), (Object[])new Object[0]);
            }
            File f = new File(files[i]);
            Tr.info((TraceComponent)traceComponent, (String)("Found file " + files[i] + ": " + f.exists()), (Object[])new Object[0]);
            FileInputStream fis = new FileInputStream(f);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(fis));
            this.plugins[plgFile] = new PluginInfo(plgFile, dom.getDocumentElement(), files[i]);
            ++this.seqNum;
            this.encoding = dom.getXmlEncoding();
            mergeConfigNode2 = (Element)dom.getDocumentElement().cloneNode(true);
            NodeList nl = mergeConfigNode2.getElementsByTagName("IntelligentManagement");
            if (nl.getLength() == 0) {
                if (plgFile == 0) {
                    this.mergeConfigNode = (Element)dom.getDocumentElement().cloneNode(true);
                    PluginMergeToolImpl.nodeListRemoveAll(this.mergeConfigNode, this.mergeConfigNode.getElementsByTagName("ServerCluster"));
                    PluginMergeToolImpl.nodeListRemoveAll(this.mergeConfigNode, this.mergeConfigNode.getElementsByTagName("VirtualHostGroup"));
                    PluginMergeToolImpl.nodeListRemoveAll(this.mergeConfigNode, this.mergeConfigNode.getElementsByTagName("UriGroup"));
                    PluginMergeToolImpl.nodeListRemoveAll(this.mergeConfigNode, this.mergeConfigNode.getElementsByTagName("Route"));
                }
            } else {
                Tr.info((TraceComponent)traceComponent, (String)"Configurations with IntelligentManagement can not be merged.", (Object[])new Object[0]);
                throw new RuntimeException("Configurations with IntelligentManagement can not be merged.");
            }
            ++plgFile;
        }
    }

    public static void printHelp() {
        System.out.println("\nUSAGE\n  <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg1.xml <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg2.xml [...] <Liberty_Home>/wlp/usr/servers/<Controller_Name>/<ClusterName>-plugin-cfg.xml\n");
        System.out.println("DESCRIPTION\n    The PluginCfgMerge Tool combines the plugin-cfg.xml files from two or more unbridged \n    servers such that the IBM HTTP Server Plugin will route traffic to all servers. \n    A uri is considered to be shared between two unbridged servers if the uri and  \n    corresponding virtual host definitions are identical.\n\n    The contents of the merged plugin-cfg.xml files must be in English language\n\n    Additional parmaters:\n     -debug               = prints additional log statements\n     -sortVhostGrp        = adds VirtualHostGroup name as part of the key.  Use this if a single XML contains\n                            two identical sets of URIs assigned to two different VirtualHostGroup Names.\n     -setMatchUriAppVhost = sets the MatchUriAppVhost value.\n \n Example with Paramters:\n    -sortVhostGrp -debug <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg1.xml <Liberty_Home>/wlp/usr/servers/<Member_Name>/plugin-cfg2.xml [...] <Liberty_Home>/wlp/usr/servers/<Controller_Name>/<ClusterName>-plugin-cfg.xml\n");
        System.exit(1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge(String[] argv) {
        if (argv.length < 2) {
            throw new IllegalArgumentException("Please provide at least 1 plugin-cfg.xml file to merge.");
        }
        PluginMergeToolImpl toolInstance = new PluginMergeToolImpl();
        matchUriAppVhost = Boolean.getBoolean("com.ibm.ws.pluginmerge.match.appname");
        try {
            Tr.info((TraceComponent)traceComponent, (String)"Merging...", (Object[])new Object[0]);
            toolInstance.loadData(argv);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"582", (Object)this, (Object[])new Object[]{argv});
            throw new RuntimeException((Throwable)t);
        }
        try {
            if (precedence) {
                toolInstance.pMerge();
            } else {
                toolInstance.lfMerge();
            }
            toolInstance.printMergedCopy(argv[argv.length - 1]);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"592", (Object)this, (Object[])new Object[]{argv});
            throw new RuntimeException(t);
        }
        Tr.info((TraceComponent)traceComponent, (String)"Merge Complete", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] argv) {
        if (argv.length < 3) {
            PluginMergeToolImpl.printHelp();
        }
        matchUriAppVhost = Boolean.getBoolean("com.ibm.ws.pluginmerge.match.appname");
        PluginMergeToolImpl toolInstance = new PluginMergeToolImpl();
        try {
            System.out.println("Merging:");
            toolInstance.loadData(argv);
        }
        catch (SAXException sAXException) {
            void e;
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"608", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(2);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"612", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(3);
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"616", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(3);
        }
        try {
            if (precedence) {
                toolInstance.pMerge();
            } else {
                toolInstance.lfMerge();
            }
            toolInstance.printMergedCopy(argv[argv.length - 1]);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"628", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(4);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl", (String)"632", null, (Object[])new Object[]{argv});
            e.printStackTrace();
            System.out.println(NO_MERGE_ERR);
            System.exit(5);
        }
        System.out.println("Merge Complete");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        matchUriAppVhost = false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class AppInfo
    implements Cloneable {
        private String appName = null;
        private Element uriGrp;
        private Element route;
        private Element serverCluster;
        private Element vhg;
        private Element uri;
        private Element vh = null;
        private final Vector sharedUris = new Vector();
        private final Hashtable sharedServers = new Hashtable();
        private boolean uniqueVhgNeeded = false;
        static final long serialVersionUID = 1485288136585737722L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AppInfo() {
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public Element getUriGrp() {
            return this.uriGrp;
        }

        public void setUriGrp(Element uriGrp) {
            this.uriGrp = uriGrp;
        }

        public Element getRoute() {
            return this.route;
        }

        public void setRoute(Element route) {
            this.route = route;
        }

        public Element getServerCluster() {
            return this.serverCluster;
        }

        public void setServerCluster(Element serverCluster) {
            this.serverCluster = serverCluster;
        }

        public Element getVhg() {
            return this.vhg;
        }

        public void setVhg(Element vhg) {
            this.vhg = vhg;
        }

        public Element getUri() {
            return this.uri;
        }

        public void setUri(Element uri) {
            this.uri = uri;
        }

        public Element getVh() {
            return this.vh;
        }

        public void setVh(Element vh) {
            this.vh = vh;
        }

        public void addSharedUriElements(Element uri) {
            this.sharedUris.add(uri);
        }

        public Node[] getSharedUriElemenets() {
            this.sharedUris.trimToSize();
            Object[] rtnNodes = new Node[this.sharedUris.size()];
            this.sharedUris.copyInto(rtnNodes);
            return rtnNodes;
        }

        public boolean setSharedServer(String serverName, Node serverNode) {
            return this.sharedServers.put(serverName, serverNode.cloneNode(true)) == null;
        }

        public Set getAppServerSet() {
            return this.sharedServers.keySet();
        }

        public Hashtable getSharedServersMap() {
            return this.sharedServers;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AppInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class PluginInfo {
        private int seqNum = 0;
        private boolean isShared = false;
        private final Hashtable uniquePluginRep = new Hashtable();
        private ArrayList<String> primaryServers = null;
        private ArrayList<String> backupServers = null;
        private Document sharedDoc = null;
        private Document unsharedDoc = null;
        private Element sharedCluster = null;
        private final Vector<Node> unsharedClusters = new Vector();
        private final Hashtable<Set<String>, Node> allSharedScElements = new Hashtable();
        private Hashtable<String, Node> sharedVhosts = null;
        private final Hashtable<String, Node> allSharedServers = new Hashtable();
        private final Vector<Node> unsharedVhg = new Vector();
        private ArrayList<Node> sharedVhgs = null;
        private Hashtable<String, String> uriVhostGrpMap = null;
        private final Hashtable<String, Node> uriGrps = new Hashtable();
        private final Hashtable<String, Node> uniqueUriGrps = new Hashtable();
        private final Vector<Node> routes = new Vector();
        private final HashSet<String> containedUris = new HashSet();
        private final HashSet<String> containedApps = new HashSet();
        static final long serialVersionUID = -7683981277239842238L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private void listNodes(Node node, String indent, String Type) {
            NodeList list;
            int i;
            if (node.hasAttributes()) {
                NamedNodeMap attrs = node.getAttributes();
                for (i = 0; i < attrs.getLength(); ++i) {
                    Attr attribute = (Attr)attrs.item(i);
                    if (!attribute.getName().equals("Name")) continue;
                    if (Type == "Primary") {
                        if (PluginMergeToolImpl.this.debug) {
                            Tr.info((TraceComponent)traceComponent, (String)(indent + "Found PrimaryServer: " + attribute.getName() + " = " + attribute.getValue()), (Object[])new Object[0]);
                        }
                        PluginMergeToolImpl.this.G_primaryServers.add(attribute.getValue());
                        continue;
                    }
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)(indent + "Found BackupServer: " + attribute.getName() + " = " + attribute.getValue()), (Object[])new Object[0]);
                    }
                    PluginMergeToolImpl.this.G_backupServers.add(attribute.getValue());
                }
            }
            if ((list = node.getChildNodes()).getLength() > 0) {
                for (i = 0; i < list.getLength(); ++i) {
                    this.listNodes(list.item(i), indent + "  ", Type);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @FFDCIgnore(value={ArrayIndexOutOfBoundsException.class})
        public PluginInfo(int seqNum, Element config, String fileLoc) {
            Node n;
            this.seqNum = seqNum;
            Stack<Node> stack = new Stack<Node>();
            NodeList nodeList1 = config.getElementsByTagName("PrimaryServers");
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)"Storing Primary Server information", (Object[])new Object[0]);
            }
            for (int i = 0; i < nodeList1.getLength(); ++i) {
                Node n2 = nodeList1.item(i);
                Node node = n2.getFirstChild();
                Tr.info((TraceComponent)traceComponent, (String)("Calling listNodes for : " + n2.getNodeName()), (Object[])new Object[0]);
                this.listNodes(n2, "", "Primary");
                while (node != null) {
                    if (node.hasChildNodes()) {
                        if (node.getNextSibling() != null) {
                            stack.push(node.getNextSibling());
                        }
                        node = node.getFirstChild();
                        continue;
                    }
                    if ((node = node.getNextSibling()) != null || stack.isEmpty()) continue;
                    node = (Node)stack.pop();
                }
            }
            NodeList nodeList2 = config.getElementsByTagName("BackupServers");
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)"Gathering Backup Server information", (Object[])new Object[0]);
            }
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node n2 = nodeList2.item(i);
                Tr.info((TraceComponent)traceComponent, (String)("Calling listNodes for : " + n2.getNodeName()), (Object[])new Object[0]);
                this.listNodes(n2, "", "Backup");
            }
            NodeList nl = config.getElementsByTagName("PrimaryServers");
            int i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                n.getParentNode().removeChild(n);
            }
            nl = config.getElementsByTagName("BackupServers");
            i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                n.getParentNode().removeChild(n);
            }
            Hashtable<String, Node> serverClusters = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("ServerCluster")), "Name");
            Hashtable<String, Node> routes = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("Route")), "UriGroup");
            Hashtable<String, Node> vHostGrps = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("VirtualHostGroup")), "Name");
            Enumeration<String> keys = serverClusters.keys();
            while (keys.hasMoreElements()) {
                Element cluster = (Element)serverClusters.get(keys.nextElement());
                cluster.setAttribute("Name", cluster.getAttribute("Name") + "_" + seqNum);
            }
            keys = vHostGrps.keys();
            while (keys.hasMoreElements()) {
                Element vhg = (Element)vHostGrps.get(keys.nextElement());
                vhg.setAttribute("Name", vhg.getAttribute("Name") + "_" + seqNum);
            }
            keys = routes.keys();
            while (keys.hasMoreElements()) {
                Element route = (Element)routes.get(keys.nextElement());
                route.setAttribute("ServerCluster", route.getAttribute("ServerCluster") + "_" + seqNum);
                route.setAttribute("VirtualHostGroup", route.getAttribute("VirtualHostGroup") + "_" + seqNum);
            }
            Hashtable<String, Node> uriGrpsTmp = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(config.getElementsByTagName("UriGroup")), "Name");
            AppInfo info = new AppInfo();
            String uriName = null;
            Enumeration<String> uriGrpNames = uriGrpsTmp.keys();
            while (uriGrpNames.hasMoreElements()) {
                String uriGrpName;
                block26: {
                    uriGrpName = uriGrpNames.nextElement();
                    if (PluginMergeToolImpl.this.isXdOnly) {
                        try {
                            info.setAppName(uriGrpName.split("/cell/.+?(/application/)")[1]);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            Tr.info((TraceComponent)traceComponent, (String)"Merging a non-ODC generated plugin-cfg.xml", (Object[])new Object[0]);
                            PluginMergeToolImpl.this.isXdOnly = false;
                            info.setAppName(uriGrpName);
                            if (!PluginMergeToolImpl.this.setMatchUriAppVhost && matchUriAppVhost) {
                                matchUriAppVhost = false;
                                Tr.info((TraceComponent)traceComponent, (String)"Cannot match based on uri app vhost for non-ODC generated plugin-cfg.xml files. com.ibm.ws.pluginmerge.match.appname set to false", (Object[])new Object[0]);
                                break block26;
                            }
                            matchUriAppVhost = PluginMergeToolImpl.this.setMatchUriAppVhost;
                        }
                    } else {
                        info.setAppName(uriGrpName);
                    }
                }
                this.containedApps.add(info.getAppName());
                Element eUriGrp = (Element)uriGrpsTmp.get(uriGrpName);
                info.setUriGrp((Element)eUriGrp.cloneNode(false));
                try {
                    info.setRoute((Element)((Element)routes.get(uriGrpName)).cloneNode(true));
                }
                catch (NullPointerException nullPointerException) {
                    FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$PluginInfo", (String)"833", (Object)this, (Object[])new Object[]{seqNum, config, fileLoc});
                    Tr.info((TraceComponent)traceComponent, (String)("Skipping UriGroup " + uriGrpName + " because it does not have a corresponding Route definition"), (Object[])new Object[0]);
                    continue;
                }
                String scName = info.getRoute().getAttribute("ServerCluster");
                info.setServerCluster((Element)((Element)serverClusters.get(scName.substring(0, scName.lastIndexOf("_" + seqNum)))).cloneNode(true));
                String vhgName = info.getRoute().getAttribute("VirtualHostGroup");
                Element eVhg = (Element)vHostGrps.get(vhgName.substring(0, vhgName.lastIndexOf("_" + seqNum)));
                info.setVhg((Element)eVhg.cloneNode(false));
                Hashtable<String, Node> vHosts = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(eVhg.getElementsByTagName("VirtualHost")), "Name");
                Hashtable<String, Node> uris = this.createTable(PluginMergeToolImpl.nodeListToDeadArray(eUriGrp.getElementsByTagName("Uri")), "Name");
                Enumeration<String> uriNames = uris.keys();
                while (uriNames.hasMoreElements()) {
                    uriName = uriNames.nextElement();
                    info.setUri((Element)((Element)uris.get(uriName)).cloneNode(true));
                    this.containedUris.add(uriName);
                    Enumeration<String> eVh = vHosts.keys();
                    while (eVh.hasMoreElements()) {
                        String vhName = eVh.nextElement();
                        info.setVh((Element)((Element)vHosts.get(vhName)).cloneNode(true));
                        try {
                            if (matchUriAppVhost) {
                                this.uniquePluginRep.put("/uri/" + uriName + "/app/" + info.getAppName() + "/vHost/" + vhName, info.clone());
                                continue;
                            }
                            if (PluginMergeToolImpl.this.sortVhostGrp) {
                                this.uniquePluginRep.put("/uri/" + uriName + "/vhostGrp/" + vhgName.substring(0, vhgName.lastIndexOf("_" + seqNum)) + "/vHost/" + vhName, info.clone());
                                continue;
                            }
                            this.uniquePluginRep.put("/uri/" + uriName + "/vHost/" + vhName, info.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            void e;
                            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.http.plugin.merge.internal.PluginMergeToolImpl$PluginInfo", (String)"869", (Object)this, (Object[])new Object[]{seqNum, config, fileLoc});
                            Tr.info((TraceComponent)traceComponent, (String)("Error processing /uri/" + uriName + "/app/" + info.getAppName() + "/vHost/\n" + e.getLocalizedMessage()), (Object[])new Object[0]);
                            throw new RuntimeException((Throwable)e);
                        }
                    }
                }
            }
        }

        public PluginInfo(int seqNum, Element serverCluster1) throws ParserConfigurationException {
            this.isShared = true;
            this.seqNum = seqNum;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            this.sharedDoc = parser.newDocument();
            this.sharedCluster = (Element)serverCluster1.cloneNode(false);
            this.sharedVhosts = new Hashtable();
            this.sharedVhgs = new ArrayList();
            this.uriVhostGrpMap = new Hashtable();
            this.primaryServers = new ArrayList();
            this.backupServers = new ArrayList();
        }

        private void addMatch(String uid, String appName, Element serverCluster1, int p1_seq, Element serverCluster2, int p2_seq, Element uri, Element vh) {
            AppInfo sharedAppInfo = null;
            Object sharedServers = null;
            if (this.uniquePluginRep.containsKey(uid)) {
                sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
            } else {
                sharedAppInfo = new AppInfo();
                sharedAppInfo.setAppName(appName);
                this.uniquePluginRep.put(uid, sharedAppInfo);
            }
            sharedAppInfo.setUri(uri);
            sharedAppInfo.setVh(vh);
            this.sharedVhosts.put(vh.getAttribute("Name"), vh);
            this.addSharedServers(p1_seq, serverCluster1, sharedAppInfo, true);
            this.addSharedServers(p2_seq, serverCluster2, sharedAppInfo, true);
        }

        private void addSharedServers(int postfix, Element sc, AppInfo appInfo, boolean isPrimary) {
            Element srvr = null;
            String serverNom = null;
            Iterator<Node> itrServers = PluginMergeToolImpl.nodeListToDeadArray(sc.getElementsByTagName("Server")).iterator();
            if (!itrServers.hasNext()) {
                String scName = sc.getAttribute("Name");
                if (!PluginMergeToolImpl.this.emptyServerClusters.contains(scName)) {
                    Tr.info((TraceComponent)traceComponent, (String)("ServerCluster element '" + scName.substring(0, scName.lastIndexOf("_")) + "' from " + sc.getBaseURI() + " does not contain any Server elements"), (Object[])new Object[0]);
                    PluginMergeToolImpl.this.emptyServerClusters.add(scName);
                }
            }
            while (itrServers.hasNext()) {
                srvr = (Element)itrServers.next();
                serverNom = srvr.getAttribute("Name") + "_" + postfix;
                srvr.setAttribute("Name", serverNom);
                if (appInfo.setSharedServer(serverNom, srvr)) {
                    if (isPrimary) {
                        this.primaryServers.add(serverNom);
                    } else {
                        this.backupServers.add(serverNom);
                    }
                }
                this.allSharedServers.put(serverNom, srvr.cloneNode(true));
            }
        }

        public String createSharedName(String nom) {
            return "/cell/sharedCell_" + this.seqNum + "/" + nom;
        }

        private Hashtable<String, Node> createTable(ArrayList<Node> elements, String attr) {
            Hashtable<String, Node> table = new Hashtable<String, Node>();
            if (elements != null) {
                String key = null;
                Object var5_5 = null;
                elements.trimToSize();
                for (Element element : elements) {
                    key = element.getAttribute(attr);
                    if (table.put(key, element) == null || !PluginMergeToolImpl.this.debug) continue;
                    Tr.info((TraceComponent)traceComponent, (String)("Replaced value for key: " + key), (Object[])new Object[0]);
                }
            }
            return table;
        }

        private void makeServerClusterElement(int scNum, Set serverNames) {
            Element sc = (Element)this.sharedCluster.cloneNode(true);
            sc = (Element)this.sharedDoc.importNode(sc, true);
            sc.setAttribute("Name", "Shared_" + this.seqNum + "_Cluster_" + scNum);
            Iterator itr = serverNames.iterator();
            while (itr.hasNext()) {
                sc.appendChild(this.sharedDoc.importNode(((Element)this.allSharedServers.get(itr.next())).cloneNode(true), true));
            }
            this.allSharedScElements.put(serverNames, sc.cloneNode(true));
        }

        private void createShared_ServerClusters_VhostGrps() {
            PluginMergeToolImpl.this.tc = "createShared_ServerClusters_VhostGrps - ";
            int scNum = 0;
            int serverCount = 0;
            Set srvrSetTmp = null;
            HashSet<String> vhostSetTmp = null;
            ArrayList srvrSetList = null;
            AppInfo sharedAppInfo = null;
            Hashtable serversSetTbl = new Hashtable();
            Hashtable uriVhostSetTbl = new Hashtable();
            Enumeration e = null;
            e = this.uniquePluginRep.keys();
            while (e.hasMoreElements()) {
                String uid = (String)e.nextElement();
                sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
                srvrSetTmp = ((Hashtable)sharedAppInfo.getSharedServersMap().clone()).keySet();
                serverCount = srvrSetTmp.size();
                if (serversSetTbl.containsKey(new Integer(serverCount))) {
                    ((ArrayList)serversSetTbl.get(new Integer(serverCount))).add(srvrSetTmp);
                } else {
                    srvrSetList = new ArrayList();
                    srvrSetList.add(srvrSetTmp);
                    serversSetTbl.put(new Integer(serverCount), srvrSetList);
                }
                String uriName = uid.substring(0, uid.indexOf("/vHost/"));
                if (PluginMergeToolImpl.this.debug) {
                    Tr.info((TraceComponent)traceComponent, (String)(PluginMergeToolImpl.this.tc + "uriName: " + uriName), (Object[])new Object[0]);
                }
                if (uriVhostSetTbl.containsKey(uriName)) {
                    ((Set)uriVhostSetTbl.get(uriName)).add(sharedAppInfo.getVh().getAttribute("Name"));
                    continue;
                }
                vhostSetTmp = new HashSet<String>();
                vhostSetTmp.add(sharedAppInfo.getVh().getAttribute("Name"));
                uriVhostSetTbl.put(uriName, vhostSetTmp);
            }
            e = serversSetTbl.keys();
            while (e.hasMoreElements()) {
                int i;
                srvrSetList = (ArrayList)serversSetTbl.get(e.nextElement());
                srvrSetList.trimToSize();
                Set[] sets = new Set[srvrSetList.size()];
                srvrSetList.toArray(sets);
                for (i = 0; i < sets.length - 1; ++i) {
                    for (int j = i + 1; j < sets.length; ++j) {
                        if (!sets[i].containsAll(sets[j])) continue;
                        sets[j].clear();
                    }
                }
                for (i = 0; i < sets.length; ++i) {
                    if (sets[i].isEmpty()) continue;
                    this.makeServerClusterElement(scNum, sets[i]);
                    ++scNum;
                }
            }
            int vhGrpNum = 0;
            Hashtable<Integer, ArrayList[]> vhostSetsTbl = new Hashtable<Integer, ArrayList[]>();
            ArrayList[] vhostSetList = null;
            e = uriVhostSetTbl.keys();
            while (e.hasMoreElements()) {
                String uriNom = (String)e.nextElement();
                vhostSetTmp = (HashSet<String>)uriVhostSetTbl.get(uriNom);
                if (vhostSetsTbl.containsKey(vhostSetTmp.size())) {
                    boolean found = false;
                    vhostSetList = (ArrayList[])vhostSetsTbl.get(vhostSetTmp.size());
                    Iterator itrSetList = vhostSetList[0].iterator();
                    Iterator itrVhgName = vhostSetList[1].iterator();
                    while (itrSetList.hasNext()) {
                        String vhgName = (String)itrVhgName.next();
                        if (!((Set)itrSetList.next()).containsAll(vhostSetTmp)) continue;
                        found = true;
                        this.uriVhostGrpMap.put(uriNom, vhgName);
                        break;
                    }
                    if (found) continue;
                    String newVhgName = this.createSharedVhostGrp(vhostSetTmp, vhGrpNum);
                    ++vhGrpNum;
                    vhostSetList[0].add(vhostSetTmp);
                    vhostSetList[1].add(newVhgName);
                    vhostSetsTbl.put(vhostSetTmp.size(), vhostSetList);
                    this.uriVhostGrpMap.put(uriNom, newVhgName);
                    continue;
                }
                String newVhgName = this.createSharedVhostGrp(vhostSetTmp, vhGrpNum);
                ++vhGrpNum;
                vhostSetList = new ArrayList[]{new ArrayList(), new ArrayList()};
                vhostSetList[0].add(vhostSetTmp);
                vhostSetList[1].add(newVhgName);
                vhostSetsTbl.put(vhostSetTmp.size(), vhostSetList);
                this.uriVhostGrpMap.put(uriNom, newVhgName);
            }
        }

        private String createSharedVhostGrp(HashSet vhostsSet, int grpNum) {
            String sharedVhgName = this.createSharedName("vHostGroup/shared_host_" + grpNum);
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)("createSharedVhostGrp - sharedVghName: " + sharedVhgName), (Object[])new Object[0]);
            }
            Element eVhg = (Element)this.sharedDoc.createElement("VirtualHostGroup").cloneNode(true);
            eVhg.setAttribute("Name", sharedVhgName);
            Iterator itr = vhostsSet.iterator();
            while (itr.hasNext()) {
                eVhg.appendChild(this.sharedDoc.importNode(this.sharedVhosts.get(itr.next()), true));
            }
            this.sharedVhgs.add(eVhg.cloneNode(true));
            return sharedVhgName;
        }

        private void cleanPlugin() throws ParserConfigurationException {
            PluginMergeToolImpl.this.tc = "cleanPlugin - ";
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)(PluginMergeToolImpl.this.tc + "Cleaning the plugin"), (Object[])new Object[0]);
            }
            Enumeration<Object> e = null;
            if (this.isShared) {
                this.createShared_ServerClusters_VhostGrps();
                Element eRoute = (Element)this.sharedDoc.createElement("Route").cloneNode(true);
                Hashtable knownUris = new Hashtable();
                e = this.uniquePluginRep.keys();
                while (e.hasMoreElements()) {
                    String uid = (String)e.nextElement();
                    AppInfo sharedAppInfo = (AppInfo)this.uniquePluginRep.get(uid);
                    String appName = sharedAppInfo.getAppName();
                    Element eUriGrp = null;
                    if (!this.uriGrps.containsKey(appName)) {
                        Element sc = null;
                        Set servers = sharedAppInfo.getAppServerSet();
                        Enumeration<Set<String>> serverSets = this.allSharedScElements.keys();
                        while (serverSets.hasMoreElements()) {
                            Set<String> s = serverSets.nextElement();
                            if (servers.size() != s.size() || !s.containsAll(servers)) continue;
                            sc = (Element)this.allSharedScElements.get(s);
                            break;
                        }
                        if (sc == null) {
                            Tr.info((TraceComponent)traceComponent, (String)("Unable to find a mathcing ServerCluster definition for uid " + uid + "\nSkipping the unique instance of " + appName), (Object[])new Object[0]);
                            continue;
                        }
                        eUriGrp = (Element)this.sharedDoc.createElement("UriGroup").cloneNode(true);
                        eUriGrp.setAttribute("Name", this.createSharedName("application/" + appName));
                        HashSet<String> uris = new HashSet<String>();
                        String uriNom = sharedAppInfo.getUri().getAttribute("Name");
                        uris.add(uriNom);
                        knownUris.put(appName, uris);
                        eUriGrp.appendChild(this.sharedDoc.importNode(sharedAppInfo.getUri().cloneNode(true), true));
                        this.uriGrps.put(appName, eUriGrp.cloneNode(true));
                        String newKeyUriVhg = uid.substring(0, uid.indexOf("/vHost/"));
                        eRoute.setAttribute("VirtualHostGroup", this.uriVhostGrpMap.get(newKeyUriVhg));
                        eRoute.setAttribute("UriGroup", eUriGrp.getAttribute("Name"));
                        eRoute.setAttribute("ServerCluster", sc.getAttribute("Name"));
                        this.routes.add(eRoute.cloneNode(true));
                        continue;
                    }
                    HashSet uris = (HashSet)knownUris.get(appName);
                    if (!uris.contains(sharedAppInfo.getUri().getAttribute("Name"))) {
                        uris.add(sharedAppInfo.getUri().getAttribute("Name"));
                        ((Element)this.uriGrps.get(appName)).appendChild(this.sharedDoc.importNode(sharedAppInfo.getUri().cloneNode(true), true));
                    }
                    eUriGrp = (Element)this.uriGrps.get(appName);
                }
            } else {
                HashSet<String> knownSc = new HashSet<String>();
                Hashtable<String, Node> knownVhgs = new Hashtable<String, Node>();
                Hashtable knownVhs = new Hashtable();
                Hashtable<String, HashSet<String>> knownUris = new Hashtable<String, HashSet<String>>();
                Hashtable<String, Node> knownUniqueVhgs = new Hashtable<String, Node>();
                Hashtable knownUniqueVhs = new Hashtable();
                Hashtable knownUniqueUris = new Hashtable();
                e = this.uniquePluginRep.elements();
                while (e.hasMoreElements()) {
                    HashSet<String> uris;
                    AppInfo uid = (AppInfo)e.nextElement();
                    Element uriGrp = (Element)uid.getUriGrp().cloneNode(true);
                    String uriGrpName = uriGrp.getAttribute("Name");
                    if (uid.uniqueVhgNeeded) {
                        if (!this.uniqueUriGrps.containsKey(uriGrpName)) {
                            Element newUriGrp = (Element)uriGrp.cloneNode(true);
                            newUriGrp.setAttribute("Name", uriGrpName + "_" + this.seqNum);
                            newUriGrp.appendChild(uid.getUri().cloneNode(true));
                            this.uniqueUriGrps.put(uriGrpName, newUriGrp.cloneNode(true));
                            HashSet<String> uniqueUris = new HashSet<String>();
                            uniqueUris.add(uid.getUri().getAttribute("Name"));
                            knownUniqueUris.put(uriGrpName, uniqueUris);
                        } else {
                            HashSet uniqueUris = (HashSet)knownUniqueUris.get(uriGrpName);
                            if (!uniqueUris.contains(uid.getUri().getAttribute("Name"))) {
                                uniqueUris.add(uid.getUri().getAttribute("Name"));
                                ((Element)this.uniqueUriGrps.get(uriGrpName)).appendChild(uid.getUri().cloneNode(true));
                            }
                        }
                        uid.getRoute().setAttribute("UriGroup", uriGrpName + "_" + this.seqNum);
                    } else if (!this.uriGrps.containsKey(uriGrpName)) {
                        uriGrp.appendChild(uid.getUri().cloneNode(true));
                        this.uriGrps.put(uriGrpName, uriGrp.cloneNode(true));
                        uris = new HashSet<String>();
                        uris.add(uid.getUri().getAttribute("Name"));
                        knownUris.put(uriGrpName, uris);
                    } else {
                        uris = (HashSet<String>)knownUris.get(uriGrpName);
                        if (!uris.contains(uid.getUri().getAttribute("Name"))) {
                            uris.add(uid.getUri().getAttribute("Name"));
                            ((Element)this.uriGrps.get(uriGrpName)).appendChild(uid.getUri().cloneNode(true));
                        }
                    }
                    Element vhg = uid.getVhg();
                    String vhgName = vhg.getAttribute("Name");
                    if (uid.uniqueVhgNeeded) {
                        if (!knownUniqueVhgs.containsKey(vhgName)) {
                            Element newVhg = (Element)vhg.cloneNode(true);
                            newVhg.setAttribute("Name", vhgName + "_" + this.seqNum);
                            newVhg.appendChild(uid.getVh().cloneNode(true));
                            knownUniqueVhgs.put(vhgName, newVhg.cloneNode(true));
                            HashSet<String> vhUniqueSet = new HashSet<String>();
                            vhUniqueSet.add(uid.getVh().getAttribute("Name"));
                            knownUniqueVhs.put(vhgName, vhUniqueSet);
                        } else if (((HashSet)knownUniqueVhs.get(vhgName)).add(uid.getVh().getAttribute("Name"))) {
                            ((Element)knownUniqueVhgs.get(vhgName)).appendChild(uid.getVh().cloneNode(true));
                        }
                        uid.getRoute().setAttribute("VirtualHostGroup", vhgName + "_" + this.seqNum);
                    } else if (!knownVhgs.containsKey(vhgName)) {
                        vhg.appendChild(uid.getVh().cloneNode(true));
                        knownVhgs.put(vhgName, vhg.cloneNode(true));
                        HashSet<String> vhSet = new HashSet<String>();
                        vhSet.add(uid.getVh().getAttribute("Name"));
                        knownVhs.put(vhgName, vhSet);
                    } else if (((HashSet)knownVhs.get(vhgName)).add(uid.getVh().getAttribute("Name"))) {
                        ((Element)knownVhgs.get(vhgName)).appendChild(uid.getVh().cloneNode(true));
                    }
                    Element sc = uid.getServerCluster();
                    String scName = sc.getAttribute("Name");
                    if (!knownSc.contains(scName)) {
                        knownSc.add(scName);
                        this.unsharedClusters.add(sc.cloneNode(true));
                    }
                    if (this.routes.contains(uid.getRoute())) continue;
                    this.routes.add(uid.getRoute());
                }
                this.unsharedVhg.addAll(knownVhgs.values());
                this.unsharedVhg.addAll(knownUniqueVhgs.values());
            }
        }

        public Hashtable<String, AppInfo> getUniquePluginRep() {
            return this.uniquePluginRep;
        }

        public Node[] getUnsharedServerClusters() throws ParserConfigurationException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            this.unsharedDoc = parser.newDocument();
            ArrayList<Node> lstNodes = new ArrayList<Node>();
            Vector<String> primaries = new Vector<String>();
            Vector<String> backups = new Vector<String>();
            int indx = 0;
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)"Building UnsharedCluster information", (Object[])new Object[0]);
            }
            Iterator<Node> itr = this.unsharedClusters.iterator();
            while (itr.hasNext()) {
                Element tmpSc = (Element)this.unsharedDoc.importNode(itr.next().cloneNode(true), true);
                if (PluginMergeToolImpl.this.debug) {
                    Tr.info((TraceComponent)traceComponent, (String)("ServerCluster Name: " + tmpSc.getAttribute("Name")), (Object[])new Object[0]);
                }
                NodeList nlstServers = tmpSc.getElementsByTagName("Server");
                for (int i = 0; i < nlstServers.getLength(); ++i) {
                    Element serverName = (Element)nlstServers.item(i);
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)("\t Cluster Server Name: " + serverName.getAttribute("Name")), (Object[])new Object[0]);
                    }
                    if (PluginMergeToolImpl.this.G_primaryServers.contains(serverName.getAttribute("Name")) || PluginMergeToolImpl.this.G_primaryServers.isEmpty() || !PluginMergeToolImpl.this.G_backupServers.contains(serverName.getAttribute("Name"))) {
                        if (PluginMergeToolImpl.this.debug) {
                            Tr.info((TraceComponent)traceComponent, (String)("UnShared: Adding " + serverName.getAttribute("Name") + " to PrimaryServer list"), (Object[])new Object[0]);
                        }
                        primaries.add(serverName.getAttribute("Name"));
                        continue;
                    }
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)("UnShared: Adding " + serverName.getAttribute("Name") + " to BackupServer list"), (Object[])new Object[0]);
                    }
                    backups.add(serverName.getAttribute("Name"));
                }
                Element eServerTmp = (Element)this.unsharedDoc.createElement("Server").cloneNode(true);
                eServerTmp = (Element)this.unsharedDoc.importNode(eServerTmp, true);
                Element ePrimary = (Element)this.unsharedDoc.createElement("PrimaryServers").cloneNode(true);
                ePrimary = (Element)this.unsharedDoc.importNode(ePrimary, true);
                primaries.trimToSize();
                Enumeration e = primaries.elements();
                while (e.hasMoreElements()) {
                    eServerTmp.setAttribute("Name", (String)e.nextElement());
                    ePrimary.appendChild(eServerTmp.cloneNode(true));
                }
                tmpSc.appendChild(ePrimary);
                if (!backups.isEmpty()) {
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)"Unshared: Backup servers are configured.", (Object[])new Object[0]);
                    }
                    Element eBackup = (Element)this.unsharedDoc.createElement("BackupServers").cloneNode(true);
                    eBackup = (Element)this.unsharedDoc.importNode(eBackup, true);
                    backups.trimToSize();
                    e = backups.elements();
                    while (e.hasMoreElements()) {
                        eServerTmp.setAttribute("Name", (String)e.nextElement());
                        eBackup.appendChild(eServerTmp.cloneNode(true));
                    }
                    tmpSc.appendChild(eBackup);
                }
                lstNodes.add(tmpSc.cloneNode(true));
                ++indx;
                primaries.clear();
                backups.clear();
            }
            this.unsharedClusters.trimToSize();
            lstNodes.trimToSize();
            Object[] nodes = new Node[this.unsharedClusters.size()];
            this.unsharedClusters.copyInto(nodes);
            lstNodes.toArray(nodes);
            return nodes;
        }

        public Node[] getSharedServerClusters() {
            Node[] rtnNodes = new Node[this.allSharedScElements.size()];
            Enumeration<Node> e = this.allSharedScElements.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                rtnNodes[i] = e.nextElement().cloneNode(true);
                ++i;
            }
            return rtnNodes;
        }

        public Node[] getFailOverServerClusters() {
            String subServerName = null;
            ArrayList<Node> lstNodes = new ArrayList<Node>();
            Vector<String> primaries = new Vector<String>();
            Vector<String> backups = new Vector<String>();
            Collection<Node> c = this.allSharedScElements.values();
            Iterator<Node> itr = c.iterator();
            if (PluginMergeToolImpl.this.debug) {
                Tr.info((TraceComponent)traceComponent, (String)"Building Shared Cluster information", (Object[])new Object[0]);
            }
            while (itr.hasNext()) {
                Element sc = (Element)((Element)itr.next()).cloneNode(true);
                NodeList nList = sc.getElementsByTagName("Server");
                for (int i = 0; i < nList.getLength(); ++i) {
                    Element e = (Element)nList.item(i);
                    String serverName = e.getAttribute("Name");
                    subServerName = serverName.substring(0, serverName.length() - (serverName.length() - serverName.lastIndexOf("_")));
                    if (PluginMergeToolImpl.this.G_primaryServers.contains(subServerName) || PluginMergeToolImpl.this.G_primaryServers.isEmpty() || !PluginMergeToolImpl.this.G_backupServers.contains(subServerName)) {
                        if (PluginMergeToolImpl.this.debug) {
                            Tr.info((TraceComponent)traceComponent, (String)("Shared: Adding " + serverName + " to PrimaryServer list."), (Object[])new Object[0]);
                        }
                        primaries.add(serverName);
                        continue;
                    }
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)("Shared: Adding " + serverName + " to BackupServer list."), (Object[])new Object[0]);
                    }
                    backups.add(serverName);
                }
                Element eServerTmp = (Element)this.sharedDoc.createElement("Server").cloneNode(true);
                eServerTmp = (Element)this.sharedDoc.importNode(eServerTmp, true);
                Element ePrimary = (Element)this.sharedDoc.createElement("PrimaryServers").cloneNode(true);
                ePrimary = (Element)this.sharedDoc.importNode(ePrimary, true);
                primaries.trimToSize();
                Enumeration e = primaries.elements();
                while (e.hasMoreElements()) {
                    eServerTmp.setAttribute("Name", (String)e.nextElement());
                    ePrimary.appendChild(eServerTmp.cloneNode(true));
                }
                sc.appendChild(ePrimary);
                if (!backups.isEmpty()) {
                    if (PluginMergeToolImpl.this.debug) {
                        Tr.info((TraceComponent)traceComponent, (String)"Shared: Backup servers are configured.", (Object[])new Object[0]);
                    }
                    Element eBackup = (Element)this.sharedDoc.createElement("BackupServers").cloneNode(true);
                    eBackup = (Element)this.sharedDoc.importNode(eBackup, true);
                    this.backupServers.trimToSize();
                    e = backups.elements();
                    while (e.hasMoreElements()) {
                        eServerTmp.setAttribute("Name", (String)e.nextElement());
                        eBackup.appendChild(eServerTmp.cloneNode(true));
                    }
                    sc.appendChild(eBackup);
                }
                lstNodes.add(sc.cloneNode(true));
                primaries.clear();
                backups.clear();
            }
            lstNodes.trimToSize();
            Node[] rtnNodes = new Node[lstNodes.size()];
            lstNodes.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUnsharedVHostGrp() {
            this.unsharedVhg.trimToSize();
            Object[] rtnNodes = new Node[this.unsharedVhg.size()];
            this.unsharedVhg.copyInto(rtnNodes);
            return rtnNodes;
        }

        public Node[] getSharedVHostGrps() {
            this.sharedVhgs.trimToSize();
            Node[] rtnNodes = new Node[this.sharedVhgs.size()];
            this.sharedVhgs.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUriGrps() {
            Node[] rtnNodes = new Node[this.uriGrps.size()];
            Collection<Node> c = this.uriGrps.values();
            c.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getUniqueUriGrps() {
            Node[] rtnNodes = new Node[this.uniqueUriGrps.size()];
            Collection<Node> c = this.uniqueUriGrps.values();
            c.toArray(rtnNodes);
            return rtnNodes;
        }

        public Node[] getRoutes() {
            this.routes.trimToSize();
            Object[] rtnNodes = new Node[this.routes.size()];
            this.routes.copyInto(rtnNodes);
            return rtnNodes;
        }

        public int getSeqNum() {
            return this.seqNum;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PluginInfo.class);
        }
    }
}

