/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.ErrorHandlerImpl;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.tai.TAIResult;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIWebUtils {
    public static final TraceComponent tc = Tr.register(TAIWebUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    WebUtils webUtils = new WebUtils();
    SocialWebUtils socialWebUtils = new SocialWebUtils();
    ReferrerURLCookieHandler referrerURLCookieHandler = this.getCookieHandler();
    static final long serialVersionUID = -2995225354196403339L;

    @FFDCIgnore(value={SocialLoginException.class})
    public String getRedirectUrl(HttpServletRequest req, SocialLoginConfig clientConfig) {
        String host;
        boolean isRedirectConfiguredAndValid;
        block5: {
            isRedirectConfiguredAndValid = false;
            host = clientConfig.getRedirectToRPHostAndPort();
            if (host != null && !host.isEmpty()) {
                try {
                    SocialUtil.validateEndpointFormat(host, false);
                    isRedirectConfiguredAndValid = true;
                }
                catch (SocialLoginException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Failed to validate URL format of redirectToRPHostAndPort value [" + host + "] due to " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (!isRedirectConfiguredAndValid) {
            host = this.getHostAndPort(req);
        }
        StringBuffer redirect = new StringBuffer(host);
        redirect.append(Oauth2LoginConfigImpl.getContextRoot()).append("/redirect/").append(clientConfig.getUniqueId());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("redirect=" + redirect), (Object[])new Object[0]);
        }
        return redirect.toString();
    }

    public String getAuthorizationEndpoint(SocialLoginConfig clientConfig) throws SocialLoginException {
        String authzEndpoint = clientConfig.getAuthorizationEndpoint();
        SocialUtil.validateEndpointWithQuery(authzEndpoint);
        return authzEndpoint;
    }

    public String createStateCookie(HttpServletRequest request, HttpServletResponse response) {
        String stateValue = SocialUtil.generateRandom();
        String loginHint = this.socialWebUtils.getLoginHint(request);
        if (!request.getMethod().equalsIgnoreCase("GET") && loginHint != null) {
            stateValue = stateValue + loginHint;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting cookie WASSocialState to " + stateValue), (Object[])new Object[0]);
        }
        Cookie stateCookie = this.referrerURLCookieHandler.createCookie("WASSocialState", stateValue, request);
        response.addCookie(stateCookie);
        return stateValue;
    }

    public TAIResult sendToErrorPage(HttpServletResponse response, TAIResult taiResult) {
        return ErrorHandlerImpl.getInstance().handleErrorResponse(response, taiResult);
    }

    public void savePostParameters(HttpServletRequest request) {
        PostParameterHelper.savePostParams((SRTServletRequest)((SRTServletRequest)request));
    }

    public void restorePostParameters(HttpServletRequest request) {
        PostParameterHelper.restorePostParams((SRTServletRequest)((SRTServletRequest)request));
    }

    public ReferrerURLCookieHandler getCookieHandler() {
        WebAppSecurityConfig config = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        if (config != null) {
            return config.createReferrerURLCookieHandler();
        }
        return new ReferrerURLCookieHandler(config);
    }

    String getHostAndPort(HttpServletRequest req) {
        String hostName = req.getServerName();
        Integer httpsPort = this.webUtils.getRedirectPortFromRequest(req);
        String hostAndPort = null;
        if (httpsPort == null && req.isSecure()) {
            int port = req.getServerPort();
            String httpSchema = req.getScheme();
            hostAndPort = httpSchema + "://" + hostName + (port > 0 && port != 443 ? ":" + port : "");
        } else {
            hostAndPort = "https://" + hostName + (httpsPort == null ? "" : ":" + httpsPort);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hostAndPort=" + hostAndPort), (Object[])new Object[0]);
        }
        return hostAndPort;
    }
}

