/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.DiscoveryConfigUtils;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.common.ConfigUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import com.ibm.ws.security.social.internal.SslRefInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.oidclogin", configurationPolicy=ConfigurationPolicy.REQUIRE, service={SocialLoginConfig.class, JwtConsumerConfig.class}, property={"service.vendor=IBM", "type=oidcLogin"})
public class OidcLoginConfigImpl
extends Oauth2LoginConfigImpl
implements JwtConsumerConfig,
ConvergedClientConfig {
    public static final TraceComponent tc = Tr.register(OidcLoginConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    ConsumerUtils consumerUtils = null;
    JWKSet jwkSet = null;
    public static final String KEY_ISSUER = "issuer";
    String issuer = null;
    public static final String KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    String signatureAlgorithm = null;
    public static final String KEY_CLOCKSKEW = "clockSkew";
    int clockSkewMsec = 0;
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    private boolean hostNameVerificationEnabled = true;
    public static final String KEY_TRUSTED_ALIAS = "trustAliasName";
    private String trustAliasName = null;
    public static final String KEY_USERINFO_ENDPOINT = "userInfoEndpoint";
    private String userInfoEndpoint = null;
    public static final String KEY_USERINFO_ENDPOINT_ENABLED = "userInfoEndpointEnabled";
    private boolean userInfoEndpointEnabled = false;
    public static final String KEY_DISCOVERY_ENDPOINT = "discoveryEndpoint";
    private String discoveryEndpointUrl = null;
    private JSONObject discoveryjson = null;
    private boolean discovery = false;
    public static final String KEY_DISCOVERY_POLLING_RATE = "discoveryPollingRate";
    private long discoveryPollingRate = 300000L;
    private String discoveryDocumentHash = null;
    private long nextDiscoveryTime;
    public static final String OPDISCOVERY_AUTHZ_EP_URL = "authorization_endpoint";
    public static final String OPDISCOVERY_TOKEN_EP_URL = "token_endpoint";
    public static final String OPDISCOVERY_INTROSPECTION_EP_URL = "introspection_endpoint";
    public static final String OPDISCOVERY_JWKS_EP_URL = "jwks_uri";
    public static final String OPDISCOVERY_USERINFO_EP_URL = "userinfo_endpoint";
    public static final String OPDISCOVERY_ISSUER = "issuer";
    public static final String OPDISCOVERY_TOKEN_EP_AUTH = "token_endpoint_auth_methods_supported";
    public static final String OPDISCOVERY_SCOPES = "scopes_supported";
    public static final String OPDISCOVERY_IDTOKEN_SIGN_ALG = "id_token_signing_alg_values_supported";
    public static final String KEY_JWK_CLIENT_ID = "jwkClientId";
    public static final String KEY_JWK_CLIENT_SECRET = "jwkClientSecret";
    private String jwkClientId = null;
    private String jwkClientSecret = null;
    public static final String KEY_RESPONSE_MODE = "responseMode";
    private String responseMode = null;
    public static final String KEY_NONCE_ENABLED = "nonceEnabled";
    public static final String KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT = "includeCustomCacheKeyInSubject";
    private boolean includeCustomCacheKeyInSubject = true;
    public static final String KEY_AUTHZ_PARAM = "authzParameter";
    public static final String KEY_TOKEN_PARAM = "tokenParameter";
    public static final String KEY_USERINFO_PARAM = "userinfoParameter";
    public static final String KEY_JWK_PARAM = "jwkParameter";
    public static final String KEY_PARAM_NAME = "name";
    public static final String KEY_PARAM_VALUE = "value";
    private HashMap<String, String> authzRequestParamMap;
    private HashMap<String, String> tokenRequestParamMap;
    private HashMap<String, String> userinfoRequestParamMap;
    private HashMap<String, String> jwkRequestParamMap;
    public static final String CFG_KEY_FORWARD_LOGIN_PARAMETER = "forwardLoginParameter";
    private List<String> forwardLoginParameter = null;
    HttpUtils httputils = new HttpUtils();
    ConfigUtils oidcConfigUtils = new ConfigUtils(null);
    DiscoveryConfigUtils discoveryUtil = new DiscoveryConfigUtils();
    static final long serialVersionUID = -6965177803964780282L;

    @Override
    protected void setRequiredConfigAttributes(Map<String, Object> props) {
        this.clientId = this.getRequiredConfigAttribute(props, "clientId");
        this.clientSecret = this.getRequiredSerializableProtectedStringConfigAttribute(props, "clientSecret");
    }

    @Override
    protected void setOptionalConfigAttributes(Map<String, Object> props) throws SocialLoginException {
        this.useSystemPropertiesForHttpClientConnections = this.configUtils.getBooleanConfigAttribute(props, "useSystemPropertiesForHttpClientConnections", false);
        this.sslRef = this.configUtils.getConfigAttribute(props, "sslRef");
        this.discoveryEndpointUrl = this.configUtils.getConfigAttribute(props, KEY_DISCOVERY_ENDPOINT);
        this.discoveryPollingRate = this.configUtils.getLongConfigAttribute(props, KEY_DISCOVERY_POLLING_RATE, this.discoveryPollingRate);
        this.jwkClientId = this.configUtils.getConfigAttribute(props, KEY_JWK_CLIENT_ID);
        this.jwkClientSecret = this.configUtils.processProtectedString(props, KEY_JWK_CLIENT_SECRET);
        this.hostNameVerificationEnabled = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_HOST_NAME_VERIFICATION_ENABLED, this.hostNameVerificationEnabled);
        this.userInfoEndpointEnabled = this.configUtils.getBooleanConfigAttribute(props, KEY_USERINFO_ENDPOINT_ENABLED, this.userInfoEndpointEnabled);
        this.signatureAlgorithm = this.configUtils.getConfigAttribute(props, KEY_SIGNATURE_ALGORITHM);
        this.tokenEndpointAuthMethod = this.configUtils.getConfigAttribute(props, "tokenEndpointAuthMethod");
        this.scope = this.configUtils.getConfigAttribute(props, "scope");
        this.discovery = false;
        this.discoveryjson = null;
        if (this.discoveryEndpointUrl != null) {
            this.discovery = this.handleDiscoveryEndpoint(this.discoveryEndpointUrl);
            if (this.discovery) {
                this.discoveryUtil.logDiscoveryWarning(props);
            } else {
                this.reConfigEndpointsAfterDiscoveryFailure();
            }
        } else {
            this.userInfoEndpoint = this.configUtils.getConfigAttribute(props, KEY_USERINFO_ENDPOINT);
            this.authorizationEndpoint = this.getRequiredConfigAttribute(props, "authorizationEndpoint");
            this.tokenEndpoint = this.configUtils.getConfigAttribute(props, "tokenEndpoint");
            this.jwksUri = this.configUtils.getConfigAttribute(props, "jwksUri");
            this.issuer = this.configUtils.getConfigAttribute(props, "issuer");
        }
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, "userNameAttribute");
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, "mapToUserRegistry", this.mapToUserRegistry);
        this.authFilterRef = this.configUtils.getConfigAttribute(props, "authFilterRef");
        this.trustAliasName = this.configUtils.getConfigAttribute(props, KEY_TRUSTED_ALIAS);
        this.isClientSideRedirectSupported = this.configUtils.getBooleanConfigAttribute(props, "isClientSideRedirectSupported", this.isClientSideRedirectSupported);
        this.displayName = this.configUtils.getConfigAttribute(props, "displayName");
        this.website = this.configUtils.getConfigAttribute(props, "website");
        this.realmNameAttribute = this.configUtils.getConfigAttribute(props, "realmNameAttribute");
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, "groupNameAttribute");
        this.userUniqueIdAttribute = this.configUtils.getConfigAttribute(props, "userUniqueIdAttribute");
        this.clockSkewMsec = this.configUtils.getIntegerConfigAttribute(props, KEY_CLOCKSKEW, this.clockSkewMsec);
        this.redirectToRPHostAndPort = this.configUtils.getConfigAttribute(props, "redirectToRPHostAndPort");
        this.responseType = this.configUtils.getConfigAttribute(props, "responseType");
        this.responseMode = this.configUtils.getConfigAttribute(props, KEY_RESPONSE_MODE);
        this.nonce = this.configUtils.getBooleanConfigAttribute(props, KEY_NONCE_ENABLED, this.nonce);
        this.realmName = this.configUtils.getConfigAttribute(props, "realmName");
        this.includeCustomCacheKeyInSubject = this.configUtils.getBooleanConfigAttribute(props, KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT, this.includeCustomCacheKeyInSubject);
        this.resource = this.configUtils.getConfigAttribute(props, "resource");
        this.authzRequestParamMap = this.populateCustomRequestParameterMap(props, KEY_AUTHZ_PARAM);
        this.tokenRequestParamMap = this.populateCustomRequestParameterMap(props, KEY_TOKEN_PARAM);
        this.userinfoRequestParamMap = this.populateCustomRequestParameterMap(props, KEY_USERINFO_PARAM);
        this.jwkRequestParamMap = this.populateCustomRequestParameterMap(props, KEY_JWK_PARAM);
        this.forwardLoginParameter = this.oidcConfigUtils.readAndSanitizeForwardLoginParameter(props, this.uniqueId, CFG_KEY_FORWARD_LOGIN_PARAMETER);
        if (this.discovery) {
            String OIDC_CLIENT_DISCOVERY_COMPLETE = "CWWKS6110I: The client [{" + this.getId() + "}] configuration has been established with the information from the discovery endpoint URL [{" + this.discoveryEndpointUrl + "}]. This information enables the client to interact with the OpenID Connect provider to process the requests such as authorization and token.";
            this.discoveryUtil.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_COMPLETE", null, OIDC_CLIENT_DISCOVERY_COMPLETE);
        }
    }

    private HashMap<String, String> populateCustomRequestParameterMap(Map<String, Object> configProps, String configAttributeName) {
        HashMap<String, String> customRequestParameterMap = new HashMap<String, String>();
        String[] customRequestParameterElements = this.configUtils.getStringArrayConfigAttribute(configProps, configAttributeName);
        if (customRequestParameterElements != null && customRequestParameterElements.length > 0) {
            this.populateCustomRequestParameterMap(customRequestParameterMap, customRequestParameterElements);
        }
        return customRequestParameterMap;
    }

    private void reConfigEndpointsAfterDiscoveryFailure() {
        this.authorizationEndpoint = null;
        this.tokenEndpoint = null;
        this.userInfoEndpoint = null;
        this.jwksUri = null;
        this.issuer = null;
        this.discoveryDocumentHash = null;
        this.discoveryUtil = this.discoveryUtil.initialConfig(this.getId(), this.discoveryEndpointUrl, this.discoveryPollingRate).discoveryDocumentResult(null).discoveryDocumentHash(this.discoveryDocumentHash).discoveredConfig(this.signatureAlgorithm, this.tokenEndpointAuthMethod, this.scope);
    }

    @FFDCIgnore(value={Exception.class})
    public boolean handleDiscoveryEndpoint(String discoveryUrl) {
        boolean valid;
        block6: {
            String jsonString = null;
            valid = false;
            try {
                this.setNextDiscoveryTime();
                if (!this.isValidDiscoveryUrl(discoveryUrl)) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_SSL_ERROR", (Object[])new Object[]{this.getId(), discoveryUrl});
                    return false;
                }
                SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
                jsonString = this.httputils.getHttpRequest(sslSocketFactory, discoveryUrl, this.hostNameVerificationEnabled, null, null);
                if (jsonString != null) {
                    this.parseJsonResponse(jsonString);
                    if (this.discoveryjson != null) {
                        valid = this.discoverEndpointUrls(this.discoveryjson);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Fail to get successful discovery response : ", (Object[])new Object[]{e.getCause()});
            }
        }
        if (!valid) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_SSL_ERROR", (Object[])new Object[]{this.getId(), discoveryUrl});
        }
        return valid;
    }

    boolean discoverEndpointUrls(JSONObject json) {
        this.discoveryUtil = this.discoveryUtil.initialConfig(this.getId(), this.discoveryEndpointUrl, this.discoveryPollingRate).discoveryDocumentResult(json).discoveryDocumentHash(this.discoveryDocumentHash).discoveredConfig(this.signatureAlgorithm, this.tokenEndpointAuthMethod, this.scope);
        if (this.discoveryUtil.calculateDiscoveryDocumentHash(json)) {
            this.authorizationEndpoint = this.discoveryUtil.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_AUTHZ_EP_URL));
            this.tokenEndpoint = this.discoveryUtil.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_TOKEN_EP_URL));
            this.jwksUri = this.discoveryUtil.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_JWKS_EP_URL));
            this.userInfoEndpoint = this.discoveryUtil.discoverOPConfigSingleValue(json.get((Object)OPDISCOVERY_USERINFO_EP_URL));
            this.issuer = this.discoveryUtil.discoverOPConfigSingleValue(json.get((Object)"issuer"));
            if (this.invalidEndpoints() || this.invalidIssuer()) {
                return false;
            }
            this.tokenEndpointAuthMethod = this.discoveryUtil.adjustTokenEndpointAuthMethod();
            this.scope = this.discoveryUtil.adjustScopes();
            this.discoveryDocumentHash = this.discoveryUtil.getDiscoveryDocumentHash();
        }
        return true;
    }

    public void setNextDiscoveryTime() {
        this.nextDiscoveryTime = System.currentTimeMillis() + this.discoveryPollingRate;
    }

    public long getNextDiscoveryTime() {
        return this.nextDiscoveryTime;
    }

    private boolean invalidIssuer() {
        return this.issuer == null;
    }

    private boolean invalidEndpoints() {
        return this.authorizationEndpoint == null && this.tokenEndpoint == null;
    }

    /*
     * WARNING - void declaration
     */
    protected void parseJsonResponse(String jsonString) {
        block2: {
            try {
                this.discoveryjson = JSONObject.parse((String)jsonString);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.internal.OidcLoginConfigImpl", (String)"319", (Object)this, (Object[])new Object[]{jsonString});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing JSON string [" + jsonString + "]: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public boolean isDiscoveryInUse() {
        return this.isValidDiscoveryUrl(this.discoveryEndpointUrl);
    }

    private boolean isValidDiscoveryUrl(String discoveryUrl) {
        return discoveryUrl != null && discoveryUrl.startsWith("https");
    }

    @Override
    protected void initializeMembersAfterConfigAttributesPopulated(Map<String, Object> props) throws SocialLoginException {
        this.initializeJwt(props);
        this.resetLazyInitializedMembers();
        this.setGrantType();
    }

    @Override
    protected void resetLazyInitializedMembers() {
        super.resetLazyInitializedMembers();
        this.jwkSet = null;
        this.consumerUtils = null;
    }

    @Override
    protected void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId = " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientSecret is null = " + (this.clientSecret == null)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpoint = " + this.authorizationEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpoint = " + this.tokenEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userInfoEndpoint = " + this.userInfoEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userInfoEndpointEnabled = " + this.userInfoEndpointEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri = " + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope = " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute = " + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry = " + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trustAliasName = " + this.trustAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("builder = " + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claims = " + (this.jwtClaims == null ? null : Arrays.toString(this.jwtClaims))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported = " + this.isClientSideRedirectSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("displayName = " + this.displayName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("website = " + this.website), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("issuer = " + this.issuer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmNameAttribute = " + this.realmNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute = " + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userUniqueIdAttribute = " + this.userUniqueIdAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clockSkew = " + this.clockSkewMsec), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm = " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod = " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort = " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled = " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("nonce = " + this.nonce), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("responseType = " + this.responseType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("responseMode = " + this.responseMode), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmName = " + this.realmName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeCustomCacheKeyInSubject = " + this.includeCustomCacheKeyInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("resource = " + this.resource), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("forwardLoginParameter = " + this.forwardLoginParameter), (Object[])new Object[0]);
        }
    }

    public boolean isUserInfoEnabled() {
        return this.userInfoEndpointEnabled;
    }

    public String getUserInfoEndpointUrl() {
        return this.userInfoEndpoint;
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    @Override
    public String getRealmNameAttribute() {
        return this.realmNameAttribute;
    }

    public String getId() {
        return this.getUniqueId();
    }

    public String getIssuer() {
        if ((this.issuer == null || this.issuer.length() == 0) && this.tokenEndpoint != null && this.tokenEndpoint.length() > "http://".length()) {
            String computedIssuer = null;
            if (this.tokenEndpoint.toLowerCase().startsWith("http")) {
                int lastpos = this.tokenEndpoint.lastIndexOf("/");
                computedIssuer = lastpos > "http://".length() ? this.tokenEndpoint.substring(0, lastpos) : this.tokenEndpoint;
                return computedIssuer;
            }
            return this.issuer;
        }
        return this.issuer;
    }

    @Sensitive
    public String getSharedKey() {
        return this.clientSecret;
    }

    public List<String> getAudiences() {
        ArrayList<String> audiences = new ArrayList<String>();
        String clientId = this.getClientId();
        if (clientId != null) {
            audiences.add(clientId);
        }
        return audiences;
    }

    public boolean isValidationRequired() {
        return false;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    public String getTrustStoreRef() {
        if (this.sslRefInfo == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = this.createSslRefInfoImpl(service);
        }
        try {
            return this.sslRefInfo.getTrustStoreName();
        }
        catch (SocialLoginException e) {
            e.logErrorMessage();
            return null;
        }
    }

    public String getTrustedAlias() {
        return this.trustAliasName;
    }

    public long getClockSkew() {
        return this.clockSkewMsec;
    }

    public boolean getJwkEnabled() {
        return this.jwksUri != null;
    }

    public String getJwkEndpointUrl() {
        return this.jwksUri;
    }

    public ConsumerUtils getConsumerUtils() {
        if (this.consumerUtils == null) {
            SocialLoginService socialLoginService = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (socialLoginService != null) {
                this.consumerUtils = new ConsumerUtils(socialLoginService.getKeyStoreServiceRef());
            } else {
                Tr.warning((TraceComponent)tc, (String)"SERVICE_NOT_FOUND_JWT_CONSUMER_NOT_AVAILABLE", (Object[])new Object[]{this.uniqueId});
            }
        }
        return this.consumerUtils;
    }

    public JWKSet getJwkSet() {
        if (this.jwkSet == null) {
            this.jwkSet = new JWKSet();
        }
        return this.jwkSet;
    }

    public boolean getTokenReuse() {
        return false;
    }

    @Override
    public String getResponseMode() {
        return this.responseMode;
    }

    public boolean includeCustomCacheKeyInSubject() {
        return this.includeCustomCacheKeyInSubject;
    }

    @Override
    protected SslRefInfoImpl createSslRefInfoImpl(SocialLoginService socialLoginService) {
        return new SslRefInfoImpl(socialLoginService.getSslSupport(), socialLoginService.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
    }

    public boolean isSocial() {
        return true;
    }

    public OidcClientConfig getOidcClientConfig() {
        return null;
    }

    public String getInboundPropagation() {
        return "none";
    }

    public boolean getAccessTokenInLtpaCookie() {
        return false;
    }

    public boolean isAuthnSessionDisabled_propagation() {
        return false;
    }

    public long getClockSkewInSeconds() {
        return this.getClockSkew() / 1000L;
    }

    public String getAuthorizationEndpointUrl() {
        return this.getAuthorizationEndpoint();
    }

    public boolean createSession() {
        return false;
    }

    public long getAuthenticationTimeLimitInSeconds() {
        return 420L;
    }

    public boolean isHttpsRequired() {
        return true;
    }

    public boolean isClientSideRedirect() {
        return this.isClientSideRedirectSupported();
    }

    public String getContextPath() {
        return OidcLoginConfigImpl.getContextRoot();
    }

    public String getTokenEndpointUrl() {
        return this.getTokenEndpoint();
    }

    public String getSSLConfigurationName() {
        return this.getSslRef();
    }

    public String getRedirectUrlFromServerToClient() {
        return this.getRedirectToRPHostAndPort();
    }

    public String getRedirectUrlWithJunctionPath(String redirect_url) {
        return redirect_url;
    }

    public String getAuthContextClassReference() {
        return null;
    }

    public boolean isNonceEnabled() {
        return this.createNonce();
    }

    public String getPrompt() {
        return null;
    }

    public String[] getResources() {
        String resource = this.getResource();
        if (resource == null) {
            return null;
        }
        return resource.split(" ");
    }

    public String getOidcClientCookieName() {
        return null;
    }

    public String getIssuerIdentifier() {
        return this.getIssuer();
    }

    public boolean getUseAccessTokenAsIdToken() {
        return false;
    }

    public boolean isMapIdentityToRegistryUser() {
        return this.getMapToUserRegistry();
    }

    public boolean isIncludeCustomCacheKeyInSubject() {
        return false;
    }

    public boolean isIncludeIdTokenInSubject() {
        return true;
    }

    public boolean isDisableLtpaCookie() {
        return false;
    }

    public String getGroupIdentifier() {
        return this.getGroupNameAttribute();
    }

    public String getUserIdentifier() {
        return this.getUserNameAttribute();
    }

    public String getUserIdentityToCreateSubject() {
        return this.getUserNameAttribute();
    }

    public String getRealmIdentifier() {
        return this.getRealmNameAttribute();
    }

    public String getUniqueUserIdentifier() {
        return this.getUserUniqueIdAttribute();
    }

    public String getJsonWebKey() {
        return null;
    }

    public boolean allowedAllAudiences() {
        return false;
    }

    public boolean disableIssChecking() {
        return false;
    }

    public String getJwkClientId() {
        return null;
    }

    public String getJwkClientSecret() {
        return null;
    }

    public List<String> getForwardLoginParameter() {
        return this.forwardLoginParameter;
    }

    public String getDiscoveryEndpointUrl() {
        return this.discoveryEndpointUrl;
    }

    public HashMap<String, String> getAuthzRequestParams() {
        return this.authzRequestParamMap;
    }

    public HashMap<String, String> getTokenRequestParams() {
        return this.tokenRequestParamMap;
    }

    public HashMap<String, String> getUserinfoRequestParams() {
        return this.userinfoRequestParamMap;
    }

    public HashMap<String, String> getJwkRequestParams() {
        return this.jwkRequestParamMap;
    }

    private void populateCustomRequestParameterMap(HashMap<String, String> paramMapToPopulate, String[] configuredCustomRequestParams) {
        SocialLoginService socialLoginService = (SocialLoginService)this.socialLoginServiceRef.getService();
        if (socialLoginService == null) {
            return;
        }
        this.oidcConfigUtils.populateCustomRequestParameterMap(socialLoginService.getConfigAdmin(), paramMapToPopulate, configuredCustomRequestParams, KEY_PARAM_NAME, KEY_PARAM_VALUE);
    }
}

