/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.utility;

import com.ibm.ws.kernel.service.util.UtilityTemplate;
import com.ibm.ws.springboot.utility.SpringBootUtilityReturnCodes;
import com.ibm.ws.springboot.utility.SpringBootUtilityTask;
import com.ibm.ws.springboot.utility.tasks.HelpTask;
import com.ibm.ws.springboot.utility.tasks.ThinAppTask;
import com.ibm.ws.springboot.utility.utils.CommandUtils;
import com.ibm.ws.springboot.utility.utils.ConsoleWrapper;
import com.ibm.ws.springboot.utility.utils.FileUtility;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class SpringBootUtility
extends UtilityTemplate {
    static final String SCRIPT_NAME = "springBootUtility";
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    List<SpringBootUtilityTask> tasks = new ArrayList<SpringBootUtilityTask>();

    SpringBootUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerTask(SpringBootUtilityTask task) {
        this.tasks.add(task);
    }

    private SpringBootUtilityTask getTask(String taskName) {
        SpringBootUtilityTask task = null;
        for (SpringBootUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    SpringBootUtilityReturnCodes runProgram(String[] args) {
        SpringBootUtilityTask task;
        if (this.stdin == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdin"));
            return SpringBootUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stdout == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdout"));
            return SpringBootUtilityReturnCodes.ERR_GENERIC;
        }
        if (this.stderr == null) {
            this.stdout.println(CommandUtils.getMessage("error.missingIO", "stderr"));
            return SpringBootUtilityReturnCodes.ERR_GENERIC;
        }
        HelpTask help = new HelpTask(SCRIPT_NAME, this.tasks);
        this.registerTask(help);
        if (args.length == 0) {
            this.stdout.println(help.getScriptUsage());
            return SpringBootUtilityReturnCodes.OK;
        }
        if (args[0].toLowerCase().endsWith(help.getTaskName().toLowerCase())) {
            args[0] = help.getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.stderr.println(CommandUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(help.getScriptUsage());
            return SpringBootUtilityReturnCodes.OK;
        }
        try {
            return task.handleTask(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            this.stderr.println(help.getTaskUsage(task));
            return SpringBootUtilityReturnCodes.ERR_GENERIC;
        }
        catch (Exception e) {
            this.stderr.println("");
            this.stderr.println(CommandUtils.getMessage("error", e.toString()));
            this.stderr.println(help.getTaskUsage(task));
            return SpringBootUtilityReturnCodes.ERR_GENERIC;
        }
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        SpringBootUtility util = new SpringBootUtility(console, System.out, System.err);
        FileUtility fileUtil = new FileUtility();
        util.registerTask(new ThinAppTask(fileUtil, SCRIPT_NAME));
        int rc = util.runProgram(args).getReturnCode();
        System.exit(rc);
    }
}

