/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.Resolves;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Updates;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveEntryNotFoundException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveInvalidEntryException;
import com.ibm.ws.repository.resources.writeable.IfixResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IfixParser
extends ParserBase
implements Parser<IfixResourceWritable> {
    private static final String APPLIES_TO = "Applies-To";
    private File _jarPayload = null;
    private File _readmePayload = null;
    static final long serialVersionUID = -1576725071802516375L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    @Override
    public IfixResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        IFixInfo ifixInfo;
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(assetFile, metadataFile);
        if (artifactMetadata == null) {
            throw new RepositoryArchiveException("Unable to find sibling metadata zip for " + assetFile.getName() + " so do not have the required information", assetFile);
        }
        this.extractFiles(artifactMetadata);
        this._jarPayload = assetFile;
        ParserBase.ExtractedFileInformation xmlFileInfo = this.extractFileFromArchive(this._jarPayload.getAbsolutePath(), ".*lib\\/fixes.*\\.xml");
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(xmlFileInfo.getExtractedFile());
            ifixInfo = IFixInfo.fromDocument((Document)doc);
        }
        catch (Exception docBuilder) {
            void e;
            FFDCFilter.processException((Throwable)docBuilder, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"76", (Object)this, (Object[])new Object[]{assetFile, metadataFile, contentUrl});
            throw new RepositoryArchiveInvalidEntryException("Parse failure", xmlFileInfo.getSourceArchive(), xmlFileInfo.getSelectedPathFromArchive(), (Throwable)e);
        }
        IfixResourceWritable resource = WritableResourceFactory.createIfix(null);
        resource.setName(this.getFixId(ifixInfo, xmlFileInfo));
        resource.setDisplayPolicy(DisplayPolicy.HIDDEN);
        resource.setWebDisplayPolicy(DisplayPolicy.HIDDEN);
        resource.setProviderName("IBM");
        String appliesTo = this.parseManifestForAppliesTo(this._jarPayload);
        resource.setAppliesTo(appliesTo);
        resource.setProvideFix(this.getProvides(ifixInfo, xmlFileInfo));
        resource.addAttachment(this._readmePayload, AttachmentType.DOCUMENTATION);
        resource.setDate(this.getLatestDateOfAnyFile(ifixInfo, xmlFileInfo));
        this.addContent((RepositoryResourceWritable)resource, this._jarPayload, this._jarPayload.getName(), artifactMetadata, contentUrl);
        return resource;
    }

    @Override
    protected void checkRequiredProperties(ParserBase.ArtifactMetadata artifact) throws RepositoryArchiveInvalidEntryException {
    }

    private void extractFiles(ParserBase.ArtifactMetadata artifactMetadata) throws RepositoryArchiveIOException, RepositoryArchiveEntryNotFoundException, RepositoryArchiveException {
        this._readmePayload = artifactMetadata.getFileWithExtension(".txt");
        if (this._readmePayload == null) {
            throw new RepositoryArchiveEntryNotFoundException("Unable to find iFix readme .txt file in archive" + artifactMetadata.getArchive().getAbsolutePath(), artifactMetadata.getArchive(), "*.txt");
        }
    }

    private String getFixId(IFixInfo iFixInfo, ParserBase.ExtractedFileInformation xmlInfo) throws RepositoryArchiveInvalidEntryException {
        if (null == iFixInfo) {
            throw new RepositoryArchiveInvalidEntryException("Null XML object provided", xmlInfo.getSourceArchive(), xmlInfo.getSelectedPathFromArchive());
        }
        return iFixInfo.getId();
    }

    private List<String> getProvides(IFixInfo iFixInfo, ParserBase.ExtractedFileInformation xmlInfo) throws RepositoryArchiveInvalidEntryException {
        if (null == iFixInfo) {
            throw new RepositoryArchiveInvalidEntryException("Null document provided", xmlInfo.getSourceArchive(), xmlInfo.getSelectedPathFromArchive());
        }
        Resolves resolves = iFixInfo.getResolves();
        if (null == resolves) {
            throw new RepositoryArchiveInvalidEntryException("Document does not contain a \"resolves\" node", xmlInfo.getSourceArchive(), xmlInfo.getSelectedPathFromArchive());
        }
        ArrayList<String> retList = new ArrayList<String>();
        List problems = resolves.getProblems();
        if (problems != null) {
            for (Problem problem : problems) {
                String displayId = problem.getDisplayId();
                if (null == displayId) {
                    throw new RepositoryArchiveInvalidEntryException("Unexpected null getting APAR id", xmlInfo.getSourceArchive(), xmlInfo.getSelectedPathFromArchive());
                }
                retList.add(displayId);
            }
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    private String parseManifestForAppliesTo(File file) throws RepositoryArchiveIOException {
        Manifest mf = null;
        try {
            JarFile jar = new JarFile(file);
            try {
                try {
                    mf = jar.getManifest();
                }
                catch (IOException iOException) {
                    void ioe;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"203", (Object)this, (Object[])new Object[]{file});
                    throw new RepositoryArchiveIOException("Error getting manifest from jar " + jar.getName(), new File(jar.getName()), (Throwable)ioe);
                }
            }
            catch (Throwable ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"200", (Object)this, (Object[])new Object[]{file});
                try {
                    jar.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"200", (Object)this, (Object[])new Object[]{file});
                    ioe.addSuppressed(throwable);
                }
                throw ioe;
            }
            jar.close();
        }
        catch (IOException jar) {
            void ioe;
            FFDCFilter.processException((Throwable)jar, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"206", (Object)this, (Object[])new Object[]{file});
            throw new RepositoryArchiveIOException("Unable to create JarFile from path " + file, new File(file.getName()), (Throwable)ioe);
        }
        String appliesTo = null;
        Attributes mainattrs = mf.getMainAttributes();
        for (Object at : mainattrs.keySet()) {
            String attribName = ((Attributes.Name)at).toString();
            String attribValue = (String)mainattrs.get(at);
            if (!APPLIES_TO.equals(attribName)) continue;
            appliesTo = attribValue;
        }
        return appliesTo;
    }

    private Date getLatestDateOfAnyFile(IFixInfo ifixInfo, ParserBase.ExtractedFileInformation xmlFileInfo) {
        Set updatedFiles;
        ArrayList<Date> updateDates = new ArrayList<Date>();
        Updates updates = ifixInfo.getUpdates();
        if (updates != null && (updatedFiles = updates.getFiles()) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            for (UpdatedFile updatedFile : updatedFiles) {
                String dateString = updatedFile.getDate();
                if (dateString == null) continue;
                try {
                    Date date = dateFormat.parse(updatedFile.getDate());
                    updateDates.add(date);
                }
                catch (ParseException parseException) {
                    FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.repository.parsers.IfixParser", (String)"259", (Object)this, (Object[])new Object[]{ifixInfo, xmlFileInfo});
                }
            }
        }
        Collections.sort(updateDates);
        Date lastUpdateDate = updateDates.size() > 0 ? (Date)updateDates.get(updateDates.size() - 1) : new Date(0L);
        return lastUpdateDate;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IfixParser.class);
    }
}

