/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.policy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.jaxws.wsat.components.WSATFeatureService;
import com.ibm.ws.jaxws.wsat.components.WSATInterceptorService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyInInterceptor;
import org.apache.cxf.ws.policy.PolicyOutInterceptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSATPolicyAwareInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(WSATPolicyAwareInterceptor.class, (String)"WSAT", null);
    private final boolean isOut;
    static final long serialVersionUID = 4634484641885644094L;

    public WSATPolicyAwareInterceptor(String phase, boolean isOut) {
        super(phase);
        this.isOut = isOut;
        if (phase.equals("pre-protocol")) {
            this.getBefore().add(MustUnderstandInterceptor.class.getName());
        } else if (phase.equals("write")) {
            this.getBefore().add(SoapOutInterceptor.class.getName());
        } else if (phase.equals("setup")) {
            this.getAfter().add(PolicyOutInterceptor.class.getName());
        } else {
            this.getAfter().add(PolicyInInterceptor.class.getName());
        }
    }

    private WSATInterceptorService getService() {
        BundleContext context = FrameworkUtil.getBundle(WSATInterceptorService.class).getBundleContext();
        if (context != null) {
            ServiceReference serviceRef = context.getServiceReference(WSATInterceptorService.class);
            if (serviceRef != null) {
                return (WSATInterceptorService)context.getService(serviceRef);
            }
            return null;
        }
        return null;
    }

    private boolean assertAssertion(Message message) {
        Collection ais;
        boolean assertion_exist = false;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleMessage", (Object[])new Object[]{"Checking if there's any ATAssertion present in the AssertionInfoMap", aim});
        }
        if (aim != null && (ais = (Collection)aim.get((Object)Constants.AT_ASSERTION_QNAME)) != null) {
            for (AssertionInfo a : ais) {
                a.setAsserted(true);
                assertion_exist = true;
            }
        }
        return assertion_exist;
    }

    public void handleMessage(Message message) throws Fault {
        boolean feature_exist = WSATFeatureService.isWSATPresent();
        boolean assertionExist = this.assertAssertion(message);
        if (!feature_exist && (this.getPhase().equals("pre-protocol") && !this.isOut || this.getPhase().equals("write") && this.isOut)) {
            this.handleMessage_feature_no_exist(message, assertionExist);
        } else if (feature_exist && (this.getPhase().equals("receive") && !this.isOut || this.getPhase().equals("setup") && this.isOut)) {
            this.handleMessage_feature_exist(message);
        }
    }

    private void handleMessage_feature_exist(Message message) {
        WSATInterceptorService service = this.getService();
        if (service == null) {
            throw new Fault((Throwable)new RuntimeException("WS-AT Feature is present, however there is no interceptor service available"));
        }
        Exchange ex = message.getExchange();
        if (ex == null) {
            throw new Fault((Throwable)new RuntimeException("Not able to get exchange from message"));
        }
        LibertyApplicationBus.Type busType = (LibertyApplicationBus.Type)ex.getBus().getExtension(LibertyApplicationBus.Type.class);
        if (busType == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSATPolicyAwareInterceptor", (Object[])new Object[]{"busType is NULL"});
            }
            return;
        }
        if (this.isOut && busType.equals((Object)LibertyApplicationBus.Type.CLIENT)) {
            message.getInterceptorChain().add(service.getCoorContextOutInterceptor());
        } else if (!this.isOut && busType.equals((Object)LibertyApplicationBus.Type.SERVER)) {
            String requrl = (String)message.get((Object)Message.PATH_INFO);
            if (requrl != null && requrl.contains("ibm/wsatservice")) {
                message.getInterceptorChain().add(service.getSSLServerInterceptor());
            } else {
                message.getInterceptorChain().add(service.getCoorContextInInterceptor());
            }
        }
    }

    private void handleMessage_feature_no_exist(Message message, boolean assertion_exist) {
        ArrayList headers;
        if (this.isOut) {
            if (assertion_exist) {
                throw new Fault((Throwable)new RuntimeException("WS-AT Feature is not installed"));
            }
            XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            if (xtw != null && xtw.toString().contains("http://docs.oasis-open.org/ws-tx/wsat/2006/06")) {
                throw new Fault((Throwable)new RuntimeException("WS-AT Feature is not installed"));
            }
        }
        if ((headers = (ArrayList)message.get((Object)"org.apache.cxf.headers.Header.list")) != null) {
            for (Header h : headers) {
                Element headerElement;
                String headerURI;
                if (!(h.getObject() instanceof Element) || (headerURI = (headerElement = (Element)h.getObject()).getNamespaceURI()) == null || !headerURI.contains("http://docs.oasis-open.org/ws-tx/wscoor/2006/06") || !headerElement.getTextContent().contains("http://docs.oasis-open.org/ws-tx/wsat/2006/06")) continue;
                throw new Fault((Throwable)new RuntimeException("WS-AT Feature is not installed"));
            }
        }
    }
}

