/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.audit;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditServiceUnavailableException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.utils.SecurityUtils;
import com.ibm.wsspi.security.audit.AuditService;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuditEvent {
    public static final String EVENTNAME = "eventName";
    public static final String EVENTTYPE = "eventType";
    public static final String EVENTTIME = "eventTime";
    public static final String LOGGING_EVENTTIME = "loggingEventTime";
    public static final String WASEVENTTYPE = "wasEventType";
    public static final String HASHTAG = "hashTag";
    public static final String OBSERVER = "observer";
    public static final String OBSERVER_ID = "observer.id";
    public static final String OBSERVER_NAME = "observer.name";
    public static final String OBSERVER_TYPEURI = "observer.typeURI";
    public static final String OBSERVER_HOST_ADDRESS = "observer.host.address";
    public static final String OBSERVER_HOST_AGENT = "observer.host.agent";
    public static final String TARGET = "target";
    public static final String TARGET_ACTION = "target.action";
    public static final String TARGET_ID = "target.id";
    public static final String TARGET_UNIQUENAME = "target.uniqueName";
    public static final String TARGET_ENTITY_TYPE = "target.entityType";
    public static final String TARGET_EXTENDED_PROPERTIES = "target.extendedProperties";
    public static final String TARGET_METHOD = "target.method";
    public static final String TARGET_NAME = "target.name";
    public static final String TARGET_MESSAGING_BUSNAME = "target.messaging.busname";
    public static final String TARGET_MESSAGING_ENGINE = "target.messaging.engine";
    public static final String TARGET_MESSAGING_LOGIN_TYPE = "target.messaging.loginType";
    public static final String TARGET_MESSAGING_REMOTE_CHAIN_NAME = "target.messaging.remote.chainName";
    public static final String TARGET_MESSAGING_USER_NAME = "target.messaging.userName";
    public static final String TARGET_MESSAGING_DESTINATION = "target.messaging.destination";
    public static final String TARGET_MESSAGING_OPERATIONTYPE = "target.messaging.operationType";
    public static final String TARGET_MESSAGING_CALLTYPE = "target.messaging.callType";
    public static final String TARGET_MESSAGING_JMS_RESOURCE = "target.messaging.jmsResource";
    public static final String TARGET_MESSAGING_JMS_ACTIONS = "target.messaging.jmsActions";
    public static final String TARGET_MESSAGING_JMS_ROLES = "target.messaging.jmsRoles";
    public static final String TARGET_MESSAGING_JMS_REQUESTOR_TYPE = "target.messaging.jmsRequestorType";
    public static final String TARGET_MESSAGING_JMS_QUEUE_PERMISSIONS = "target.messaging.queuePermissions";
    public static final String TARGET_MESSAGING_JMS_TOPIC_PERMISSIONS = "target.messaging.topicPermissions";
    public static final String TARGET_MESSAGING_JMS_TEMPORARY_DESTINATION_PERMISSIONS = "target.messaging.tempDestinationPermissions";
    public static final String TARGET_JMX_NOTIFICATION_NAME = "target.jmx.notification.name";
    public static final String TARGET_JMX_NOTIFICATION_LISTENER = "target.jmx.notification.listener";
    public static final String TARGET_JMX_NOTIFICATION_FILTER = "target.jmx.notification.filter";
    public static final String TARGET_JMX_NOTIFICATION_HANDBACK = "target.jmx.notification.handback";
    public static final String TARGET_JMX_MBEAN_NAME = "target.jmx.mbean.name";
    public static final String TARGET_JMX_MBEAN_ACTION = "target.jmx.mbean.action";
    public static final String TARGET_JMX_MBEAN_ATTRIBUTE_NAME = "target.jmx.mbean.attribute.name";
    public static final String TARGET_JMX_MBEAN_ATTRIBUTE_NAMES = "target.jmx.mbean.attribute.names";
    public static final String TARGET_JMX_MBEAN_ATTRIBUTE_ACTION = "target.jmx.mbean.attribute.action";
    public static final String TARGET_JMX_MBEAN_CLASSNAME = "target.jmx.mbean.classname";
    public static final String TARGET_JMX_MBEAN_CLASSLOADER_NAME = "target.jmx.mbean.classloader.name";
    public static final String TARGET_JMX_MBEAN_INVOKE_OPERATION = "target.jmx.mbean.invoke.operation";
    public static final String TARGET_JMX_MBEAN_PARAMS = "target.jmx.mbean.params";
    public static final String TARGET_JMX_MBEAN_SIGNATURE = "target.jmx.mbean.signature";
    public static final String TARGET_JMX_MBEAN_QUERYEXP = "target.jmx.mbean.queryExp";
    public static final String TARGET_APPNAME = "target.appname";
    public static final String TARGET_APPLICATION_ID = "target.applicationId";
    public static final String TARGET_TOKEN_ID = "target.tokenId";
    public static final String TARGET_CLIENT_ID = "target.clientId";
    public static final String TARGET_ENDPOINT = "target.endpoint";
    public static final String TARGET_PROVIDER = "target.provider";
    public static final String TARGET_INITIATOR_ROLE = "target.initiatorRole";
    public static final String TARGET_NUMBER_REVOKED = "target.numberRevoked";
    public static final String TARGET_USERID = "target.userId";
    public static final String TARGET_PARAMS = "target.params";
    public static final String TARGET_TYPEURI = "target.typeURI";
    public static final String TARGET_HOST_ADDRESS = "target.host.address";
    public static final String TARGET_HOST_AGENT = "target.host.agent";
    public static final String TARGET_CREDENTIAL_TYPE = "target.credential.type";
    public static final String TARGET_CREDENTIAL_TOKEN = "target.credential.token";
    public static final String TARGET_REPOSITORY_ID = "target.repositoryId";
    public static final String TARGET_SESSION = "target.session";
    public static final String TARGET_DELEGATION_USERS = "target.delegation.users";
    public static final String TARGET_ORIGINAL_AUTH_TYPE = "target.authtype.original";
    public static final String TARGET_FAILOVER_AUTH_TYPE = "target.authtype.failover";
    public static final String TARGET_URINAME = "target.uriname";
    public static final String TARGET_ROLE_NAMES = "target.role.names";
    public static final String TARGET_RUNAS_ROLE = "target.runas.role";
    public static final String TARGET_JACC_PERMISSIONS = "target.jacc.permissions";
    public static final String TARGET_JACC_CONTAINER = "target.jacc.container";
    public static final String TARGET_JASPI_PROVIDER = "target.jaspi.provider";
    public static final String TARGET_JASPI_AUTHTYPE = "target.jaspi.authtype";
    public static final String TARGET_REALM = "target.realm";
    public static final String TARGET_EJB_MODULE_NAME = "target.ejb.module.name";
    public static final String TARGET_EJB_METHOD_INTERFACE = "target.ejb.method.interface";
    public static final String TARGET_EJB_METHOD_SIGNATURE = "target.ejb.method.signature";
    public static final String TARGET_EJB_BEAN_NAME = "target.ejb.beanname";
    public static final String TARGET_EJB_METHOD_PARAMETERS = "target.ejb.method.parameters";
    public static final String TARGET_SAF_RETURN_CODE = "target.saf.return.code";
    public static final String TARGET_RACF_RETURN_CODE = "target.racf.return.code";
    public static final String TARGET_RACF_REASON_CODE = "target.racf.reason.code";
    public static final String TARGET_USER_SECURITY_NAME = "target.user.security.name";
    public static final String TARGET_APPLID = "target.applid";
    public static final String TARGET_SAF_PROFILE = "target.saf.profile";
    public static final String TARGET_SAF_CLASS = "target.saf.class";
    public static final String TARGET_AUTHORIZATION_DECISION = "target.authorization.decision";
    public static final String INITIATOR = "initiator";
    public static final String INITIATOR_ID = "initiator.id";
    public static final String INITIATOR_NAME = "initiator.name";
    public static final String INITIATOR_TYPEURI = "initiator.typeURI";
    public static final String INITIATOR_HOST_ADDRESS = "initiator.host.address";
    public static final String INITIATOR_HOST_AGENT = "initiator.host.agent";
    public static final String OUTCOME = "outcome";
    public static final String ACTION = "action";
    public static final String REASON = "reason";
    public static final String REASON_CODE = "reason.reasonCode";
    public static final String REASON_TYPE = "reason.reasonType";
    public static final String TARGET_METHOD_GET = "GET";
    public static final String TARGET_METHOD_POST = "POST";
    public static final String TARGET_METHOD_PUT = "PUT";
    public static final String TARGET_METHOD_DELETE = "DELETE";
    public static final String TARGET_METHOD_CUSTOM = "CUSTOM";
    public static final String REASON_TYPE_HTTP = "HTTP";
    public static final String REASON_TYPE_HTTPS = "HTTPS";
    public static final String REASON_TYPE_EJB_DENYALL = "EJB Deny All";
    public static final String REASON_TYPE_EJB_PERMITALL = "EJB Permit All";
    public static final String REASON_TYPE_EJB_NO_ROLES = "EBJ No Roles";
    public static final String REASON_TYPE_EJB_NO_AUTHZ_SERVICE = "EJB No Authorization Service Found";
    public static final String REASON_TYPE_MISSING_ENTITY_DATA_OBJECT = "Missing entity data object";
    public static final String REASON_TYPE_ACTION_MULTIPLE_ENTITIES_SPECIFIED = "Multiple entities specified";
    public static final String REASON_TYPE_ENTITY_IDENTIFIER_NOT_SPECIFIED = "Entity identifier not specified";
    public static final String REASON_TYPE_ENTITY_NOT_IN_REALM_SCOPE = "Entity not in the scope of the realm";
    public static final String REASON_TYPE_INVALID_PARENT_UNIQUE_ID = "Invalid parent uniqueId";
    public static final String REASON_TYPE_DEFAULT_PARENT_NOT_FOUND = "Default parent not found";
    public static final String REASON_TYPE_MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION = "Repository for groups is missing or indicates groups are in cross repositories";
    public static final String REASON_TYPE_ENTITY_TYPE_NOT_SUPPORTED = "Entity type not supported";
    public static final String REASON_TYPE_CANNOT_WRITE_TO_READ_ONLY_REPOSITORY = "Cannot write to read only repository";
    public static final String REASON_TYPE_EXTERNAL_NAME_CONTROL_NOT_FOUND = "External name control not found";
    public static final String REASON_TYPE_INVALID_IDENTIFIER = "Invalid identifier";
    public static final String REASON_TYPE_ENTITY_NOT_FOUND = "Entity not found";
    public static final String REASON_TYPE_MISSING_SORT_KEY = "Missing sort key";
    public static final String REASON_TYPE_MISSING_SEARCH_CONTROL = "Missing search control";
    public static final String REASON_TYPE_INCORRECT_SEARCH_LIMIT = "Incorrect search limit";
    public static final String REASON_TYPE_CANNOT_SPECIFY_COUNT_LIMIT = "Cannot specify count limit";
    public static final String REASON_TYPE_MISSING_SEARCH_EXPRESSION = "Missing search expression";
    public static final String REASON_TYPE_SEARCH_EXPRESSION_ERROR = "Search expression error";
    public static final String REASON_TYPE_INVALID_SEARCH_EXPRESSION = "Invalid search expression";
    public static final String REASON_TYPE_EXCEED_MAX_TOTAL_SEARCH_LIMIT = "Exceeding max total search limit";
    public static final String REASON_TYPE_ENTITY_SEARCH_FAILED = "Entity search failed";
    public static final String REASON_TYPE_NON_COMPLIANT_MBEAN = "Not compliant MBean";
    public static final String REASON_TYPE_INSTANCE_ALREADY_EXISTS = "Instance of MBean already exists";
    public static final String REASON_TYPE_MBEAN_REGISTRATION_FAILURE = "MBean registration failure";
    public static final String REASON_TYPE_INSTANCE_NOT_FOUND = "Instance of MBean not found";
    public static final String OUTCOME_REDIRECT_TO_PROVIDER = "redirect_to_provider";
    public static final String OUTCOME_TAI_CHALLENGE = "tai_challenge";
    public static final String OUTCOME_REDIRECT = "redirect";
    public static final String OUTCOME_CHALLENGE = "challenge";
    public static final String OUTCOME_FAILURE = "failure";
    public static final String OUTCOME_SUCCESS = "success";
    public static final String OUTCOME_DENIED = "denied";
    public static final String CRED_TYPE_FORM = "FORM";
    public static final String CRED_TYPE_CERTIFICATE = "CLIENT-CERT";
    public static final String CRED_TYPE_BASIC = "BASIC";
    public static final String CRED_TYPE_JASPIC = "JASPIC";
    public static final String CRED_TYPE_TAI = "TrustAssociationInterceptor";
    public static final String CRED_TYPE_IDTOKEN = "IDToken";
    public static final String CRED_TYPE_SPNEGO = "SPNEGO";
    public static final String CRED_TYPE_OAUTH_TOKEN = "OAuth token";
    public static final String CRED_TYPE_LTPATOKEN2 = "LtpaToken2";
    public static final String CRED_TYPE_JASPI_AUTH = "JASPI_AUTH";
    public static final String WEB = "WEB";
    public static final String EJB = "EJB";
    public static final String STD_ID;
    public static final TreeMap<String, Object> STD_OBSERVER;
    public static final TreeMap<String, Object> STD_INITIATOR;
    public static final TreeMap<String, Object> STD_TARGET;
    private final Map<String, Object> eventMap = Collections.synchronizedMap(new TreeMap());
    private static String serverID;
    static final long serialVersionUID = 3630592419497678875L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuditEvent() {
        this.setEventTime(this.getCurrentTime());
    }

    public String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String nowAsISO = df.format(new Date());
        return nowAsISO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getInitiator() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Map<String, Object> map2 = this.eventMap;
        synchronized (map2) {
            for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
                if (!entry.getKey().startsWith(INITIATOR)) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public void setInitiator(Map<String, Object> initiator) {
        this.removeEntriesStartingWith(INITIATOR);
        this.eventMap.putAll(initiator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getObserver() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Map<String, Object> map2 = this.eventMap;
        synchronized (map2) {
            for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
                if (!entry.getKey().startsWith(OBSERVER)) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public void setObserver(Map<String, Object> observer) {
        this.removeEntriesStartingWith(OBSERVER);
        this.eventMap.putAll(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTarget() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Map<String, Object> map2 = this.eventMap;
        synchronized (map2) {
            for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
                if (!entry.getKey().startsWith(TARGET)) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public void setTarget(Map<String, Object> target) {
        this.removeEntriesStartingWith(TARGET);
        this.eventMap.putAll(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getReason() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Map<String, Object> map2 = this.eventMap;
        synchronized (map2) {
            for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
                if (!entry.getKey().startsWith(REASON)) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public void setReason(Map<String, Object> reason) {
        this.removeEntriesStartingWith(REASON);
        this.eventMap.putAll(reason);
    }

    public Map<String, Object> getMap() {
        Map<String, Object> retMap = Collections.synchronizedMap(new TreeMap());
        retMap.putAll(this.eventMap);
        return retMap;
    }

    public void setMap(Map<String, Object> map) {
        this.eventMap.clear();
        this.eventMap.putAll(map);
    }

    public String getOutcome() {
        return (String)this.eventMap.get(OUTCOME);
    }

    public void setOutcome(String outcome) {
        this.eventMap.put(OUTCOME, outcome);
    }

    public String getAction() {
        return (String)this.eventMap.get(ACTION);
    }

    public void setAction(String action) {
        this.eventMap.put(ACTION, action);
    }

    public String getType() {
        return (String)this.eventMap.get(EVENTTYPE);
    }

    public void setType(String eventType) {
        this.eventMap.put(EVENTTYPE, eventType);
    }

    public String getWASType() {
        return (String)this.eventMap.get(WASEVENTTYPE);
    }

    public void setWASType(String wasEventType) {
        this.eventMap.put(WASEVENTTYPE, wasEventType);
    }

    public String getEventTime() {
        return (String)this.eventMap.get(EVENTTIME);
    }

    public void setEventTime(String eventTime) {
        this.eventMap.put(EVENTTIME, eventTime);
    }

    public String getHashtag() {
        return (String)this.eventMap.get(HASHTAG);
    }

    public void setHashtag(String hash) {
        this.eventMap.put(HASHTAG, hash);
    }

    public Object get(String key) {
        return this.eventMap.get(key);
    }

    public void set(String key, Object value) {
        this.eventMap.put(key, value);
    }

    public void set(Map<String, Object> map) {
        this.eventMap.putAll(map);
    }

    public static String getServerID() {
        AuditService auditService;
        if (serverID == null && (auditService = SecurityUtils.getAuditService()) != null) {
            serverID = auditService.getServerID();
        }
        return serverID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buff = new StringBuffer();
        Map<String, Object> map = this.eventMap;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.eventMap.entrySet()) {
                buff.append("\n").append(entry.getKey()).append("    :    ").append(entry.getValue() != null ? entry.getValue().toString() : "null");
            }
        }
        return buff.toString();
    }

    public void send() throws AuditServiceUnavailableException {
        AuditService auditService = SecurityUtils.getAuditService();
        if (auditService == null) {
            throw new AuditServiceUnavailableException();
        }
        auditService.sendEvent(this);
    }

    public boolean isAuditRequired() throws AuditServiceUnavailableException {
        return AuditEvent.isAuditRequired(this.getType(), this.getOutcome());
    }

    public static boolean isAuditRequired(String eventType, String outcome) throws AuditServiceUnavailableException {
        AuditService auditService = SecurityUtils.getAuditService();
        if (auditService != null) {
            return auditService.isAuditRequired(eventType, outcome);
        }
        throw new AuditServiceUnavailableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntriesStartingWith(String key) {
        Map<String, Object> map = this.eventMap;
        synchronized (map) {
            Iterator<String> iter = this.eventMap.keySet().iterator();
            while (iter.hasNext()) {
                String str = iter.next();
                if (!str.startsWith(key)) continue;
                iter.remove();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AuditEvent.class);
        STD_ID = AuditEvent.getServerID();
        STD_OBSERVER = new TreeMap();
        STD_INITIATOR = new TreeMap();
        STD_TARGET = new TreeMap();
        STD_OBSERVER.put(OBSERVER_ID, STD_ID);
        STD_OBSERVER.put(OBSERVER_NAME, "SecurityService");
        STD_OBSERVER.put(OBSERVER_TYPEURI, "service/server");
        STD_TARGET.put(TARGET_ID, STD_ID);
        STD_TARGET.put(TARGET_TYPEURI, "service/application/web");
        serverID = null;
    }
}

