/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.clientcontainer.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.clientcontainer.metadata.ClientModuleMetaData;
import com.ibm.ws.container.service.app.deploy.ClientModuleInfo;
import com.ibm.ws.container.service.config.extended.RefBndAndExtHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.clientbnd.ApplicationClientBnd;
import com.ibm.ws.javaee.dd.common.JMSConnectionFactory;
import com.ibm.ws.javaee.dd.common.JMSDestination;
import com.ibm.ws.javaee.dd.common.MailSession;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientModuleInjection {
    private final ClientModuleMetaData cmmd;
    private final ApplicationClient appClient;
    private final ApplicationClientBnd appClientBnd;
    private final ResourceRefConfigFactory resourceRefConfigFactory;
    private final ClientModuleInfo moduleInfo;
    private final InjectionEngine injectionEngine;
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceRef;
    private final CallbackHandler callbackHandler;
    private Class<?> mainClass;
    public Exception invokeException;
    private final boolean runningInClient;
    private static final TraceComponent tc = Tr.register(ClientModuleInjection.class, null, null);
    static final long serialVersionUID = -18565359693447521L;

    public ClientModuleInjection(ClientModuleMetaData cmmd, ApplicationClientBnd appClientBnd, ResourceRefConfigFactory resourceRefConfigFactory, InjectionEngine injectionEngine, AtomicServiceReference<ManagedObjectService> managedObjectServiceRef, CallbackHandler callbackHandler, boolean runningInClient) {
        this.cmmd = cmmd;
        this.appClient = cmmd.getAppClient();
        this.appClientBnd = appClientBnd;
        this.resourceRefConfigFactory = resourceRefConfigFactory;
        this.injectionEngine = injectionEngine;
        this.managedObjectServiceRef = managedObjectServiceRef;
        this.callbackHandler = callbackHandler;
        this.moduleInfo = (ClientModuleInfo)cmmd.getModuleInfo();
        this.runningInClient = runningInClient;
    }

    public Class<?> getMainClass() throws ClassNotFoundException {
        if (this.mainClass == null) {
            ClassLoader cl = this.moduleInfo.getClassLoader();
            this.mainClass = cl.loadClass(this.getMainClassName());
        }
        return this.mainClass;
    }

    private String getMainClassName() {
        return this.moduleInfo.getMainClassName();
    }

    public void processReferences() throws ClassNotFoundException, InjectionException {
        HashMap<Class<?>, InjectionTarget[]> cookies = this.getInjectionCookies();
        if (this.runningInClient) {
            this.inject(this.getMainClass(), null, cookies);
        }
        if (this.callbackHandler != null) {
            this.inject(this.callbackHandler.getClass(), this.callbackHandler, cookies);
        }
    }

    private ManagedObject getManagedObject(Object instance) throws Exception {
        ManagedObjectFactory mof = ((ManagedObjectService)this.managedObjectServiceRef.getServiceWithException()).createManagedObjectFactory((ModuleMetaData)this.cmmd, instance.getClass(), false);
        ManagedObject mo = mof.createManagedObject(instance, null);
        return mo;
    }

    /*
     * WARNING - void declaration
     */
    private InjectionTargetContext getInjectionTargetContext(Object instance) throws InjectionException {
        ManagedObject mo;
        try {
            mo = this.getManagedObject(instance);
            if (mo == null) {
                return null;
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleInjection", (String)"129", (Object)this, (Object[])new Object[]{instance});
            throw new InjectionException(e.getCause());
        }
        InjectionTargetContext itc = new InjectionTargetContext(){
            static final long serialVersionUID = 8103125184000792773L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public <T> T getInjectionTargetContextData(Class<T> data) {
                return (T)mo.getContextData(data);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return itc;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void inject(Object obj, Object instance, HashMap<Class<?>, InjectionTarget[]> cookies) throws InjectionException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"obj --> [" + obj + "]"});
        }
        if (cookies.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"no injection cookies found"});
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injection cookies found"});
        }
        if (cookies.containsKey(obj)) {
            if (instance != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"about to inject via managed object --> [" + obj + "]"});
                }
                try {
                    ManagedObject mo = this.getManagedObject(instance);
                    mo.inject(cookies.get(obj), null);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.clientcontainer.internal.ClientModuleInjection", (String)"166", (Object)this, (Object[])new Object[]{obj, instance, cookies});
                    throw new InjectionException(e.getCause());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injected --> [" + obj + "]"});
                }
            } else {
                for (InjectionTarget cookie : cookies.get(obj)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"about to inject resource --> [" + cookie + "]"});
                    }
                    this.injectionEngine.inject(obj, cookie, null);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"injected resource --> [" + cookie + "]"});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inject", (Object[])new Object[]{"cookies does not contains the key --> [" + obj + "]"});
        }
    }

    private HashMap<Class<?>, InjectionTarget[]> getInjectionCookies() throws InjectionException, ClassNotFoundException {
        HashMap injectionCookies = new HashMap();
        ComponentNameSpaceConfiguration compNSConfig = this.getComponentNameSpaceConfiguration();
        InjectionEngineAccessor.getInstance().processInjectionMetaData(injectionCookies, compNSConfig);
        return injectionCookies;
    }

    private ComponentNameSpaceConfiguration getComponentNameSpaceConfiguration() throws ClassNotFoundException {
        String displayName = "";
        J2EEName j2eeName = this.cmmd.getJ2EEName();
        ClassLoader classLoader = this.moduleInfo.getClassLoader();
        boolean metadataComplete = false;
        if (this.appClient.isSetMetadataComplete()) {
            metadataComplete = this.appClient.isMetadataComplete();
        }
        ArrayList injectionClasses = new ArrayList();
        List envEntries = this.appClient.getEnvEntries();
        HashMap envEntryBindings = new HashMap();
        HashMap envEntryValues = new HashMap();
        RefBndAndExtHelper.configureEnvEntryBindings((RefBindingsGroup)this.appClientBnd, envEntryValues, envEntryBindings);
        List ejbRefs = this.appClient.getEJBRefs();
        HashMap ejbRefBndMap = new HashMap();
        RefBndAndExtHelper.configureEJBRefBindings((RefBindingsGroup)this.appClientBnd, ejbRefBndMap);
        List webServiceRefs = this.appClient.getServiceRefs();
        List resourceRefs = this.appClient.getResourceRefs();
        ResourceRefConfigList resourceRefConfigList = this.resourceRefConfigFactory.createResourceRefConfigList();
        HashMap resourceRefBindings = new HashMap();
        RefBndAndExtHelper.configureResourceRefBindings((RefBindingsGroup)this.appClientBnd, resourceRefBindings, (ResourceRefConfigList)resourceRefConfigList);
        List resourceEnvRefs = this.appClient.getResourceEnvRefs();
        HashMap resourceEnvRefBindings = new HashMap();
        RefBndAndExtHelper.configureResourceEnvRefBindings((RefBindingsGroup)this.appClientBnd, resourceEnvRefBindings);
        List msgDestRefs = this.appClient.getMessageDestinationRefs();
        HashMap msgDestValues = new HashMap();
        RefBndAndExtHelper.configureMessageDestinationRefBindings((RefBindingsGroup)this.appClientBnd, msgDestValues);
        List persistenceUnitRefs = this.appClient.getPersistenceUnitRefs();
        List persistenceContextRefs = null;
        List dataSourceDefs = this.appClient.getDataSources();
        HashMap dataSourceBindings = new HashMap();
        RefBndAndExtHelper.configureDataSourceBindings((RefBindingsGroup)this.appClientBnd, dataSourceBindings);
        List mailSessions = this.appClient.getMailSessions();
        List jmsConnectionFactories = this.appClient.getJMSConnectionFactories();
        List jmsDestinations = this.appClient.getJMSDestinations();
        List connectionFactories = this.appClient.getConnectionFactories();
        List adminObjects = this.appClient.getAdministeredObjects();
        HashMap mailSessionBindings = new HashMap();
        RefBndAndExtHelper.configureResourceRefBindings((RefBindingsGroup)this.appClientBnd, mailSessionBindings, (ResourceRefConfigList)resourceRefConfigList);
        HashMap jmsConnectionFactoryBindings = new HashMap();
        RefBndAndExtHelper.configureResourceRefBindings((RefBindingsGroup)this.appClientBnd, jmsConnectionFactoryBindings, (ResourceRefConfigList)resourceRefConfigList);
        HashMap jmsDestinationBindings = new HashMap();
        RefBndAndExtHelper.configureResourceRefBindings((RefBindingsGroup)this.appClientBnd, jmsDestinationBindings, (ResourceRefConfigList)resourceRefConfigList);
        injectionClasses.add(this.getMainClass());
        if (this.callbackHandler != null) {
            injectionClasses.add(this.callbackHandler.getClass());
        }
        ComponentNameSpaceConfiguration compNSConfig = new ComponentNameSpaceConfiguration(displayName, j2eeName);
        compNSConfig.setClientContainer(true);
        compNSConfig.setClassLoader(classLoader);
        compNSConfig.setMetaDataComplete(metadataComplete);
        compNSConfig.setInjectionClasses(injectionClasses);
        compNSConfig.setEnvEntries(envEntries);
        compNSConfig.setEnvEntryBindings(envEntryBindings);
        compNSConfig.setEJBRefs(ejbRefs);
        compNSConfig.setEJBRefBindings(ejbRefBndMap);
        compNSConfig.setWebServiceRefs(webServiceRefs);
        compNSConfig.setResourceRefs(resourceRefs);
        compNSConfig.setResourceRefBindings(resourceRefBindings);
        compNSConfig.setResourceEnvRefs(resourceEnvRefs);
        compNSConfig.setResourceEnvRefBindings(resourceEnvRefBindings);
        compNSConfig.setMsgDestRefs(msgDestRefs);
        compNSConfig.setMsgDestRefBindings(msgDestValues);
        compNSConfig.setPersistenceUnitRefs(persistenceUnitRefs);
        compNSConfig.setPersistenceContextRefs(persistenceContextRefs);
        compNSConfig.setEnvEntryValues(envEntryValues);
        compNSConfig.setDataSourceDefinitions(dataSourceDefs);
        compNSConfig.setDataSourceDefinitionBindings(dataSourceBindings);
        compNSConfig.setJNDIEnvironmentRefs(JMSConnectionFactory.class, jmsConnectionFactories);
        compNSConfig.setJNDIEnvironmentRefs(JMSDestination.class, jmsDestinations);
        compNSConfig.setConnectionFactoryDefinitions(connectionFactories);
        compNSConfig.setJNDIEnvironmentRefs(MailSession.class, mailSessions);
        compNSConfig.setAdministeredObjectDefinitions(adminObjects);
        compNSConfig.setJNDIEnvironmentRefBindings(JMSConnectionFactory.class, jmsConnectionFactoryBindings);
        compNSConfig.setJNDIEnvironmentRefBindings(JMSDestination.class, jmsDestinationBindings);
        compNSConfig.setJNDIEnvironmentRefBindings(MailSession.class, mailSessionBindings);
        compNSConfig.setModuleMetaData((ModuleMetaData)this.cmmd);
        return compNSConfig;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }
}

