/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.sse.OutboundSseEvent;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.NoSuitableMessageBodyWriterException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OutboundSseEventBodyWriter
implements MessageBodyWriter<OutboundSseEvent> {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE;
    private static final byte[] COMMENT;
    private static final byte[] EVENT;
    private static final byte[] ID;
    private static final byte[] RETRY;
    private static final byte[] DATA;
    private static final byte[] NEW_LINE;
    private ServerProviderFactory factory;
    private Message message;
    static final long serialVersionUID = 923602364737160884L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected OutboundSseEventBodyWriter() {
    }

    public OutboundSseEventBodyWriter(ServerProviderFactory factory, Exchange exchange) {
        this.factory = factory;
        this.message = new MessageImpl();
        this.message.setExchange(exchange);
    }

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return OutboundSseEvent.class.isAssignableFrom(cls) || SERVER_SENT_EVENTS_TYPE.isCompatible(mt);
    }

    public void writeTo(OutboundSseEvent p, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (p.getName() != null) {
            os.write(EVENT);
            os.write(p.getName().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getId() != null) {
            os.write(ID);
            os.write(p.getId().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getComment() != null) {
            os.write(COMMENT);
            os.write(p.getComment().getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getReconnectDelay() > 0L) {
            os.write(RETRY);
            os.write(Long.toString(p.getReconnectDelay()).getBytes(StandardCharsets.UTF_8));
            os.write(NEW_LINE);
        }
        if (p.getData() != null) {
            Class<Object> payloadClass = p.getType();
            Object payloadType = p.getGenericType();
            if (payloadType == null) {
                payloadType = payloadClass;
            }
            if (payloadType == null && payloadClass == null) {
                payloadType = Object.class;
                payloadClass = Object.class;
            }
            os.write(DATA);
            this.writePayloadTo(payloadClass, (Type)payloadType, anns, p.getMediaType(), headers, p.getData(), os);
            os.write(NEW_LINE);
        }
    }

    private <T> void writePayloadTo(Class<T> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, Object data, OutputStream os) throws IOException, WebApplicationException {
        MessageBodyWriter writer = null;
        if (this.message != null && this.factory != null) {
            writer = this.factory.createMessageBodyWriter(cls, type, anns, mt, this.message);
        }
        if (writer == null) {
            throw new NoSuitableMessageBodyWriterException("No suitable message body writer for class: " + cls.getName());
        }
        writer.writeTo(data, cls, type, anns, mt, headers, os);
    }

    public long getSize(OutboundSseEvent t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OutboundSseEventBodyWriter.class);
        SERVER_SENT_EVENTS_TYPE = MediaType.valueOf((String)SERVER_SENT_EVENTS);
        COMMENT = ": ".getBytes(StandardCharsets.UTF_8);
        EVENT = "event: ".getBytes(StandardCharsets.UTF_8);
        ID = "id: ".getBytes(StandardCharsets.UTF_8);
        RETRY = "retry: ".getBytes(StandardCharsets.UTF_8);
        DATA = "data: ".getBytes(StandardCharsets.UTF_8);
        NEW_LINE = "\n".getBytes(StandardCharsets.UTF_8);
    }
}

