/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.statemachine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.NotificationHelper;
import com.ibm.ws.app.manager.internal.ApplicationInstallInfo;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor;
import com.ibm.ws.app.manager.internal.statemachine.Action;
import com.ibm.ws.app.manager.internal.statemachine.StateChangeCallback;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class StopAction
implements Action {
    private static final TraceComponent _tc = Tr.register(StopAction.class);
    private final ApplicationInstallInfo _aii;
    private final FutureMonitor _monitor;
    private final AtomicReference<StateChangeCallback> _callback = new AtomicReference();
    private final ApplicationMonitor _appMonitor;
    private final CompletionListener<Boolean> _listener = new CompletionListener<Boolean>(){
        static final long serialVersionUID = 8739738285980375613L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void successfulCompletion(Future<Boolean> future, Boolean result) {
            StateChangeCallback callback = StopAction.this._callback.getAndSet(null);
            if (callback != null) {
                NotificationHelper.broadcastChange(StopAction.this._aii.getMBeanNotifier(), StopAction.this._aii.getMBeanName(), "application.stop", Boolean.TRUE, AppMessageHelper.get(StopAction.this._aii.getHandler()).formatMessage("APPLICATION_STOPPED", StopAction.this._aii.getName()));
                AppMessageHelper.get(StopAction.this._aii.getHandler()).audit("APPLICATION_STOPPED", StopAction.this._aii.getName());
                callback.changed();
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        }

        public void failedCompletion(Future<Boolean> future, Throwable t) {
            StateChangeCallback callback = StopAction.this._callback.getAndSet(null);
            if (callback != null) {
                NotificationHelper.broadcastChange(StopAction.this._aii.getMBeanNotifier(), StopAction.this._aii.getMBeanName(), "application.stop", Boolean.FALSE, AppMessageHelper.get(StopAction.this._aii.getHandler()).formatMessage("APPLICATION_STOP_FAILED", StopAction.this._aii.getName(), t.toString()));
                AppMessageHelper.get(StopAction.this._aii.getHandler()).error("APPLICATION_STOP_FAILED", StopAction.this._aii.getName(), t.toString());
                callback.failed(t);
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = -7712184275645965074L;

    public StopAction(ApplicationInstallInfo aii, ApplicationMonitor appMonitor, FutureMonitor monitor, StateChangeCallback callback) {
        this._aii = aii;
        this._monitor = monitor;
        this._callback.set(callback);
        this._appMonitor = appMonitor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(ExecutorService executor) {
        try {
            this._appMonitor.removeApplication(this._aii.getPid());
            ApplicationHandler<?> handler = this._aii.getHandler();
            Future<Boolean> result = handler.uninstall(this._aii);
            this._monitor.onCompletion(result, this._listener);
        }
        catch (Throwable handler) {
            void t;
            FFDCFilter.processException((Throwable)handler, (String)"com.ibm.ws.app.manager.internal.statemachine.StopAction", (String)"85", (Object)this, (Object[])new Object[]{executor});
            this._listener.failedCompletion(null, (Throwable)t);
        }
    }

    @Override
    public void cancel() {
        this._callback.set(null);
    }
}

