/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.internal.ApplicationConfig;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoForContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.NotificationBroadcasterSupport;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationInstallInfo
implements ApplicationInformation<Object>,
ApplicationInfoForContainer {
    private final ApplicationConfig _config;
    private final AtomicReference<Object> _handlerInfo = new AtomicReference();
    private final AtomicReference<Container> _container = new AtomicReference();
    private final AtomicReference<WsResource> _resolvedLocation = new AtomicReference();
    private final ApplicationHandler<?> _handler;
    private final AtomicReference<ApplicationMonitoringInformation> _ami = new AtomicReference();
    private final ApplicationMonitor.UpdateHandler _updateHandler;
    static final long serialVersionUID = 2630639237123415755L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public ApplicationInstallInfo(ApplicationConfig cfg, Container container, WsResource resolvedLocation, ApplicationHandler<?> handler, ApplicationMonitor.UpdateHandler updateHandler) {
        this._config = cfg;
        this._container.set(container);
        this._resolvedLocation.set(resolvedLocation);
        this._handler = handler;
        this._updateHandler = updateHandler;
        try {
            NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            cache.addToCache(ApplicationInfoForContainer.class, (Object)this);
        }
        catch (UnableToAdaptException cache) {
            void ex;
            FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.app.manager.internal.ApplicationInstallInfo", (String)"51", (Object)this, (Object[])new Object[]{cfg, container, resolvedLocation, handler, updateHandler});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"ApplicationInstallInfo_ctor");
        }
    }

    public ApplicationHandler<?> getHandler() {
        return this._handler;
    }

    @Override
    public String getPid() {
        return this._config.getConfigPid();
    }

    public NotificationBroadcasterSupport getMBeanNotifier() {
        return this._config.getMBeanNotifier();
    }

    @Override
    public String getName() {
        return this._config.getName();
    }

    @Override
    public boolean getUseJandex() {
        return this._config.getUseJandex();
    }

    public String getMBeanName() {
        return this._config.getMBeanName();
    }

    @Override
    public String getLocation() {
        WsResource res = this._resolvedLocation.get();
        if (res != null && res.exists()) {
            return res.asFile().getAbsolutePath();
        }
        return this._config.getLocation();
    }

    @Override
    public Container getContainer() {
        return this._container.get();
    }

    @Override
    public void setContainer(Container container) {
        this._container.set(container);
    }

    @Override
    public Object getConfigProperty(String propName) {
        return this._config.getConfigProperty(propName);
    }

    @Override
    public Object getHandlerInfo() {
        return this._handlerInfo.get();
    }

    @Override
    public void setHandlerInfo(Object handlerInfo) {
        this._handlerInfo.set(handlerInfo);
    }

    public void setApplicationMonitoringInformation(ApplicationMonitoringInformation ami) {
        this._ami.set(ami);
    }

    public ApplicationMonitoringInformation getApplicationMonitoringInformation() {
        return this._ami.get();
    }

    public ApplicationMonitor.UpdateHandler getUpdateHandler() {
        return this._updateHandler;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationInstallInfo.class);
    }
}

