/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RestClientBean
implements Bean<Object>,
PassivationCapable {
    private static final Logger LOG = LogUtils.getL7dLogger(RestClientBean.class);
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_PROVIDERS_FORMAT = "%s/mp-rest/providers";
    public static final String REST_PROVIDERS_PRIORITY_FORMAT = "%s/mp-rest/providers/%s/priority";
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    static final long serialVersionUID = 4239946566437176475L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "<init>", new Object[]{clientInterface, beanManager});
        }
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getId() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getId", new Object[0]);
        }
        String string = this.clientInterface.getName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?> getBeanClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBeanClass", new Object[0]);
        }
        Class<?> clazz = this.clientInterface;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBeanClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<InjectionPoint> getInjectionPoints() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInjectionPoints", new Object[0]);
        }
        Set<InjectionPoint> set = Collections.emptySet();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getInjectionPoints", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isNullable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isNullable", new Object[0]);
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isNullable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object create(CreationalContext<Object> creationalContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "create", new Object[]{creationalContext});
        }
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUri = this.getBaseUri();
        builder = builder.baseUri(URI.create(baseUri));
        List<Class<?>> providers = this.getConfiguredProviders();
        Map<Class<?>, Integer> providerPriorities = this.getConfiguredProviderPriorities(providers);
        for (Class<?> providerClass : providers) {
            builder = (RestClientBuilder)builder.register(providerClass, providerPriorities.getOrDefault(providerClass, 5000));
        }
        Object object = builder.build(this.clientInterface);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "create", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "destroy", new Object[]{instance, creationalContext});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "destroy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Type> getTypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getTypes", new Object[0]);
        }
        Set<Type> set = Collections.singleton(this.clientInterface);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getTypes", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Annotation> getQualifiers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getQualifiers", new Object[0]);
        }
        HashSet<Annotation> hashSet = new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getQualifiers", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<? extends Annotation> getScope() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getScope", new Object[0]);
        }
        Class<? extends Annotation> clazz = this.scope;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getScope", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getName", new Object[0]);
        }
        String string = this.clientInterface.getName();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<? extends Annotation>> getStereotypes() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getStereotypes", new Object[0]);
        }
        Set<Class<? extends Annotation>> set = Collections.emptySet();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getStereotypes", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAlternative() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isAlternative", new Object[0]);
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "isAlternative", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NoSuchElementException.class})
    private String getBaseUri() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBaseUri", new Object[0]);
        }
        String interfaceName = this.clientInterface.getName();
        String property = String.format(REST_URI_FORMAT, interfaceName);
        String baseURI = null;
        try {
            baseURI = ConfigFacade.getValue(property, String.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (baseURI == null && (baseURI = ConfigFacade.getValue(property = String.format(REST_URL_FORMAT, interfaceName), String.class)) == null) {
            throw new IllegalStateException("Unable to determine base URI from configuration");
        }
        String string = baseURI;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getBaseUri", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", new Object[0]);
        }
        String property = String.format(REST_SCOPE_FORMAT, this.clientInterface.getName());
        String configuredScope = ConfigFacade.getOptionalValue(property, String.class).orElse(null);
        if (configuredScope != null) {
            Class clazz;
            block9: {
                try {
                    clazz = ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", e);
                }
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            Class<Dependent> clazz = Dependent.class;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        if (possibleScopes.size() == 1) {
            Class<? extends Annotation> clazz = ((Annotation)possibleScopes.get(0)).annotationType();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "readScope", clazz);
            }
            return clazz;
        }
        throw new IllegalArgumentException("The client interface " + this.clientInterface + " has multiple scopes defined " + possibleScopes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class})
    private List<Class<?>> getConfiguredProviders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviders", new Object[0]);
        }
        String property = String.format(REST_PROVIDERS_FORMAT, this.clientInterface.getName());
        String providersList = ConfigFacade.getOptionalValue(property, String.class).orElse(null);
        ArrayList providers = new ArrayList();
        if (providersList != null) {
            String[] providerClassNames = providersList.split(",");
            for (int i = 0; i < providerClassNames.length; ++i) {
                try {
                    providers.add(ClassLoaderUtils.loadClass((String)providerClassNames[i], RestClientBean.class));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOG.log(Level.WARNING, "Could not load provider, {0}, configured for Rest Client interface, {1} ", new Object[]{providerClassNames[i], this.clientInterface.getName()});
                }
            }
        }
        ArrayList arrayList = providers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviders", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<Class<?>, Integer> getConfiguredProviderPriorities(List<Class<?>> providers) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviderPriorities", new Object[]{providers});
        }
        HashMap map = new HashMap();
        for (Class<?> providerClass : providers) {
            String property = String.format(REST_PROVIDERS_PRIORITY_FORMAT, this.clientInterface.getName(), providerClass.getName());
            Integer priority = ConfigFacade.getOptionalValue(property, Integer.class).orElse(5000);
            map.put(providerClass, priority);
        }
        HashMap hashMap = map;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.RestClientBean", "getConfiguredProviderPriorities", hashMap);
        }
        return hashMap;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DefaultLiteral() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DefaultLiteral.class);
        }
    }
}

