/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IBMHibernateExtendedBeanManager {
    private ClassLoader applicationClassLoader;
    private BeanManager deligateBeanManager = null;
    private Set<Object> hibernateLifecycleListeners = new HashSet<Object>();
    static final long serialVersionUID = 3794346686241209595L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IBMHibernateExtendedBeanManager(ClassLoader applicationClassLoader) {
        this.applicationClassLoader = applicationClassLoader;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public void registerLifecycleListener(Object lifecycleListener) {
        Class<?> lifeCycleListenerClass = null;
        try {
            lifeCycleListenerClass = Class.forName("org.hibernate.resource.beans.container.spi.ExtendedBeanManager$LifecycleListener", true, this.applicationClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to find org.hibernate.resource.beans.container.spi.ExtendedBeanManager$LifecycleListener", e);
        }
        if (!lifeCycleListenerClass.isAssignableFrom(lifecycleListener.getClass())) {
            String errorMsg = "Object " + lifecycleListener + " of class " + lifecycleListener.getClass().getCanonicalName() + " is not instance of org.hibernate.resource.beans.container.spi.ExtendedBeanManager.LifecycleListener";
            throw new IllegalArgumentException(errorMsg);
        }
        this.hibernateLifecycleListeners.add(lifecycleListener);
    }

    public void setBaseBeanManager(BeanManager deligateBeanManager) {
        this.deligateBeanManager = deligateBeanManager;
    }

    public BeanManager getBaseBeanManager() {
        return this.deligateBeanManager;
    }

    public void notifyHibernateAfterBeanDiscovery(BeanManager deligateBeanManager) throws SecurityException, IllegalArgumentException {
        if (deligateBeanManager != null && deligateBeanManager.equals(this.deligateBeanManager)) {
            for (Object o : this.hibernateLifecycleListeners) {
                try {
                    Method beanManagerInitialized = o.getClass().getMethod("beanManagerInitialized", BeanManager.class);
                    beanManagerInitialized.invoke(o, deligateBeanManager);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"94", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"95", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"96", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyHibernateBeforeShutdown(BeanManager deligateBeanManager) throws SecurityException, IllegalArgumentException {
        boolean rightBeanManager = false;
        if (deligateBeanManager != null && deligateBeanManager.equals(this.deligateBeanManager)) {
            rightBeanManager = true;
            Iterator<Object> it = this.hibernateLifecycleListeners.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                try {
                    Method beanManagerInitialized = o.getClass().getMethod("beforeBeanManagerDestroyed", BeanManager.class);
                    beanManagerInitialized.invoke(o, deligateBeanManager);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"112", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"113", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"114", (Object)this, (Object[])new Object[]{deligateBeanManager});
                }
                finally {
                    it.remove();
                }
            }
        }
        return rightBeanManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IBMHibernateExtendedBeanManager.class);
    }
}

