/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.filter.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.internal.FilterException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IPAddressRange {
    private static final TraceComponent tc = Tr.register(IPAddressRange.class);
    InetAddress ipHigher;
    InetAddress ipLower;
    String ipRange;
    static final long serialVersionUID = -1449211764480285948L;

    /*
     * WARNING - void declaration
     */
    public IPAddressRange(String iprange) throws FilterException {
        String msg;
        this.ipRange = iprange;
        String lowerAddr = new String();
        String upperAddr = new String();
        StringTokenizer tokens = new StringTokenizer(iprange, ".:", true);
        boolean foundRange = false;
        String currentTop = "FFFF";
        while (tokens.hasMoreTokens()) {
            String ipPiece = tokens.nextToken();
            if (ipPiece.equals(":")) {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
                continue;
            }
            String delim = tokens.hasMoreElements() ? tokens.nextToken() : "";
            ipPiece = ipPiece.trim();
            if (".".equals(delim)) {
                currentTop = "255";
            }
            if (foundRange) {
                if (!ipPiece.equals("*")) {
                    String msg2 = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_MALFORMED_IP_RANGE", (Object[])new Object[]{ipPiece}, (String)"CWWKS1754E: Malformed IP range specified. Found {0} rather than a wildcard.");
                    throw new FilterException(msg2);
                }
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
            } else if (ipPiece.startsWith("[") && ipPiece.endsWith("]")) {
                int dash = ipPiece.indexOf(45);
                String startStr = ipPiece.substring(1, dash);
                lowerAddr = lowerAddr + startStr;
                int bracket = ipPiece.lastIndexOf(93);
                String lastStr = ipPiece.substring(dash + 1, bracket);
                upperAddr = upperAddr + lastStr;
                foundRange = true;
            } else if (ipPiece.equals("*")) {
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
                foundRange = true;
            } else {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
            }
            upperAddr = upperAddr + delim;
            lowerAddr = lowerAddr + delim;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("upperAddr is " + upperAddr), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("lowerAddr is " + lowerAddr), (Object[])new Object[0]);
        }
        try {
            this.ipHigher = InetAddress.getByName(upperAddr);
        }
        catch (UnknownHostException ipPiece) {
            void e;
            FFDCFilter.processException((Throwable)ipPiece, (String)"com.ibm.ws.security.authentication.filter.internal.IPAddressRange", (String)"190", (Object)this, (Object[])new Object[]{iprange});
            msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_MALFORMED_IP_RANGE", (Object[])new Object[]{upperAddr}, (String)"CWWKS1755E: Unknown host exception raised for IP address {0}.");
            throw new FilterException(msg, (Throwable)e);
        }
        try {
            this.ipLower = InetAddress.getByName(lowerAddr);
        }
        catch (UnknownHostException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.filter.internal.IPAddressRange", (String)"201", (Object)this, (Object[])new Object[]{iprange});
            msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_MALFORMED_IP_RANGE", (Object[])new Object[]{lowerAddr}, (String)"CWWKS1755E: Unknown host exception raised for IP address {0}.");
            throw new FilterException(msg, e);
        }
    }

    public boolean inRange(InetAddress ip) {
        if (IPAddressRange.greaterThan(ip, this.ipHigher)) {
            return false;
        }
        return !IPAddressRange.lessThan(ip, this.ipLower);
    }

    public boolean aboveRange(InetAddress ip) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("aboveRange, ip is " + ip), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("aboveRange, ip is " + ip), (Object[])new Object[0]);
        }
        return IPAddressRange.greaterThan(ip, this.ipHigher);
    }

    public boolean belowRange(InetAddress ip) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("belowRange, ip is " + ip), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("belowRange, ipLower is " + this.ipLower), (Object[])new Object[0]);
        }
        return IPAddressRange.lessThan(ip, this.ipLower);
    }

    public static boolean greaterThan(InetAddress a1, InetAddress a2) {
        return IPAddressRange.compare(a1, a2) > 0;
    }

    public static boolean lessThan(InetAddress a1, InetAddress a2) {
        return IPAddressRange.compare(a1, a2) < 0;
    }

    public static int compare(InetAddress a1, InetAddress a2) {
        int len;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("compare, a1 is " + a1), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("compare, a2 is " + a2), (Object[])new Object[0]);
        }
        byte[] byte1 = a1.getAddress();
        byte[] byte2 = a2.getAddress();
        int base1 = 0;
        int base2 = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("compare, byte1.length is " + byte1.length), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("compare, byte2.length is " + byte2.length), (Object[])new Object[0]);
        }
        if (byte1.length > byte2.length) {
            len = byte2.length;
            base1 = byte1.length - len;
            if (!IPAddressRange.isZeros(byte1, byte1.length - len)) {
                return 1;
            }
        } else if (byte1.length < byte2.length) {
            len = byte1.length;
            base2 = byte2.length - len;
            if (!IPAddressRange.isZeros(byte2, byte2.length - len)) {
                return -1;
            }
        } else {
            len = byte1.length;
        }
        for (int i = 0; i < len; ++i) {
            if (byte1[base1] != byte2[base2]) {
                int b2;
                int b1 = byte1[base1];
                if (b1 < 0) {
                    b1 += 256;
                }
                if ((b2 = byte2[base2]) < 0) {
                    b2 += 256;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("compare, b1 is " + b1), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("compare, b2 is " + b2), (Object[])new Object[0]);
                }
                if (b1 > b2) {
                    return 1;
                }
                return -1;
            }
            ++base1;
            ++base2;
        }
        return 0;
    }

    private static boolean isZeros(byte[] bytes, int len) {
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.ipRange;
    }
}

