/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.internal.servlet;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.handler.helper.ServletRESTRequestImpl;
import com.ibm.ws.rest.handler.helper.ServletRESTResponseImpl;
import com.ibm.wsspi.rest.handler.RESTHandlerContainer;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RESTProxyServlet
extends HttpServlet {
    private static final TraceComponent tc = Tr.register(RESTProxyServlet.class);
    private static final long serialVersionUID = 1L;
    private transient RESTHandlerContainer REST_HANDLER_CONTAINER = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getAndSetRESTHandlerContainer(request);
        if ("/".equals(request.getPathInfo())) {
            if ("GET".equals(request.getMethod())) {
                this.listRegisteredHandlers(response);
            } else {
                response.sendError(405);
            }
        } else {
            this.handleWithDelegate(request, response);
        }
    }

    private void listRegisteredHandlers(HttpServletResponse response) throws IOException {
        JSONArray keyArray = new JSONArray();
        Iterator keys = this.REST_HANDLER_CONTAINER.registeredKeys();
        if (keys != null) {
            while (keys.hasNext()) {
                keyArray.add(keys.next());
            }
        }
        OrderedJSONObject jsonObject = new OrderedJSONObject();
        jsonObject.put((Object)"version", (Object)1);
        jsonObject.put((Object)"roots", (Object)keyArray);
        String serialized = jsonObject.serialize();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(serialized.replace("\\/", "/"));
    }

    private void handleWithDelegate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean foundHandler = this.REST_HANDLER_CONTAINER.handleRequest((RESTRequest)new ServletRESTRequestImpl(request), (RESTResponse)new ServletRESTResponseImpl(response));
        if (!foundHandler) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"HANDLER_NOT_FOUND_ERROR", (Object[])new Object[]{request.getRequestURI()});
            response.sendError(404, errorMsg);
        }
    }

    private synchronized void getAndSetRESTHandlerContainer(HttpServletRequest request) throws ServletException {
        if (this.REST_HANDLER_CONTAINER == null) {
            HttpSession session = request.getSession();
            ServletContext sc = session.getServletContext();
            BundleContext ctxt = (BundleContext)sc.getAttribute("osgi-bundlecontext");
            ServiceReference ref = ctxt.getServiceReference(RESTHandlerContainer.class);
            if (ref == null) {
                throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"RESTHandlerContainer"}));
            }
            this.REST_HANDLER_CONTAINER = (RESTHandlerContainer)ctxt.getService(ref);
        }
    }
}

