/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class HttpsURLConnectionFactory {
    public static final String HTTPS_URL_PROTOCOL_ID = "https";
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static boolean weblogicWarned;
    SSLSocketFactory socketFactory;
    int lastTlsHash;
    static final long serialVersionUID = -5467577209562570888L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpsURLConnectionFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HttpURLConnection createConnection(TLSClientParameters tlsClientParameters, java.net.Proxy proxy, URL url) throws IOException {
        HttpURLConnection connection;
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", new Object[]{tlsClientParameters, proxy, url});
            }
            connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            if (HTTPS_URL_PROTOCOL_ID.equals(url.getProtocol())) {
                if (tlsClientParameters == null) {
                    tlsClientParameters = new TLSClientParameters();
                }
                Throwable ex = null;
                try {
                    this.decorateWithTLS(tlsClientParameters, connection);
                }
                catch (Exception ioException) {
                    void e;
                    FFDCFilter.processException((Throwable)ioException, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"101", (Object)this, (Object[])new Object[]{tlsClientParameters, proxy, url});
                    ex = e;
                    return ex;
                }
                finally {
                    if (ex == null) break block10;
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    IOException ioException = new IOException("Error while initializing secure socket");
                    ioException.initCause(ex);
                    throw ioException;
                }
            }
        }
        HttpURLConnection httpURLConnection = connection;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            httpURLConnection = httpURLConnection;
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "createConnection", httpURLConnection);
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected synchronized void decorateWithTLS(TLSClientParameters tlsClientParameters, HttpURLConnection connection) throws GeneralSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS", new Object[]{tlsClientParameters, connection});
        }
        int hash = tlsClientParameters.hashCode();
        if (hash != this.lastTlsHash) {
            this.lastTlsHash = hash;
            this.socketFactory = null;
        }
        if (tlsClientParameters.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            this.socketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        } else if (tlsClientParameters.getSSLSocketFactory() != null) {
            this.socketFactory = tlsClientParameters.getSSLSocketFactory();
        } else if (this.socketFactory == null) {
            SSLContext ctx = SSLUtils.getSSLContext(tlsClientParameters);
            String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude(tlsClientParameters.getCipherSuites(), tlsClientParameters.getCipherSuitesFilter(), ctx.getSocketFactory().getDefaultCipherSuites(), org.apache.cxf.configuration.jsse.SSLUtils.getSupportedCipherSuites(ctx), LOG);
            String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : "TLS";
            this.socketFactory = new SSLSocketFactoryWrapper(ctx.getSocketFactory(), cipherSuites, protocol);
            this.lastTlsHash = tlsClientParameters.hashCode();
        }
        HostnameVerifier verifier = SSLUtils.getHostnameVerifier(tlsClientParameters);
        if (connection instanceof HttpsURLConnection) {
            final HttpsURLConnection conn = (HttpsURLConnection)connection;
            conn.setHostnameVerifier(verifier);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -7346763299087277688L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    conn.setSSLSocketFactory(HttpsURLConnectionFactory.this.socketFactory);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        } else {
            try {
                Method method = connection.getClass().getMethod("getHostnameVerifier", new Class[0]);
                ReflectionInvokationHandler handler = new ReflectionInvokationHandler(verifier){
                    static final long serialVersionUID = 4351777493615938345L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        try {
                            return super.invoke(proxy, method, args);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory$2", (String)"192", (Object)this, (Object[])new Object[]{proxy, method, args});
                            return false;
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                };
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)handler);
                method = connection.getClass().getMethod("setHostnameVerifier", method.getReturnType());
                method.invoke((Object)connection, proxy);
            }
            catch (Exception method) {
                FFDCFilter.processException((Throwable)method, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"203", (Object)this, (Object[])new Object[]{tlsClientParameters, connection});
            }
            try {
                Method getSSLSocketFactory = connection.getClass().getMethod("getSSLSocketFactory", new Class[0]);
                Method setSSLSocketFactory = connection.getClass().getMethod("setSSLSocketFactory", getSSLSocketFactory.getReturnType());
                if (getSSLSocketFactory.getReturnType().isInstance(this.socketFactory)) {
                    setSSLSocketFactory.invoke((Object)connection, this.socketFactory);
                } else {
                    Constructor<?> c = getSSLSocketFactory.getReturnType().getDeclaredConstructor(SSLSocketFactory.class);
                    ReflectionUtil.setAccessible(c);
                    setSSLSocketFactory.invoke((Object)connection, c.newInstance(this.socketFactory));
                }
            }
            catch (Exception getSSLSocketFactory) {
                void ex;
                FFDCFilter.processException((Throwable)getSSLSocketFactory, (String)"org.apache.cxf.transport.https.HttpsURLConnectionFactory", (String)"219", (Object)this, (Object[])new Object[]{tlsClientParameters, connection});
                if (connection.getClass().getName().contains("weblogic")) {
                    if (!weblogicWarned) {
                        weblogicWarned = true;
                        LOG.warning("Could not configure SSLSocketFactory on Weblogic.   Use the Weblogic control panel to configure the SSL settings.");
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
                    }
                    return;
                }
                throw new IllegalArgumentException("Error decorating connection class " + connection.getClass().getName(), (Throwable)ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "decorateWithTLS");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void addLogHandler(Handler handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler", new Object[]{handler});
        }
        LOG.addHandler(handler);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.https.HttpsURLConnectionFactory", "addLogHandler");
        }
    }
}

