/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.ProxyOutputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientRequestFilterInterceptor
extends AbstractOutDatabindingInterceptor {
    static final long serialVersionUID = 6884998896692193605L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClientRequestFilterInterceptor() {
        super("pre-logical");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleMessage(Message outMessage) throws Fault {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(outMessage);
        if (pf == null) {
            return;
        }
        ProxyOutputStream pos = new ProxyOutputStream();
        outMessage.setContent(OutputStream.class, pos);
        outMessage.setContent(ProxyOutputStream.class, pos);
        List<ProviderInfo<ClientRequestFilter>> filters = pf.getClientRequestFilters();
        if (!filters.isEmpty()) {
            Exchange exchange = outMessage.getExchange();
            ClientRequestContextImpl context = new ClientRequestContextImpl(outMessage, false);
            for (ProviderInfo<ClientRequestFilter> filter : filters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, outMessage);
                try {
                    filter.getProvider().filter((ClientRequestContext)context);
                    Response response = outMessage.getExchange().get(Response.class);
                    if (response == null) continue;
                    outMessage.getInterceptorChain().abort();
                    MessageImpl inMessage = new MessageImpl();
                    inMessage.setExchange(exchange);
                    inMessage.put(Message.RESPONSE_CODE, response.getStatus());
                    inMessage.put(Message.PROTOCOL_HEADERS, response.getMetadata());
                    exchange.setInMessage(inMessage);
                    MessageObserver observer = exchange.get(MessageObserver.class);
                    observer.onMessage(inMessage);
                    return;
                }
                catch (IOException response) {
                    void ex;
                    FFDCFilter.processException((Throwable)response, (String)"org.apache.cxf.jaxrs.client.spec.ClientRequestFilterInterceptor", (String)"87", (Object)this, (Object[])new Object[]{outMessage});
                    throw new ProcessingException((Throwable)ex);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientRequestFilterInterceptor.class);
    }
}

