/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.classloading.java2sec.PermissionManager;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.metadata.extended.NestedModuleMetaDataFactory;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DeployedAppInfoFactoryBase
implements DeployedAppInfoFactory,
DeployedAppServices {
    static final String SERVER_APPS_DIR = "${server.output.dir}/apps/";
    protected static final String EXPANDED_APPS_DIR = "${server.output.dir}/apps/expanded/";
    protected static final String XML_SUFFIX = ".xml";
    private BundleContext bundleContext;
    private ApplicationInfoFactory applicationInfoFactory;
    private FutureMonitor futureMonitor;
    private ClassLoadingService classLoadingService;
    private Library globalSharedLibrary;
    private String globalSharedLibraryPid;
    private ConfigurationAdmin configAdmin;
    private MetaDataService metaDataService;
    private StateChangeService stateChangeService;
    private final String[] allModuleTypes = new String[]{"ejb", "web", "client", "connector"};
    private final Map<String, List<ModuleMetaDataExtender>> moduleMetaDataExtenders = new ConcurrentHashMap<String, List<ModuleMetaDataExtender>>();
    private final Map<String, List<NestedModuleMetaDataFactory>> nestedModuleMetaDataFactories = new ConcurrentHashMap<String, List<NestedModuleMetaDataFactory>>();
    private PermissionManager permissionManager;
    private WsLocationAdmin locAdmin;
    private ArtifactContainerFactory artifactFactory;
    private AdaptableModuleFactory moduleFactory;
    static final long serialVersionUID = -2763244787089254448L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DeployedAppInfoFactoryBase() {
        for (String moduleType : this.allModuleTypes) {
            this.moduleMetaDataExtenders.put(moduleType, new CopyOnWriteArrayList());
            this.nestedModuleMetaDataFactories.put(moduleType, new CopyOnWriteArrayList());
        }
    }

    @Override
    public List<Library> getLibrariesFromPid(String pid) throws InvalidSyntaxException {
        ArrayList<Library> libraries = new ArrayList<Library>();
        String libraryFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)pid);
        Collection libraryRefs = this.bundleContext.getServiceReferences(Library.class, libraryFilter);
        for (ServiceReference libraryRef : libraryRefs) {
            Library library = (Library)this.bundleContext.getService(libraryRef);
            libraries.add(library);
        }
        return libraries;
    }

    @Override
    public List<ModuleMetaDataExtender> getModuleMetaDataExtenders(String moduleType) {
        List<ModuleMetaDataExtender> list = this.moduleMetaDataExtenders.get(moduleType);
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    @Override
    public List<NestedModuleMetaDataFactory> getNestedModuleMetaDataFactories(String moduleType) {
        List<NestedModuleMetaDataFactory> list = this.nestedModuleMetaDataFactories.get(moduleType);
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public ApplicationInfoFactory getApplicationInfoFactory() {
        return this.applicationInfoFactory;
    }

    @Override
    public FutureMonitor getFutureMonitor() {
        return this.futureMonitor;
    }

    @Override
    public ClassLoadingService getClassLoadingService() {
        return this.classLoadingService;
    }

    @Override
    public Library getGlobalSharedLibrary() {
        return this.globalSharedLibrary;
    }

    @Override
    public String getGlobalSharedLibraryPid() {
        return this.globalSharedLibraryPid;
    }

    @Override
    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    @Override
    public MetaDataService getMetaDataService() {
        return this.metaDataService;
    }

    @Override
    public StateChangeService getStateChangeService() {
        return this.stateChangeService;
    }

    public Map<String, List<ModuleMetaDataExtender>> getModuleMetaDataExtenders() {
        return this.moduleMetaDataExtenders;
    }

    public Map<String, List<NestedModuleMetaDataFactory>> getNestedModuleMetaDataFactories() {
        return this.nestedModuleMetaDataFactories;
    }

    @Override
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public WsLocationAdmin getLocationAdmin() {
        return this.locAdmin;
    }

    @Override
    public ArtifactContainerFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    @Override
    public AdaptableModuleFactory getModuleFactory() {
        return this.moduleFactory;
    }

    @Override
    public Container setupContainer(String pid, File locationFile) {
        if (!FileUtils.fileExists((File)locationFile)) {
            return null;
        }
        File cacheDir = new File(this.getCacheDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDir)) {
            return null;
        }
        ArtifactContainer artifactContainer = this.getArtifactFactory().getContainer(cacheDir, (Object)locationFile);
        if (artifactContainer == null) {
            return null;
        }
        File cacheDirAdapt = new File(this.getCacheAdaptDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDirAdapt)) {
            return null;
        }
        File cacheDirOverlay = new File(this.getCacheOverlayDir(), pid);
        if (!FileUtils.ensureDirExists((File)cacheDirOverlay)) {
            return null;
        }
        return this.getModuleFactory().getContainer(cacheDirAdapt, cacheDirOverlay, artifactContainer);
    }

    private File getCacheAdaptDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cacheAdapt");
    }

    private File getCacheOverlayDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cacheOverlay");
    }

    private File getCacheDir() {
        return this.getLocationAdmin().getBundleFile((Object)this, "cache");
    }

    @Reference
    protected void setApplicationInfoFactory(ApplicationInfoFactory applicationInfoFactory) {
        this.applicationInfoFactory = applicationInfoFactory;
    }

    protected void unsetApplicationInfoFactory(ApplicationInfoFactory applicationInfoFactory) {
    }

    @Reference
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
    }

    @Reference
    protected void setClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = service;
    }

    protected void unsetClassLoadingService(ClassLoadingService service) {
        this.classLoadingService = null;
    }

    @Reference(target="(id=global)")
    protected void setGlobalSharedLibrary(Library library, Map<String, ?> serviceProps) {
        this.globalSharedLibrary = library;
        this.globalSharedLibraryPid = (String)serviceProps.get("service.pid");
    }

    protected void unsetGlobalSharedLibrary(Library library) {
        this.globalSharedLibrary = null;
    }

    @Reference
    protected void setConfigAdmin(ConfigurationAdmin admin) {
        this.configAdmin = admin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin admin) {
        this.configAdmin = null;
    }

    @Reference
    protected void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    protected void unsetMetaDataService(MetaDataService metaDataService) {
    }

    @Reference
    protected void setStateChangeService(StateChangeService stateChangeService) {
        this.stateChangeService = stateChangeService;
    }

    protected void unsetStateChangeService(StateChangeService stateChangeService) {
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this._setModuleMetaDataExtender(moduleMetaDataExtender, moduleType);
            } else if (o instanceof String[]) {
                String[] moduleTypes = (String[])o;
                this._setModuleMetaDataExtender(moduleMetaDataExtender, moduleTypes);
            }
        } else {
            this._setModuleMetaDataExtender(moduleMetaDataExtender, this.allModuleTypes);
        }
    }

    private void _setModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, String ... types) {
        for (String moduleType : types) {
            List<ModuleMetaDataExtender> extenders = this.moduleMetaDataExtenders.get(moduleType);
            if (extenders == null) continue;
            extenders.add(moduleMetaDataExtender);
        }
    }

    protected void unsetModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this._unsetModuleMetaDataExtender(moduleMetaDataExtender, moduleType);
            } else if (o instanceof String[]) {
                String[] moduleTypes = (String[])o;
                this._unsetModuleMetaDataExtender(moduleMetaDataExtender, moduleTypes);
            }
        } else {
            this._unsetModuleMetaDataExtender(moduleMetaDataExtender, this.allModuleTypes);
        }
    }

    private void _unsetModuleMetaDataExtender(ModuleMetaDataExtender moduleMetaDataExtender, String ... types) {
        for (String moduleType : types) {
            List<ModuleMetaDataExtender> extenders = this.moduleMetaDataExtenders.get(moduleType);
            if (extenders == null) continue;
            extenders.remove(moduleMetaDataExtender);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setNestedModuleMetaDataFactory(NestedModuleMetaDataFactory nestedModuleMetaDataFactory, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this._setNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, moduleType);
            } else if (o instanceof String[]) {
                String[] moduleTypes = (String[])o;
                this._setNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, moduleTypes);
            }
        } else {
            this._setNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, this.allModuleTypes);
        }
    }

    private void _setNestedModuleMetaDataFactory(NestedModuleMetaDataFactory nestedModuleMetaDataFactory, String ... types) {
        for (String moduleType : types) {
            List<NestedModuleMetaDataFactory> factories = this.nestedModuleMetaDataFactories.get(moduleType);
            if (factories == null) continue;
            factories.add(nestedModuleMetaDataFactory);
        }
    }

    protected void unsetNestedModuleMetaDataFactory(NestedModuleMetaDataFactory nestedModuleMetaDataFactory, Map<String, ?> serviceProps) {
        Object o = serviceProps.get("type");
        if (o != null) {
            if (o instanceof String) {
                String moduleType = (String)o;
                this._unsetNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, moduleType);
            } else if (o instanceof String[]) {
                String[] moduleTypes = (String[])o;
                this._unsetNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, moduleTypes);
            }
        } else {
            this._unsetNestedModuleMetaDataFactory(nestedModuleMetaDataFactory, this.allModuleTypes);
        }
    }

    private void _unsetNestedModuleMetaDataFactory(NestedModuleMetaDataFactory nestedModuleMetaDataFactory, String ... types) {
        for (String moduleType : types) {
            List<NestedModuleMetaDataFactory> factories = this.nestedModuleMetaDataFactories.get(moduleType);
            if (factories == null) continue;
            factories.remove(nestedModuleMetaDataFactory);
        }
    }

    @Reference(service=PermissionManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void unsetPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = null;
    }

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locAdmin) {
        this.locAdmin = locAdmin;
    }

    protected void unsetLocationAdmin(WsLocationAdmin locAdmin) {
        this.locAdmin = null;
    }

    @Reference
    protected void setArtifactFactory(ArtifactContainerFactory factory) {
        this.artifactFactory = factory;
    }

    protected void unsetArtifactFactory(ArtifactContainerFactory factory) {
        this.artifactFactory = null;
    }

    @Reference
    protected void setModuleFactory(AdaptableModuleFactory factory) {
        this.moduleFactory = factory;
    }

    protected void unsetModuleFactory(AdaptableModuleFactory factory) {
        this.moduleFactory = null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DeployedAppInfoFactoryBase.class);
    }
}

