/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs21.clientconfig.JAXRSClientConfigHolder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientProperties;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientConfigurableImpl;
import org.apache.cxf.jaxrs.client.spec.InvocationBuilderImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.https.SSLUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientImpl
implements Client {
    private Configurable<Client> configImpl;
    private TLSConfiguration secConfig;
    private boolean closed;
    private Set<WebClient> baseClients = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    static final long serialVersionUID = 5487661181411339331L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClientImpl(Configuration config, TLSConfiguration secConfig) {
        this.configImpl = new ClientConfigurableImpl<ClientImpl>(this, config);
        this.secConfig = secConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            Set<WebClient> set = this.baseClients;
            synchronized (set) {
                for (WebClient wc : this.baseClients) {
                    wc.close();
                }
            }
            this.baseClients = null;
            this.closed = true;
        }
    }

    public Invocation.Builder invocation(Link link) {
        this.checkNull(link);
        this.checkClosed();
        Invocation.Builder builder = this.target(link.getUriBuilder()).request();
        String type = link.getType();
        if (type != null) {
            builder.accept(new String[]{type});
        }
        return builder;
    }

    public WebTarget target(UriBuilder builder) {
        this.checkNull(builder);
        this.checkClosed();
        return new WebTargetImpl(builder, this.getConfiguration());
    }

    public WebTarget target(String address) {
        WebTarget target;
        int braceIndex;
        this.checkNull(address);
        if (address.isEmpty()) {
            address = "/";
        }
        if ((braceIndex = address.indexOf(123)) < 0) {
            UriBuilder builder = UriBuilder.fromUri((String)address);
            target = this.target(builder);
        } else {
            String strippedAddress = address.substring(0, braceIndex);
            String template = address.substring(braceIndex);
            target = this.target(UriBuilder.fromUri((String)strippedAddress));
            target = target.path(template);
        }
        return target;
    }

    public WebTarget target(Link link) {
        this.checkNull(link);
        return this.target(link.getUriBuilder());
    }

    public WebTarget target(URI uri) {
        this.checkNull(uri);
        return this.target(UriBuilder.fromUri((URI)uri));
    }

    private void checkNull(Object ... target) {
        for (Object o : target) {
            if (o != null) continue;
            throw new NullPointerException("Value is null");
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        this.checkClosed();
        return this.secConfig.getTlsClientParams().getHostnameVerifier();
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext getSslContext() {
        this.checkClosed();
        if (this.secConfig.getSslContext() != null) {
            return this.secConfig.getSslContext();
        }
        if (this.secConfig.getTlsClientParams().getTrustManagers() != null) {
            try {
                return SSLUtils.getSSLContext((TLSParameterBase)this.secConfig.getTlsClientParams());
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.client.spec.ClientImpl", (String)"183", (Object)this, (Object[])new Object[0]);
                throw new ProcessingException((Throwable)ex);
            }
        }
        return null;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("client is closed");
        }
    }

    public Configuration getConfiguration() {
        this.checkClosed();
        return this.configImpl.getConfiguration();
    }

    public Client property(String name, @Sensitive Object value) {
        this.checkClosed();
        if ("com.ibm.ws.jaxrs.client.proxy.password".equals(name) && value != null && !(value instanceof ProtectedString)) {
            return (Client)this.configImpl.property(name, (Object)new ProtectedString(value.toString().toCharArray()));
        }
        return (Client)this.configImpl.property(name, value);
    }

    public Client register(Class<?> cls) {
        this.checkClosed();
        return (Client)this.configImpl.register(cls);
    }

    public Client register(Object object) {
        this.checkClosed();
        return (Client)this.configImpl.register(object);
    }

    public Client register(Class<?> cls, int index) {
        this.checkClosed();
        return (Client)this.configImpl.register(cls, index);
    }

    public Client register(Class<?> cls, Class<?> ... contracts) {
        this.checkClosed();
        return (Client)this.configImpl.register(cls, (Class[])contracts);
    }

    public Client register(Class<?> cls, Map<Class<?>, Integer> map) {
        this.checkClosed();
        return (Client)this.configImpl.register(cls, map);
    }

    public Client register(Object object, int index) {
        this.checkClosed();
        return (Client)this.configImpl.register(object, index);
    }

    public Client register(Object object, Class<?> ... contracts) {
        this.checkClosed();
        return (Client)this.configImpl.register(object, (Class[])contracts);
    }

    public Client register(Object object, Map<Class<?>, Integer> map) {
        this.checkClosed();
        return (Client)this.configImpl.register(object, map);
    }

    private static Long getLongValue(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof String ? Long.valueOf(o.toString()) : (o instanceof Integer ? Long.valueOf(((Integer)o).longValue()) : null));
    }

    private static Integer getIntValue(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof String ? Integer.valueOf(o.toString()) : null);
    }

    private static Boolean getBooleanValue(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof String ? Boolean.valueOf(o.toString()) : null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public class WebTargetImpl
    implements WebTarget {
        private Configurable<WebTarget> configImpl;
        private UriBuilder uriBuilder;
        private WebClient targetClient;
        static final long serialVersionUID = -1364710636595362665L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebTargetImpl(UriBuilder uriBuilder, Configuration config) {
            this(uriBuilder, config, null);
        }

        @FFDCIgnore(value={IllegalArgumentException.class})
        public WebTargetImpl(UriBuilder uriBuilder, Configuration config, WebClient targetClient) {
            this.configImpl = new ClientConfigurableImpl<WebTargetImpl>(this, config);
            this.uriBuilder = uriBuilder.clone();
            this.targetClient = targetClient;
            try {
                Map<String, String> propertiesFromServerXml = JAXRSClientConfigHolder.getURIProps(uriBuilder);
                this.applyProperties(propertiesFromServerXml, this.configImpl);
            }
            catch (IllegalArgumentException iaex2) {
                Object iaex2 = null;
            }
        }

        private void applyProperties(Map<String, String> props, Configurable<WebTarget> config) {
            if (props == null || props.size() == 0) {
                return;
            }
            for (String key : props.keySet()) {
                config.property(key, (Object)props.get(key));
            }
        }

        public WebClient getWebClient() {
            return this.targetClient;
        }

        public Invocation.Builder request() {
            Object executorServiceProp;
            TLSClientParameters tlsParams;
            ClientImpl.this.checkClosed();
            Map configProps = this.getConfiguration().getProperties();
            this.initTargetClientIfNeeded(configProps);
            ClientProviderFactory pf = ClientProviderFactory.getInstance(WebClient.getConfig(this.targetClient).getEndpoint());
            LinkedList providers = new LinkedList();
            LinkedList<Feature> cxfFeatures = new LinkedList<Feature>();
            Configuration cfg = this.configImpl.getConfiguration();
            for (Object p : cfg.getInstances()) {
                if (p instanceof Feature) {
                    cxfFeatures.add((Feature)p);
                    continue;
                }
                if (p instanceof javax.ws.rs.core.Feature) continue;
                Map contracts = cfg.getContracts(p.getClass());
                if (contracts == null || contracts.isEmpty()) {
                    providers.add(p);
                    continue;
                }
                Class providerCls = ClassHelper.getRealClass((Bus)pf.getBus(), p);
                providers.add(new FilterProviderInfo(p.getClass(), providerCls, p, pf.getBus(), contracts));
            }
            pf.setUserProviders(providers);
            ClientConfiguration clientCfg = WebClient.getConfig(this.targetClient);
            clientCfg.getRequestContext().putAll(configProps);
            clientCfg.getRequestContext().put(Client.class.getName(), ClientImpl.this);
            clientCfg.getRequestContext().put(Configuration.class.getName(), this.getConfiguration());
            Boolean responseAutoClose = ClientImpl.getBooleanValue(configProps.get("http.response.stream.auto.close"));
            if (responseAutoClose != null) {
                clientCfg.getResponseContext().put("response.stream.auto.close", responseAutoClose);
            }
            if ((tlsParams = ClientImpl.this.secConfig.getTlsClientParams()).getSSLSocketFactory() != null || tlsParams.getTrustManagers() != null || tlsParams.getHostnameVerifier() != null) {
                clientCfg.getHttpConduit().setTlsClientParameters(tlsParams);
            }
            if ((executorServiceProp = configProps.get("executorService")) != null) {
                clientCfg.getResponseContext().put("executorService", executorServiceProp);
            }
            this.setConnectionProperties(configProps, clientCfg);
            for (Feature cxfFeature : cxfFeatures) {
                cxfFeature.initialize((InterceptorProvider)clientCfg, clientCfg.getBus());
            }
            return new InvocationBuilderImpl(WebClient.fromClient(this.targetClient), this.getConfiguration());
        }

        private void setConnectionProperties(Map<String, Object> configProps, ClientConfiguration clientCfg) {
            Boolean mantainSessionValue;
            Boolean autoRedirectValue;
            Integer proxyServerPortValue;
            Object proxyServerValue;
            Long recTimeOutValue;
            Long connTimeOutValue = ClientImpl.getLongValue(configProps.get("http.connection.timeout"));
            if (connTimeOutValue != null) {
                clientCfg.getHttpConduit().getClient().setConnectionTimeout(connTimeOutValue.longValue());
            }
            if ((recTimeOutValue = ClientImpl.getLongValue(configProps.get("http.receive.timeout"))) != null) {
                clientCfg.getHttpConduit().getClient().setReceiveTimeout(recTimeOutValue.longValue());
            }
            if ((proxyServerValue = configProps.get("http.proxy.server.uri")) != null) {
                clientCfg.getHttpConduit().getClient().setProxyServer((String)proxyServerValue);
            }
            if ((proxyServerPortValue = ClientImpl.getIntValue(configProps.get("http.proxy.server.port"))) != null) {
                clientCfg.getHttpConduit().getClient().setProxyServerPort(proxyServerPortValue);
            }
            if ((autoRedirectValue = ClientImpl.getBooleanValue(configProps.get("http.autoredirect"))) != null) {
                clientCfg.getHttpConduit().getClient().setAutoRedirect(autoRedirectValue.booleanValue());
            }
            if ((mantainSessionValue = ClientImpl.getBooleanValue(configProps.get("http.maintain.session"))) != null) {
                clientCfg.getRequestContext().put(Message.MAINTAIN_SESSION, mantainSessionValue);
            }
        }

        private void initTargetClientIfNeeded(Map<String, Object> configProps) {
            URI uri = this.uriBuilder.build(new Object[0]);
            if (this.targetClient == null) {
                JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
                bean.setAddress(uri.toString());
                Boolean threadSafe = ClientImpl.getBooleanValue(configProps.get("thread.safe.client"));
                if (threadSafe == null) {
                    threadSafe = ClientProperties.DEFAULT_THREAD_SAFETY_CLIENT_STATUS;
                }
                bean.setThreadSafe(threadSafe);
                if (threadSafe.booleanValue()) {
                    Integer cleanupPeriod = ClientImpl.getIntValue(configProps.get("thread.safe.client.state.cleanup.period"));
                    if (cleanupPeriod == null) {
                        cleanupPeriod = ClientProperties.THREAD_SAFE_CLIENT_STATE_CLEANUP_PERIOD;
                    }
                    if (cleanupPeriod != null) {
                        bean.setSecondsToKeepState(cleanupPeriod.intValue());
                    }
                }
                this.targetClient = bean.createWebClient();
                ClientImpl.this.baseClients.add(this.targetClient);
            } else if (!this.targetClient.getCurrentURI().equals(uri)) {
                this.targetClient.to(uri.toString(), false);
            }
        }

        public Invocation.Builder request(String ... accept) {
            return this.request().accept(accept);
        }

        public Invocation.Builder request(MediaType ... accept) {
            return this.request().accept(accept);
        }

        public URI getUri() {
            ClientImpl.this.checkClosed();
            return this.uriBuilder.build(new Object[0]);
        }

        public UriBuilder getUriBuilder() {
            ClientImpl.this.checkClosed();
            return this.uriBuilder.clone();
        }

        public WebTarget path(String path) {
            ClientImpl.this.checkClosed();
            ClientImpl.this.checkNull(new Object[]{path});
            return this.newWebTarget(this.getUriBuilder().path(path));
        }

        public WebTarget queryParam(String name, Object ... values) {
            ClientImpl.this.checkClosed();
            this.checkNullValues(name, values);
            UriBuilder thebuilder = this.getUriBuilder();
            if (values == null || values.length == 1 && values[0] == null) {
                thebuilder.replaceQueryParam(name, (Object[])null);
            } else {
                thebuilder.queryParam(name, values);
            }
            return this.newWebTarget(thebuilder);
        }

        public WebTarget matrixParam(String name, Object ... values) {
            ClientImpl.this.checkClosed();
            this.checkNullValues(name, values);
            UriBuilder thebuilder = this.getUriBuilder();
            if (values == null || values.length == 1 && values[0] == null) {
                thebuilder.replaceMatrixParam(name, (Object[])null);
            } else {
                thebuilder.matrixParam(name, values);
            }
            return this.newWebTarget(thebuilder);
        }

        public WebTarget resolveTemplate(String name, Object value) {
            return this.resolveTemplate(name, value, true);
        }

        public WebTarget resolveTemplate(String name, Object value, boolean encodeSlash) {
            ClientImpl.this.checkClosed();
            ClientImpl.this.checkNull(new Object[]{name, value});
            return this.newWebTarget(this.getUriBuilder().resolveTemplate(name, value, encodeSlash));
        }

        public WebTarget resolveTemplateFromEncoded(String name, Object value) {
            ClientImpl.this.checkNull(new Object[]{name, value});
            return this.newWebTarget(this.getUriBuilder().resolveTemplateFromEncoded(name, value));
        }

        public WebTarget resolveTemplates(Map<String, Object> templatesMap) {
            return this.resolveTemplates(templatesMap, true);
        }

        public WebTarget resolveTemplates(Map<String, Object> templatesMap, boolean encodeSlash) {
            ClientImpl.this.checkClosed();
            this.checkNullMap(templatesMap);
            if (templatesMap.isEmpty()) {
                return this;
            }
            return this.newWebTarget(this.getUriBuilder().resolveTemplates(templatesMap, encodeSlash));
        }

        public WebTarget resolveTemplatesFromEncoded(Map<String, Object> templatesMap) {
            ClientImpl.this.checkClosed();
            this.checkNullMap(templatesMap);
            if (templatesMap.isEmpty()) {
                return this;
            }
            return this.newWebTarget(this.getUriBuilder().resolveTemplatesFromEncoded(templatesMap));
        }

        private WebTarget newWebTarget(UriBuilder newBuilder) {
            WebClient newClient = this.targetClient != null ? WebClient.fromClient(this.targetClient) : null;
            return new WebTargetImpl(newBuilder, this.getConfiguration(), newClient);
        }

        public Configuration getConfiguration() {
            ClientImpl.this.checkClosed();
            return this.configImpl.getConfiguration();
        }

        public WebTarget property(String name, @Sensitive Object value) {
            ClientImpl.this.checkClosed();
            if ("com.ibm.ws.jaxrs.client.proxy.password".equals(name) && value != null && !(value instanceof ProtectedString)) {
                return (WebTarget)this.configImpl.property(name, (Object)new ProtectedString(value.toString().toCharArray()));
            }
            return (WebTarget)this.configImpl.property(name, value);
        }

        public WebTarget register(Class<?> cls) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(cls);
        }

        public WebTarget register(Object object) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(object);
        }

        public WebTarget register(Class<?> cls, int index) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(cls, index);
        }

        public WebTarget register(Class<?> cls, Class<?> ... contracts) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(cls, (Class[])contracts);
        }

        public WebTarget register(Class<?> cls, Map<Class<?>, Integer> map) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(cls, map);
        }

        public WebTarget register(Object object, int index) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(object, index);
        }

        public WebTarget register(Object object, Class<?> ... contracts) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(object, (Class[])contracts);
        }

        public WebTarget register(Object object, Map<Class<?>, Integer> map) {
            ClientImpl.this.checkClosed();
            return (WebTarget)this.configImpl.register(object, map);
        }

        private void checkNullValues(Object name, Object ... values) {
            ClientImpl.this.checkNull(new Object[]{name});
            if (values != null && values.length > 1) {
                ClientImpl.this.checkNull(values);
            }
        }

        private void checkNullMap(Map<String, Object> templatesMap) {
            ClientImpl.this.checkNull(new Object[]{templatesMap});
            ClientImpl.this.checkNull(templatesMap.keySet().toArray());
            ClientImpl.this.checkNull(templatesMap.values().toArray());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WebTargetImpl.class);
        }
    }
}

