/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArraySet;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ClientProviderFactory
extends ProviderFactory {
    private final ProviderFactory.AtomicReferenceProviderList<ClientRequestFilter> clientRequestFilters = new ProviderFactory.AtomicReferenceProviderList((ProviderFactory)this);
    private final ProviderFactory.AtomicReferenceProviderList<ClientResponseFilter> clientResponseFilters = new ProviderFactory.AtomicReferenceProviderList((ProviderFactory)this);
    private final ProviderFactory.AtomicReferenceProviderList<ResponseExceptionMapper<?>> responseExceptionMappers = new ProviderFactory.AtomicReferenceProviderList((ProviderFactory)this);
    private RxInvokerProvider<?> rxInvokerProvider;
    static final long serialVersionUID = 4412132848095720967L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ClientProviderFactory(Bus bus) {
        super(bus);
    }

    public static ClientProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ClientProviderFactory factory = new ClientProviderFactory(bus);
        ProviderFactory.initFactory((ProviderFactory)factory);
        factory.setBusProviders();
        return factory;
    }

    public static ClientProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return (ClientProviderFactory)((Object)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory"));
    }

    public static ClientProviderFactory getInstance(Endpoint e) {
        return (ClientProviderFactory)((Object)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory"));
    }

    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        ArrayList newClientRequestFilters = new ArrayList();
        ArrayList newClientResponseFilters = new ArrayList();
        ArrayList newResponseExceptionMappers = new ArrayList();
        for (ProviderInfo provider : theProviders) {
            Class<?> providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider());
            if (providerCls == Object.class) {
                providerCls = provider.getProvider().getClass();
            }
            if (ClientProviderFactory.filterContractSupported((ProviderInfo)provider, providerCls, ClientRequestFilter.class)) {
                this.addProviderToList(newClientRequestFilters, provider);
            }
            if (ClientProviderFactory.filterContractSupported((ProviderInfo)provider, providerCls, ClientResponseFilter.class)) {
                this.addProviderToList(newClientResponseFilters, provider);
            }
            if (ResponseExceptionMapper.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(newResponseExceptionMappers, provider);
            }
            if (!RxInvokerProvider.class.isAssignableFrom(providerCls)) continue;
            this.rxInvokerProvider = (RxInvokerProvider)RxInvokerProvider.class.cast(provider.getProvider());
        }
        if (newClientRequestFilters.size() > 0) {
            this.clientRequestFilters.addAndSortProviders(newClientRequestFilters, (Comparator)new ProviderFactory.BindingPriorityComparator(ClientRequestFilter.class, true), false);
        }
        if (newClientResponseFilters.size() > 0) {
            this.clientResponseFilters.addAndSortProviders(newClientResponseFilters, (Comparator)new ProviderFactory.BindingPriorityComparator(ClientResponseFilter.class, false), false);
        }
        if (newResponseExceptionMappers.size() > 0) {
            this.responseExceptionMappers.addProviders(newResponseExceptionMappers);
        }
        this.injectContextProxies(new Collection[]{this.responseExceptionMappers.get(), this.clientRequestFilters.get(), this.clientResponseFilters.get()});
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Message m, Class<?> paramType) {
        return this.responseExceptionMappers.get().stream().filter(em -> this.handleMapper((ProviderInfo)em, paramType, m, ResponseExceptionMapper.class, true)).map(ProviderInfo::getProvider).sorted((Comparator<ResponseExceptionMapper>)new ProviderFactory.ClassComparator(paramType)).findFirst().orElse(null);
    }

    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.clientRequestFilters.clear();
        this.clientResponseFilters.clear();
    }

    public List<ProviderInfo<ClientRequestFilter>> getClientRequestFilters() {
        return Collections.unmodifiableList(this.clientRequestFilters.get());
    }

    public List<ProviderInfo<ClientResponseFilter>> getClientResponseFilters() {
        return Collections.unmodifiableList(this.clientResponseFilters.get());
    }

    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    public void clearThreadLocalProxies() {
        ThreadLocalProxyCopyOnWriteArraySet proxySet = (ThreadLocalProxyCopyOnWriteArraySet)this.getBus().getProperty("proxy-set");
        if (proxySet != null) {
            Object[] proxies;
            for (Object proxy : proxies = proxySet.toArray()) {
                ((ThreadLocalProxy)proxy).remove();
            }
        }
    }

    public RxInvokerProvider<?> getRxInvokerProvider() {
        return this.rxInvokerProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientProviderFactory.class);
    }
}

