/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.extensions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.intfc.SubjectManagerService;
import com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextHelper;
import com.ibm.ws.security.mp.jwt.proxy.MpJwtHelper;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityContextImpl
implements SecurityContext {
    private static final TraceComponent tc = Tr.register(SecurityContextImpl.class);
    private final SubjectManager subjectManager = null;
    static final long serialVersionUID = 4163187217859485298L;

    /*
     * WARNING - void declaration
     */
    public AuthenticationStatus authenticate(HttpServletRequest req, HttpServletResponse res, AuthenticationParameters params) {
        AuthenticationStatus authStatus = AuthenticationStatus.SEND_FAILURE;
        req.setAttribute("com.ibm.ws.security.javaeesec.auth.params", (Object)params);
        try {
            boolean result = req.authenticate(res);
            if (result) {
                authStatus = AuthenticationStatus.SUCCESS;
            }
        }
        catch (Exception result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextImpl", (String)"68", (Object)this, (Object[])new Object[]{req, res, params});
            e.printStackTrace();
        }
        return authStatus;
    }

    /*
     * WARNING - void declaration
     */
    public Principal getCallerPrincipal() {
        String securityName = null;
        Principal principal2 = null;
        Subject callerSubject = this.getCallerSubject();
        if (callerSubject == null) {
            return null;
        }
        SubjectHelper subjectHelper = new SubjectHelper();
        if (subjectHelper.isUnauthenticated(callerSubject)) {
            return null;
        }
        Principal jsonWebToken = MpJwtHelper.getJsonWebTokenPricipal((Subject)callerSubject);
        if (jsonWebToken != null) {
            return jsonWebToken;
        }
        WSCredential wscredential = this.getWSCredential(callerSubject);
        if (wscredential != null) {
            Set<Principal> principals;
            block15: {
                block14: {
                    try {
                        principal2 = (Principal)wscredential.get("com.ibm.wsspi.security.cred.jaspi.principal");
                        if (principal2 != null) {
                            return principal2;
                        }
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextImpl", (String)"117", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"Internal error getting JASPIC Principal from credential", (Object[])new Object[]{e});
                    }
                }
                try {
                    securityName = wscredential.getSecurityName();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.javaeesec.cdi.extensions.SecurityContextImpl", (String)"126", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)"Error getting securityName from WSCredential", (Object[])new Object[]{e});
                }
            }
            WSPrincipal wsPrincipal = null;
            if (securityName != null) {
                principals = callerSubject.getPrincipals(WSPrincipal.class);
                if (!principals.isEmpty()) {
                    wsPrincipal = (WSPrincipal)principals.iterator().next();
                    wsPrincipal = new WSPrincipal(securityName, wsPrincipal.getAccessId(), wsPrincipal.getAuthenticationMethod());
                }
                if (wsPrincipal != null) {
                    return wsPrincipal;
                }
            }
            if ((principals = callerSubject.getPrincipals()).size() > 0) {
                for (Principal principal2 : principals) {
                    if (!(principal2 instanceof WSPrincipal)) continue;
                    return principal2;
                }
            }
            return principals.iterator().next();
        }
        return null;
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> type) {
        Subject callerSubject = this.getCallerSubject();
        if (callerSubject != null) {
            Set<T> principals = callerSubject.getPrincipals(type);
            return principals;
        }
        return null;
    }

    public boolean hasAccessToWebResource(String resource, String ... methods) {
        String appName = this.getApplicationName();
        SecurityMetadata securityMetadata = WebConfigUtils.getSecurityMetadata();
        SecurityConstraintCollection collection = null;
        if (securityMetadata != null) {
            collection = securityMetadata.getSecurityConstraintCollection();
        }
        if (null != collection) {
            AuthorizationService authService = SecurityContextHelper.getAuthorizationService();
            Subject callerSubject = this.getCallerSubject();
            List matchResponses = collection.getMatchResponses(resource, methods);
            for (MatchResponse response : matchResponses) {
                if (response.equals(MatchResponse.NO_MATCH_RESPONSE)) {
                    return true;
                }
                if (response.isAccessPrecluded()) continue;
                List roles = response.getRoles();
                if (roles != null && !roles.isEmpty()) {
                    if (!authService.isAuthorized(appName, (Collection)roles, callerSubject)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCallerInRole(String role) {
        Subject callerSubject = this.getCallerSubject();
        AuthorizationService authService = SecurityContextHelper.getAuthorizationService();
        if (authService != null) {
            String appName = this.getApplicationName();
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(role);
            return authService.isAuthorized(appName, roles, callerSubject);
        }
        return false;
    }

    private Subject getCallerSubject() {
        SubjectManagerService subjectManagerService = SecurityContextHelper.getSubjectManagerService();
        if (subjectManagerService != null) {
            Subject callerSubject = null;
            callerSubject = subjectManagerService.getCallerSubject();
            return callerSubject;
        }
        return null;
    }

    private String getApplicationName() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        return cmd.getJ2EEName().getApplication();
    }
}

