/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLNonTransactionalDataSource;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class SQLMultiScopeRecoveryLog
implements LogCursorCallback,
MultiScopeLog {
    private static final TraceComponent tc = Tr.register(SQLMultiScopeRecoveryLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final RecoveryAgent _recoveryAgent;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private final String _logIdentifierString;
    private final String _serverName;
    private final Properties _internalLogProperties;
    private URL[] _urls;
    private String _dbURL;
    private volatile boolean _isOracle = false;
    private volatile boolean _isDB2 = false;
    private boolean isolationFailureReported = false;
    private HashMap<Long, RecoverableUnit> _recoverableUnits;
    private int _closesRequired;
    private final CustomLogProperties _customLogProperties;
    private boolean _failed;
    private boolean _incompatible;
    private RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    private final String _traceId;
    private final boolean _bypassContainmentCheck;
    private final String _recoveryTableName = "WAS_";
    private final String _recoveryIndexName = "IXWS";
    private String _recoveryTableNameSuffix = "";
    FailureScope _failureScope;
    private final String db2TablePreString = "CREATE TABLE ";
    private final String db2TablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA LONG VARCHAR FOR BIT DATA) ";
    private final String oracleTablePreString = "CREATE TABLE ";
    private final String oracleTablePostString = "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID NUMBER(19), RUSECTION_ID NUMBER(19), RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
    private final String indexPreString = "CREATE INDEX ";
    private final String indexPostString = "( \"RU_ID\" ASC, \"SERVICE_ID\" ASC, \"SERVER_NAME\" ASC) ";
    private DataSource _theDS = null;
    private Connection _reservedConn = null;
    private int _inserts;
    private int _updates;
    private int _removes;
    private static final Object _CreateTableLock = new Object();
    private List<ruForReplay> _cachedInserts = new ArrayList<ruForReplay>();
    private List<ruForReplay> _cachedUpdates = new ArrayList<ruForReplay>();
    private List<ruForReplay> _cachedRemoves = new ArrayList<ruForReplay>();
    private final int[] _db2TransientErrorCodes = new int[]{-1015, -1034, -1035, -6036, -30081, -30108, -1224, -1229, -518, -514, -30080, -924, -923, -906, -4498, -4499, -1776};
    private final int[] _oracleTransientErrorCodes = new int[]{20, 28, 1012, 1014, 1033, 1034, 1035, 1089, 1090, 1092, 3113, 3114, 12505, 12514, 12541, 12560, 12571, 17002, 17008, 17009, 17410, 17401, 17430, 25408, 24794, 17447, 30006};
    private int[] _sqlTransientErrorCodes;
    private final int DEFAULT_TRANSIENT_RETRY_SLEEP_TIME = 10000;
    private final int _transientRetrySleepTime;
    private final int DEFAULT_TRANSIENT_RETRY_ATTEMPTS = 180;
    private final int _transientRetryAttempts;
    private boolean sqlTransientErrorHandlingEnabled = false;
    private static boolean _serverStopping;
    private Throwable _nonTransientExceptionAtOpen = null;
    private Throwable _nonTransientExceptionAtRuntime = null;
    volatile MultiScopeLog _associatedLog = null;
    volatile boolean _failAssociatedLog = false;
    private final String _currentProcessServerName;

    public SQLMultiScopeRecoveryLog(CustomLogProperties logProperties, RecoveryAgent recoveryAgent, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object)new Object[]{logProperties, recoveryAgent, fs, this});
        }
        this._customLogProperties = logProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._customLogProperties.logName();
        this._logIdentifier = this._customLogProperties.logIdentifier();
        this._logIdentifierString = this.logTypeFromInteger(this._logIdentifier);
        this._clientName = recoveryAgent.clientName();
        this._clientVersion = recoveryAgent.clientVersion();
        this._serverName = fs.serverName();
        this._failureScope = fs;
        this._internalLogProperties = this._customLogProperties.properties();
        this._urls = null;
        this._dbURL = null;
        this._currentProcessServerName = Configuration.fqServerName();
        this._transientRetryAttempts = this.getTransientSQLErrorRetryAttempts();
        this._transientRetrySleepTime = this.getTransientSQLErrorRetrySleepTime();
        this._inserts = 0;
        this._updates = 0;
        this._removes = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to server " + this._serverName));
            Tr.debug((TraceComponent)tc, (String)("Recovery log created by client service " + this._clientName + " at version " + this._clientVersion));
            Tr.debug((TraceComponent)tc, (String)("Recovery log name is " + this._logName));
            Tr.debug((TraceComponent)tc, (String)("Recovery log identifier is " + this._logIdentifier));
            Tr.debug((TraceComponent)tc, (String)("Recovery log internal properties are " + this._internalLogProperties));
            Tr.debug((TraceComponent)tc, (String)"FIS 114950");
        }
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Use SQL RecoveryLog for " + this._logName + " on server " + this._serverName));
        this._cachedInserts = new ArrayList<ruForReplay>();
        this._cachedUpdates = new ArrayList<ruForReplay>();
        this._cachedRemoves = new ArrayList<ruForReplay>();
        this._traceId = "SQLMultiScopeRecoveryLog:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        boolean bl = this._bypassContainmentCheck = !Configuration.HAEnabled() && !Configuration.isZOS();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_bypassContainmentCheck = " + this._bypassContainmentCheck));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLMultiScopeRecoveryLog", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        block87: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"openLog", (Object)this);
            }
            if (this.incompatible()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogIncompatibleException");
                }
                throw new LogIncompatibleException();
            }
            if (this.failed()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(null);
            }
            if (_serverStopping) {
                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot open SQL RecoveryLog " + this._logName + " for server " + this._serverName + " as the server is stopping"));
                InternalLogException ile = new InternalLogException("Cannot open the log as the server is stopping", null);
                this.markFailed(ile);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw ile;
            }
            Connection conn = null;
            if (this._closesRequired != 0) break block87;
            this._recoverableUnits = new HashMap();
            try {
                block78: {
                    String fullLogDirectory = this._internalLogProperties.getProperty("LOG_DIRECTORY");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
                    }
                    if ((conn = !fullLogDirectory.contains("datasource") ? this.getConnFromTranLogDirString(fullLogDirectory) : this.getConnection(fullLogDirectory)) == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"Null connection InternalLogException");
                        }
                        throw new InternalLogException("Failed to get JDBC Connection", null);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection");
                    }
                    conn.setAutoCommit(false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"create a statement");
                    }
                    Statement lockingStmt = conn.createStatement();
                    boolean newTable = true;
                    ResultSet lockingRS = null;
                    boolean handleFailover = false;
                    Object object = _CreateTableLock;
                    synchronized (object) {
                        int queryRetries = 0;
                        boolean tableCreated = false;
                        Exception excToCheck = null;
                        while (queryRetries < 3) {
                            try {
                                if (handleFailover) {
                                    conn = this._theDS.getConnection();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Acquired connection in Database retry scenario");
                                    }
                                    conn.setAutoCommit(false);
                                    lockingStmt = conn.createStatement();
                                }
                                String queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE - " + queryString));
                                }
                                lockingRS = lockingStmt.executeQuery(queryString);
                                newTable = false;
                                break;
                            }
                            catch (Exception e) {
                                block77: {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e));
                                    }
                                    excToCheck = e;
                                    try {
                                        this.createDBTable(conn);
                                        conn.commit();
                                        tableCreated = true;
                                    }
                                    catch (Exception ine) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Table Creation failed with exception: " + ine));
                                        }
                                        excToCheck = ine;
                                    }
                                    if (tableCreated) {
                                        if (!tc.isDebugEnabled()) break;
                                        Tr.debug((TraceComponent)tc, (String)"Table Creation succeeded");
                                        break;
                                    }
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block77;
                                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, after table creation failure, got exception: " + exc));
                                    }
                                }
                                ++queryRetries;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Table Creation failed, query retries: " + queryRetries));
                                }
                                if (queryRetries >= 2) {
                                    boolean allowHARetry = false;
                                    if (!handleFailover) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Have we encounted a DB HA FAilover?");
                                        }
                                        if (excToCheck instanceof SQLException) {
                                            SQLException sqlex = (SQLException)excToCheck;
                                            if (this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex)) {
                                                allowHARetry = true;
                                                queryRetries = 0;
                                                handleFailover = true;
                                            }
                                        }
                                    }
                                    if (allowHARetry) continue;
                                    FFDCFilter.processException((Throwable)excToCheck, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"48", (Object)this);
                                    throw excToCheck;
                                }
                                Thread.sleep(1000L);
                            }
                        }
                    }
                    if (!newTable) {
                        SQLException currentSqlEx;
                        boolean secondPhaseSuccess;
                        block81: {
                            block80: {
                                block79: {
                                    secondPhaseSuccess = false;
                                    currentSqlEx = null;
                                    this.updateHADBLock(conn, lockingStmt, lockingRS);
                                    this.recover(conn);
                                    conn.commit();
                                    secondPhaseSuccess = true;
                                    if (conn == null) break block78;
                                    if (!secondPhaseSuccess) break block79;
                                    conn.close();
                                    break block78;
                                }
                                try {
                                    conn.rollback();
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) break block80;
                                    Tr.debug((TraceComponent)tc, (String)("Rollback Failed, in second phase open log, got exception: " + exc));
                                }
                            }
                            try {
                                conn.close();
                            }
                            catch (Throwable exc) {
                                if (!tc.isDebugEnabled()) break block81;
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, in second phase open log, got exception: " + exc));
                            }
                        }
                        boolean failAndReport = this.handleOpenLogSQLException(currentSqlEx);
                        if (failAndReport) {
                            Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtOpen));
                            this.markFailed(this._nonTransientExceptionAtOpen);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(this._nonTransientExceptionAtOpen);
                        }
                        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        break block78;
                        catch (SQLException sqlex) {
                            block84: {
                                block83: {
                                    block82: {
                                        try {
                                            Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex));
                                            currentSqlEx = sqlex;
                                            if (conn == null) break block78;
                                            if (!secondPhaseSuccess) break block82;
                                        }
                                        catch (Throwable throwable) {
                                            if (conn != null) {
                                                if (secondPhaseSuccess) {
                                                    conn.close();
                                                } else {
                                                    block86: {
                                                        block85: {
                                                            try {
                                                                conn.rollback();
                                                            }
                                                            catch (Throwable exc) {
                                                                if (!tc.isDebugEnabled()) break block85;
                                                                Tr.debug((TraceComponent)tc, (String)("Rollback Failed, in second phase open log, got exception: " + exc));
                                                            }
                                                        }
                                                        try {
                                                            conn.close();
                                                        }
                                                        catch (Throwable exc) {
                                                            if (!tc.isDebugEnabled()) break block86;
                                                            Tr.debug((TraceComponent)tc, (String)("Close Failed, in second phase open log, got exception: " + exc));
                                                        }
                                                    }
                                                    boolean failAndReport2 = this.handleOpenLogSQLException(currentSqlEx);
                                                    if (failAndReport2) {
                                                        Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtOpen));
                                                        this.markFailed(this._nonTransientExceptionAtOpen);
                                                        if (tc.isEntryEnabled()) {
                                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                                        }
                                                        throw new InternalLogException(this._nonTransientExceptionAtOpen);
                                                    }
                                                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                                                }
                                            }
                                            throw throwable;
                                        }
                                        conn.close();
                                    }
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block83;
                                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, in second phase open log, got exception: " + exc));
                                    }
                                }
                                try {
                                    conn.close();
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) break block84;
                                    Tr.debug((TraceComponent)tc, (String)("Close Failed, in second phase open log, got exception: " + exc));
                                }
                            }
                            failAndReport = this.handleOpenLogSQLException(currentSqlEx);
                            if (failAndReport) {
                                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtOpen));
                                this.markFailed(this._nonTransientExceptionAtOpen);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                }
                                throw new InternalLogException(this._nonTransientExceptionAtOpen);
                            }
                            Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when opening SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        }
                    }
                }
                if (conn != null) {
                    if (conn.isClosed()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Connection is already closed");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Closing DB Connection");
                        }
                        if (this._reservedConn == null) {
                            conn.close();
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Connection was NULL");
                }
            }
            catch (SQLException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"464", (Object)this);
                this.markFailed(exc);
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object)exc);
                }
                this.markFailed(exc);
                this._recoverableUnits = null;
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(" " + ste));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
        }
        ++this._closesRequired;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    public Connection getConnFromTranLogDirString(String fullLogDirectory) throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnFromTranLogDirString", (Object)new Object[]{fullLogDirectory, this});
        }
        Connection conn = null;
        try {
            ClassLoader sqlDriverClassLoader;
            Class<?> cls;
            Properties dbProps;
            block11: {
                dbProps = new Properties();
                this.parseLogDirectoryString(fullLogDirectory, dbProps);
                cls = null;
                sqlDriverClassLoader = null;
                try {
                    sqlDriverClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            URLClassLoader cl = new URLClassLoader(SQLMultiScopeRecoveryLog.this._urls);
                            return cl;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Tr.error((TraceComponent)tc, (String)e.getMessage());
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
            }
            cls = this._isOracle ? sqlDriverClassLoader.loadClass("oracle.jdbc.OracleDriver") : sqlDriverClassLoader.loadClass("com.ibm.db2.jcc.DB2Driver");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("instantiate jdbc driver class = " + cls));
            }
            Driver d = (Driver)cls.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" **** Does this driver accept my URL? " + d.acceptsURL(this._dbURL)));
            }
            DriverManager.registerDriver(d);
            conn = d.connect(this._dbURL, dbProps);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object)exc);
            }
            this.markFailed(exc);
            this._recoverableUnits = null;
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnFromTranLogDirString", (Object)conn);
        }
        return conn;
    }

    public void parseLogDirectoryString(String fullLogDirectory, Properties dbProps) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseLogDirectoryString", (Object)new Object[]{fullLogDirectory, this});
        }
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname));
        }
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString));
        }
        if (dbPropertiesString.contains("oracle")) {
            this._isOracle = true;
            this._sqlTransientErrorCodes = this._oracleTransientErrorCodes;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configure a connection to an ORACLE database");
            }
        } else if (dbPropertiesString.contains("DB2")) {
            this._isDB2 = true;
            this._sqlTransientErrorCodes = this._db2TransientErrorCodes;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Configure a connection to a DB2 database");
            }
            this.sqlTransientErrorHandlingEnabled = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"This is neither Oracle nor DB2");
        }
        dbProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbProps = " + dbProps));
        }
        this._dbURL = dbProps.getProperty("url");
        dbProps.remove("url");
        String dbDir = dbProps.getProperty("dbdir");
        dbProps.remove("dbdir");
        String file3String = dbDir + "\\";
        String file1String = "";
        String file2String = "";
        if (this._isOracle) {
            file1String = file3String + "ojdbc6.jar";
        } else {
            file1String = file3String + "db2jcc.jar";
            file2String = file3String + "db2jcc_license_cu.jar";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DB URL: " + this._dbURL));
            Tr.debug((TraceComponent)tc, (String)("DB props: " + dbProps));
            Tr.debug((TraceComponent)tc, (String)("DB file1String: " + file1String));
            Tr.debug((TraceComponent)tc, (String)("DB file2String: " + file2String));
            Tr.debug((TraceComponent)tc, (String)("DB file3String: " + file3String));
        }
        File file1 = new File(file1String);
        File file2 = new File(file2String);
        File file3 = new File(file3String);
        URL url1 = file1.toURL();
        URL url2 = file2.toURL();
        URL url3 = file3.toURL();
        this._urls = this._isOracle ? new URL[]{url1} : new URL[]{url1, url2, url3};
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseLogDirectoryString");
        }
    }

    private Connection getConnection(String fullLogDirectory) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)fullLogDirectory);
        }
        Connection conn = null;
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname));
        }
        Properties dbStringProps = new Properties();
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString));
        }
        dbStringProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbStringProps = " + dbStringProps));
        }
        String dsName = dbStringProps.getProperty("datasource");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Data Source name = " + dsName));
        }
        String tableSuffix = dbStringProps.getProperty("tablesuffix");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Table Suffix = " + tableSuffix));
        }
        if (tableSuffix != null && !tableSuffix.equals("")) {
            this._recoveryTableNameSuffix = tableSuffix;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Full RecoveryTableName = WAS_" + this._recoveryTableNameSuffix));
            }
        }
        SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(dsName, this._customLogProperties);
        this._theDS = sqlNonTranDS.getDataSource();
        if (this._theDS != null) {
            String dbName;
            conn = this._theDS.getConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got connection: " + conn));
            }
            DatabaseMetaData mdata = conn.getMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got metadata: " + mdata));
            }
            if ((dbName = mdata.getDatabaseProductName()).toLowerCase().contains("oracle")) {
                this._isOracle = true;
                this._sqlTransientErrorCodes = this._oracleTransientErrorCodes;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an Oracle Database");
                }
                this.sqlTransientErrorHandlingEnabled = true;
            } else if (dbName.toLowerCase().contains("db2")) {
                this._isDB2 = true;
                this._sqlTransientErrorCodes = this._db2TransientErrorCodes;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a DB2 Database");
                }
                this.sqlTransientErrorHandlingEnabled = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This is neither Oracle nor DB2, it is " + dbName));
            }
            String dbVersion = mdata.getDatabaseProductVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("You are now connected to " + dbName + ", version " + dbVersion));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover(Connection conn) throws SQLException, RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)conn);
        }
        Statement recoveryStmt = null;
        ResultSet recoveryRS = null;
        try {
            recoveryStmt = conn.createStatement();
            String queryString = "SELECT RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME='" + this._serverName + "' AND SERVICE_ID=" + this._recoveryAgent.clientIdentifier();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Retrieve all rows from table using - " + queryString));
            }
            recoveryRS = recoveryStmt.executeQuery(queryString);
            while (recoveryRS.next()) {
                long ruId = recoveryRS.getLong(1);
                if (ruId != -1L) {
                    SQLRecoverableUnitSectionImpl sect;
                    SQLRecoverableUnitImpl ru = (SQLRecoverableUnitImpl)this._recoverableUnits.get(ruId);
                    if (ru == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Creating ru with id: " + ruId));
                        }
                        ru = new SQLRecoverableUnitImpl(this, ruId, this._failureScope, true);
                    }
                    long sectId = recoveryRS.getLong(2);
                    int index = recoveryRS.getInt(3);
                    byte[] data = recoveryRS.getBytes(4);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read ruId: " + ruId));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read sectionId: " + sectId));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read item: " + index));
                        Tr.event((TraceComponent)tc, (String)("sql tranlog: read data: " + RLSUtils.toHexString((byte[])data, (int)32)));
                    }
                    if ((sect = (SQLRecoverableUnitSectionImpl)ru.lookupSection((int)sectId)) == null) {
                        sect = (SQLRecoverableUnitSectionImpl)ru.createSection((int)sectId, index == 0);
                    }
                    sect.addData(index, data);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Bypass locking row with id: " + ruId));
            }
        }
        finally {
            if (recoveryRS != null && !recoveryRS.isClosed()) {
                recoveryRS.close();
            }
            if (recoveryStmt != null && !recoveryStmt.isClosed()) {
                recoveryStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceData", null);
        }
        return null;
    }

    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void closeLog(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{RLSUtils.toHexString((byte[])serviceData, (int)32), this});
        }
        this.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    public synchronized void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{this._reservedConn, this});
        }
        boolean connAlreadyClosed = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
        }
        if (this._closesRequired > 0) {
            try {
                if (this._reservedConn == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reserved Connection is NULL, attempt to get new DataSource connection");
                    }
                    if (!_serverStopping) {
                        this._reservedConn = this._theDS.getConnection();
                    } else {
                        Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Server stopping but no reserved connection when closing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        InternalLogException ile = new InternalLogException("Server stopping, no reserved connection", null);
                        throw ile;
                    }
                }
                if (this._reservedConn.isClosed()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reserved Connection is already closed");
                    }
                    connAlreadyClosed = true;
                }
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeLog", (String)"550", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in closeLog", (Object)exc);
                }
                this.markFailed(exc);
                this._recoverableUnits = null;
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(" " + ste));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
            if (!connAlreadyClosed) {
                try {
                    this.internalKeypoint();
                }
                catch (LogClosedException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"944", (Object)this);
                }
                catch (InternalLogException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"948", (Object)this);
                    this.markFailed(exc);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)((Object)exc));
                    }
                    throw exc;
                }
                catch (Throwable exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.closeLog", (String)"955", (Object)this);
                    this.markFailed(exc);
                    for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(" " + ste));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(exc);
                }
                --this._closesRequired;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
                }
                try {
                    if (this._closesRequired <= 0) {
                        this._recoverableUnits = null;
                        this._closesRequired = 0;
                        this._failed = false;
                        this._reservedConn.rollback();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Close the Reserved Connection");
                    }
                    this._reservedConn.close();
                }
                catch (Throwable exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeLog", (String)"550", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in closeLog", (Object)exc);
                    }
                    this.markFailed(exc);
                    this._recoverableUnits = null;
                    for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(" " + ste));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(exc);
                }
                this._reservedConn = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogImmediate", (Object)this);
        }
        this.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogImmediate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverableUnit createRecoverableUnit(FailureScope failureScope) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object)new Object[]{failureScope, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            long identity = this._recUnitIdTable.nextId((Object)this);
            recoverableUnit = new SQLRecoverableUnitImpl(this, identity, failureScope);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SQLMultiScopeRecoveryLog '" + this._logName + "' created a new RecoverableUnit with id '" + identity + "'"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)new Object[]{identity, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            recoverableUnit = this.removeRecoverableUnitMapEntries(identity);
        }
        if (recoverableUnit == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InvalidRecoverableUnitException");
            }
            throw new InvalidRecoverableUnitException(null);
        }
        try {
            recoverableUnit.remove();
            sQLMultiScopeRecoveryLog = this;
            synchronized (sQLMultiScopeRecoveryLog) {
                ruForReplay deleteRU = new ruForReplay(identity, 0L, 0, null);
                this._cachedRemoves.add(deleteRU);
                ++this._removes;
            }
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1182", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removeRecoverableUnit", (String)"1186", (Object)this);
            this.markFailed(e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)e);
            }
            throw new InternalLogException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    public synchronized LogCursor recoverableUnits(FailureScope failureScope) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object)new Object[]{failureScope, this});
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        ArrayList<SQLRecoverableUnitImpl> recoverableUnits = new ArrayList<SQLRecoverableUnitImpl>();
        for (SQLRecoverableUnitImpl sQLRecoverableUnitImpl : this._recoverableUnits.values()) {
            if (!this._bypassContainmentCheck && !sQLRecoverableUnitImpl.failureScope().isContainedBy(failureScope)) continue;
            recoverableUnits.add(sQLRecoverableUnitImpl);
        }
        LogCursorImpl logCursorImpl = new LogCursorImpl((Lock)null, recoverableUnits, true, (LogCursorCallback)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)logCursorImpl);
        }
        return logCursorImpl;
    }

    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object)this);
        }
        LogCursor cursor = this.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    public RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl runit = this.getRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object)this);
        }
        RecoverableUnit runit = this.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    public LogProperties logProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logProperties", (Object)this._customLogProperties);
        }
        return this._customLogProperties;
    }

    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object)this);
        }
        this.internalKeypoint();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    public void internalKeypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalKeypoint", (Object)new Object[]{this, this._reservedConn});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._closesRequired == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        try {
            this.internalForceSections();
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.internalKeypoint", (String)"537", (Object)this);
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"internalKeypoint", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalKeypoint");
        }
    }

    public void writeRUSection(long ruId, long sectionId, int index, byte[] data) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRUSection ", (Object)new Object[]{ruId, sectionId, index, data, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.internalWriteRUSection(ruId, sectionId, index, data, false);
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.writeRUSection", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst writing data");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeRUSection", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeRUSection");
        }
    }

    public synchronized void internalWriteRUSection(long ruId, long sectionId, int index, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalWriteRUSection ", (Object)new Object[]{ruId, sectionId, index, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing item: " + index));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        ruForReplay insertRU = new ruForReplay(ruId, sectionId, index, data);
        this._cachedInserts.add(insertRU);
        ++this._inserts;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalWriteRUSection");
        }
    }

    public void updateRUSection(long ruId, long sectionId, byte[] data) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRUSection ", (Object)new Object[]{ruId, sectionId, data, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: writing data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        try {
            this.internalUpdateRUSection(ruId, sectionId, data, false);
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.updateRUSection", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst updating a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRUSection", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRUSection");
        }
    }

    public synchronized void internalUpdateRUSection(long ruId, long sectionId, byte[] data, boolean replaying) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"internalUpdateRUSection ", (Object)new Object[]{ruId, sectionId, data, replaying, this});
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating ruId: " + ruId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating sectionId: " + sectionId));
            Tr.event((TraceComponent)tc, (String)("sql tranlog: updating data: " + RLSUtils.toHexString((byte[])data, (int)32)));
        }
        ruForReplay updateRU = new ruForReplay(ruId, sectionId, 0, data);
        this._cachedUpdates.add(updateRU);
        ++this._updates;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"internalUpdateRUSection");
        }
    }

    public synchronized void forceSections() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object)new Object[]{this});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.internalForceSections();
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.forceSections", (String)"537", (Object)this);
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(" " + ste));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forceSections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    void internalForceSections() throws Exception {
        block95: {
            block80: {
                block78: {
                    block82: {
                        block81: {
                            block79: {
                                if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                    Tr.entry((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections", (Object)new Object[]{this, this._reservedConn});
                                }
                                conn = null;
                                sqlSuccess = false;
                                currentSqlEx = null;
                                initialIsolation = 4;
                                if (this._reservedConn != null) ** GOTO lbl20
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Reserved Connection is NULL, attempt to get new DataSource connection");
                                }
                                if (!SQLMultiScopeRecoveryLog._serverStopping) {
                                    conn = this._theDS.getConnection();
                                } else {
                                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Server stopping but no reserved connection when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                                    ile = new InternalLogException("Server stopping, no reserved connection", null);
                                    this.markFailed(ile);
                                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                                    }
                                    throw ile;
lbl20:
                                    // 1 sources

                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Drive SQL using reserved connection");
                                    }
                                    conn = this._reservedConn;
                                }
                                initialIsolation = this.prepareConnectionForBatch(conn);
                                this.takeHADBLock(conn);
                                this.executeBatchStatements(conn);
                                conn.commit();
                                sqlSuccess = true;
                                if (conn == null) break block78;
                                if (!sqlSuccess) break block79;
                                ** if (this._reservedConn != null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block80;
                                }
                            }
                            try {
                                conn.rollback();
                            }
                            catch (SQLRecoverableException sqlrecexc) {
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                }
                            }
                            catch (Throwable exc) {
                                if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block81;
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc));
                            }
                        }
                        if (this._reservedConn == null) {
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (SQLRecoverableException sqlrecexc) {
                                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                }
                            }
                            catch (Throwable exc) {
                                if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block82;
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc));
                            }
                        }
                    }
                    failAndReport = true;
                    if (currentSqlEx != null) {
                        failAndReport = this.handleForceSectionsSQLException(currentSqlEx);
                    }
                    if (failAndReport) {
                        Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                        this.markFailed(this._nonTransientExceptionAtRuntime);
                        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                        }
                        throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                    }
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                    break block80;
                }
                if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL");
                }
                Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                this.markFailed(this._nonTransientExceptionAtRuntime);
                if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                }
                throw new InternalLogException(this._nonTransientExceptionAtRuntime);
            }
            this._cachedInserts.clear();
            this._cachedUpdates.clear();
            this._cachedRemoves.clear();
            this._inserts = 0;
            this._updates = 0;
            this._removes = 0;
            break block95;
            catch (SQLException sqlex) {
                block85: {
                    block83: {
                        block87: {
                            block86: {
                                block84: {
                                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex));
                                    currentSqlEx = sqlex;
                                    if (conn == null) {
                                        this._nonTransientExceptionAtRuntime = sqlex;
                                    }
                                    if (conn == null) break block83;
                                    if (!sqlSuccess) break block84;
                                    ** if (this._reservedConn != null) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        this.closeConnectionAfterBatch(conn, initialIsolation);
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        break block85;
                                    }
                                }
                                try {
                                    conn.rollback();
                                }
                                catch (SQLRecoverableException sqlrecexc) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                    }
                                }
                                catch (Throwable exc) {
                                    if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block86;
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc));
                                }
                            }
                            if (this._reservedConn == null) {
                                try {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                                catch (SQLRecoverableException sqlrecexc) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                    }
                                }
                                catch (Throwable exc) {
                                    if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block87;
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc));
                                }
                            }
                        }
                        failAndReport = true;
                        if (currentSqlEx != null) {
                            failAndReport = this.handleForceSectionsSQLException(currentSqlEx);
                        }
                        if (failAndReport) {
                            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                            this.markFailed(this._nonTransientExceptionAtRuntime);
                            if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                        }
                        Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        break block85;
                    }
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL");
                    }
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                    this.markFailed(this._nonTransientExceptionAtRuntime);
                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                }
                this._cachedInserts.clear();
                this._cachedUpdates.clear();
                this._cachedRemoves.clear();
                this._inserts = 0;
                this._updates = 0;
                this._removes = 0;
            }
            catch (Throwable exc) {
                block90: {
                    block88: {
                        block92: {
                            block91: {
                                block89: {
                                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0107W: Caught non-SQLException Throwable when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Throwable: " + exc));
                                    this._nonTransientExceptionAtRuntime = exc;
                                    if (conn == null) break block88;
                                    if (!sqlSuccess) break block89;
                                    ** if (this._reservedConn != null) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        this.closeConnectionAfterBatch(conn, initialIsolation);
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        break block90;
                                    }
                                }
                                try {
                                    conn.rollback();
                                }
                                catch (SQLRecoverableException sqlrecexc) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                    }
                                }
                                catch (Throwable exc) {
                                    if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block91;
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc));
                                }
                            }
                            if (this._reservedConn == null) {
                                try {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                                catch (SQLRecoverableException sqlrecexc) {
                                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                    }
                                }
                                catch (Throwable exc) {
                                    if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block92;
                                    Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc));
                                }
                            }
                        }
                        failAndReport = true;
                        if (currentSqlEx != null) {
                            failAndReport = this.handleForceSectionsSQLException(currentSqlEx);
                        }
                        if (failAndReport) {
                            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                            this.markFailed(this._nonTransientExceptionAtRuntime);
                            if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                        }
                        Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                        break block90;
                    }
                    if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL");
                    }
                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                    this.markFailed(this._nonTransientExceptionAtRuntime);
                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                }
                this._cachedInserts.clear();
                this._cachedUpdates.clear();
                this._cachedRemoves.clear();
                this._inserts = 0;
                this._updates = 0;
                this._removes = 0;
                {
                    catch (Throwable var6_26) {
                        if (conn != null) {
                            if (sqlSuccess) {
                                if (this._reservedConn == null) {
                                    this.closeConnectionAfterBatch(conn, initialIsolation);
                                }
                            } else {
                                block94: {
                                    block93: {
                                        try {
                                            conn.rollback();
                                        }
                                        catch (SQLRecoverableException sqlrecexc) {
                                            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                            }
                                        }
                                        catch (Throwable exc) {
                                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block93;
                                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Rollback Failed, after force sections failure, got exception: " + exc));
                                        }
                                    }
                                    if (this._reservedConn == null) {
                                        try {
                                            this.closeConnectionAfterBatch(conn, initialIsolation);
                                        }
                                        catch (SQLRecoverableException sqlrecexc) {
                                            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got SQL Recoverable Exception: " + sqlrecexc));
                                            }
                                        }
                                        catch (Throwable exc) {
                                            if (!SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) break block94;
                                            Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("Close Failed, after force sections failure, got exception: " + exc));
                                        }
                                    }
                                }
                                failAndReport = true;
                                if (currentSqlEx != null) {
                                    failAndReport = this.handleForceSectionsSQLException(currentSqlEx);
                                }
                                if (failAndReport) {
                                    Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                                    this.markFailed(this._nonTransientExceptionAtRuntime);
                                    if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                                    }
                                    throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                                }
                                Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0108I: Have recovered from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                            }
                        } else {
                            if (SQLMultiScopeRecoveryLog.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"Connection was NULL");
                            }
                            Tr.audit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)("WTRN0100E: Cannot recover from SQLException when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName + " Exception: " + this._nonTransientExceptionAtRuntime));
                            this.markFailed(this._nonTransientExceptionAtRuntime);
                            if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"forceSections", (Object)"InternalLogException");
                            }
                            throw new InternalLogException(this._nonTransientExceptionAtRuntime);
                        }
                        this._cachedInserts.clear();
                        this._cachedUpdates.clear();
                        this._cachedRemoves.clear();
                        this._inserts = 0;
                        this._updates = 0;
                        this._removes = 0;
                        throw var6_26;
                    }
                }
            }
        }
        if (SQLMultiScopeRecoveryLog.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SQLMultiScopeRecoveryLog.tc, (String)"internalForceSections");
        }
    }

    private boolean isSQLErrorTransient(SQLException sqlex) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSQLErrorTransient ", (Object)new Object[]{sqlex, this});
        }
        boolean retryBatch = false;
        int sqlErrorCode = sqlex.getErrorCode();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" SQL exception:");
            Tr.event((TraceComponent)tc, (String)(" Message: " + sqlex.getMessage()));
            Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + sqlex.getSQLState()));
            Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode));
        }
        for (int transientCode : this._sqlTransientErrorCodes) {
            Tr.event((TraceComponent)tc, (String)("Test against stored code: " + transientCode));
            if (transientCode != sqlErrorCode) continue;
            Tr.event((TraceComponent)tc, (String)"TRANSIENT: A connection failed but could be reestablished, retry.");
            retryBatch = true;
            break;
        }
        if (!retryBatch && sqlex instanceof BatchUpdateException) {
            BatchUpdateException buex = (BatchUpdateException)sqlex;
            Tr.event((TraceComponent)tc, (String)"BatchUpdateException: Update Counts - ");
            int[] updateCounts = buex.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; ++i) {
                Tr.event((TraceComponent)tc, (String)("   Statement " + i + ":" + updateCounts[i]));
            }
            block2: for (SQLException nextex = buex.getNextException(); nextex != null; nextex = nextex.getNextException()) {
                sqlErrorCode = nextex.getErrorCode();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)" SQL exception:");
                    Tr.event((TraceComponent)tc, (String)(" Message: " + nextex.getMessage()));
                    Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + nextex.getSQLState()));
                    Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode));
                }
                for (int transientCode : this._sqlTransientErrorCodes) {
                    Tr.event((TraceComponent)tc, (String)("Test against stored code: " + transientCode));
                    if (transientCode != sqlErrorCode) continue;
                    Tr.event((TraceComponent)tc, (String)"TRANSIENT: A connection failed but could be reestablished, retry.");
                    retryBatch = true;
                    continue block2;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSQLErrorTransient", (Object)retryBatch);
        }
        return retryBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchStatements(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatchStatements", (Object)new Object[]{conn, this});
        }
        Statement insertStatement = null;
        Statement updateStatement = null;
        Statement removeStatement = null;
        try {
            int[] numUpdates;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the INSERT statement for " + this._inserts + " inserts"));
            }
            if (this._inserts > 0) {
                String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("INSERT string - " + insertString));
                }
                insertStatement = conn.prepareStatement(insertString);
                insertStatement.setString(1, this._serverName);
                insertStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the UPDATE statement for " + this._updates + " updates"));
            }
            if (this._updates > 0) {
                String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET DATA = ? WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? AND RUSECTION_ID = ? AND RUSECTION_DATA_INDEX = 0";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("UPDATE string - " + updateString));
                }
                updateStatement = conn.prepareStatement(updateString);
                updateStatement.setString(2, this._serverName);
                updateStatement.setShort(3, (short)this._recoveryAgent.clientIdentifier());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Prepare the DELETE statement for " + this._removes + " removes"));
            }
            if (this._removes > 0) {
                String removeString = "DELETE FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE SERVER_NAME = ? AND SERVICE_ID = ? AND RU_ID = ? ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DELETE string - " + (String)removeString));
                }
                removeStatement = conn.prepareStatement(removeString);
                removeStatement.setString(1, this._serverName);
                removeStatement.setShort(2, (short)this._recoveryAgent.clientIdentifier());
            }
            if (this._inserts > 0) {
                for (ruForReplay element : this._cachedInserts) {
                    insertStatement.setLong(3, element.getRuId());
                    insertStatement.setLong(4, element.getSectionId());
                    insertStatement.setShort(5, (short)element.getIndex());
                    insertStatement.setBytes(6, element.getData());
                    insertStatement.addBatch();
                }
            }
            if (this._updates > 0) {
                for (ruForReplay element : this._cachedUpdates) {
                    updateStatement.setLong(4, element.getRuId());
                    updateStatement.setLong(5, element.getSectionId());
                    updateStatement.setBytes(1, element.getData());
                    updateStatement.addBatch();
                }
            }
            if (this._removes > 0) {
                for (ruForReplay element : this._cachedRemoves) {
                    removeStatement.setLong(3, element.getRuId());
                    removeStatement.addBatch();
                }
            }
            if (this._inserts > 0) {
                numUpdates = insertStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch inserts: " + this._inserts));
            }
            if (this._updates > 0) {
                numUpdates = updateStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch updates: " + this._updates));
            }
            if (this._removes > 0) {
                numUpdates = removeStatement.executeBatch();
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < numUpdates.length; ++i) {
                        if (numUpdates[i] == -2) {
                            Tr.debug((TraceComponent)tc, (String)("Execution " + i + ": unknown number of rows updated"));
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)("Execution " + i + "successful: " + numUpdates[i] + " rows updated"));
                    }
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("sql tranlog: batch deletes: " + this._removes + ", for obj: " + this));
            }
        }
        finally {
            if (insertStatement != null && !insertStatement.isClosed()) {
                insertStatement.close();
            }
            if (updateStatement != null && !updateStatement.isClosed()) {
                updateStatement.close();
            }
            if (removeStatement != null && !removeStatement.isClosed()) {
                removeStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeBatchStatements");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleForceSectionsSQLException(SQLException sqlex) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleForceSectionsSQLException", (Object)new Object[]{sqlex, this});
        }
        boolean retryBatch = true;
        boolean failAndReport = false;
        int batchRetries = 0;
        this._nonTransientExceptionAtRuntime = sqlex;
        while (retryBatch && !failAndReport && batchRetries < this._transientRetryAttempts) {
            retryBatch = this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex);
            ++batchRetries;
            if (retryBatch) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + this._theDS + ", attempt number: " + batchRetries));
                }
                if (this._theDS != null) {
                    Connection conn = null;
                    int initialIsolation = 4;
                    try {
                        conn = this._theDS.getConnection();
                        initialIsolation = this.prepareConnectionForBatch(conn);
                        this.takeHADBLock(conn);
                        this.executeBatchStatements(conn);
                        conn.commit();
                        retryBatch = false;
                        continue;
                    }
                    catch (SQLException sqlex2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("reset the sqlex to " + sqlex2));
                        }
                        sqlex = sqlex2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sleeping for " + this._transientRetrySleepTime + " millisecs"));
                        }
                        Thread.sleep(this._transientRetrySleepTime);
                        continue;
                    }
                    catch (Throwable exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Failed got exception: " + exc));
                        }
                        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(" " + ste));
                        }
                        failAndReport = true;
                        this._nonTransientExceptionAtRuntime = exc;
                        continue;
                    }
                    finally {
                        if (conn != null) {
                            block36: {
                                if (retryBatch) {
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block36;
                                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, when handling ForceSections SQLException, got exception: " + exc));
                                    }
                                }
                            }
                            try {
                                this.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Throwable exc) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, when handling ForceSections SQLException, got exception: " + exc));
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Connection was NULL");
                        continue;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"NULL DataSource reference");
                }
                failAndReport = true;
                continue;
            }
            failAndReport = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleForceSectionsSQLException", (Object)failAndReport);
        }
        return failAndReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleOpenLogSQLException(SQLException sqlex) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleOpenLogSQLException", (Object)new Object[]{sqlex, this});
        }
        boolean retryBatch = true;
        boolean failAndReport = false;
        int batchRetries = 0;
        this._nonTransientExceptionAtOpen = sqlex;
        Connection conn = null;
        while (retryBatch && !failAndReport && batchRetries < this._transientRetryAttempts) {
            retryBatch = this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex);
            ++batchRetries;
            if (retryBatch) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + this._theDS + ", attempt number: " + batchRetries));
                }
                if (this._theDS != null) {
                    try {
                        conn = this._theDS.getConnection();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Acquired connection in Database retry scenario");
                        }
                        conn.setAutoCommit(false);
                        Statement lockingStmt = conn.createStatement();
                        String queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE - " + queryString));
                        }
                        ResultSet lockingRS = lockingStmt.executeQuery(queryString);
                        this.updateHADBLock(conn, lockingStmt, lockingRS);
                        this._recoverableUnits.clear();
                        this._recUnitIdTable = new RecoverableUnitIdTable();
                        this.recover(conn);
                        conn.commit();
                        retryBatch = false;
                        continue;
                    }
                    catch (SQLException sqlex2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("reset the sqlex to " + sqlex2));
                        }
                        sqlex = sqlex2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sleeping for " + this._transientRetrySleepTime + " millisecs"));
                        }
                        Thread.sleep(this._transientRetrySleepTime);
                        continue;
                    }
                    catch (Throwable exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Failed got exception: " + exc));
                        }
                        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(" " + ste));
                        }
                        failAndReport = true;
                        this._nonTransientExceptionAtOpen = exc;
                        continue;
                    }
                    finally {
                        block37: {
                            if (conn == null) continue;
                            if (retryBatch) {
                                try {
                                    conn.rollback();
                                }
                                catch (Throwable exc) {
                                    if (!tc.isDebugEnabled()) break block37;
                                    Tr.debug((TraceComponent)tc, (String)("Rollback Failed, when handling OpenLog SQLException, got exception: " + exc));
                                }
                            }
                        }
                        try {
                            conn.close();
                        }
                        catch (Throwable exc) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Close Failed, when handling OpenLog SQLException, got exception: " + exc));
                        }
                        continue;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"NULL DataSource reference");
                }
                failAndReport = true;
                continue;
            }
            failAndReport = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleOpenLogSQLException", (Object)failAndReport);
        }
        return failAndReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeHADBLock(Connection conn) throws SQLException, InternalLogException {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"takeHADBLock", (Object)new Object[]{conn, this});
            }
            Statement lockingStmt = null;
            ResultSet lockingRS = null;
            try {
                lockingStmt = conn.createStatement();
                String queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1 FOR UPDATE";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW for UPDATE using - " + queryString));
                }
                if ((lockingRS = lockingStmt.executeQuery(queryString)).next()) {
                    String storedServerName = lockingRS.getString(1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Acquired lock on HA Lock row, stored server value is: " + storedServerName));
                    }
                    if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This server OWNS the HA lock row as expected");
                        }
                        break block16;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ANOTHER server OWNS the lock row - we need to mark the log as failed");
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Another server owns the log cannot force SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                    InternalLogException ile = new InternalLogException("Another server has locked the HA lock row", null);
                    this.markFailed(ile);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)"InternalLogException");
                    }
                    throw ile;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find HA Lock row");
                }
                InternalLogException ile = new InternalLogException("Could not find the HA lock row", null);
                Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Could not find HA lock row when forcing SQL RecoveryLog " + this._logName + " for server " + this._serverName));
                this.markFailed(ile);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"takeHADBLock", (Object)"InternalLogException");
                }
                throw ile;
            }
            finally {
                if (lockingRS != null && !lockingRS.isClosed()) {
                    lockingRS.close();
                }
                if (lockingStmt != null && !lockingStmt.isClosed()) {
                    lockingStmt.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"takeHADBLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHADBLock(Connection conn, Statement lockingStmt, ResultSet lockingRS) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateHADBLock", (Object)new Object[]{conn, lockingStmt, lockingRS, this});
        }
        if (lockingRS.next()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Acquired lock on HA Lock row");
            }
            String storedServerName = lockingRS.getString(1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Stored server value is: " + storedServerName));
            }
            if (this._currentProcessServerName.equalsIgnoreCase(storedServerName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This server ALREADY OWNS the HA lock row");
                }
            } else {
                String updateString = "UPDATE WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " SET SERVER_NAME = '" + this._currentProcessServerName + "' WHERE RU_ID = -1";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ANOTHER server OWNS the lock, lets update it using - " + updateString));
                }
                int ret = lockingStmt.executeUpdate(updateString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated HA Lock row with return: " + ret));
                }
            }
        } else {
            short serviceId = 1;
            String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
            Statement specStatement = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Need to setup HA Lock row using - " + insertString));
                }
                specStatement = conn.prepareStatement(insertString);
                specStatement.setString(1, this._currentProcessServerName);
                specStatement.setShort(2, serviceId);
                specStatement.setLong(3, -1L);
                specStatement.setLong(4, 1L);
                specStatement.setShort(5, (short)1);
                byte[] buf = new byte[2];
                specStatement.setBytes(6, buf);
                int ret = specStatement.executeUpdate();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have inserted HA Lock row with return: " + ret));
                }
            }
            finally {
                if (specStatement != null && !specStatement.isClosed()) {
                    specStatement.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHADBLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDBTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDBTable", (Object)new Object[]{conn, this});
        }
        Statement createTableStmt = null;
        Statement specStatement = null;
        try {
            createTableStmt = conn.createStatement();
            if (this._isOracle) {
                String oracleFullTableName = "WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix;
                String oracleTableString = "CREATE TABLE " + oracleFullTableName + "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID NUMBER(19), RUSECTION_ID NUMBER(19), RUSECTION_DATA_INDEX SMALLINT, DATA BLOB) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Table using: " + oracleTableString));
                }
                String oracleIndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + oracleFullTableName + "( \"RU_ID\" ASC, \"SERVICE_ID\" ASC, \"SERVER_NAME\" ASC) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Index using: " + oracleIndexString));
                }
                createTableStmt.executeUpdate(oracleTableString);
                createTableStmt.executeUpdate(oracleIndexString);
            } else {
                String db2FullTableName = "WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix;
                String db2TableString = "CREATE TABLE " + db2FullTableName + "( SERVER_NAME VARCHAR(128), SERVICE_ID SMALLINT, RU_ID BIGINT, RUSECTION_ID BIGINT, RUSECTION_DATA_INDEX SMALLINT, DATA LONG VARCHAR FOR BIT DATA) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Table using: " + db2TableString));
                }
                String db2IndexString = "CREATE INDEX IXWS" + this._logIdentifierString + this._recoveryTableNameSuffix + " ON " + db2FullTableName + "( \"RU_ID\" ASC, \"SERVICE_ID\" ASC, \"SERVER_NAME\" ASC) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Index using: " + db2IndexString));
                }
                createTableStmt.executeUpdate(db2TableString);
                createTableStmt.executeUpdate(db2IndexString);
            }
            short serviceId = (short)this._recoveryAgent.clientIdentifier();
            String insertString = "INSERT INTO WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " (SERVER_NAME, SERVICE_ID, RU_ID, RUSECTION_ID, RUSECTION_DATA_INDEX, DATA) VALUES (?,?,?,?,?,?)";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have created the table, insert special HA LOCKING row using - " + insertString));
            }
            specStatement = conn.prepareStatement(insertString);
            specStatement.setString(1, this._currentProcessServerName);
            specStatement.setShort(2, serviceId);
            specStatement.setLong(3, -1L);
            specStatement.setLong(4, 1L);
            specStatement.setShort(5, (short)1);
            byte[] buf = new byte[2];
            specStatement.setBytes(6, buf);
            int ret = specStatement.executeUpdate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have inserted HA LOCKING ROW with return: " + ret));
            }
        }
        finally {
            if (createTableStmt != null && !createTableStmt.isClosed()) {
                createTableStmt.close();
            }
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDBTable");
        }
    }

    public void removing(Object target) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removing", (Object)new Object[]{target, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.removeRecoverableUnit(((SQLRecoverableUnitImpl)target).identity());
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1573", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)((Object)exc));
            }
            throw exc;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.removing", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing");
        }
    }

    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("failed: RecoveryLog has been marked as failed. [" + this + "]"));
        }
        return this._failed;
    }

    protected boolean incompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("incompatible: RecoveryLog has been marked as incompatible. [" + this + "]"));
        }
        return this._incompatible;
    }

    protected void markFailed(Throwable t) {
        this.markFailed(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markFailed(Throwable t, boolean report) {
        boolean newFailure = false;
        SQLMultiScopeRecoveryLog sQLMultiScopeRecoveryLog = this;
        synchronized (sQLMultiScopeRecoveryLog) {
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailed: RecoveryLog has been marked as failed. [" + this + "]"));
            }
            if (!this._failed) {
                newFailure = true;
                this._failed = true;
                if (report) {
                    Object[] errorObject = new Object[]{this._logIdentifier, this._clientName};
                    Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object)errorObject);
                    Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object)t);
                }
                if (Configuration.HAEnabled()) {
                    if (Configuration.localFailureScope().equals(this._failureScope)) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)t);
                        Configuration.getRecoveryLogComponent().terminateServer();
                    } else {
                        Configuration.getRecoveryLogComponent().leaveGroup(this._failureScope);
                    }
                }
            }
        }
        if (newFailure && this._associatedLog != null) {
            if (this._failAssociatedLog) {
                if (tc.isDebugEnabled() && this._failed) {
                    Tr.debug((TraceComponent)tc, (String)"associated log will be marked as failed", (Object)this._associatedLog);
                }
                this._associatedLog.markFailedByAssociation();
            } else {
                this._associatedLog.provideServiceability();
            }
        }
    }

    public synchronized void markFailedByAssociation() {
        if (!this._failed) {
            this._failed = true;
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog has been marked as failed by association. [" + this + "]"));
            }
            this.provideServiceability();
        } else if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog was already failed when marked as failed by association. [" + this + "]"));
        }
    }

    protected synchronized void markIncompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("markIncompatible: RecoveryLog has been marked as incompatible. [" + this + "]"));
        }
        this._incompatible = true;
    }

    protected void addRecoverableUnit(RecoverableUnit recoverableUnit, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoverableUnit", (Object)new Object[]{recoverableUnit, recovered, this});
        }
        long identity = recoverableUnit.identity();
        this._recoverableUnits.put(identity, recoverableUnit);
        if (recovered) {
            this._recUnitIdTable.reserveId(identity, (Object)recoverableUnit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoverableUnit");
        }
    }

    protected SQLRecoverableUnitImpl removeRecoverableUnitMapEntries(long identity) {
        SQLRecoverableUnitImpl recoverableUnit;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)new Object[]{identity, this});
        }
        if ((recoverableUnit = (SQLRecoverableUnitImpl)this._recoverableUnits.remove(identity)) != null) {
            this._recUnitIdTable.removeId(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    protected SQLRecoverableUnitImpl getRecoverableUnit(long identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoverableUnit", (Object)new Object[]{identity, this});
        }
        SQLRecoverableUnitImpl recoverableUnit = null;
        if (!this.incompatible() && !this.failed()) {
            recoverableUnit = (SQLRecoverableUnitImpl)this._recoverableUnits.get(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", recoverableUnit);
        }
        return recoverableUnit;
    }

    String serverName() {
        return this._serverName;
    }

    String clientName() {
        return this._clientName;
    }

    public int clientVersion() {
        return this._clientVersion;
    }

    public String logName() {
        return this._logName;
    }

    public int logIdentifier() {
        return this._logIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serverStopping() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverStopping ", (Object)new Object[]{this});
        }
        _serverStopping = true;
        Statement lockingStmt = null;
        String queryString = "";
        ResultSet nonLockingRS = null;
        try {
            this._reservedConn = this._theDS.getConnection();
            lockingStmt = this._reservedConn.createStatement();
            queryString = "SELECT SERVER_NAME FROM WAS_" + this._logIdentifierString + this._recoveryTableNameSuffix + " WHERE RU_ID=-1";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the HA LOCKING ROW BUT NOT for UPDATE - " + queryString));
            }
            if (!(nonLockingRS = lockingStmt.executeQuery(queryString)).next()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HA Locking row was NOT found");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HA Locking row was found");
                }
            }
            lockingStmt.close();
            this._reservedConn.commit();
        }
        catch (SQLException sqlex) {
            Throwable theNonTransientException = sqlex;
            Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when server stopping for SQL RecoveryLog " + this._logName + " for server " + this._serverName + " SQLException: " + sqlex));
            boolean retryBatch = this.sqlTransientErrorHandlingEnabled && this.isSQLErrorTransient(sqlex);
            boolean failAndReport = true;
            if (retryBatch) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL using connection from DS: " + this._theDS));
                }
                try {
                    this._reservedConn = this._theDS.getConnection();
                    lockingStmt = this._reservedConn.createStatement();
                    nonLockingRS = lockingStmt.executeQuery(queryString);
                    if (!nonLockingRS.next()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"HA Locking row was NOT found");
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"HA Locking row was found");
                        }
                    }
                    lockingStmt.close();
                    this._reservedConn.commit();
                    failAndReport = false;
                }
                catch (SQLException sqlex2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("reset the sqlex to " + sqlex2));
                    }
                    theNonTransientException = sqlex2;
                }
                catch (Throwable exc) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Failed got exception: " + exc));
                    }
                    for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(" " + ste));
                    }
                    theNonTransientException = exc;
                }
            }
            if (failAndReport) {
                FFDCFilter.processException((Throwable)theNonTransientException, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.serverStopping", (String)"464", (Object)this);
                this._reservedConn = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"serverStopping", (Object)theNonTransientException);
                }
            }
        }
        finally {
            block36: {
                try {
                    if (nonLockingRS != null && !nonLockingRS.isClosed()) {
                        nonLockingRS.close();
                    }
                    if (lockingStmt != null && !lockingStmt.isClosed()) {
                        lockingStmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug((TraceComponent)tc, (String)("on closing SQL resources caught exception: " + e));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public String toString() {
        return this._traceId;
    }

    private String logTypeFromInteger(int x) {
        switch (x) {
            case 1: {
                return "TRAN_LOG";
            }
            case 2: {
                return "PARTNER_LOG";
            }
            case 3: {
                return "COMP_LOG";
            }
        }
        return "";
    }

    private Integer getTransientSQLErrorRetryAttempts() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransientSQLErrorRetryAttempts");
        }
        Integer transientSqlRetryAttempts = null;
        try {
            transientSqlRetryAttempts = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.recoverylog.custom.jdbc.impl.TransientRetryAttempts", 180);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SqlMultiScopeRecoveryLog.getTransientSQLErrorRetryAttempts", (String)"132");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting transient SQL retry attempts", (Object)e);
            }
            transientSqlRetryAttempts = null;
        }
        if (transientSqlRetryAttempts == null) {
            transientSqlRetryAttempts = 180;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransientSQLErrorRetryAttempts", (Object)transientSqlRetryAttempts);
        }
        return transientSqlRetryAttempts;
    }

    private Integer getTransientSQLErrorRetrySleepTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransientSQLErrorRetrySleepTime");
        }
        Integer transientSqlRetrySleepTime = null;
        try {
            transientSqlRetrySleepTime = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.ws.recoverylog.custom.jdbc.impl.TransientRetrySleepTime", 10000);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SqlMultiScopeRecoveryLog.getTransientSQLErrorRetrySleepTime", (String)"132");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting transient SQL retry sleep time", (Object)e);
            }
            transientSqlRetrySleepTime = null;
        }
        if (transientSqlRetrySleepTime == null) {
            transientSqlRetrySleepTime = 10000;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransientSQLErrorRetrySleepTime", (Object)transientSqlRetrySleepTime);
        }
        return transientSqlRetrySleepTime;
    }

    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateLog", (Object)new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof MultiScopeLog) {
            this._associatedLog = (MultiScopeLog)otherLog;
            this._failAssociatedLog = failAssociatedLog;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateLog");
        }
    }

    public void provideServiceability() {
        Exception e = new Exception();
        try {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3624", (Object)this);
            HashMap<Long, RecoverableUnit> rus = this._recoverableUnits;
            if (rus != null) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog.provideServiceability", (String)"3628", rus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int prepareConnectionForBatch(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        int initialIsolation = 4;
        if (this._isDB2) {
            try {
                initialIsolation = conn.getTransactionIsolation();
                if (4 != initialIsolation && 8 != initialIsolation) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Transaction isolation level was " + initialIsolation + " , setting to TRANSACTION_REPEATABLE_READ"));
                    }
                    conn.setTransactionIsolation(4);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation to RR threw Exception. Transaction isolation level was " + initialIsolation + " "), (Object)e);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.prepareConnectionForBatch", (String)"3668", (Object)this);
                if (!this.isolationFailureReported) {
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)e);
                }
                initialIsolation = 4;
            }
        }
        return initialIsolation;
    }

    private void closeConnectionAfterBatch(Connection conn, int initialIsolation) throws SQLException {
        block4: {
            if (this._isDB2 && 4 != initialIsolation && 8 != initialIsolation) {
                try {
                    conn.setTransactionIsolation(initialIsolation);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation threw Exception. Specified transaction isolation level was " + initialIsolation + " "), (Object)e);
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeConnectionAfterBatch", (String)"3696", (Object)this);
                    if (this.isolationFailureReported) break block4;
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)e);
                }
            }
        }
        conn.close();
    }

    private static class ruForReplay {
        private final long _ruId;
        private final long _sectionId;
        private final int _index;
        private byte[] _data = null;

        public ruForReplay(long ruId, long sectionId, int index, byte[] data) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ruForReplay", (Object)new Object[]{ruId, sectionId, index, data});
            }
            this._ruId = ruId;
            this._sectionId = sectionId;
            this._index = index;
            this._data = data;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ruForReplay", (Object)this);
            }
        }

        public long getRuId() {
            return this._ruId;
        }

        public long getSectionId() {
            return this._sectionId;
        }

        public int getIndex() {
            return this._index;
        }

        private byte[] getData() {
            return this._data;
        }
    }
}

