/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.event.FilterListenerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.webcontainer.filter.FilterChainContents;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.filter.WebAppFilterChain;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.filter.IFilterMapping;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerHelper;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebAppFilterManager
implements com.ibm.wsspi.webcontainer.filter.WebAppFilterManager {
    protected Hashtable _filterWrappers = new Hashtable();
    private Map chainCache = Collections.synchronizedMap(new LinkedHashMap(20, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 200;
        }
    });
    private Map forwardChainCache = Collections.synchronizedMap(new LinkedHashMap(10, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private Map includeChainCache = Collections.synchronizedMap(new LinkedHashMap(5, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private Map errorChainCache = Collections.synchronizedMap(new LinkedHashMap(2, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    public boolean _filtersDefined = false;
    static final int FMI_MAPPING_SINGLE_SLASH = 0;
    static final int FMI_MAPPING_PATH_MATCH = 1;
    static final int FMI_MAPPING_EXTENSION_MATCH = 2;
    static final int FMI_MAPPING_EXACT_MATCH = 3;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.WebAppFilterManager";
    private static TraceNLS nls = TraceNLS.getTraceNLS(WebAppFilterManager.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    WebAppConfiguration webAppConfig;
    WebApp webApp;
    private ICollaboratorHelper collabHelper;
    private IWebAppNameSpaceCollaborator webAppNameSpaceCollab;
    private IWebAppSecurityCollaborator secCollab;
    private boolean sessionSecurityIntegrationEnabled;
    private boolean assumeFilterSuccessOnSecurityError = WCCustomProperties.ASSUME_FILTER_SUCCESS_ON_SECURITY_ERROR;
    private static boolean useOriginalRequestState = WCCustomProperties.USE_ORIGINAL_REQUEST_STATE;
    private WebAppEventSource _evtSource = null;
    private WebComponentMetaData defaultComponentMetaData;
    public static final boolean DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR = WCCustomProperties.DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR;

    public WebAppFilterManager(WebAppConfiguration webGroupConfig, WebApp webApp) {
        this.webAppConfig = webGroupConfig;
        this.webApp = webApp;
        this._evtSource = (WebAppEventSource)webApp.getServletContextEventSource();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "WebAppFilterManager", "Adding debug filter invocation listener");
            FilterListenerImpl testListener = new FilterListenerImpl();
            this._evtSource.addFilterInvocationListener(testListener);
            this._evtSource.addFilterListener(testListener);
            this._evtSource.addFilterErrorListener(testListener);
        }
        this.collabHelper = webApp.getCollaboratorHelper();
        this.webAppNameSpaceCollab = this.collabHelper.getWebAppNameSpaceCollaborator();
        this.secCollab = this.collabHelper.getSecurityCollaborator();
        this.defaultComponentMetaData = webApp.getWebAppCmd();
        if (webApp.getSessionContext() != null) {
            this.sessionSecurityIntegrationEnabled = webApp.getSessionContext().getIntegrateWASSecurity();
        }
    }

    public void init() {
        ArrayList fMappings = new ArrayList(this.webAppConfig.getFilterMappings());
        if (!fMappings.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "filter mappings at init time ->" + fMappings);
            }
            this._filtersDefined = true;
            for (FilterMapping fMapping : fMappings) {
                String filterName;
                this.addFilterMapping(fMapping);
                if (!WCCustomProperties.INVOKE_FILTER_INIT_AT_START_UP || this._filterWrappers.get(filterName = fMapping.getFilterConfig().getFilterName()) != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", "load filter init at startup, filter ->" + filterName);
                }
                try {
                    this.loadFilter(filterName);
                }
                catch (Throwable th) {
                    LoggerHelper.logParamsAndException(logger, Level.SEVERE, CLASS_NAME, "init", "init.exception.thrown.by.filter.at.startup", new Object[]{filterName}, th);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "init", "no filter mappings at init time");
        }
    }

    private void addFilterMapping(FilterMapping fMapping) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "filter mapping->" + fMapping);
        }
        if (fMapping != null) {
            this._filtersDefined = true;
            String urlMap = fMapping.getUrlPattern();
            if (urlMap != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "add url pattern filter mapping");
                }
                this.webAppConfig.addUriMappedFilterInfo(fMapping);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addFilterMapping", "add servlet name filter mapping");
                }
                this.webAppConfig.addServletMappedFilterInfo(fMapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterInstanceWrapper getFilterInstanceWrapper(String filterName) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getFilterInstanceWrapper", "entry for " + filterName);
        }
        try {
            FilterInstanceWrapper filterInstW = (FilterInstanceWrapper)this._filterWrappers.get(filterName);
            if (filterInstW == null) {
                IFilterConfig iFilterConfig = this.webAppConfig.getFilterInfo(filterName);
                synchronized (iFilterConfig) {
                    filterInstW = (FilterInstanceWrapper)this._filterWrappers.get(filterName);
                    if (filterInstW == null) {
                        filterInstW = this.loadFilter(filterName);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getFilterInstanceWrapper", "exit for " + filterName);
            }
            return filterInstW;
        }
        catch (ServletException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "166", this);
            throw e;
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.getFilterInstanceWrapper", "172", this);
            throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", filterName), th);
        }
    }

    public WebAppFilterChain getFilterChain(String reqURI, RequestProcessor requestProcessor, DispatcherType dispatcherType) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getFilterChain", "requestURI [" + reqURI + "] no request passed");
        }
        return this.getFilterChain(null, reqURI, requestProcessor, DispatcherType.REQUEST);
    }

    public WebAppFilterChain getFilterChain(ServletRequest request, String reqURI, RequestProcessor requestProcessor, DispatcherType dispatcherType) throws ServletException {
        String processorName = "null";
        boolean isInternal = false;
        if (requestProcessor != null) {
            String tempProcessorName;
            if (requestProcessor instanceof IServletWrapper && (tempProcessorName = ((IServletWrapper)requestProcessor).getServletName()) != null) {
                processorName = tempProcessorName;
            }
            isInternal = requestProcessor.isInternal();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getFilterChain", "requestURI [" + reqURI + "] isInternal [" + isInternal + "]");
        }
        FilterChainContents fcc = this.getFilterChainContents(reqURI, processorName, dispatcherType, isInternal);
        WebAppFilterChain newChain = new WebAppFilterChain(this.webApp);
        int nbrOfNames = 0;
        if (fcc._hasFilters) {
            ArrayList filterNames = fcc.getFilterNames();
            nbrOfNames = filterNames.size();
            for (int i = 0; i < nbrOfNames; ++i) {
                newChain.addFilter(this.getFilterInstanceWrapper((String)filterNames.get(i)));
            }
        }
        if (nbrOfNames > 0) {
            WebContainerRequestState reqStateSaveFilteredRequest = WebContainerRequestState.getInstance(true);
            reqStateSaveFilteredRequest.setInvokedFilters(true);
            if (useOriginalRequestState) {
                reqStateSaveFilteredRequest.setAttribute("unFilteredRequestObject", request);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChain", "request [" + request + "] ,requestURI [" + reqURI + "] has filters [" + nbrOfNames + "]");
                }
            }
        } else {
            WebContainerRequestState.getInstance(true).setInvokedFilters(false);
        }
        newChain.setRequestProcessor(requestProcessor);
        return newChain;
    }

    public WebAppFilterChain getFilterChain(String reqURI, ServletWrapper reqServlet) throws ServletException {
        return this.getFilterChain(reqURI, reqServlet, DispatcherType.REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Enumeration filterWrappers = this._filterWrappers.elements();
        ClassLoader origClassLoader = ThreadContextHelper.getContextClassLoader();
        try {
            ClassLoader warClassLoader = this.webApp.getClassLoader();
            if (warClassLoader != origClassLoader) {
                ThreadContextHelper.setClassLoader(warClassLoader);
            }
            while (filterWrappers.hasMoreElements()) {
                try {
                    FilterInstanceWrapper fw = (FilterInstanceWrapper)filterWrappers.nextElement();
                    Throwable t = this.webApp.invokeAnnotTypeOnObjectAndHierarchy(fw.getFilterInstance(), WebApp.ANNOT_TYPE.PRE_DESTROY);
                    if (t != null && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "shutdown", "Exception caught during preDestroy processing: " + t);
                    }
                    fw.destroy();
                }
                catch (Throwable th) {
                    FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.shutdown", "237", this);
                }
            }
        }
        finally {
            ThreadContextHelper.setClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterInstanceWrapper loadFilter(String filterName) throws ServletException {
        ClassLoader origClassLoader = ThreadContextHelper.getContextClassLoader();
        try {
            ClassLoader warClassLoader = this.webApp.getClassLoader();
            if (warClassLoader != origClassLoader) {
                ThreadContextHelper.setClassLoader(warClassLoader);
            }
            FilterInstanceWrapper filterInstanceWrapper = this._loadFilter(filterName);
            return filterInstanceWrapper;
        }
        finally {
            ThreadContextHelper.setClassLoader(origClassLoader);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FilterInstanceWrapper _loadFilter(String filterName) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "_loadFilter", "filter--->" + filterName);
        }
        FilterInstanceWrapper fiw = null;
        Filter filter = null;
        try {
            ManagedObject mo;
            IFilterConfig filterConfig;
            block26: {
                filterConfig = this.webAppConfig.getFilterInfo(filterName);
                filterConfig.setIServletContext((IServletContext)this.webApp.getFacade());
                String filterClass = filterConfig.getFilterClassName();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "Instantiating Filter Class: {0}", filterClass);
                }
                mo = null;
                try {
                    String serializedName;
                    ClassLoader loader;
                    InputStream is;
                    if (filterConfig.getFilter() != null) {
                        filter = filterConfig.getFilter();
                        mo = this.webApp.getCdiContexts().remove(filter);
                        break block26;
                    }
                    if (filterConfig.getFilterClass() != null) {
                        mo = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webApp).injectAndPostConstruct(filterConfig.getFilterClass(), filterConfig.getFilterClassLoader());
                        filter = (Filter)mo.getObject();
                        break block26;
                    }
                    final ClassLoader filterLoader = filterConfig.getFilterClassLoader();
                    if (filterLoader != null) {
                        String serializedName2;
                        InputStream is2;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "FilterConfig classloader: " + filterLoader);
                        }
                        if ((is2 = (InputStream)AccessController.doPrivileged(new PrivilegedAction(serializedName2 = filterClass.replace('.', '/').concat(".ser")){
                            final /* synthetic */ String val$serializedName;
                            {
                                this.val$serializedName = string;
                            }

                            public Object run() {
                                return filterLoader.getResourceAsStream(this.val$serializedName);
                            }
                        })) != null) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "serialized filter exists: " + serializedName2);
                            }
                            filter = (Filter)Beans.instantiate(filterLoader, filterClass);
                            mo = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webApp).injectAndPostConstruct(filter);
                        } else {
                            Class<?> fClass = filterLoader.loadClass(filterClass);
                            mo = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webApp).injectAndPostConstruct(fClass);
                            filter = (Filter)mo.getObject();
                        }
                        filterConfig.setFilterClassLoader(null);
                        break block26;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "_loadFilter", "Filter default classloader: " + this.webApp.getClassLoader());
                    }
                    if ((is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(loader = this.webApp.getClassLoader(), serializedName = filterClass.replace('.', '/').concat(".ser")){
                        final /* synthetic */ ClassLoader val$loader;
                        final /* synthetic */ String val$serializedName;
                        {
                            this.val$loader = classLoader;
                            this.val$serializedName = string;
                        }

                        public Object run() {
                            return this.val$loader.getResourceAsStream(this.val$serializedName);
                        }
                    })) != null) {
                        filter = (Filter)Beans.instantiate(loader, filterClass);
                        mo = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webApp).injectAndPostConstruct(filter);
                    } else {
                        Class<?> fClass = loader.loadClass(filterClass);
                        mo = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webApp).injectAndPostConstruct(fClass);
                        filter = (Filter)mo.getObject();
                    }
                }
                catch (ClassNotFoundException e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "298", this);
                    throw new ServletException(MessageFormat.format(nls.getString("Could.not.find.required.filter.class", "Filter [{0}]: Could not find required filter class - {1}.class"), filterName, filterClass), (Throwable)e);
                }
                catch (ClassCastException e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "303", this);
                    throw new ServletException(MessageFormat.format(nls.getString("Filter.not.a.filter.class", "Filter [{0}]: not a filter class"), filterName), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "308", this);
                    throw new ServletException(MessageFormat.format(nls.getString("Filter.was.found.but.is.missing.another.required.class", "Filter [{0}]: {1} was found, but is missing another required class.\n"), filterName, filterClass), (Throwable)e);
                }
                catch (ClassFormatError e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "313", this);
                    throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.corrupt", "Filter [{0}]: {1} was found, but is corrupt:\n"), filterName, filterClass), (Throwable)e);
                }
            }
            fiw = this.createFilterInstanceWrapper(filterName, filter, mo);
            fiw.init(filterConfig);
            this._filterWrappers.put(filterName, fiw);
            if (null != filter) {
                this.webApp.getCdiContexts().remove(filter);
            }
        }
        catch (ServletException e) {
            try {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "380", this);
                throw e;
                catch (InjectionException ie) {
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", (String)"381", (Object)this);
                    throw new ServletException(MessageFormat.format(nls.getString("Filter.found.but.injection.failure", "The [{0}] filter was found but a resource injection failure has occurred:\n"), filterName), (Throwable)ie);
                }
                catch (Throwable th) {
                    FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterManager.loadFilter", "385", this);
                    throw new ServletException(MessageFormat.format("Filter [{0}]: could not be loaded", filterName), th);
                }
            }
            catch (Throwable throwable) {
                if (null != filter) {
                    this.webApp.getCdiContexts().remove(filter);
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "_loadFilter");
        }
        return fiw;
    }

    protected FilterInstanceWrapper createFilterInstanceWrapper(String filterName, Filter filter, ManagedObject mo) throws InjectionException {
        return new FilterInstanceWrapper(filterName, filter, this._evtSource, mo);
    }

    private FilterChainContents getFilterChainContents(String reqURI, String reqServletName, DispatcherType dispatcherType, boolean servletIsInternal) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getFilterChainContents", "reqUri->" + reqURI + ", reqServletName->" + reqServletName + ", mode->" + dispatcherType + ", servletIsInternal->" + servletIsInternal);
        }
        FilterChainContents fcc = null;
        String strippedUri = null;
        if (reqURI != null) {
            int queryIndex = reqURI.indexOf("?");
            strippedUri = queryIndex > 0 ? reqURI.substring(0, queryIndex) : reqURI;
            int semicolon = strippedUri.indexOf(59);
            if (semicolon != -1) {
                strippedUri = strippedUri.substring(0, semicolon);
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "strippedUri->" + strippedUri);
            }
            if (dispatcherType == DispatcherType.REQUEST) {
                fcc = (FilterChainContents)this.chainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter request mode, get cache entry fcc->" + fcc);
                }
            } else if (dispatcherType == DispatcherType.FORWARD) {
                fcc = (FilterChainContents)this.forwardChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter forward mode, get cache entry fcc->" + fcc);
                }
            } else if (dispatcherType == DispatcherType.INCLUDE) {
                fcc = (FilterChainContents)this.includeChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter include mode, get cache entry fcc->" + fcc);
                }
            } else if (dispatcherType == DispatcherType.ERROR) {
                fcc = (FilterChainContents)this.errorChainCache.get(strippedUri);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter error mode, get cache entry fcc->" + fcc);
                }
            }
        } else if (dispatcherType == DispatcherType.REQUEST) {
            fcc = (FilterChainContents)this.chainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter request mode, get cache entry fcc->" + fcc);
            }
        } else if (dispatcherType == DispatcherType.FORWARD) {
            fcc = (FilterChainContents)this.forwardChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter forward mode, get cache entry fcc->" + fcc);
            }
        } else if (dispatcherType == DispatcherType.INCLUDE) {
            fcc = (FilterChainContents)this.includeChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter include mode, get cache entry fcc->" + fcc);
            }
        } else if (dispatcherType == DispatcherType.ERROR) {
            fcc = (FilterChainContents)this.errorChainCache.get(reqServletName);
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter error mode, get cache entry fcc->" + fcc);
            }
        }
        if (fcc == null) {
            List<IFilterMapping> servletFilterMappings;
            int i;
            int nbrOfMappings;
            List<IFilterMapping> uriFilterMappings;
            fcc = new FilterChainContents();
            if (strippedUri != null && (uriFilterMappings = this.webAppConfig.getUriFilterMappings()) != null) {
                nbrOfMappings = uriFilterMappings.size();
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "number of uri filter mapping->" + nbrOfMappings);
                }
                for (i = 0; i < nbrOfMappings; ++i) {
                    IFilterMapping fmInfo = uriFilterMappings.get(i);
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter mapping info->" + fmInfo);
                    }
                    if (!servletIsInternal && servletIsInternal != fmInfo.getFilterConfig().isInternal() || !this.uriMatch(strippedUri, fmInfo, dispatcherType)) continue;
                    fcc.addFilter(fmInfo.getFilterConfig().getFilterName());
                }
            }
            if ((servletFilterMappings = this.webAppConfig.getServletFilterMappings()) != null) {
                nbrOfMappings = servletFilterMappings.size();
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "number of servlet filter mapping->" + nbrOfMappings);
                }
                block1: for (i = 0; i < nbrOfMappings; ++i) {
                    IFilterMapping fmInfo = servletFilterMappings.get(i);
                    String filterServlet = fmInfo.getServletConfig().getServletName();
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "filter mapping info->" + fmInfo);
                    }
                    if (filterServlet != null) {
                        int j;
                        if (reqServletName.equals(filterServlet)) {
                            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "matches servlet name");
                            }
                            for (j = 0; j < fmInfo.getDispatchMode().length; ++j) {
                                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "current dispatch mode->" + fmInfo.getDispatchMode()[j]);
                                }
                                if (!servletIsInternal && servletIsInternal != fmInfo.getFilterConfig().isInternal() || dispatcherType != fmInfo.getDispatchMode()[j]) continue;
                                fcc.addFilter(fmInfo.getFilterConfig().getFilterName());
                                continue block1;
                            }
                            continue;
                        }
                        if (!filterServlet.equals("*")) continue;
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "matches *");
                        }
                        for (j = 0; j < fmInfo.getDispatchMode().length; ++j) {
                            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getFilterChainContents", "current dispatch mode->" + fmInfo.getDispatchMode()[j]);
                            }
                            if (fmInfo.getDispatchMode()[j] != DispatcherType.FORWARD && fmInfo.getDispatchMode()[j] != DispatcherType.INCLUDE || !servletIsInternal && servletIsInternal != fmInfo.getFilterConfig().isInternal() || dispatcherType != fmInfo.getDispatchMode()[j]) continue;
                            fcc.addFilter(fmInfo.getFilterConfig().getFilterName());
                            continue block1;
                        }
                        continue;
                    }
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "getFilterChainContents", "Null.Filter.Mapping");
                }
            }
            if (strippedUri != null) {
                if (dispatcherType == DispatcherType.REQUEST) {
                    this.chainCache.put(strippedUri, fcc);
                } else if (dispatcherType == DispatcherType.FORWARD) {
                    this.forwardChainCache.put(strippedUri, fcc);
                } else if (dispatcherType == DispatcherType.INCLUDE) {
                    this.includeChainCache.put(strippedUri, fcc);
                } else if (dispatcherType == DispatcherType.ERROR) {
                    this.errorChainCache.put(strippedUri, fcc);
                }
            } else if (dispatcherType == DispatcherType.REQUEST) {
                this.chainCache.put(reqServletName, fcc);
            } else if (dispatcherType == DispatcherType.FORWARD) {
                this.forwardChainCache.put(reqServletName, fcc);
            } else if (dispatcherType == DispatcherType.INCLUDE) {
                this.includeChainCache.put(reqServletName, fcc);
            } else if (dispatcherType == DispatcherType.ERROR) {
                this.errorChainCache.put(reqServletName, fcc);
            }
        }
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getFilterChainContents");
        }
        return fcc;
    }

    private boolean uriMatch(String requestURI, IFilterMapping fmInfo, DispatcherType dispatcherType) {
        boolean theyMatch = false;
        switch (fmInfo.getMappingType()) {
            case 0: {
                if (!requestURI.equals("/")) break;
                theyMatch = true;
                break;
            }
            case 1: {
                if (!requestURI.startsWith(fmInfo.getUrlPattern() + "/") && !requestURI.equals(fmInfo.getUrlPattern())) break;
                theyMatch = true;
                break;
            }
            case 2: {
                String ext = fmInfo.getUrlPattern().substring(2);
                int index = requestURI.lastIndexOf(46);
                if (index == -1 || !ext.equals(requestURI.substring(index + 1))) break;
                theyMatch = true;
                break;
            }
            case 3: {
                if (!requestURI.equals(fmInfo.getUrlPattern())) break;
                theyMatch = true;
                break;
            }
        }
        boolean dispMatch = false;
        if (theyMatch) {
            for (int i = 0; i < fmInfo.getDispatchMode().length; ++i) {
                if (dispatcherType != fmInfo.getDispatchMode()[i]) continue;
                dispMatch = true;
                break;
            }
        }
        return dispMatch && theyMatch;
    }

    public void doFilter(ServletRequest request, ServletResponse response, RequestProcessor requestProcessor, WebAppDispatcherContext dispatchContext) throws ServletException, IOException {
        WebAppFilterChain fc;
        String nested;
        boolean isNested;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "doFilter");
        }
        boolean bl = isNested = (nested = (String)request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested")) != null && nested.equalsIgnoreCase("true");
        if (!isNested) {
            fc = this.getFilterChain(request, dispatchContext.getRelativeUri(), requestProcessor, DispatcherType.REQUEST);
        } else if (request.getDispatcherType() == DispatcherType.ERROR) {
            fc = this.getFilterChain(request, dispatchContext.getRelativeUri(), requestProcessor, DispatcherType.ERROR);
        } else if (request.getDispatcherType() == DispatcherType.INCLUDE) {
            String attr = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (attr == null) {
                fc = this.getFilterChain(request, null, requestProcessor, DispatcherType.INCLUDE);
            } else {
                StringBuffer relUri = new StringBuffer(attr);
                String pi = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pi != null) {
                    relUri.append(pi);
                }
                String ru = relUri.toString();
                fc = this.getFilterChain(request, ru, requestProcessor, DispatcherType.INCLUDE);
            }
        } else {
            fc = request.getDispatcherType() == DispatcherType.FORWARD ? this.getFilterChain(request, dispatchContext.getRelativeUri(), requestProcessor, DispatcherType.FORWARD) : (request.getDispatcherType() == DispatcherType.ASYNC ? this.getFilterChain(request, dispatchContext.getRelativeUri(), requestProcessor, DispatcherType.ASYNC) : this.getFilterChain(request, dispatchContext.getRelativeUri(), requestProcessor, DispatcherType.REQUEST));
        }
        if (requestProcessor != null) {
            fc.setRequestProcessor(requestProcessor);
        }
        fc.doFilter(request, response);
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doFilter");
        }
    }

    @Override
    public boolean invokeFilters(ServletRequest request, ServletResponse response, IServletContext context, RequestProcessor requestProcessor, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException {
        return this.invokeFilters(request, response, context, requestProcessor, colEnum, null);
    }

    /*
     * Exception decompiling
     */
    public boolean invokeFilters(ServletRequest request, ServletResponse response, IServletContext context, RequestProcessor requestProcessor, EnumSet<CollaboratorInvocationEnum> colEnum, HttpInboundConnection httpInboundConnection) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WebComponentMetaData getDefaultComponentMetaData() {
        return this.defaultComponentMetaData;
    }

    private boolean isRethrowOriginalException(ServletRequest req, boolean isInclude, boolean isForward) {
        return (isInclude || isForward) && req.getAttribute("com.ibm.wsspi.webcontainer.ignoreDispatchState") == null;
    }

    private String getPath(HttpServletRequest request) {
        int semicolon;
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (pathInfo != null && (semicolon = pathInfo.indexOf(59)) != -1) {
            pathInfo = pathInfo.substring(0, semicolon);
        }
        return servletPath + pathInfo;
    }

    public boolean areFiltersDefined() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "areFiltersDefined", "_filtersDefined->" + this._filtersDefined);
        }
        return this._filtersDefined;
    }

    private boolean setDefaultMethod(HttpServletRequest httpServletReq, String attributeTargetClass, String httpMethod) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setDefaultMethod", "set attribute checkdefaultmethod [" + httpMethod + "] , and [" + attributeTargetClass + "]");
        }
        httpServletReq.setAttribute("com.ibm.ws.webcontainer.security.checkdefaultmethod", (Object)httpMethod);
        httpServletReq.setAttribute(attributeTargetClass, (Object)"TRUE");
        return true;
    }
}

