/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.filter.FilterMapping;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.TargetConfig;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.ws.webcontainer.util.EmptyEnumeration;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;

public class FilterConfig
extends TargetConfig
implements IFilterConfig {
    private static final TraceComponent tc = Tr.register(FilterConfig.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private DispatcherType[] dispatchMode;
    private ClassLoader filterClassLoader = null;
    private boolean isInternal = false;
    private WebAppConfig webAppConfig;
    private Filter filter;
    private Class<? extends Filter> filterClass;
    private List<String> urlPatternMappings;
    private List<String> servletNameMappings;
    protected static TraceNLS nls = TraceNLS.getTraceNLS(ServletConfig.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public FilterConfig(String id, WebAppConfig webAppConfig) {
        super(id);
        this.name = id;
        this.setDisplayName(id);
        this.webAppConfig = webAppConfig;
        this.dispatchMode = null;
    }

    public String getFilterName() {
        return this.name;
    }

    public Enumeration getInitParameterNames() {
        if (this.initParams == null) {
            return EmptyEnumeration.instance();
        }
        return new ArrayEnumeration(this.initParams.keySet().toArray());
    }

    public void loadFrom(Object o) {
    }

    @Override
    public void setDispatchMode(int[] dispatchModeInts) {
        this.dispatchMode = new DispatcherType[dispatchModeInts.length];
        block6: for (int i = 0; i < dispatchModeInts.length; ++i) {
            int dispatchModeCur = dispatchModeInts[i];
            switch (dispatchModeCur) {
                case 0: {
                    this.dispatchMode[i] = DispatcherType.REQUEST;
                    continue block6;
                }
                case 1: {
                    this.dispatchMode[i] = DispatcherType.FORWARD;
                    continue block6;
                }
                case 2: {
                    this.dispatchMode[i] = DispatcherType.INCLUDE;
                    continue block6;
                }
                case 3: {
                    this.dispatchMode[i] = DispatcherType.ERROR;
                    continue block6;
                }
                default: {
                    this.dispatchMode[i] = DispatcherType.REQUEST;
                }
            }
        }
    }

    public void setDispatchType(DispatcherType[] dispatchMode) {
        this.dispatchMode = dispatchMode;
    }

    @Override
    public DispatcherType[] getDispatchType() {
        return this.dispatchMode;
    }

    @Override
    public ClassLoader getFilterClassLoader() {
        return this.filterClassLoader;
    }

    @Override
    public void setFilterClassLoader(ClassLoader filterClassLoader) {
        this.filterClassLoader = filterClassLoader;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) throws IllegalStateException, IllegalArgumentException {
        if (servletNames == null) {
            throw new IllegalArgumentException(nls.getString("add.filter.mapping.to.null.servlet.names"));
        }
        if (servletNames.length == 0) {
            throw new IllegalArgumentException(nls.getString("add.filter.mapping.to.empty.servlet.names"));
        }
        if (this.context != null && this.context.isInitialized()) {
            throw new IllegalStateException(nls.getString("Not.in.servletContextCreated"));
        }
        if (this.servletNameMappings == null) {
            this.servletNameMappings = new ArrayList<String>();
        }
        for (String servletName : servletNames) {
            this.servletNameMappings.add(servletName);
            IServletConfig sConfig = this.webAppConfig.getServletInfo(servletName);
            FilterMapping fmapping = new FilterMapping(null, this, sConfig);
            if (dispatcherTypes != null) {
                DispatcherType[] dispatcherType = new DispatcherType[]{};
                fmapping.setDispatchMode(dispatcherTypes.toArray(dispatcherType));
            }
            if (isMatchAfter) {
                this.webAppConfig.getFilterMappings().add(fmapping);
                continue;
            }
            int previous = this.webAppConfig.getLastIndexBeforeDeclaredFilters();
            this.webAppConfig.getFilterMappings().add(previous, fmapping);
            this.webAppConfig.setLastIndexBeforeDeclaredFilters(++previous);
        }
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) throws IllegalStateException, IllegalArgumentException {
        this.addMappingForUrlPatterns(dispatcherTypes, isMatchAfter, -1, urlPatterns);
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, int index, String ... urlPatterns) throws IllegalStateException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addMappingForUrlPatterns", (Object[])new Object[]{"isMatchAfter -> " + isMatchAfter + " index -> " + index});
        }
        if (urlPatterns == null) {
            throw new IllegalArgumentException(nls.getString("add.filter.mapping.to.null.url.patterns"));
        }
        if (urlPatterns.length == 0) {
            throw new IllegalArgumentException(nls.getString("add.filter.mapping.to.empty.url.patterns"));
        }
        if (this.context != null && this.context.isInitialized()) {
            throw new IllegalStateException(nls.getString("Not.in.servletContextCreated"));
        }
        if (this.urlPatternMappings == null) {
            this.urlPatternMappings = new ArrayList<String>();
        }
        for (String urlPattern : urlPatterns) {
            this.urlPatternMappings.add(urlPattern);
            FilterMapping fmapping = new FilterMapping(urlPattern, this, null);
            if (dispatcherTypes != null) {
                DispatcherType[] dispatcherType = new DispatcherType[]{};
                fmapping.setDispatchMode(dispatcherTypes.toArray(dispatcherType));
            }
            if (isMatchAfter) {
                if (index < 0) {
                    this.webAppConfig.getFilterMappings().add(fmapping);
                    continue;
                }
                this.webAppConfig.getFilterMappings().add(index, fmapping);
                continue;
            }
            int previous = this.webAppConfig.getLastIndexBeforeDeclaredFilters();
            this.webAppConfig.getFilterMappings().add(previous, fmapping);
            this.webAppConfig.setLastIndexBeforeDeclaredFilters(++previous);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addMappingForUrlPatterns", (Object)("isMatchAfter -> " + isMatchAfter + " index -> " + index));
        }
    }

    public Collection<String> getServletNameMappings() {
        return this.servletNameMappings;
    }

    public Collection<String> getUrlPatternMappings() {
        return this.urlPatternMappings;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String getClassName() {
        String className = super.getClassName();
        if (className != null) {
            return className;
        }
        if (this.filterClass != null) {
            return this.filterClass.getName();
        }
        if (this.filter != null) {
            return this.filter.getClass().getName();
        }
        return null;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }

    @Override
    public void setFilterClass(Class<? extends Filter> filterClass) {
        this.filterClass = filterClass;
    }

    @Override
    public String getFilterClassName() {
        return this.getClassName();
    }

    @Override
    public void setFilterClassName(String className) {
        this.setClassName(className);
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        Filter filter = this.getFilter();
        String filterObjectsClassName = null;
        if (filter != null) {
            filterObjectsClassName = filter.getClass().getName();
        }
        strBuilder.append("Filter->" + filterObjectsClassName);
        strBuilder.append(",FilterClass->" + this.getFilterClass());
        strBuilder.append(",FilterClassLoader->" + this.getFilterClassLoader());
        strBuilder.append(",FilterClassName->" + this.getFilterClassName());
        strBuilder.append(",FilterName->" + this.getFilterName());
        strBuilder.append(",ServletContext->" + this.getServletContext());
        strBuilder.append(",UrlPatternMappings->" + this.getUrlPatternMappings());
        strBuilder.append(",ServletNameMappings->" + this.getServletNameMappings());
        Map<String, String> localInitParams = this.getInitParameters();
        for (Map.Entry<String, String> entry : localInitParams.entrySet()) {
            strBuilder.append(",initParams->" + entry.getKey() + "," + entry.getValue());
        }
        strBuilder.append(super.toString());
        return strBuilder.toString();
    }
}

