/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs21.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBusFactory;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBusListener;
import com.ibm.ws.jaxrs21.threading.LibertyJaxRsAutomaticWorkQueueImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threading.WSExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.cxf.Bus;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class LibertyJaxRsThreadPoolAdapter {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsThreadPoolAdapter.class);
    private static final AtomicServiceReference<WSExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private static final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private static final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    private AutomaticWorkQueue automaticeWorkQueue;
    private LibertyAutomaticWorkQueueBusListener workQueueBusListener;
    static final long serialVersionUID = 4808477919489338490L;

    public static AtomicServiceReference<ClassLoadingService> getClassLoadingServiceref() {
        return classLoadingServiceSR;
    }

    public static AtomicServiceReference<ScheduledExecutorService> getScheduledexecutorserviceref() {
        return scheduledExecutorServiceRef;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        executorServiceRef.activate(cc);
        scheduledExecutorServiceRef.activate(cc);
        classLoadingServiceSR.activate(cc);
        WSExecutorService executorService = (WSExecutorService)executorServiceRef.getService();
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)scheduledExecutorServiceRef.getService();
        if (executorService != null && scheduledExecutorService != null) {
            this.automaticeWorkQueue = new LibertyJaxRsAutomaticWorkQueueImpl(scheduledExecutorService, executorService);
            this.workQueueBusListener = new LibertyAutomaticWorkQueueBusListener();
            LibertyApplicationBusFactory.getInstance().registerApplicationBusListener(this.workQueueBusListener);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LibertyAutomaticWorkQueueBusListener is registered into LibertyApplicationBusFactory", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyAutomaticWorkQueueBusListener is not registered into LibertyApplicationBusFactory due to executorService {0} or scheduledExecutorService {1}", (Object[])new Object[]{executorService == null ? "NULL" : "NOT NULL", scheduledExecutorService == null ? "NULL" : "NOT NULL"});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        executorServiceRef.deactivate(cc);
        scheduledExecutorServiceRef.deactivate(cc);
        classLoadingServiceSR.deactivate(cc);
        if (this.workQueueBusListener != null) {
            LibertyApplicationBusFactory.getInstance().unregisterApplicationBusListener(this.workQueueBusListener);
        }
    }

    @Reference(name="executorService", service=WSExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutorService(ServiceReference<WSExecutorService> reference) {
        executorServiceRef.setReference(reference);
    }

    protected void unsetExecutorService(ServiceReference<WSExecutorService> reference) {
        executorServiceRef.unsetReference(reference);
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> reference) {
        scheduledExecutorServiceRef.setReference(reference);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> reference) {
        scheduledExecutorServiceRef.unsetReference(reference);
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> reference) {
        classLoadingServiceSR.setReference(reference);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> reference) {
        classLoadingServiceSR.unsetReference(reference);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class LibertyAutomaticWorkQueueBusListener
    implements LibertyApplicationBusListener {
        static final long serialVersionUID = 4618672294158653098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LibertyAutomaticWorkQueueBusListener() {
        }

        @Override
        public void preInit(Bus bus) {
        }

        @Override
        public void initComplete(Bus bus) {
            if (LibertyJaxRsThreadPoolAdapter.this.automaticeWorkQueue != null) {
                ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).addNamedWorkQueue("default", LibertyJaxRsThreadPoolAdapter.this.automaticeWorkQueue);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The default automticWorkQueue is added to bus " + bus.getId()), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The default automticWorkQueue is NOT added to bus " + bus.getId() + " due to null automaticWorkQueue"), (Object[])new Object[0]);
            }
        }

        @Override
        public void preShutdown(Bus bus) {
        }

        @Override
        public void postShutdown(Bus bus) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LibertyAutomaticWorkQueueBusListener.class);
        }
    }
}

