/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.impl.managedobject.AbstractManagedObjectFactory;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObjectState;
import com.ibm.ws.cdi.impl.managedobject.EJBInterceptorAroundConstructCallback;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CDIEJBManagedObjectFactoryImpl<T>
extends AbstractManagedObjectFactory<T>
implements ManagedObjectFactory<T> {
    private static final TraceComponent tc = Tr.register(CDIEJBManagedObjectFactoryImpl.class);
    private String ejbName = null;
    private ManagedObjectFactory<T> defaultEJBManagedObjectFactory = null;
    private EjbDescriptor<T> ejbDescriptor;
    private Bean<T> ejbBean;
    private WebSphereBeanDeploymentArchive ejbBDA;
    private WeldManager ejbBeanManager;
    private boolean ejbBeanLookupComplete;
    static final long serialVersionUID = 2696588813055436384L;

    public CDIEJBManagedObjectFactoryImpl(Class<T> classToManage, String ejbName, CDIRuntime cdiRuntime, ManagedObjectFactory<T> defaultEJBManagedObjectFactory) {
        super(classToManage, cdiRuntime, false);
        this.ejbName = ejbName;
        this.defaultEJBManagedObjectFactory = defaultEJBManagedObjectFactory;
    }

    @Override
    protected synchronized WeldManager getBeanManager() {
        if (this.ejbBeanManager == null) {
            this.getEjbDescriptor();
        }
        return this.ejbBeanManager;
    }

    @Override
    protected synchronized WebSphereBeanDeploymentArchive getCurrentBeanDeploymentArchive() {
        if (this.ejbBDA == null) {
            this.getEjbDescriptor();
        }
        return this.ejbBDA;
    }

    @Override
    public ManagedObjectContext createContext() {
        Bean<T> bean = null;
        EjbDescriptor<T> ejbDescriptor = this.getEjbDescriptor();
        if (!ejbDescriptor.isMessageDriven()) {
            bean = this.getBean();
        }
        WeldManager beanManager = this.getBeanManager();
        WeldCreationalContext creationalContext = beanManager.createCreationalContext(bean);
        CDIManagedObjectState managedObjectContext = new CDIManagedObjectState(creationalContext);
        return managedObjectContext;
    }

    @Override
    protected synchronized Bean<T> getBean() {
        if (!this.ejbBeanLookupComplete) {
            EjbDescriptor<T> ejbDescriptor;
            WeldManager beanManager = this.getBeanManager();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Looking for EJB Bean: " + this.ejbName), (Object[])new Object[0]);
            }
            if ((ejbDescriptor = this.getEjbDescriptor()) != null) {
                this.ejbBean = beanManager.getBean(ejbDescriptor);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.ejbBean != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found EJB Bean: " + this.ejbBean), (Object[])new Object[0]);
                }
            }
            this.ejbBeanLookupComplete = true;
            if (this.ejbBean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a bean of class : " + this.ejbBean.getBeanClass()), (Object[])new Object[0]);
                }
                if (!this.ejbBean.getBeanClass().equals(this.getManagedObjectClass())) {
                    throw new IllegalStateException("Managed Class {" + this.getManagedObjectClass().getName() + "} does not match Bean Class {" + this.ejbBean.getBeanClass().getName() + "}");
                }
            }
        }
        return this.ejbBean;
    }

    private synchronized EjbDescriptor<T> getEjbDescriptor() {
        if (this.ejbDescriptor == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Looking for EJB Bean: " + this.ejbName), (Object[])new Object[0]);
            }
            WebSphereBeanDeploymentArchive bda = super.getCurrentBeanDeploymentArchive();
            WeldManager beanManager = null;
            beanManager = bda != null ? (WeldManager)bda.getBeanManager() : (WeldManager)this.getCDIRuntime().getCurrentBeanManager();
            EjbDescriptor ejbDescriptor = beanManager.getEjbDescriptor(this.ejbName);
            if (ejbDescriptor == null) {
                Set children = bda.getDescendantBdas();
                Iterator itr = children.iterator();
                while (ejbDescriptor == null && itr.hasNext()) {
                    bda = (WebSphereBeanDeploymentArchive)itr.next();
                    beanManager = (WeldManager)bda.getBeanManager();
                    ejbDescriptor = beanManager.getEjbDescriptor(this.ejbName);
                }
                if (ejbDescriptor == null) {
                    children = bda.getWebSphereBeanDeploymentArchives();
                    itr = children.iterator();
                    while (ejbDescriptor == null && itr.hasNext()) {
                        bda = (WebSphereBeanDeploymentArchive)itr.next();
                        beanManager = (WeldManager)bda.getBeanManager();
                        ejbDescriptor = beanManager.getEjbDescriptor(this.ejbName);
                    }
                }
            }
            if (ejbDescriptor != null) {
                this.ejbDescriptor = ejbDescriptor;
                this.ejbBeanManager = beanManager;
                this.ejbBDA = bda;
            }
        }
        if (this.ejbDescriptor == null) {
            Tr.error((TraceComponent)tc, (String)("Could not find an EjbDescriptor for : " + this.ejbName), (Object[])new Object[0]);
        }
        return this.ejbDescriptor;
    }

    @Override
    public ManagedObject<T> createManagedObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedObject<T> createManagedObject(ManagedObjectInvocationContext<T> invocationContext) throws ManagedObjectException {
        if (this.getBean() == null) {
            return this.defaultEJBManagedObjectFactory.createManagedObject(invocationContext);
        }
        return super.createManagedObject(invocationContext);
    }

    @Override
    protected InjectionTarget<T> getInjectionTarget(boolean nonContextual) {
        EjbDescriptor<T> ejbDescriptor = this.getEjbDescriptor();
        InjectionTarget injectionTarget = this.getBeanManager().createInjectionTarget(ejbDescriptor);
        return injectionTarget;
    }

    @Override
    protected WeldCreationalContext<T> getCreationalContext(ManagedObjectInvocationContext<T> invocationContext) {
        ManagedObjectContext managedObjectContext = invocationContext.getManagedObjectContext();
        WeldCreationalContext creationalContext = (WeldCreationalContext)managedObjectContext.getContextData(WeldCreationalContext.class);
        EJBInterceptorAroundConstructCallback<T> callback = new EJBInterceptorAroundConstructCallback<T>(invocationContext);
        creationalContext.registerAroundConstructCallback(callback);
        creationalContext.setConstructorInterceptionSuppressed(true);
        return creationalContext;
    }

    public String toString() {
        return "CDI EJB Managed Object Factory for class: " + this.getManagedObjectClass().getName();
    }
}

