/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.jandex.internal.Jandex_Utils;
import com.ibm.ws.anno.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedJar;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_MappedJar
extends ClassSourceImpl
implements ClassSource_MappedJar {
    public static final String CLASS_NAME = ClassSourceImpl_MappedJar.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_MappedJar.class);
    protected int opens;
    protected final String jarPath;
    protected JarFile jarFile;
    static final long serialVersionUID = -7968250068631327008L;

    @Trivial
    public ClassSourceImpl_MappedJar(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_Options options, String jarPath) throws ClassSource_Exception {
        super(factory, internMap, name, options, jarPath);
        this.jarPath = jarPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (tc.isEntryEnabled()) {
            String msg = MessageFormat.format("[ {0} ] State [ {1} ]", this.getHashText(), this.opens);
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{msg});
        }
        if (this.opens < 0 || this.opens == 0 && this.jarFile != null || this.opens > 0 && this.jarFile == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_JAR_STATE_BAD", (Object[])new Object[]{this.getHashText(), this.getJarPath(), this.opens});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + this.getJarPath() + " ] Count of opens [ " + this.opens + " ] Jar state [ " + this.jarFile + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        ++this.opens;
        if (this.jarFile == null) {
            try {
                this.jarFile = UtilImpl_FileUtils.createJarFile(this.jarPath);
            }
            catch (IOException eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"101", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_OPEN4_EXCEPTION", (Object[])new Object[]{this.getHashText(), this.jarPath});
                String eMsg2 = "[ " + this.getHashText() + " ] Failed to open [ " + this.jarPath + " ]";
                throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] RETURN (new open)", this.getHashText()));
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] RETURN (already open)", this.getHashText()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        JarFile useJarFile = this.getJarFile();
        if (this.opens < 0 || this.opens == 0 && useJarFile != null || this.opens > 0 && useJarFile == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_JAR_STATE_BAD", (Object[])new Object[]{this.getHashText(), this.getJarPath(), this.opens});
            this.opens = 0;
            useJarFile = this.clearJarFile();
            if (useJarFile != null) {
                try {
                    useJarFile.close();
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"146", (Object)this, (Object[])new Object[0]);
                    String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + this.getJarPath() + " ]";
                    throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
            }
            String eMsg = "[ " + this.getHashText() + " ] Close with open count [ " + this.opens + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        if (--this.opens == 0) {
            useJarFile = this.clearJarFile();
            try {
                useJarFile.close();
            }
            catch (IOException eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"166", (Object)this, (Object[])new Object[0]);
                String eMsg2 = "[ " + this.getHashText() + " ] Failed to close [ " + this.getJarPath() + " ]";
                throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    @Override
    @Trivial
    public String getJarPath() {
        return this.jarPath;
    }

    @Trivial
    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected JarFile clearJarFile() {
        JarFile useJarFile = this.jarFile;
        this.jarFile = null;
        return useJarFile;
    }

    @Override
    @Trivial
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return this.scanCounts.getResult(resultField);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processFromScratch(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        JarFile useJarFile = this.getJarFile();
        Enumeration<JarEntry> jarEntries = useJarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            String nextEntryName = nextEntry.getName();
            if (this.isDirectoryResource(nextEntryName)) {
                this.incrementResourceExclusionCount();
                this.markResult(ClassSource_ScanCounts.ResultField.CONTAINER);
                this.markResult(ClassSource_ScanCounts.ResultField.NON_ROOT_CONTAINER);
            } else {
                if (!this.isClassResource(nextEntryName)) {
                    this.incrementResourceExclusionCount();
                    this.markResult(ClassSource_ScanCounts.ResultField.NON_CLASS);
                } else {
                    String nextClassName = this.getClassNameFromResourceName(nextEntryName);
                    if (this.isJava9SpecificClass(nextClassName)) {
                        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Unsupported class; skipping [ {1} ]", this.getHashText(), nextClassName), (Object[])new Object[0]);
                        continue;
                    }
                    String i_nextClassName = this.internClassName(nextClassName);
                    boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
                    if (!didAdd) {
                        this.incrementClassExclusionCount();
                        this.markResult(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                    } else {
                        boolean didProcess;
                        this.incrementClassInclusionCount();
                        try {
                            didProcess = this.process(streamer, nextClassName, nextEntryName, scanPolicy);
                        }
                        catch (ClassSource_Exception classSource_Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"279", (Object)this, (Object[])new Object[]{streamer, i_seedClassNames, scanPolicy});
                            didProcess = false;
                            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                        }
                        if (didProcess) {
                            this.markResult(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                        } else {
                            this.markResult(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
                        }
                    }
                    this.markResult(ClassSource_ScanCounts.ResultField.CLASS);
                }
                this.markResult(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            }
            this.markResult(ClassSource_ScanCounts.ResultField.ENTRY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ClassSource_Streamer streamer, String className, String resourceName, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(className, resourceName);
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, inputStream);
        }
        return true;
    }

    @Override
    protected boolean basicHasJandexIndex() {
        return this.getJarFile().getJarEntry(this.getJandexIndexPath()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Index basicGetJandexIndex() {
        InputStream jandexStream;
        String useJandexIndexPath = this.getJandexIndexPath();
        try {
            jandexStream = this.openResourceStream(null, useJandexIndexPath);
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"351", (Object)this, (Object[])new Object[0]);
            String errorMessage = "Failed to read [ " + useJandexIndexPath + " ] from [ " + this.getCanonicalName() + " ] as JANDEX index: " + e.getMessage();
            Tr.error((TraceComponent)tc, (String)errorMessage, (Object[])new Object[0]);
            return null;
        }
        if (jandexStream == null) {
            return null;
        }
        try {
            Index jandexIndex = Jandex_Utils.basicReadIndex(jandexStream);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Read JANDEX index [ {1} ] from [ {2} ] Classes  [ {3} ]", this.getHashText(), useJandexIndexPath, this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size())), (Object[])new Object[0]);
            }
            return jandexIndex;
        }
        catch (IOException jandexIndex) {
            void e;
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"372", (Object)this, (Object[])new Object[0]);
            String eMsg = "Failed to read [ " + useJandexIndexPath + " ] from [ " + this.getCanonicalName() + " ] as JANDEX index: " + e.getMessage();
            Tr.error((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        InputStream inputStream;
        String methodName = "openResourceStream";
        JarFile useJarFile = this.getJarFile();
        JarEntry jarEntry = useJarFile.getJarEntry(resourceName);
        if (jarEntry == null) {
            return null;
        }
        try {
            inputStream = useJarFile.getInputStream(jarEntry);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"402", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] in [ " + this.getJarPath() + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        return inputStream;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedJar", (String)"424", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE6_EXCEPTION", (Object[])new Object[]{this.getHashText(), resourceName, className, this.getJarPath()});
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.logCounts(logger);
    }
}

