/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ScanCounts;
import com.ibm.ws.anno.jandex.internal.Jandex_Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.FastModeControl;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_MappedContainer
extends ClassSourceImpl
implements ClassSource_MappedContainer {
    public static final String CLASS_NAME = ClassSourceImpl_MappedContainer.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_MappedContainer.class);
    protected final Container container;
    protected long startTime;
    protected long endTime;
    protected long streamTime;
    protected long jandexTime;
    public static final String EMPTY_PREFIX = "";
    static final long serialVersionUID = -3433985981669448401L;

    @Trivial
    public ClassSourceImpl_MappedContainer(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_Options options, Container container) throws ClassSource_Exception {
        super(factory, internMap, name, options, String.valueOf(container));
        this.container = container;
    }

    @Override
    @Trivial
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        try {
            FastModeControl fastMode = (FastModeControl)this.getContainer().adapt(FastModeControl.class);
            fastMode.useFastMode();
        }
        catch (UnableToAdaptException e) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to adapt [ " + this.getCanonicalName() + " ] to [ " + FastModeControl.class.getName() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER/RETURN", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        try {
            FastModeControl fastMode = (FastModeControl)this.getContainer().adapt(FastModeControl.class);
            fastMode.stopUsingFastMode();
        }
        catch (UnableToAdaptException e) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + this.getCanonicalName() + " ] to [ " + FastModeControl.class.getName() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER/RETURN", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public Container getContainer() {
        return this.container;
    }

    @Override
    protected void processFromScratch(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.startTimings();
        }
        this.processClasses(this.getContainer(), EMPTY_PREFIX, streamer, i_seedClassNames, this.getScanResults(), scanPolicy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.endTimings();
        }
    }

    protected void startTimings() {
        this.startTime = ClassSourceImpl_MappedContainer.getTime();
        this.streamTime = 0L;
        this.jandexTime = 0L;
    }

    protected void addStreamTime(long additionalTime) {
        this.streamTime += additionalTime;
    }

    protected void addJandexTime(long additionalTime) {
        this.jandexTime += additionalTime;
    }

    @Trivial
    protected void endTimings() {
        this.endTime = ClassSourceImpl_MappedContainer.getTime();
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Start time:  [ {0} ]", this.startTime), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("End time:    [ {0} ]", this.endTime), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Delta time:  [ {0} ]", this.endTime - this.startTime), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Stream time: [ {0} ]", this.streamTime), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Jandex time: [ {0} ]", this.jandexTime), (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    protected void processClasses(Container targetContainer, String prefix, ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSourceImpl_ScanCounts localScanCounts, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        String methodName = "processClasses";
        if (tc.isEntryEnabled()) {
            String msg = MessageFormat.format("[ {0} ] ENTER [ {1} ] of [ {2} ]", this.getHashText(), prefix, targetContainer.getName());
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{msg});
        }
        int initialResources = i_seedClassNames.size();
        for (Entry nextEntry : targetContainer) {
            Container nextChildContainer;
            String nextChildName = nextEntry.getName();
            String nextPrefix = this.resourceAppend(prefix, nextChildName);
            try {
                nextChildContainer = (Container)nextEntry.adapt(Container.class);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"220", (Object)this, (Object[])new Object[]{targetContainer, prefix, streamer, i_seedClassNames, localScanCounts, scanPolicy});
                nextChildContainer = null;
                Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_ADAPT_EXCEPTION", (Object[])new Object[]{this.getHashText(), nextChildName, nextEntry, targetContainer, prefix});
            }
            if (nextChildContainer != null) {
                if (nextChildContainer.isRoot()) {
                    this.incrementResourceExclusionCount();
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.ROOT_CONTAINER);
                } else {
                    ClassSourceImpl_ScanCounts childScanCounts = new ClassSourceImpl_ScanCounts();
                    this.processClasses(nextChildContainer, nextPrefix, streamer, i_seedClassNames, childScanCounts, scanPolicy);
                    localScanCounts.addResults(childScanCounts);
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.ROOT_CONTAINER);
                }
            } else {
                if (!this.isClassResource(nextPrefix)) {
                    this.incrementResourceExclusionCount();
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.NON_CLASS);
                } else {
                    String nextClassName = this.getClassNameFromResourceName(nextPrefix);
                    if (this.isJava9SpecificClass(nextClassName)) {
                        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Unsupported class; skipping [ {1} ]", this.getHashText(), nextClassName), (Object[])new Object[0]);
                        continue;
                    }
                    String i_nextClassName = this.internClassName(nextClassName);
                    boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
                    if (!didAdd) {
                        this.incrementClassExclusionCount();
                        localScanCounts.increment(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                    } else {
                        boolean didProcess;
                        this.incrementClassInclusionCount();
                        try {
                            didProcess = this.process(streamer, nextClassName, nextPrefix, nextEntry, scanPolicy);
                        }
                        catch (ClassSource_Exception classSource_Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"315", (Object)this, (Object[])new Object[]{targetContainer, prefix, streamer, i_seedClassNames, localScanCounts, scanPolicy});
                            didProcess = false;
                            String eMsg = "[ " + this.getHashText() + " ] Failed to process class [ " + nextClassName + " ] under root [ " + this.getContainer() + " ]";
                            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                        }
                        if (didProcess) {
                            localScanCounts.increment(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                        } else {
                            localScanCounts.increment(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
                        }
                    }
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.CLASS);
                }
                localScanCounts.increment(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            }
            localScanCounts.increment(ClassSource_ScanCounts.ResultField.ENTRY);
        }
        int finalResources = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalResources - initialResources;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = localScanCounts.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {0}", logParms), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ClassSource_Streamer streamer, String className, String resourceName, Entry entry, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(className, resourceName, entry);
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, entry, inputStream);
        }
        return true;
    }

    @Override
    @Trivial
    public String getJandexIndexPath() {
        String jandexIndexPath = super.getJandexIndexPath();
        Container useContainer = this.getContainer();
        if (!useContainer.isRoot() && useContainer.getPath().equals("/WEB-INF/classes")) {
            jandexIndexPath = "../.." + jandexIndexPath;
        }
        return jandexIndexPath;
    }

    @Override
    protected boolean basicHasJandexIndex() {
        return this.getContainer().getEntry(this.getJandexIndexPath()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Index basicGetJandexIndex() {
        InputStream jandexStream;
        String useJandexIndexPath = this.getJandexIndexPath();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Looking for JANDEX [ {1} ] in [ {2} ]", this.getHashText(), useJandexIndexPath, this.getContainer().getPhysicalPath()), (Object[])new Object[0]);
        }
        try {
            jandexStream = this.openResourceStream(null, useJandexIndexPath);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"436", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"JANDEX_INDEX_OPEN_EXCEPTION", (Object[])new Object[]{useJandexIndexPath, this.getCanonicalName()});
            return null;
        }
        if (jandexStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] No JANDEX index was found", this.getHashText()), (Object[])new Object[0]);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Located JANDEX index", this.getHashText()), (Object[])new Object[0]);
        }
        long startJandexTime = ClassSourceImpl_MappedContainer.getTime();
        try {
            Index jandexIndex = Jandex_Utils.basicReadIndex(jandexStream);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Read JANDEX index [ {1} ] from [ {2} ]: Classes [ {3} ]", this.getHashText(), useJandexIndexPath, this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size())), (Object[])new Object[0]);
            }
            Index index = jandexIndex;
            return index;
        }
        catch (Exception jandexIndex) {
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"463", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"JANDEX_INDEX_READ_EXCEPTION", (Object[])new Object[]{useJandexIndexPath, this.getCanonicalName()});
            Index index = null;
            return index;
        }
        finally {
            this.closeResourceStream(null, useJandexIndexPath, jandexStream);
            long endJandexTime = ClassSourceImpl_MappedContainer.getTime();
            this.addJandexTime(endJandexTime - startJandexTime);
        }
    }

    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        Entry entry = this.getContainer().getEntry(resourceName);
        if (entry == null) {
            return null;
        }
        return this.openResourceStream(className, resourceName, entry);
    }

    /*
     * WARNING - void declaration
     */
    public InputStream openResourceStream(String className, String resourceName, Entry entry) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        try {
            long initialTime = 0L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                initialTime = ClassSourceImpl_MappedContainer.getTime();
            }
            result = (InputStream)entry.adapt(InputStream.class);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                long finalTime = ClassSourceImpl_MappedContainer.getTime();
                this.addStreamTime(finalTime - initialTime);
            }
        }
        catch (Throwable initialTime) {
            void th;
            FFDCFilter.processException((Throwable)initialTime, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"513", (Object)this, (Object[])new Object[]{className, resourceName, entry});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] as [ " + entry + " ] under root [ " + this.getContainer() + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)th);
        }
        if (result == null) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] as [ " + entry + " ] under root [ " + this.getContainer() + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            throw this.getFactory().newClassSourceException(eMsg);
        }
        return result;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        Entry entry = this.getContainer().getEntry(resourceName);
        if (entry == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_RESOURCE_NOTFOUND", (Object[])new Object[]{this.getHashText(), resourceName, this.getContainer(), className});
        } else {
            this.closeResourceStream(className, resourceName, entry, inputStream);
        }
    }

    protected void closeResourceStream(String className, String resourceName, Entry entry, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedContainer", (String)"574", (Object)this, (Object[])new Object[]{className, resourceName, entry, inputStream});
            String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + resourceName + " ] in [ " + this.getCanonicalName() + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            Tr.warning((TraceComponent)tc, (String)eMsg, (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }
}

