/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.CommsServerByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public abstract class CATConsumer {
    private static String CLASS_NAME = CATConsumer.class.getName();
    protected static final CommsServerByteBufferPool poolManager = CommsServerByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(CATConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    protected boolean started = false;
    protected long messagesSent = 0L;
    protected long batchesSent = 0L;
    protected long requestsReceived = 0L;

    public CATConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected abstract ConsumerSession getConsumerSession();

    protected abstract Conversation getConversation();

    protected abstract int getLowestPriority();

    protected abstract short getClientSessionId();

    protected abstract Reliability getUnrecoverableReliability();

    public void receive(int requestNumber, int tran, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{requestNumber, tran, timeout});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".receive"), (String)"3-019-0001", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
        }
        throw e;
    }

    public void close(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)requestNumber);
        }
        try {
            ConsumerSession cs = this.getConsumerSession();
            if (cs != null) {
                cs.close();
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 201, requestNumber, this.getLowestPriority(), true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-019-0003", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2013", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-019-0002", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-019-0002", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext, boolean stoppable, int maxSequentialFailures, long hiddenMessageDelay) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setAsynchConsumerCallback"), (String)"3-019-0004", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
        throw e;
    }

    public void unsetAsynchConsumerCallback(int requestNumber, boolean stoppable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsetAsynchConsumerCallback", (Object)("requestNumber=" + requestNumber));
        }
        try {
            if (stoppable) {
                this.getConsumerSession().deregisterStoppableAsynchConsumerCallback();
            } else {
                this.getConsumerSession().deregisterAsynchConsumerCallback();
            }
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 212, requestNumber, this.getLowestPriority(), true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unsetAsynchConsumerCallback"), (String)"3-019-0012", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2013", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unsetAsynchConsumerCallback"), (String)"3-019-0013", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-019-0013", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsetAsynchConsumerCallback");
        }
    }

    public void start(int requestNumber, boolean deliverImmediately, boolean sendReply, SendListener sendListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{"" + requestNumber, "" + deliverImmediately, "" + sendReply, sendListener});
        }
        try {
            this.started = true;
            this.getConsumerSession().start(deliverImmediately);
            ++this.requestsReceived;
            if (sendReply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 244, requestNumber, 12, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, sendListener);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".start"), (String)"3-019-0018", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2013", (Object)((Object)e));
                    SIConnectionLostException cle = e instanceof SIConnectionLostException ? (SIConnectionLostException)e : null;
                    sendListener.errorOccurred(cle, this.getConversation());
                }
            } else {
                sendListener.dataSent(this.getConversation());
            }
        }
        catch (SIException e) {
            this.started = false;
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".start"), (String)"3-019-0005", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            if (sendReply) {
                StaticCATHelper.sendExceptionToClient(e, "3-019-0005", this.getConversation(), requestNumber);
            }
            sendListener.errorOccurred(null, this.getConversation());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int requestNumber, SendListener sendListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)new Object[]{requestNumber, sendListener});
        }
        try {
            this.getConsumerSession().stop();
            this.started = false;
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 214, requestNumber, this.getLowestPriority(), true, Conversation.ThrottlingPolicy.BLOCK_THREAD, sendListener);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".stop"), (String)"3-019-0007", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2013", (Object)((Object)e));
                SIConnectionLostException cle = e instanceof SIConnectionLostException ? (SIConnectionLostException)e : null;
                sendListener.errorOccurred(cle, this.getConversation());
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".stop"), (String)"3-019-0006", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-019-0006", this.getConversation(), requestNumber);
            sendListener.errorOccurred(null, this.getConversation());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public void readSet(int requestNumber, SIMessageHandle[] msgHandles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readSet", (Object)new Object[]{requestNumber, msgHandles});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readSet"), (String)"3-019-0016", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readSet");
        }
        throw e;
    }

    public void readAndDeleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet", (Object)new Object[]{requestNumber, msgHandles, tran});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-019-0017", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet");
        }
        throw e;
    }

    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-019-0008", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
        throw e;
    }

    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply, boolean incrementLockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply, incrementLockCount});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-019-0019", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
        throw e;
    }

    public void deleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{requestNumber, msgHandles, tran, reply});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-019-0009", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
        throw e;
    }

    public void unlockAll(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)requestNumber);
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-019-0010", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        throw e;
    }

    public void requestMsgs(int requestNumber, int receivedBytes, int requestedBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestMsgs", (Object)new Object[]{requestNumber, receivedBytes, requestedBytes});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".requestMsgs"), (String)"3-019-0011", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestMsgs");
        }
        throw e;
    }

    public void flush(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)requestNumber);
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".flush"), (String)"3-019-0014", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
        }
        throw e;
    }

    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".reset"), (String)"3-019-0015", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
        throw e;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": Started:" + this.started + ", messagesSent: " + this.messagesSent + ", batchesSent: " + this.batchesSent + ", startRequestsReceived: " + this.requestsReceived;
    }

    public void unlockAll(int requestNumber, boolean incrementUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{requestNumber, incrementUnlockCount});
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_SICO2003", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockAll"), (String)"3-019-0020", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_SICO2003", (Object)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        throw e;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.67.1.1");
        }
    }
}

