/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.loose.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.ArtifactListenerSelector;
import com.ibm.ws.artifact.loose.internal.LooseArchive;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LooseArtifactNotifier
implements ArtifactNotifier,
com.ibm.ws.kernel.filemonitor.FileMonitor {
    private final LooseArchive root;
    private final List<LooseArchive.EntryInfo> entries;
    private final Hashtable<String, Object> serviceProperties = new Hashtable();
    private final Hashtable<String, Object> nonRecurseServiceProperties = new Hashtable();
    private Long interval;
    private String notificationType;
    private final BundleContext ctx;
    private ServiceRegistration<FileMonitor> service = null;
    private ServiceRegistration<FileMonitor> nonRecurseService = null;
    private final NavigableMap<String, Set<String>> filesToMonitor = new TreeMap<String, Set<String>>((Comparator<String>)new PathUtils.PathComparator());
    private final Set<String> filesBeingMonitored = new HashSet<String>();
    private final NavigableMap<String, Set<String>> dirsToMonitor = new TreeMap<String, Set<String>>((Comparator<String>)new PathUtils.PathComparator());
    private final Set<String> dirsBeingMonitored = new HashSet<String>();
    private final Collection<Registration> listeners = new CopyOnWriteArrayList<Registration>();
    private final Set<String> pathsBeingMonitored = new HashSet<String>();
    private final LooseArtifactNotifier parent;
    private final Map<LooseArchive.EntryInfo, LooseArtifactNotifier> children = new HashMap<LooseArchive.EntryInfo, LooseArtifactNotifier>();
    private final Collection<LooseArtifactNotifier> enabledChildren = new ArrayList<LooseArtifactNotifier>();
    private final String pathInParent;
    static final long serialVersionUID = 2923725971363407990L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LooseArtifactNotifier(LooseArchive owner, List<LooseArchive.EntryInfo> entries, BundleContext ctx, LooseArtifactNotifier parent, String pathInParent) {
        this.root = owner;
        this.entries = entries;
        this.ctx = ctx;
        this.parent = parent;
        this.pathInParent = pathInParent;
        for (LooseArchive.EntryInfo info : entries) {
            HashSet<String> dirs;
            String path = info.getVirtualLocation();
            HashSet<String> files = (HashSet<String>)this.filesToMonitor.get(path);
            if (files == null) {
                files = new HashSet<String>();
                this.filesToMonitor.put(path, files);
            }
            if ((dirs = (HashSet<String>)this.dirsToMonitor.get(path)) == null) {
                dirs = new HashSet<String>();
                this.dirsToMonitor.put(path, dirs);
            }
            info.addMonitoringPaths(files, dirs, path);
        }
    }

    private void verifyTargets(ArtifactNotifier.ArtifactNotification targets) throws IllegalArgumentException {
        if (targets.getContainer().getRoot() != this.root) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized boolean registerForNotifications(ArtifactNotifier.ArtifactNotification targets, ArtifactNotifier.ArtifactListener callbackObject) throws IllegalArgumentException {
        this.verifyTargets(targets);
        Registration r = new Registration();
        r.listener = new ArtifactListenerSelector(callbackObject);
        Collection srcPaths = targets.getPaths();
        r.paths = new ArrayList<String>(srcPaths.size());
        for (String path : srcPaths) {
            r.paths.add(path);
        }
        this.listeners.add(r);
        this.pathsBeingMonitored.addAll(r.paths);
        this.reprocessChildrenNotifiers();
        this.processMonitoredPathList();
        return true;
    }

    private synchronized void reprocessChildrenNotifiers() {
        for (LooseArchive.EntryInfo entry : this.children.keySet()) {
            LooseArtifactNotifier childNotifier = this.children.get(entry);
            String monitoredPath = this.getEntryMonitoredPath(entry);
            if (monitoredPath != null) {
                if (this.enabledChildren.contains(childNotifier)) continue;
                HashSet<String> paths = new HashSet<String>();
                paths.add(monitoredPath);
                DefaultArtifactNotification artifactNotification = new DefaultArtifactNotification((ArtifactContainer)childNotifier.root, paths);
                childNotifier.registerForNotifications((ArtifactNotifier.ArtifactNotification)artifactNotification, new ArtifactNotifier.ArtifactListener(){
                    static final long serialVersionUID = 5163919128119168928L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public void notifyEntryChange(ArtifactNotifier.ArtifactNotification added, ArtifactNotifier.ArtifactNotification removed, ArtifactNotifier.ArtifactNotification modified) {
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                this.enabledChildren.add(this.children.get(entry));
                continue;
            }
            if (!this.enabledChildren.contains(childNotifier)) continue;
            childNotifier.removeListener(((Registration)childNotifier.listeners.toArray()[0]).listener.getListener());
            this.enabledChildren.remove(childNotifier);
        }
    }

    private String getEntryMonitoredPath(LooseArchive.EntryInfo entry) {
        if (entry != null) {
            if (this.pathsBeingMonitored.contains("/")) {
                return "/";
            }
            for (String path : this.pathsBeingMonitored) {
                String fixedPath;
                boolean isRecursive = path.startsWith("!");
                String string = fixedPath = isRecursive ? path.substring(1) : path;
                if (isRecursive && entry.matches(fixedPath)) {
                    return "!/";
                }
                if (isRecursive || !entry.matches(fixedPath, false) && !entry.isBeneath(fixedPath)) continue;
                return "/";
            }
        }
        return null;
    }

    private void processMonitoredPathList() {
        HashSet<String> fileSubPaths = new HashSet<String>();
        HashSet<String> dirSubPaths = new HashSet<String>();
        if (this.pathInParent == null && (this.pathsBeingMonitored.contains("/") || this.pathsBeingMonitored.contains("!/"))) {
            fileSubPaths.add(this.root.getXMLFile().getAbsolutePath());
        }
        if (this.pathsBeingMonitored.contains("/")) {
            for (Set s : this.filesToMonitor.values()) {
                fileSubPaths.addAll(s);
            }
            for (Set s : this.dirsToMonitor.values()) {
                dirSubPaths.addAll(s);
            }
        } else {
            for (String path : this.pathsBeingMonitored) {
                String fixedPath = path.startsWith("!") ? path.substring(1) : path;
                for (LooseArchive.EntryInfo ei : this.entries) {
                    if (!ei.matches(fixedPath, false)) continue;
                    ei.addMonitoringPaths(fileSubPaths, dirSubPaths, path);
                }
                for (LooseArchive.EntryInfo ei : this.entries) {
                    if (!ei.isBeneath(fixedPath)) continue;
                    ei.addMonitoringPaths(fileSubPaths, dirSubPaths, path);
                }
            }
        }
        fileSubPaths.remove(null);
        fileSubPaths.remove("");
        dirSubPaths.remove(null);
        dirSubPaths.remove("");
        if (!this.isEqualsCollection(this.filesBeingMonitored, fileSubPaths) || !this.isEqualsCollection(this.dirsBeingMonitored, dirSubPaths)) {
            this.filesBeingMonitored.clear();
            this.filesBeingMonitored.addAll(fileSubPaths);
            this.dirsBeingMonitored.clear();
            this.dirsBeingMonitored.addAll(dirSubPaths);
            this.updateFileMonitorService();
        }
    }

    private boolean isEqualsCollection(Collection<String> left, Collection<String> right) {
        return left.containsAll(right) && right.containsAll(left);
    }

    private void rebuildPaths() {
        this.pathsBeingMonitored.clear();
        for (Registration r : this.listeners) {
            this.pathsBeingMonitored.addAll(r.paths);
        }
    }

    public synchronized boolean removeListener(ArtifactNotifier.ArtifactListener listenerToRemove) {
        ArtifactListenerSelector listenerSelectorToRemove = new ArtifactListenerSelector(listenerToRemove);
        ArrayList<Registration> rToRemove = new ArrayList<Registration>();
        for (Registration r : this.listeners) {
            if (!r.listener.equals((Object)listenerSelectorToRemove)) continue;
            rToRemove.add(r);
        }
        this.listeners.removeAll(rToRemove);
        this.rebuildPaths();
        this.reprocessChildrenNotifiers();
        this.processMonitoredPathList();
        return rToRemove.size() > 0;
    }

    private synchronized void updateFileMonitorService() {
        HashSet<String> nonRecurseFiles = new HashSet<String>();
        HashSet<String> recurseFiles = new HashSet<String>();
        HashSet<String> nonRecurseDirs = new HashSet<String>();
        HashSet<String> recurseDirs = new HashSet<String>();
        for (String file : this.filesBeingMonitored) {
            if (file.startsWith("!")) {
                nonRecurseFiles.add(file.substring(1));
                continue;
            }
            recurseFiles.add(file);
        }
        for (String dir : this.dirsBeingMonitored) {
            if (dir.startsWith("!")) {
                nonRecurseDirs.add(dir.substring(1));
                continue;
            }
            recurseDirs.add(dir);
        }
        this.updateRecurseFileMonitorService(recurseDirs, recurseFiles);
        this.updateNonRecurseFileMonitorService(nonRecurseDirs, nonRecurseFiles);
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void updateRecurseFileMonitorService(Set<String> dirs, Set<String> files) {
        if (this.service == null) {
            this.serviceProperties.put("service.vendor", "IBM");
            this.serviceProperties.put("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
            Long newInterval = 5000L;
            if (this.interval != null) {
                newInterval = this.interval;
            }
            this.serviceProperties.put("monitor.interval", "" + newInterval + "ms");
            String type = this.notificationType;
            if (type == null) {
                type = "timed";
            }
            this.serviceProperties.put("monitor.type", type);
            this.serviceProperties.put("monitor.directories", dirs);
            this.serviceProperties.put("monitor.files", files);
            this.serviceProperties.put("monitor.recurse", true);
            this.serviceProperties.put("monitor.includeself", true);
            this.serviceProperties.put("monitor.filter", ".*");
            try {
                this.service = this.ctx.registerService(FileMonitor.class, (Object)this, this.serviceProperties);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (dirs.size() + files.size() > 0) {
            this.serviceProperties.put("monitor.directories", dirs);
            this.serviceProperties.put("monitor.files", files);
            this.service.setProperties(this.serviceProperties);
        } else {
            try {
                this.service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.service = null;
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void updateNonRecurseFileMonitorService(Set<String> dirs, Set<String> files) {
        if (this.nonRecurseService == null) {
            this.nonRecurseServiceProperties.put("service.vendor", "IBM");
            this.serviceProperties.put("monitor.identification", "com.ibm.ws.kernel.monitor.artifact");
            Long newInterval = 5000L;
            if (this.interval != null) {
                newInterval = this.interval;
            }
            this.nonRecurseServiceProperties.put("monitor.interval", newInterval);
            String type = this.notificationType;
            if (type == null) {
                type = "timed";
            }
            this.nonRecurseServiceProperties.put("monitor.type", type);
            this.nonRecurseServiceProperties.put("monitor.directories", dirs);
            this.nonRecurseServiceProperties.put("monitor.files", files);
            this.nonRecurseServiceProperties.put("monitor.recurse", false);
            this.nonRecurseServiceProperties.put("monitor.includeself", true);
            this.nonRecurseServiceProperties.put("monitor.filter", ".*");
            try {
                this.nonRecurseService = this.ctx.registerService(FileMonitor.class, (Object)this, this.nonRecurseServiceProperties);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (dirs.size() + files.size() > 0) {
            this.nonRecurseServiceProperties.put("monitor.directories", dirs);
            this.nonRecurseServiceProperties.put("monitor.files", files);
            this.nonRecurseService.setProperties(this.nonRecurseServiceProperties);
        } else {
            try {
                this.nonRecurseService.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.nonRecurseService = null;
        }
    }

    public synchronized boolean setNotificationOptions(long interval, boolean useMBean) {
        for (LooseArtifactNotifier childNotification : this.children.values()) {
            childNotification.setNotificationOptions(interval, useMBean);
        }
        Long compareInterval = interval;
        if (compareInterval.equals(this.interval) && (useMBean && "external".equals(this.notificationType) || !useMBean && "timed".equals(this.notificationType))) {
            return true;
        }
        this.interval = compareInterval;
        String string = this.notificationType = useMBean ? "external" : "timed";
        if (this.service != null || this.nonRecurseService != null) {
            this.updateFileMonitorService();
        }
        return true;
    }

    private ArtifactNotifier.ArtifactNotification filterSetByPaths(Set<String> paths, Collection<String> filterBy) {
        HashSet<String> pathsToAdd = new HashSet<String>();
        for (String path : paths) {
            for (String filter : filterBy) {
                boolean nonRecurse = filter.startsWith("!");
                if (nonRecurse) {
                    filter = filter.substring(1);
                }
                if (!filter.equals("/") && !path.startsWith(filter + "/") && !path.equals(filter)) continue;
                if (!nonRecurse) {
                    pathsToAdd.add(path);
                    continue;
                }
                String fragment = path.substring(filter.length());
                if (fragment.indexOf("/") >= 1) continue;
                pathsToAdd.add(path);
            }
        }
        DefaultArtifactNotification result = new DefaultArtifactNotification((ArtifactContainer)this.root, pathsToAdd);
        return result;
    }

    private Map<String, List<LooseArchive.EntryInfo>> buildOwnerMapOfEntryInfo(Collection<File> files) {
        String xmlPath = this.root.getXMLFile().getAbsolutePath();
        HashMap<String, List<LooseArchive.EntryInfo>> result = new HashMap<String, List<LooseArchive.EntryInfo>>();
        HashSet<String> absPath = new HashSet<String>();
        for (File f : files) {
            if (f.getAbsolutePath().equals(xmlPath)) {
                result.put("/", null);
                continue;
            }
            for (LooseArchive.EntryInfo info : this.entries) {
                absPath.clear();
                info.addMonitoringPaths(absPath, absPath, info.getVirtualLocation());
                if (absPath.size() <= 0) continue;
                String path = f.getAbsolutePath();
                for (String compare : absPath) {
                    String vloc;
                    compare = new File(compare).getAbsolutePath().replace(File.separatorChar, '/');
                    path = path.replace(File.separatorChar, '/');
                    if (compare.endsWith(File.separator)) {
                        compare = compare.substring(0, compare.length() - 1);
                    }
                    if (!path.startsWith(compare + "/") && !path.equals(compare)) continue;
                    boolean pathEquals = path.equals(compare);
                    path = path.substring(compare.length());
                    if (!pathEquals && !path.startsWith("/")) {
                        path = "/" + path;
                    }
                    if ((vloc = info.getVirtualLocation()).endsWith("/")) {
                        vloc = vloc.substring(0, vloc.length() - 1);
                    }
                    if (!info.matches(path = vloc + path, false)) continue;
                    if (!result.containsKey(path)) {
                        result.put(path, new ArrayList());
                    }
                    ((List)result.get(path)).add(info);
                }
            }
        }
        return result;
    }

    private Map<String, List<LooseArchive.EntryInfo>> buildAffectedMapOfEntryInfo(Map<String, List<LooseArchive.EntryInfo>> owner) {
        HashMap<String, List<LooseArchive.EntryInfo>> result = new HashMap<String, List<LooseArchive.EntryInfo>>();
        for (String path : owner.keySet()) {
            for (LooseArchive.EntryInfo info : this.entries) {
                if (!info.matches(path, false) && !info.isBeneath(path)) continue;
                if (!result.containsKey(path)) {
                    result.put(path, new ArrayList());
                }
                ((List)result.get(path)).add(info);
            }
        }
        return result;
    }

    private void correctNotifications(Set<String> rAdded, Set<String> rModified, Set<String> rDeleted, Map<String, List<LooseArchive.EntryInfo>> affectedMap, Map<String, List<LooseArchive.EntryInfo>> ownerMap, Operation op) {
        for (Map.Entry<String, List<LooseArchive.EntryInfo>> affected : affectedMap.entrySet()) {
            boolean xmlSpecialCase = false;
            int firstExistingIndex = Integer.MAX_VALUE;
            int firstMatchingIndex = Integer.MAX_VALUE;
            int existingMatchCount = 0;
            String path = affected.getKey();
            List<LooseArchive.EntryInfo> ownerList = ownerMap.get(path);
            if (ownerList == null) {
                xmlSpecialCase = true;
            } else {
                int index = -1;
                for (LooseArchive.EntryInfo ei : affected.getValue()) {
                    ++index;
                    if (ei.matches(affected.getKey(), true)) {
                        ++existingMatchCount;
                        if (firstExistingIndex == Integer.MAX_VALUE) {
                            firstExistingIndex = index;
                        }
                    }
                    if (firstMatchingIndex != Integer.MAX_VALUE || !ownerList.contains(ei)) continue;
                    firstMatchingIndex = index;
                }
            }
            if (xmlSpecialCase) {
                switch (op) {
                    case ADDED: {
                        rAdded.add(path);
                        break;
                    }
                    case MODIFIED: {
                        rModified.add(path);
                        break;
                    }
                    case DELETED: {
                        rDeleted.add(path);
                    }
                }
                continue;
            }
            if (firstMatchingIndex == Integer.MAX_VALUE) {
                FFDCFilter.processException((Throwable)new IllegalStateException("EntryInfo match not found"), (String)this.getClass().getName(), (String)"entryInfoMatchNotFound");
                continue;
            }
            switch (op) {
                case ADDED: {
                    if (firstExistingIndex < firstMatchingIndex) break;
                    if (firstExistingIndex > firstMatchingIndex) {
                        rModified.add(path);
                        break;
                    }
                    if (firstExistingIndex == firstMatchingIndex) {
                        if (existingMatchCount > 1) {
                            rModified.add(path);
                            break;
                        }
                        rAdded.add(path);
                        break;
                    }
                    if (firstExistingIndex != Integer.MAX_VALUE) break;
                    FFDCFilter.processException((Throwable)new IllegalStateException("No matching EntryInfo for path"), (String)this.getClass().getName(), (String)"entryInfoMatchNotFoundForAdd");
                    break;
                }
                case DELETED: {
                    if (firstExistingIndex == Integer.MAX_VALUE) {
                        rDeleted.add(path);
                        break;
                    }
                    if (firstExistingIndex < firstMatchingIndex) break;
                    if (firstExistingIndex > firstMatchingIndex) {
                        rModified.add(path);
                        break;
                    }
                    if (firstExistingIndex != firstMatchingIndex) break;
                    rModified.add(path);
                    break;
                }
                case MODIFIED: {
                    if (firstExistingIndex == Integer.MAX_VALUE) {
                        FFDCFilter.processException((Throwable)new IllegalStateException("EntryInfo match not found"), (String)this.getClass().getName(), (String)"entryInfoMatchNotFoundForModify");
                        break;
                    }
                    if (firstExistingIndex < firstMatchingIndex) break;
                    if (firstExistingIndex > firstMatchingIndex) {
                        FFDCFilter.processException((Throwable)new IllegalStateException("EntryInfo match not found"), (String)this.getClass().getName(), (String)"entryInfoMatchNotFoundForModify2");
                        break;
                    }
                    if (firstExistingIndex != firstMatchingIndex) break;
                    rModified.add(path);
                }
            }
        }
    }

    private void constructRelativeNotificationPaths(Set<String> rAdded, Set<String> rModified, Set<String> rDeleted, Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        Map<String, List<LooseArchive.EntryInfo>> ownerAdded = this.buildOwnerMapOfEntryInfo(createdFiles);
        Map<String, List<LooseArchive.EntryInfo>> ownerModified = this.buildOwnerMapOfEntryInfo(modifiedFiles);
        Map<String, List<LooseArchive.EntryInfo>> ownerDeleted = this.buildOwnerMapOfEntryInfo(deletedFiles);
        Map<String, List<LooseArchive.EntryInfo>> affectedAdded = this.buildAffectedMapOfEntryInfo(ownerAdded);
        Map<String, List<LooseArchive.EntryInfo>> affectedModified = this.buildAffectedMapOfEntryInfo(ownerModified);
        Map<String, List<LooseArchive.EntryInfo>> affectedDeleted = this.buildAffectedMapOfEntryInfo(ownerDeleted);
        this.correctNotifications(rAdded, rModified, rDeleted, affectedAdded, ownerAdded, Operation.ADDED);
        this.correctNotifications(rAdded, rModified, rDeleted, affectedModified, ownerModified, Operation.MODIFIED);
        this.correctNotifications(rAdded, rModified, rDeleted, affectedDeleted, ownerDeleted, Operation.DELETED);
    }

    public synchronized void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        this.onChange(createdFiles, modifiedFiles, deletedFiles, null);
    }

    public synchronized void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles, String filter) {
        HashSet<String> fRelativeAddedSet = new HashSet<String>();
        HashSet<String> fRelativeModifiedSet = new HashSet<String>();
        HashSet<String> fRelativeRemovedSet = new HashSet<String>();
        this.constructRelativeNotificationPaths(fRelativeAddedSet, fRelativeModifiedSet, fRelativeRemovedSet, createdFiles, modifiedFiles, deletedFiles);
        if (!(this.parent == null || fRelativeAddedSet.isEmpty() && fRelativeModifiedSet.isEmpty() && fRelativeRemovedSet.isEmpty())) {
            this.parent.notifyListenersByPath(Collections.emptySet(), Collections.singleton(this.pathInParent), Collections.emptySet(), filter);
        }
        this.notifyListenersByPath(fRelativeAddedSet, fRelativeModifiedSet, fRelativeRemovedSet, filter);
    }

    private void notifyListenersByPath(Set<String> relativeAddedSet, Set<String> relativeModifedSet, Set<String> relativeRemovedSet, String filter) {
        for (Registration r : this.listeners) {
            ArtifactNotifier.ArtifactNotification added = this.filterSetByPaths(relativeAddedSet, r.paths);
            ArtifactNotifier.ArtifactNotification removed = this.filterSetByPaths(relativeRemovedSet, r.paths);
            ArtifactNotifier.ArtifactNotification modified = this.filterSetByPaths(relativeModifedSet, r.paths);
            if (added.getPaths().size() <= 0 && removed.getPaths().size() <= 0 && modified.getPaths().size() <= 0) continue;
            r.listener.notifyEntryChange(added, removed, modified, filter);
        }
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void addChild(LooseArchive.EntryInfo entryInfo, LooseArtifactNotifier notifier) {
        this.children.put(entryInfo, notifier);
    }

    public String getId() {
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LooseArtifactNotifier.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation ADDED;
        public static final /* enum */ Operation DELETED;
        public static final /* enum */ Operation MODIFIED;
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Operation.class);
            ADDED = new Operation();
            DELETED = new Operation();
            MODIFIED = new Operation();
            $VALUES = new Operation[]{ADDED, DELETED, MODIFIED};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class Registration {
        ArtifactListenerSelector listener;
        Collection<String> paths;
        static final long serialVersionUID = -5303578116710863335L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Registration() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Registration.class);
        }
    }
}

