/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.ConfigException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSServiceConfigurationConfig;
import com.ibm.ws.transport.iiop.security.util.GSSExportedName;
import com.ibm.ws.transport.iiop.security.util.Util;
import org.omg.CSIIOP.ServiceConfiguration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSGSSExportedNameConfig
extends TSSServiceConfigurationConfig {
    private final String name;
    private final String oid;
    static final long serialVersionUID = 5878792524681284565L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSGSSExportedNameConfig(String name, String oid) {
        this.name = name;
        this.oid = oid;
    }

    public TSSGSSExportedNameConfig(GSSExportedName name) {
        this.name = name.getName();
        this.oid = name.getOid();
    }

    public String getName() {
        return this.name;
    }

    public String getOid() {
        return this.oid;
    }

    @Override
    public ServiceConfiguration generateServiceConfiguration() throws ConfigException {
        ServiceConfiguration config = new ServiceConfiguration();
        config.syntax = 324817;
        config.name = Util.encodeGSSExportName(this.oid, this.name);
        if (config.name == null) {
            throw new ConfigException("Unable to encode GSSExportedName");
        }
        return config;
    }

    @Override
    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSGSSExportedNameConfig: [\n");
        buf.append(moreSpaces).append("oid : ").append(this.oid).append("\n");
        buf.append(moreSpaces).append("name: ").append(this.name).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSGSSExportedNameConfig.class);
    }
}

