/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGSSUPMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInfo;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CSSGSSUPMechConfigStatic
implements CSSASMechConfig {
    private final String username;
    private final SerializableProtectedString password;
    private final String domain;
    private transient byte[] encoding;
    private final String mechanism = "GSSUP";
    static final long serialVersionUID = -3932238487864495510L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CSSGSSUPMechConfigStatic(String username, SerializableProtectedString password, String domain) {
        this.username = username;
        this.password = password;
        this.domain = domain;
    }

    @Override
    public short getSupports() {
        return 0;
    }

    @Override
    public short getRequires() {
        return 0;
    }

    @Override
    public boolean canHandle(TSSASMechConfig asMech) {
        if (asMech instanceof TSSGSSUPMechConfig) {
            return true;
        }
        return asMech.getRequires() == 0;
    }

    @Override
    public String getMechanism() {
        return "GSSUP";
    }

    @Override
    public byte[] encode(TSSASMechConfig tssasMechConfig, CSSSASMechConfig sas_mech, ClientRequestInfo ri, Codec codec) {
        byte[] currentEncoding = null;
        if (tssasMechConfig instanceof TSSGSSUPMechConfig) {
            if (this.encoding == null) {
                String scopedUserName = Util.buildScopedUserName(this.username, this.domain);
                this.encoding = Util.encodeGSSUPToken(codec, scopedUserName, this.password.getChars(), this.domain);
            }
            currentEncoding = this.encoding;
        }
        if (currentEncoding == null) {
            currentEncoding = new byte[]{};
        }
        return currentEncoding;
    }

    @Trivial
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSGSSUPMechConfigStatic: [\n");
        buf.append(moreSpaces).append("username: ").append(this.username).append("\n");
        buf.append(moreSpaces).append("password: ").append(this.password.toTraceString()).append("\n");
        buf.append(moreSpaces).append("domain:   ").append(this.domain).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CSSGSSUPMechConfigStatic.class);
    }
}

