/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERBitString;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.x509.GeneralNames;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IssuerSerial
extends ASN1Encodable {
    GeneralNames issuer;
    DERInteger serial;
    DERBitString issuerUID;
    static final long serialVersionUID = 3489163347498894966L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static IssuerSerial getInstance(Object obj) {
        if (obj == null || obj instanceof IssuerSerial) {
            return (IssuerSerial)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuerSerial((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static IssuerSerial getInstance(ASN1TaggedObject obj, boolean explicit) {
        return IssuerSerial.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public IssuerSerial(ASN1Sequence seq) {
        this.issuer = GeneralNames.getInstance(seq.getObjectAt(0));
        this.serial = (DERInteger)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.issuerUID = (DERBitString)seq.getObjectAt(2);
        }
    }

    public IssuerSerial(GeneralNames issuer, DERInteger serial) {
        this.issuer = issuer;
        this.serial = serial;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer);
        v.add(this.serial);
        if (this.issuerUID != null) {
            v.add(this.issuerUID);
        }
        return new DERSequence(v);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IssuerSerial.class);
    }
}

