/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.KeyringMonitor;
import com.ibm.ws.ssl.internal.KeyringBasedActionable;
import java.util.Arrays;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class KeyringMonitorImpl
implements KeyringMonitor {
    private static final TraceComponent tc = Tr.register(KeyringMonitorImpl.class);
    private final KeyringBasedActionable actionable;

    public KeyringMonitorImpl(KeyringBasedActionable fileBasedActionable) {
        this.actionable = fileBasedActionable;
    }

    public ServiceRegistration<KeyringMonitor> monitorKeyRings(String ID, String trigger, String keyStoreLocation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"monitorKeyRing registration for", (Object[])new Object[]{ID});
        }
        BundleContext bundleContext = this.actionable.getBundleContext();
        Hashtable<String, String> keyRingMonitorProps = new Hashtable<String, String>();
        keyRingMonitorProps.put("monitor.keystore.id", ID);
        keyRingMonitorProps.put("keystore.location", keyStoreLocation);
        if (!trigger.equalsIgnoreCase("disabled") && trigger.equals("polled")) {
            Tr.warning((TraceComponent)tc, (String)"Cannot have polled trigger for keyRing ID: ", (Object[])new Object[]{ID});
        }
        return bundleContext.registerService(KeyringMonitor.class, (Object)this, keyRingMonitorProps);
    }

    @Override
    public void refreshRequested(String keyStoreLocation) {
        this.actionable.performKeyStoreAction(Arrays.asList(keyStoreLocation));
    }
}

