/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector.manager.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.collector.manager.internal.CollectorManagerUtils;
import com.ibm.ws.collector.manager.internal.HandlerManager;
import com.ibm.ws.collector.manager.internal.SourceManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CollectorManagerImpl
implements CollectorManager {
    private BundleContext bundleContext;
    private ServiceRegistration<?> buffMgrRegistration;
    private final Map<String, ServiceRegistration<?>> activeBuffMgrServices = new HashMap();
    private final Map<String, BufferManager> bufferManagerMap = new HashMap<String, BufferManager>();
    private static final TraceComponent tc = Tr.register(CollectorManagerImpl.class);
    private ConfigurationAdmin configAdmin;
    private final Map<String, String> sourcePids = new HashMap<String, String>();
    private final Map<String, SourceManager> sourceMgrs = new HashMap<String, SourceManager>();
    private final Map<String, HandlerManager> handlerMgrs = new HashMap<String, HandlerManager>();
    static final long serialVersionUID = 2515004817376774919L;

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        this.unregisterAllBufferManagers();
    }

    protected void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" Modified", (Object[])new Object[0]);
        }
    }

    protected synchronized void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected synchronized void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    public synchronized void setSource(Source source) {
        String sourceId = CollectorManagerUtils.getSourceId(source);
        SourceManager srcMgr = null;
        if (!this.sourceMgrs.containsKey(sourceId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Adding source to the list", (Object[])new Object[]{source.getClass()});
            }
            srcMgr = new SourceManager(source);
            this.sourceMgrs.put(srcMgr.getSourceId(), srcMgr);
            this.processInitializedConduits(source);
            srcMgr.setBufferManager(this.bufferManagerMap.get(sourceId));
            for (Map.Entry<String, HandlerManager> entry : this.handlerMgrs.entrySet()) {
                HandlerManager hdlrMgr = entry.getValue();
                if (!hdlrMgr.getPendingSubscriptions().contains(sourceId)) continue;
                ArrayList<String> sourceIds = new ArrayList<String>();
                sourceIds.add(sourceId);
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Handling pending subscription " + sourceId), (Object[])new Object[]{hdlrMgr.getHandlerId()});
                    }
                    this.subscribe(hdlrMgr.getHandler(), sourceIds);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.manager.internal.CollectorManagerImpl", (String)"135", (Object)this, (Object[])new Object[]{source});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processInitializedConduits(Source source) {
        String sourceId = CollectorManagerUtils.getSourceId(source);
        String sourceName = source.getSourceName();
        if (sourceName.equals("com.ibm.ws.logging.source.message") || sourceName.equals("com.ibm.ws.logging.source.trace")) {
            if (this.bundleContext == null) {
                this.retrieveBundleContext();
            }
            if (this.sourceMgrs.containsKey(sourceId) && this.bufferManagerMap.containsKey(sourceId)) {
                return;
            }
            try {
                ServiceReference[] servRefs = this.bundleContext.getServiceReferences(BufferManager.class.getName(), null);
                if (servRefs != null) {
                    for (ServiceReference servRef : servRefs) {
                        if (!sourceName.equals(servRef.getProperty("source"))) continue;
                        Object object = this.bundleContext.getService(servRef);
                        BufferManager conduit = (BufferManager)object;
                        this.bufferManagerMap.put(sourceId, conduit);
                    }
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collector.manager.internal.CollectorManagerImpl", (String)"191", (Object)this, (Object[])new Object[]{source});
                e.printStackTrace();
            }
        }
    }

    public synchronized void unsetSource(Source source) {
        String sourceId = CollectorManagerUtils.getSourceId(source);
        SourceManager srcMgr = null;
        if (this.sourceMgrs.containsKey(sourceId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Removing source from the list", (Object[])new Object[]{source.getClass()});
            }
            srcMgr = this.sourceMgrs.get(sourceId);
            HashSet<String> srcMgrSubscriptions = new HashSet<String>(srcMgr.getSubscriptions());
            for (String handlerId : srcMgrSubscriptions) {
                ArrayList<String> sourceIds = new ArrayList<String>();
                sourceIds.add(sourceId);
                try {
                    HandlerManager hdlrMgr = this.handlerMgrs.get(handlerId);
                    Handler handler = hdlrMgr.getHandler();
                    this.unsubscribe(handler, sourceIds);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Source not available, adding to pending subscription list " + sourceId), (Object[])new Object[]{handlerId});
                    }
                    hdlrMgr.addPendingSubscription(sourceId);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.manager.internal.CollectorManagerImpl", (String)"228", (Object)this, (Object[])new Object[]{source});
                }
            }
            srcMgr.unsetSource(source);
            this.sourceMgrs.remove(sourceId);
        }
    }

    public synchronized void setHandler(Handler handler) {
        String handlerId = CollectorManagerUtils.getHandlerId(handler);
        if (!this.handlerMgrs.containsKey(handlerId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Adding handler to the list", (Object[])new Object[]{handler.getClass()});
            }
            HandlerManager hdlrMgr = new HandlerManager(handler);
            this.handlerMgrs.put(hdlrMgr.getHandlerId(), hdlrMgr);
            hdlrMgr.getHandler().init((CollectorManager)this);
        }
    }

    public synchronized void unsetHandler(Handler handler) {
        String handlerId = CollectorManagerUtils.getHandlerId(handler);
        if (this.handlerMgrs.containsKey(handlerId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Removing handler from the list", (Object[])new Object[]{handler.getClass()});
            }
            HandlerManager hdlrMgr = this.handlerMgrs.get(handlerId);
            try {
                this.unsubscribe(handler, new ArrayList<String>(hdlrMgr.getSubsribedSources()));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.manager.internal.CollectorManagerImpl", (String)"271", (Object)this, (Object[])new Object[]{handler});
            }
            hdlrMgr.unsetHandler(handler);
            this.handlerMgrs.remove(handlerId);
        }
    }

    public synchronized void subscribe(Handler handler, List<String> sourceIds) throws Exception {
        if (sourceIds != null) {
            String handlerId = CollectorManagerUtils.getHandlerId(handler);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Subscribe to sources " + sourceIds), (Object[])new Object[]{handlerId});
            }
            if (handlerId != null && !this.handlerMgrs.containsKey(handlerId)) {
                throw new Exception("Handler not bound : " + handlerId);
            }
            for (String sourceId : sourceIds) {
                HandlerManager hdlrMgr = this.handlerMgrs.get(handlerId);
                if (this.sourceMgrs.containsKey(sourceId) && this.sourceMgrs.get(sourceId).getSource() != null) {
                    SourceManager srcMgr = this.sourceMgrs.get(sourceId);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Subscribing to source " + sourceId), (Object[])new Object[]{handlerId});
                    }
                    srcMgr.addSubscriber(handler);
                    handler.setBufferManager(sourceId, srcMgr.getBufferManager());
                    hdlrMgr.addSubscribedSource(srcMgr.getSource());
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Source not available, adding to pending subscription list " + sourceId), (Object[])new Object[]{handlerId});
                }
                hdlrMgr.addPendingSubscription(sourceId);
                this.startSourceWithBufferManager(sourceId, handler);
            }
        }
    }

    public synchronized void unsubscribe(Handler handler, List<String> sourceIds) throws Exception {
        if (sourceIds != null) {
            String handlerId = CollectorManagerUtils.getHandlerId(handler);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Unsubscribe from sources" + sourceIds), (Object[])new Object[]{handlerId});
            }
            if (handlerId != null && !this.handlerMgrs.containsKey(handlerId)) {
                throw new Exception("Handler not bound : " + handlerId);
            }
            for (String sourceId : sourceIds) {
                ServiceRegistration<?> entry;
                if (!this.sourceMgrs.containsKey(sourceId) || this.sourceMgrs.get(sourceId).getSource() == null) continue;
                SourceManager srcMgr = this.sourceMgrs.get(sourceId);
                handler.unsetBufferManager(sourceId, srcMgr.getBufferManager());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unsubscribing from source " + sourceId), (Object[])new Object[]{handlerId});
                }
                HandlerManager hdlrMgr = this.handlerMgrs.get(handlerId);
                hdlrMgr.removeSubscribedSource(srcMgr.getSource());
                if (!srcMgr.removeSubscriber(handler) || (entry = this.activeBuffMgrServices.get(sourceId)) == null) continue;
                entry.unregister();
                this.activeBuffMgrServices.remove(sourceId);
            }
        }
    }

    private synchronized void startSourceWithBufferManager(String sourceId, Handler handler) {
        if (this.activeBuffMgrServices.containsKey(sourceId) || sourceId.contains("audit")) {
            return;
        }
        String[] result = sourceId.split("\\|");
        if (result.length != 2 || result[0].equals("") || result[1].equals("")) {
            throw new IllegalArgumentException("Incorrect source identifier format : " + sourceId);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("source", result[0]);
        BufferManagerImpl bufferMgr = new BufferManagerImpl(10000, sourceId);
        if (handler instanceof SynchronousHandler) {
            bufferMgr.addSyncHandler((SynchronousHandler)handler);
        }
        this.bufferManagerMap.put(sourceId, (BufferManager)bufferMgr);
        if (this.bundleContext == null) {
            this.retrieveBundleContext();
        }
        this.buffMgrRegistration = this.bundleContext.registerService(BufferManager.class.getName(), (Object)bufferMgr, props);
        this.activeBuffMgrServices.put(sourceId, this.buffMgrRegistration);
    }

    private synchronized void unregisterAllBufferManagers() {
        HashMap shutDownCopyBuffMgrService = new HashMap(this.activeBuffMgrServices);
        this.activeBuffMgrServices.clear();
        for (ServiceRegistration entry : shutDownCopyBuffMgrService.values()) {
            if (entry == null) continue;
            entry.unregister();
        }
        shutDownCopyBuffMgrService.clear();
    }

    private synchronized void retrieveBundleContext() {
        this.bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }
}

