/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.couchdb.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.couchdb.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CouchDbService
implements ResourceFactory,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(CouchDbService.class, (String)"couchdb");
    private static final String COUCHDB_CLIENT_OPTIONS_BUILDER_CLS_STR = "org.ektorp.http.StdHttpClient$Builder";
    private static final String COUCHDB_CLIENT_CLS_STR = "org.ektorp.impl.StdCouchDbInstance";
    static final String CONFIG_ID = "config.displayId";
    private String id;
    static final String COUCHDB = "couchdb";
    private final AtomicServiceReference<Library> libraryRef = new AtomicServiceReference("library");
    private Object couchdb;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicServiceReference<ApplicationRecycleCoordinator> appRecycleSvcRef = new AtomicServiceReference("appRecycleService");
    private static final String APP_RECYCLE_SERVICE = "appRecycleService";
    private static final Map<String, Class<?>> COUCHDB_CLIENT_OPTIONS_TYPES = new HashMap();
    private Map<String, Object> props;
    static final long serialVersionUID = -8401756426775565282L;

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.libraryRef.activate(context);
        this.props = props;
        this.id = (String)props.get(CONFIG_ID);
        this.appRecycleSvcRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.libraryRef.deactivate(context);
        this.appRecycleSvcRef.deactivate(context);
    }

    public Object createResource(ResourceInfo info) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"createResource", (Object[])new Object[0]);
        }
        Object dbInstance = this.getDBInstance();
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return dbInstance;
    }

    Object getDBInstance() throws Exception {
        try {
            ClassLoader loader = ((Library)this.libraryRef.getServiceWithException()).getClassLoader();
            Class<?> couchDbClientOptionsBuilderCls = loader.loadClass(COUCHDB_CLIENT_OPTIONS_BUILDER_CLS_STR);
            Object builderInstance = couchDbClientOptionsBuilderCls.newInstance();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("creating a org.ektorp.impl.StdCouchDbInstance instance with " + this.props.toString()), (Object[])new Object[0]);
            }
            for (Map.Entry<String, Object> prop : this.props.entrySet()) {
                String name = prop.getKey();
                Object value = prop.getValue();
                if (value == null || name.indexOf(46) >= 0 || !COUCHDB_CLIENT_OPTIONS_TYPES.containsKey(name)) continue;
                this.set(couchDbClientOptionsBuilderCls, builderInstance, name, value);
            }
            Class<?> couchDbClientCls = loader.loadClass(COUCHDB_CLIENT_CLS_STR);
            Class<?> httpClientCls = loader.loadClass("org.ektorp.http.HttpClient");
            Constructor<?> constructor = couchDbClientCls.getConstructor(httpClientCls);
            Method builderBuildMethod = couchDbClientOptionsBuilderCls.getMethod("build", new Class[0]);
            this.couchdb = constructor.newInstance(builderBuildMethod.invoke(builderInstance, new Object[0]));
            return this.couchdb;
        }
        catch (Throwable loader) {
            Throwable x;
            FFDCFilter.processException((Throwable)loader, (String)"com.ibm.ws.couchdb.internal.CouchDbService", (String)"205", (Object)this, (Object[])new Object[0]);
            Object object = x = x instanceof InvocationTargetException ? x.getCause() : x;
            if (x instanceof Exception) {
                throw (Exception)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void set(Class<?> builderCls, Object builder, String propName, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            Class<?> cls = COUCHDB_CLIENT_OPTIONS_TYPES.get(propName);
            Method method = builderCls.getMethod(propName, cls);
            if (cls.equals(Integer.TYPE) && value instanceof Long) {
                value = ((Long)value).intValue();
            }
            if (propName.equals("password")) {
                SerializableProtectedString password = (SerializableProtectedString)value;
                String pwdStr = password == null ? null : String.valueOf(password.getChars());
                value = PasswordUtil.getCryptoAlgorithm((String)pwdStr) == null ? pwdStr : PasswordUtil.decode((String)pwdStr);
            }
            method.invoke(builder, value);
            return;
        }
        catch (Throwable cls) {
            IllegalArgumentException failure;
            Throwable x2;
            void x2;
            FFDCFilter.processException((Throwable)cls, (String)"com.ibm.ws.couchdb.internal.CouchDbService", (String)"250", (Object)this, (Object[])new Object[]{builderCls, builder, propName, value});
            if (x2 instanceof InvocationTargetException) {
                x2 = x2.getCause();
            }
            if ((failure = this.ignoreWarnOrFail(x2, IllegalArgumentException.class, "CWKKD0010.prop.error", propName, COUCHDB, this.id, x2)) != null) {
                FFDCFilter.processException((Throwable)failure, (String)this.getClass().getName(), (String)"394", (Object)this, (Object[])new Object[]{value == null ? null : value.getClass(), value});
                throw failure;
            }
            return;
        }
    }

    protected void setLibrary(ServiceReference<Library> ref) {
        this.libraryRef.setReference(ref);
    }

    protected void unsetLibrary(ServiceReference<Library> ref) {
        this.libraryRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Throwable> T ignoreWarnOrFail(Throwable throwable, Class<T> exceptionClassToRaise, String msgKey, Object ... objs) {
        switch ((OnErrorUtil.OnError)this.props.get("onError")) {
            case IGNORE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ignoring error: " + msgKey), (Object[])objs);
                }
                return null;
            }
            case WARN: {
                Tr.warning((TraceComponent)tc, (String)msgKey, (Object[])objs);
                return null;
            }
            case FAIL: {
                try {
                    if (throwable != null && exceptionClassToRaise.isInstance(throwable)) {
                        return (T)((Throwable)exceptionClassToRaise.cast(throwable));
                    }
                    Constructor<T> con = exceptionClassToRaise.getConstructor(String.class);
                    String message = msgKey == null ? throwable.getMessage() : Utils.getMessage(msgKey, objs);
                    Throwable failure = (Throwable)con.newInstance(message);
                    failure.initCause(throwable);
                    return (T)failure;
                }
                catch (RuntimeException con) {
                    void e;
                    FFDCFilter.processException((Throwable)con, (String)"com.ibm.ws.couchdb.internal.CouchDbService", (String)"321", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.couchdb.internal.CouchDbService", (String)"323", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    protected void setAppRecycleService(ServiceReference<ApplicationRecycleCoordinator> svc) {
        this.appRecycleSvcRef.setReference(svc);
    }

    protected void unsetAppRecycleService(ServiceReference<ApplicationRecycleCoordinator> ref) {
        this.appRecycleSvcRef.unsetReference(ref);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        COUCHDB_CLIENT_OPTIONS_TYPES.put("url", String.class);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("host", String.class);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("port", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("username", String.class);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("password", String.class);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("maxConnections", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("connectionTimeout", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("socketTimeout", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("enableSSL", Boolean.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("relaxedSSLSettings", Boolean.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("caching", Boolean.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("maxCacheEntries", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("maxObjectSizeBytes", Integer.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("useExpectContinue", Boolean.TYPE);
        COUCHDB_CLIENT_OPTIONS_TYPES.put("cleanupIdleConnections", Boolean.TYPE);
    }
}

