/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionAddLogRecord;
import com.ibm.ws.objectManager.TransactionBackoutLogRecord;
import com.ibm.ws.objectManager.TransactionCheckpointLogRecord;
import com.ibm.ws.objectManager.TransactionCommitLogRecord;
import com.ibm.ws.objectManager.TransactionDeleteLogRecord;
import com.ibm.ws.objectManager.TransactionLock;
import com.ibm.ws.objectManager.TransactionOptimisticReplaceLogRecord;
import com.ibm.ws.objectManager.TransactionPrepareLogRecord;
import com.ibm.ws.objectManager.TransactionReplaceLogRecord;
import com.ibm.ws.objectManager.XIDModificationException;
import com.ibm.ws.objectManager.XIDTooLongException;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InternalTransaction
implements Printable {
    private static final Class cclass = InternalTransaction.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    static final int stateError = 0;
    static final int stateInactive = 1;
    static final int stateActiveNonPersistent = 2;
    static final int stateActivePersistent = 3;
    static final int statePrePreparedInactive = 4;
    static final int statePrePreparedNonPersistent = 5;
    static final int statePrePreparedPersistent = 6;
    static final int statePreparedInactive = 7;
    static final int statePreparedNonPersistent = 8;
    static final int statePreparedPersistent = 9;
    static final int stateCommitingInactive = 10;
    static final int stateCommitingNonPersistent = 11;
    static final int stateCommitingPersistent = 12;
    static final int stateBackingOutInactive = 13;
    static final int stateBackingOutNonPersistent = 14;
    static final int stateBackingOutPersistent = 15;
    static final int stateTerminated = 16;
    static final String[] stateNames = new String[]{"Error", "Inactive", "ActiveNonPersistent", "ActivePersistent", "PrePreparedInactive", "PrePreparedNonPersistent", "PrePreparedPersistent", "PreparedInactive", "PreparedNonPersistent", "PreparedPersistent", "CommitingInactive", "CommitingNonPersistent", "CommitingPersistent", "BackingOutInactive", "BackingOutNonPersistent", "BackingOutPersistent", "Terminated"};
    static final int[] nextStateForInvolveNonPersistentObject = new int[]{0, 2, 2, 3, 5, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForInvolvePersistentObject = new int[]{0, 3, 3, 3, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForInvolvePersistentObjectFromCheckpoint = new int[]{0, 3, 0, 3, 0, 0, 0, 9, 0, 9, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForInvolveOptimisticNonPersistentObject = new int[]{0, 2, 2, 3, 5, 5, 6, 8, 8, 9, 11, 11, 12, 14, 14, 15, 0};
    static final int[] nextStateForInvolveOptimisticPersistentObject = new int[]{0, 3, 3, 3, 6, 6, 6, 9, 9, 9, 0, 0, 12, 0, 0, 15, 0};
    static final int[] nextStateForRequestCallback = new int[]{0, 0, 2, 3, 0, 0, 0, 0, 8, 9, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForPrePrepare = new int[]{0, 4, 5, 6, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForPrepare = new int[]{0, 7, 8, 9, 7, 8, 9, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForStartCommit = new int[]{0, 0, 0, 12, 10, 11, 12, 10, 11, 12, 0, 0, 12, 0, 0, 0, 0};
    static final int[] nextStateForCommit = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0};
    static final int[] nextStateForStartBackout = new int[]{0, 0, 0, 15, 13, 14, 15, 13, 14, 15, 0, 0, 0, 0, 0, 15, 0};
    static final int[] nextStateForBackout = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0};
    static final int[] nextStateForTerminate = new int[]{0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForShutdown = new int[]{0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    int state;
    private int previousState;
    protected ObjectManagerState objectManagerState;
    private LogicalUnitOfWork logicalUnitOfWork;
    private int useCount = 0;
    private TransactionLock transactionLock;
    private Map includedManagedObjects = new HashMap();
    private Set callbackTokens = new HashSet();
    private Set allPersistentTokensToNotify = new HashSet();
    private Map loggedSerializedBytes = new HashMap();
    private Map logSequenceNumbers = new HashMap();
    private Map managedObjectSequenceNumbers = new HashMap();
    private static long logCommitOverhead = ((Math.max(TransactionCommitLogRecord.maximumSerializedSize(), TransactionBackoutLogRecord.maximumSerializedSize()) + 4L) / 4096L + 1L) * 4096L;
    private static long logCheckpointOverhead = ((TransactionCheckpointLogRecord.maximumSerializedSize() + 4L) / 4096L + 1L) * 4096L;
    private static long logSpaceReservedOverhead = logCommitOverhead + logCheckpointOverhead;
    private long logSpaceReserved = 0L;
    protected ObjectManagerByteArrayOutputStream logRecordByteArrayOutputStream = new ObjectManagerByteArrayOutputStream(1024);
    protected boolean requiresPersistentCheckpoint = false;
    protected TransactionReference transactionReference;

    protected InternalTransaction(ObjectManagerState objectManagerState, LogicalUnitOfWork logicalUnitOfWork) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{objectManagerState, logicalUnitOfWork});
        }
        this.objectManagerState = objectManagerState;
        this.logicalUnitOfWork = logicalUnitOfWork;
        this.transactionLock = new TransactionLock(this);
        this.state = 1;
        this.previousState = -1;
        objectManagerState.registerTransaction(this);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected final synchronized Transaction getExternalTransaction() {
        String methodName = "getExternalTransaction";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getExternalTransaction");
        }
        Transaction transaction = null;
        if (this.transactionReference != null) {
            transaction = (Transaction)this.transactionReference.get();
        }
        if (transaction == null) {
            transaction = new Transaction(this);
            this.transactionReference = new TransactionReference(this, transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getExternalTransaction", new Object[]{transaction});
        }
        return transaction;
    }

    protected int getState() {
        return this.state;
    }

    protected LogicalUnitOfWork getLogicalUnitOfWork() {
        return this.logicalUnitOfWork;
    }

    protected byte[] getXID() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getXID");
            trace.exit((Object)this, cclass, "getXID", "returns logicalUnitOfWork.XID=" + this.logicalUnitOfWork.XID + "(byte[])");
        }
        return this.logicalUnitOfWork.XID;
    }

    protected synchronized void setXID(byte[] XID) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setXID", (Object)XID);
            trace.bytes(this, cclass, XID);
        }
        if (this.logicalUnitOfWork.XID != null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setXID", "via XIDModificationException logicalUnitOfWork.XID=" + this.logicalUnitOfWork.XID + "(byte[])");
            }
            throw new XIDModificationException((Object)this, this.logicalUnitOfWork.XID, XID);
        }
        if (XID.length > 255) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "setXID", "via XIDTooLongException XID.length=" + XID.length + "(byte[])");
            }
            throw new XIDTooLongException((Object)this, XID.length);
        }
        this.logicalUnitOfWork.XID = new byte[XID.length];
        System.arraycopy(XID, 0, this.logicalUnitOfWork.XID, 0, XID.length);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setXID");
        }
    }

    protected TransactionLock getTransactionLock() {
        return this.transactionLock;
    }

    protected Collection getIncludedManagedObjects() {
        return new ArrayList(this.includedManagedObjects.values());
    }

    protected synchronized void requestCallback(Token token, Transaction transaction) throws ObjectManagerException {
        String methodName = "requestCallback";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "requestCallback", new Object[]{token, transaction});
        }
        if (transaction.internalTransaction != this) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "requestCallback", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
            }
            throw new InvalidStateException((Object)this, 16, stateNames[16]);
        }
        this.setState(nextStateForRequestCallback);
        this.callbackTokens.add(token);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "requestCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(ManagedObject managedObject) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lock", "managedObject=" + managedObject + "(ManagedObject)");
        }
        managedObject.lock(this.transactionLock);
        Object object = this;
        synchronized (object) {
            this.includedManagedObjects.put(managedObject.owningToken, managedObject);
            if (!this.logSequenceNumbers.containsKey(managedObject.owningToken)) {
                this.logSequenceNumbers.put(managedObject.owningToken, new Long(0L));
                this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            }
        }
        if (!this.transactionLock.isLocked()) {
            object = managedObject;
            synchronized (object) {
                managedObject.notify();
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ManagedObject managedObject, Transaction transaction, long logSpaceReservedDelta) throws ObjectManagerException {
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{managedObject, transaction, new Long(logSpaceReservedDelta)});
        }
        managedObject.preAdd(transaction);
        ObjectManagerByteArrayOutputStream serializedBytes = null;
        try {
            if (managedObject.owningToken.getObjectStore().getUsesSerializedForm()) {
                serializedBytes = managedObject.getSerializedBytes();
            }
        }
        catch (ObjectManagerException exception) {
            managedObject.postAdd(transaction, false);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "add", new Object[]{exception});
            }
            throw exception;
        }
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            long logSequenceNumber;
            if (transaction.internalTransaction != this) {
                managedObject.postAdd(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "add", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            try {
                if (managedObject.owningToken.getObjectStore().getPersistence()) {
                    this.testState(nextStateForInvolvePersistentObject);
                    logSpaceReservedDelta += Token.maximumSerializedSize();
                    if (this.logSpaceReserved == 0L) {
                        logSpaceReservedDelta += logSpaceReservedOverhead;
                    }
                    TransactionAddLogRecord transactionAddLogRecord = new TransactionAddLogRecord(this, managedObject.owningToken, serializedBytes);
                    logSequenceNumber = this.objectManagerState.logOutput.writeNext(transactionAddLogRecord, logSpaceReservedDelta, true, false);
                    this.setState(nextStateForInvolvePersistentObject);
                    this.logSpaceReserved += logSpaceReservedDelta;
                    this.loggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                } else {
                    this.setState(nextStateForInvolveNonPersistentObject);
                    logSequenceNumber = this.objectManagerState.getDummyLogSequenceNumber();
                    if (managedObject.owningToken.getObjectStore().getUsesSerializedForm()) {
                        this.loggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                    }
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "add", exception, "1:860:1.41");
                managedObject.postAdd(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "add", new Object[]{exception});
                }
                throw exception;
            }
            this.includedManagedObjects.put(managedObject.owningToken, managedObject);
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
        }
        managedObject.postAdd(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    protected synchronized void addFromCheckpoint(ManagedObject managedObject, Transaction transaction) throws ObjectManagerException {
        String methodName = "addFromCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addFromCheckpoint", new Object[]{managedObject, transaction});
        }
        managedObject.preAdd(transaction);
        this.setState(nextStateForInvolvePersistentObjectFromCheckpoint);
        this.includedManagedObjects.put(managedObject.owningToken, managedObject);
        if (!this.logSequenceNumbers.containsKey(managedObject.owningToken)) {
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(0L));
        }
        managedObject.postAdd(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "addFromCheckpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replace(ManagedObject managedObject, Transaction transaction, long logSpaceReservedDelta) throws ObjectManagerException {
        String methodName = "replace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "replace", new Object[]{managedObject, transaction, new Long(logSpaceReservedDelta)});
        }
        managedObject.preReplace(transaction);
        ObjectManagerByteArrayOutputStream serializedBytes = null;
        try {
            if (managedObject.owningToken.getObjectStore().getUsesSerializedForm()) {
                serializedBytes = managedObject.getSerializedBytes();
            }
        }
        catch (ObjectManagerException exception) {
            managedObject.postReplace(transaction, false);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "replace", new Object[]{exception});
            }
            throw exception;
        }
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            long logSequenceNumber;
            if (transaction.internalTransaction != this) {
                managedObject.postReplace(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "replace", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            try {
                if (managedObject.owningToken.getObjectStore().getPersistence()) {
                    this.testState(nextStateForInvolvePersistentObject);
                    logSpaceReservedDelta = logSpaceReservedDelta + Token.maximumSerializedSize() + (long)serializedBytes.getCount();
                    if (this.logSpaceReserved == 0L) {
                        logSpaceReservedDelta += logSpaceReservedOverhead;
                    }
                    TransactionReplaceLogRecord transactionReplaceLogRecord = new TransactionReplaceLogRecord(this, managedObject.owningToken, serializedBytes);
                    logSequenceNumber = this.objectManagerState.logOutput.writeNext(transactionReplaceLogRecord, logSpaceReservedDelta, true, false);
                    this.setState(nextStateForInvolvePersistentObject);
                    this.logSpaceReserved += logSpaceReservedDelta;
                    this.loggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                } else {
                    this.setState(nextStateForInvolveNonPersistentObject);
                    logSequenceNumber = this.objectManagerState.getDummyLogSequenceNumber();
                    if (managedObject.owningToken.getObjectStore().getUsesSerializedForm()) {
                        this.loggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                    }
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "replace", exception, "1:1060:1.41");
                managedObject.postReplace(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "replace", new Object[]{exception});
                }
                throw exception;
            }
            this.includedManagedObjects.put(managedObject.owningToken, managedObject);
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
        }
        managedObject.postReplace(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "replace");
        }
    }

    protected synchronized void replaceFromCheckpoint(ManagedObject managedObject, byte[] serializedBytes, Transaction transaction) throws ObjectManagerException {
        String methodName = "replaceFromCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "replaceFromCheckpoint", new Object[]{managedObject, new Integer(serializedBytes.length), transaction});
        }
        managedObject.preReplace(transaction);
        this.setState(nextStateForInvolvePersistentObjectFromCheckpoint);
        this.includedManagedObjects.put(managedObject.owningToken, managedObject);
        if (!this.logSequenceNumbers.containsKey(managedObject.owningToken)) {
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            this.loggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
        }
        managedObject.postReplace(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "replaceFromCheckpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimisticReplace(List managedObjectsToAdd, List managedObjectsToReplace, List managedObjectsToDelete, List tokensToNotify, Transaction transaction, long logSpaceReservedDelta) throws ObjectManagerException {
        String methodName = "optimisticReplace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "optimisticReplace", new Object[]{managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, tokensToNotify, transaction, new Long(logSpaceReservedDelta)});
        }
        ArrayList<Token> persistentTokensToAdd = new ArrayList<Token>();
        ArrayList<Token> persistentTokensToReplace = new ArrayList<Token>();
        ArrayList<ObjectManagerByteArrayOutputStream> persistentSerializedBytes = new ArrayList<ObjectManagerByteArrayOutputStream>();
        HashMap<Token, ObjectManagerByteArrayOutputStream> newLoggedSerializedBytes = new HashMap<Token, ObjectManagerByteArrayOutputStream>();
        ArrayList<Token> persistentTokensToDelete = new ArrayList<Token>();
        ArrayList<Token> persistentTokensToNotify = new ArrayList<Token>();
        try {
            ObjectManagerByteArrayOutputStream serializedBytes;
            if (managedObjectsToAdd != null) {
                for (ManagedObject managedObject : managedObjectsToAdd) {
                    managedObject.preAdd(transaction);
                    if (managedObject.owningToken.getObjectStore().getPersistence()) {
                        persistentTokensToAdd.add(managedObject.owningToken);
                        serializedBytes = managedObject.getSerializedBytes();
                        persistentSerializedBytes.add(serializedBytes);
                        newLoggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                        continue;
                    }
                    if (!managedObject.owningToken.getObjectStore().getUsesSerializedForm()) continue;
                    serializedBytes = managedObject.getSerializedBytes();
                    newLoggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                }
            }
            if (managedObjectsToReplace != null) {
                for (ManagedObject managedObject : managedObjectsToReplace) {
                    managedObject.preOptimisticReplace(transaction);
                    if (managedObject.owningToken.getObjectStore().getPersistence()) {
                        persistentTokensToReplace.add(managedObject.owningToken);
                        serializedBytes = managedObject.getSerializedBytes();
                        persistentSerializedBytes.add(serializedBytes);
                        newLoggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                        continue;
                    }
                    if (!managedObject.owningToken.getObjectStore().getUsesSerializedForm()) continue;
                    serializedBytes = managedObject.getSerializedBytes();
                    newLoggedSerializedBytes.put(managedObject.owningToken, serializedBytes);
                }
            }
            if (managedObjectsToDelete != null) {
                for (ManagedObject managedObject : managedObjectsToDelete) {
                    managedObject.preDelete(transaction);
                    if (!managedObject.owningToken.getObjectStore().getPersistence()) continue;
                    persistentTokensToDelete.add(managedObject.owningToken);
                }
            }
            if (tokensToNotify != null) {
                for (Token token : tokensToNotify) {
                    if (!token.getObjectStore().getPersistence()) continue;
                    persistentTokensToNotify.add(token);
                }
            }
        }
        catch (ObjectManagerException exception) {
            ObjectManager.ffdc.processException(this, cclass, "optimisticReplace", exception, "1:1305:1.41");
            this.postOptmisticReplace(managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, transaction);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "optimisticReplace", new Object[]{exception});
            }
            throw exception;
        }
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            long logSequenceNumber;
            if (transaction.internalTransaction != this) {
                this.postOptmisticReplace(managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, transaction);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "optimisticReplace", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            try {
                if (!(persistentTokensToAdd.isEmpty() && persistentTokensToReplace.isEmpty() && persistentTokensToDelete.isEmpty() && persistentTokensToNotify.isEmpty())) {
                    this.testState(nextStateForInvolveOptimisticPersistentObject);
                    logSpaceReservedDelta += (long)(persistentTokensToAdd.size() + persistentTokensToReplace.size() + persistentTokensToDelete.size() + persistentTokensToNotify.size()) * Token.maximumSerializedSize();
                    if (this.logSpaceReserved == 0L) {
                        logSpaceReservedDelta += logSpaceReservedOverhead;
                    }
                    TransactionOptimisticReplaceLogRecord transactionOptimisticReplaceLogRecord = new TransactionOptimisticReplaceLogRecord(this, persistentTokensToAdd, persistentTokensToReplace, persistentSerializedBytes, persistentTokensToDelete, persistentTokensToNotify);
                    logSequenceNumber = this.objectManagerState.logOutput.writeNext(transactionOptimisticReplaceLogRecord, logSpaceReservedDelta, true, false);
                    this.setState(nextStateForInvolveOptimisticPersistentObject);
                    this.logSpaceReserved += logSpaceReservedDelta;
                } else {
                    this.testState(nextStateForInvolveOptimisticNonPersistentObject);
                    this.setState(nextStateForInvolveOptimisticNonPersistentObject);
                    logSequenceNumber = this.objectManagerState.getDummyLogSequenceNumber();
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "optimisticReplace", exception, "1:1371:1.41");
                this.postOptmisticReplace(managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, transaction);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "optimisticReplace", new Object[]{exception});
                }
                throw exception;
            }
            this.loggedSerializedBytes.putAll(newLoggedSerializedBytes);
            if (managedObjectsToAdd != null) {
                for (ManagedObject managedObject : managedObjectsToAdd) {
                    this.includedManagedObjects.put(managedObject.owningToken, managedObject);
                    this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
                    this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
                    managedObject.postAdd(transaction, true);
                }
            }
            if (managedObjectsToReplace != null) {
                for (ManagedObject managedObject : managedObjectsToReplace) {
                    this.includedManagedObjects.put(managedObject.owningToken, managedObject);
                    this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
                    this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
                    managedObject.postOptimisticReplace(transaction, true);
                }
            }
            if (managedObjectsToDelete != null) {
                for (ManagedObject managedObject : managedObjectsToDelete) {
                    this.includedManagedObjects.put(managedObject.owningToken, managedObject);
                    this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
                    this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
                    managedObject.postDelete(transaction, true);
                }
            }
            if (tokensToNotify != null) {
                for (Token token : tokensToNotify) {
                    if (token.getObjectStore().getPersistence()) {
                        this.allPersistentTokensToNotify.add(token);
                    }
                    token.getManagedObject().optimisticReplaceLogged(transaction);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "optimisticReplace");
        }
    }

    private final void postOptmisticReplace(List managedObjectsToAdd, List managedObjectsToReplace, List managedObjectsToDelete, Transaction transaction) throws ObjectManagerException {
        if (managedObjectsToAdd != null) {
            for (ManagedObject managedObject : managedObjectsToAdd) {
                managedObject.postAdd(transaction, false);
            }
        }
        if (managedObjectsToReplace != null) {
            for (ManagedObject managedObject : managedObjectsToReplace) {
                managedObject.postOptimisticReplace(transaction, false);
            }
        }
        if (managedObjectsToDelete != null) {
            for (ManagedObject managedObject : managedObjectsToDelete) {
                managedObject.postDelete(transaction, false);
            }
        }
    }

    protected synchronized void optimisticReplaceFromCheckpoint(ManagedObject managedObject, Transaction transaction) throws ObjectManagerException {
        String methodName = "optimisticReplaceFromCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "optimisticReplaceFromCheckpoint", new Object[]{managedObject, transaction});
        }
        managedObject.preOptimisticReplace(transaction);
        this.setState(nextStateForInvolveOptimisticPersistentObject);
        this.includedManagedObjects.put(managedObject.owningToken, managedObject);
        if (!this.logSequenceNumbers.containsKey(managedObject.owningToken)) {
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(0L));
        }
        managedObject.postOptimisticReplace(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "optimisticReplaceFromCheckpoint");
        }
    }

    protected synchronized void notifyFromCheckpoint(Token token, Transaction transaction) throws ObjectManagerException {
        String methodName = "notifyFromCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "notifyFromCheckpoint", new Object[]{token, transaction});
        }
        this.allPersistentTokensToNotify.add(token);
        token.getManagedObject().optimisticReplaceLogged(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "notifyFromCheckpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(ManagedObject managedObject, Transaction transaction, long logSpaceReservedDelta) throws ObjectManagerException {
        String methodName = "delete";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "delete", new Object[]{managedObject, transaction, new Long(logSpaceReservedDelta)});
        }
        managedObject.preDelete(transaction);
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            long logSequenceNumber;
            if (transaction.internalTransaction != this) {
                managedObject.postDelete(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "delete", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            try {
                if (managedObject.owningToken.getObjectStore().getPersistence()) {
                    this.testState(nextStateForInvolvePersistentObject);
                    logSpaceReservedDelta += Token.maximumSerializedSize();
                    if (this.logSpaceReserved == 0L) {
                        logSpaceReservedDelta += logSpaceReservedOverhead;
                    }
                    TransactionDeleteLogRecord transactionDeleteLogRecord = new TransactionDeleteLogRecord(this, managedObject.owningToken);
                    logSequenceNumber = this.objectManagerState.logOutput.writeNext(transactionDeleteLogRecord, logSpaceReservedDelta, true, false);
                    this.setState(nextStateForInvolvePersistentObject);
                    this.logSpaceReserved += logSpaceReservedDelta;
                } else {
                    this.setState(nextStateForInvolveNonPersistentObject);
                    logSequenceNumber = this.objectManagerState.getDummyLogSequenceNumber();
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "delete", exception, "1:1644:1.41");
                managedObject.postDelete(transaction, false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "delete", new Object[]{exception});
                }
                throw exception;
            }
            this.loggedSerializedBytes.remove(managedObject.owningToken);
            this.includedManagedObjects.put(managedObject.owningToken, managedObject);
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(logSequenceNumber));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(managedObject.getUpdateSequence()));
        }
        managedObject.postDelete(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "delete");
        }
    }

    protected synchronized void deleteFromCheckpoint(ManagedObject managedObject, Transaction transaction) throws ObjectManagerException {
        String methodName = "deleteFromCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "deleteFromCheckpoint", new Object[]{managedObject, transaction});
        }
        managedObject.preDelete(transaction);
        this.setState(nextStateForInvolvePersistentObjectFromCheckpoint);
        this.includedManagedObjects.put(managedObject.owningToken, managedObject);
        if (!this.logSequenceNumbers.containsKey(managedObject.owningToken)) {
            this.logSequenceNumbers.put(managedObject.owningToken, new Long(0L));
            this.managedObjectSequenceNumbers.put(managedObject.owningToken, new Long(0L));
        }
        managedObject.postDelete(transaction, true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "deleteFromCheckpoint");
        }
    }

    protected void resetState(int recoveredState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "resetState", "recoveredState=" + recoveredState + "(int) " + stateNames[recoveredState] + "(String)");
        }
        switch (recoveredState) {
            case 3: {
                this.setState(nextStateForInvolvePersistentObject);
                break;
            }
            case 6: {
                this.setState(nextStateForPrePrepare);
                break;
            }
            case 9: {
                this.setState(nextStateForPrepare);
                break;
            }
            case 12: {
                this.setState(nextStateForStartCommit);
                break;
            }
            case 15: {
                this.setState(nextStateForStartBackout);
                break;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "resetState");
        }
    }

    protected synchronized void prepare(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "prepare", "transaction=" + transaction + "(Trasnaction)");
        }
        if (transaction.internalTransaction != this) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "prepare", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
            }
            throw new InvalidStateException((Object)this, 16, stateNames[16]);
        }
        this.prePrepare(transaction);
        if (this.state == 6) {
            TransactionPrepareLogRecord transactionPrepareLogRecord = new TransactionPrepareLogRecord(this);
            this.objectManagerState.logOutput.writeNext(transactionPrepareLogRecord, 0L, true, true);
        }
        this.setState(nextStateForPrepare);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "prepare");
        }
    }

    void prePrepare(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "prePrepare", new Object[]{transaction});
        }
        this.setState(nextStateForPrePrepare);
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.prePrepare(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "prePrepare");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(boolean reUse, Transaction transaction) throws ObjectManagerException {
        ManagedObject[] lockedManagedObjects;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "commit", new Object[]{new Boolean(reUse), transaction});
        }
        boolean persistentWorkDone = false;
        int numberOfLockedManagedObjects = 0;
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            if (transaction.internalTransaction != this) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "commit", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            if (this.state == 1 || this.state == 2 || this.state == 3) {
                this.prePrepare(transaction);
            }
            this.testState(nextStateForStartCommit);
            this.setState(nextStateForStartCommit);
            this.preCommit(transaction);
            if (this.state == 12) {
                persistentWorkDone = true;
                TransactionCommitLogRecord transactionCommitLogRecord = new TransactionCommitLogRecord(this);
                this.objectManagerState.logOutput.writeNext(transactionCommitLogRecord, -this.logSpaceReserved, true, true);
                this.logSpaceReserved = 0L;
            }
            lockedManagedObjects = new ManagedObject[this.includedManagedObjects.size()];
            boolean requiresCurrentPersistentCheckpoint = this.requiresPersistentCheckpoint || this.objectManagerState.checkpointStarting == 2;
            for (ManagedObject managedObject : this.includedManagedObjects.values()) {
                ObjectManagerByteArrayOutputStream serializedBytes = (ObjectManagerByteArrayOutputStream)this.loggedSerializedBytes.get(managedObject.owningToken);
                long managedObjectSequenceNumber = (Long)this.managedObjectSequenceNumbers.get(managedObject.owningToken);
                if (managedObject.lockedBy(transaction)) {
                    managedObject.commit(transaction, serializedBytes, managedObjectSequenceNumber, requiresCurrentPersistentCheckpoint);
                    lockedManagedObjects[numberOfLockedManagedObjects++] = managedObject;
                    continue;
                }
                managedObject.optimisticReplaceCommit(transaction, serializedBytes, managedObjectSequenceNumber, requiresCurrentPersistentCheckpoint);
            }
            this.setState(nextStateForCommit);
            this.transactionLock.unLock(this.objectManagerState);
            this.postCommit(transaction);
            this.complete(reUse, transaction);
        }
        for (int i = 0; i < numberOfLockedManagedObjects; ++i) {
            ManagedObject managedObject = lockedManagedObjects[i];
            synchronized (managedObject) {
                lockedManagedObjects[i].notify();
                continue;
            }
        }
        this.objectManagerState.transactionCompleted(this, persistentWorkDone);
        if (reUse) {
            this.objectManagerState.transactionPacing();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "commit");
        }
    }

    void preCommit(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preCommit", "transaction=" + transaction + "(Transaction)");
        }
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.preCommit(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preCommit");
        }
    }

    void postCommit(Transaction transaction) throws ObjectManagerException {
        String methodName = "postCommit";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postCommit", transaction);
        }
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.postCommit(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backout(boolean reUse, Transaction transaction) throws ObjectManagerException {
        ManagedObject[] lockedManagedObjects;
        String methodName = "backout";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "backout", new Object[]{new Boolean(reUse), transaction});
        }
        boolean persistentWorkDone = false;
        int numberOfLockedManagedObjects = 0;
        InternalTransaction internalTransaction = this;
        synchronized (internalTransaction) {
            if (transaction.internalTransaction != this) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "backout", new Object[]{"via InvalidTransactionException", transaction.internalTransaction});
                }
                throw new InvalidStateException((Object)this, 16, stateNames[16]);
            }
            if (this.state == 1 || this.state == 2 || this.state == 3) {
                this.prePrepare(transaction);
            }
            this.testState(nextStateForStartBackout);
            this.setState(nextStateForStartBackout);
            this.preBackout(transaction);
            if (this.state == 15) {
                persistentWorkDone = true;
                TransactionBackoutLogRecord transactionBackoutLogRecord = new TransactionBackoutLogRecord(this);
                this.objectManagerState.logOutput.writeNext(transactionBackoutLogRecord, -this.logSpaceReserved, true, true);
                this.logSpaceReserved = 0L;
            }
            lockedManagedObjects = new ManagedObject[this.includedManagedObjects.size()];
            boolean requiresCurrentPersistentCheckpoint = this.requiresPersistentCheckpoint || this.objectManagerState.checkpointStarting == 2;
            for (ManagedObject managedObject : this.includedManagedObjects.values()) {
                long managedObjectSequenceNumber = (Long)this.managedObjectSequenceNumbers.get(managedObject.owningToken);
                if (managedObject.lockedBy(transaction)) {
                    managedObject.backout(transaction, managedObjectSequenceNumber, requiresCurrentPersistentCheckpoint);
                    lockedManagedObjects[numberOfLockedManagedObjects++] = managedObject;
                    continue;
                }
                ObjectManagerByteArrayOutputStream serializedBytes = (ObjectManagerByteArrayOutputStream)this.loggedSerializedBytes.get(managedObject.owningToken);
                managedObject.optimisticReplaceBackout(transaction, serializedBytes, managedObjectSequenceNumber, requiresCurrentPersistentCheckpoint);
            }
            this.setState(nextStateForBackout);
            this.transactionLock.unLock(this.objectManagerState);
            this.postBackout(transaction);
            this.complete(reUse, transaction);
        }
        for (int i = 0; i < numberOfLockedManagedObjects; ++i) {
            ManagedObject managedObject = lockedManagedObjects[i];
            synchronized (managedObject) {
                lockedManagedObjects[i].notify();
                continue;
            }
        }
        this.objectManagerState.transactionCompleted(this, persistentWorkDone);
        if (reUse) {
            this.objectManagerState.transactionPacing();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "backout");
        }
    }

    void preBackout(Transaction transaction) throws ObjectManagerException {
        String methodName = "preBackout";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preBackout", new Object[]{transaction});
        }
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.preBackout(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preBackout");
        }
    }

    void postBackout(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "postBackouttransaction=" + transaction + "(Transaction)");
        }
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.postBackout(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postBackout");
        }
    }

    private final void complete(boolean reUse, Transaction transaction) throws ObjectManagerException {
        String methodName = "complete";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "complete", new Object[]{new Boolean(reUse), transaction});
        }
        this.requiresPersistentCheckpoint = false;
        this.logicalUnitOfWork.XID = null;
        this.transactionLock = new TransactionLock(this);
        this.includedManagedObjects.clear();
        this.callbackTokens.clear();
        this.allPersistentTokensToNotify.clear();
        this.loggedSerializedBytes.clear();
        this.logSequenceNumbers.clear();
        this.managedObjectSequenceNumbers.clear();
        ++this.useCount;
        if (!reUse) {
            transaction.internalTransaction = this.objectManagerState.dummyInternalTransaction;
            if (this.transactionReference != null) {
                this.transactionReference.clear();
            }
            this.objectManagerState.deRegisterTransaction(this);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "complete");
        }
    }

    protected synchronized void terminate(int reason) throws ObjectManagerException {
        Transaction transaction;
        String methodName = "terminate";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "terminate", new Object[]{new Integer(reason)});
        }
        if (this.transactionReference != null && (transaction = (Transaction)this.transactionReference.get()) != null) {
            transaction.setTerminationReason(reason);
        }
        this.setState(nextStateForTerminate);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "terminate");
        }
    }

    protected synchronized void shutdown() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutDown");
        }
        this.setState(nextStateForShutdown);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "shutdown");
        }
    }

    protected final void setRequiresCheckpoint() {
        String methodName = "setRequiresCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setRequiresCheckpoint", new Object[]{new Boolean(this.requiresPersistentCheckpoint)});
        }
        boolean[] checkpointRequired = new boolean[]{false, false, false, true, false, false, true, false, false, true, false, false, true, false, false, true, false};
        this.requiresPersistentCheckpoint = checkpointRequired[this.state];
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setRequiresCheckpoint", new Object[]{new Boolean(this.requiresPersistentCheckpoint)});
        }
    }

    protected synchronized void checkpoint(long forcedLogSequenceNumber) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "checkpoint", new Object[]{new Long(forcedLogSequenceNumber), new Boolean(this.requiresPersistentCheckpoint)});
        }
        if (this.requiresPersistentCheckpoint) {
            ArrayList<Token> persistentTokensToAdd = new ArrayList<Token>();
            ArrayList<Token> persistentTokensToReplace = new ArrayList<Token>();
            ArrayList<ObjectManagerByteArrayOutputStream> persistentSerializedBytesToReplace = new ArrayList<ObjectManagerByteArrayOutputStream>();
            ArrayList<Token> persistentTokensToOptimisticReplace = new ArrayList<Token>();
            ArrayList<Token> persistentTokensToDelete = new ArrayList<Token>();
            for (ManagedObject managedObject : this.includedManagedObjects.values()) {
                long logSequenceNumber;
                if (!managedObject.owningToken.getObjectStore().getPersistence() || forcedLogSequenceNumber < (logSequenceNumber = ((Long)this.logSequenceNumbers.get(managedObject.owningToken)).longValue())) continue;
                ObjectManagerByteArrayOutputStream serializedBytes = (ObjectManagerByteArrayOutputStream)this.loggedSerializedBytes.get(managedObject.owningToken);
                long managedObjectSequenceNumber = (Long)this.managedObjectSequenceNumbers.get(managedObject.owningToken);
                managedObject.checkpoint(this, serializedBytes, managedObjectSequenceNumber);
                if (managedObject.lockedBy(this)) {
                    switch (managedObject.getState()) {
                        case 2: {
                            persistentTokensToAdd.add(managedObject.owningToken);
                            break;
                        }
                        case 4: {
                            persistentTokensToReplace.add(managedObject.owningToken);
                            persistentSerializedBytesToReplace.add(serializedBytes);
                            break;
                        }
                        case 5: {
                            persistentTokensToDelete.add(managedObject.owningToken);
                        }
                    }
                    continue;
                }
                persistentTokensToOptimisticReplace.add(managedObject.owningToken);
            }
            TransactionCheckpointLogRecord transactionCheckpointLogRecord = new TransactionCheckpointLogRecord(this, persistentTokensToAdd, persistentTokensToReplace, persistentSerializedBytesToReplace, persistentTokensToOptimisticReplace, persistentTokensToDelete, this.allPersistentTokensToNotify);
            this.objectManagerState.logOutput.writeNext(transactionCheckpointLogRecord, 0L, false, false);
            this.requiresPersistentCheckpoint = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "checkpoint");
        }
    }

    protected void recoveryCompleted(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "recoveryCompleted", "transaction=" + transaction + "(Transaction)");
        }
        for (Token token : this.callbackTokens) {
            ManagedObject managedObject = token.getManagedObject();
            managedObject.recoveryCompleted(transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "recoveryCompleted");
        }
    }

    protected long getLogSpaceReserved() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogSpaceReserved)");
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogSpaceReserved", "returns logSpaceReserved=" + this.logSpaceReserved + "(long)");
        }
        return this.logSpaceReserved;
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("State Dump for:" + this.getClass().getName() + " state=" + this.state + "(int) " + stateNames[this.state] + "(String) transactionLock=" + this.transactionLock + "(TransactionLock)");
        if (this.logicalUnitOfWork == null) {
            printWriter.println("logicalUnitOfWork=null");
        } else {
            printWriter.print("logialUnitOfWork.identifier=" + this.logicalUnitOfWork.identifier + "(long)");
            if (this.logicalUnitOfWork.XID != null) {
                printWriter.print(" XID=");
                for (int i = 0; i < this.logicalUnitOfWork.XID.length; ++i) {
                    printWriter.print(Integer.toHexString(this.logicalUnitOfWork.XID[i]));
                }
            }
            printWriter.println();
        }
        printWriter.println("logSpaceReserved=" + this.logSpaceReserved + "(long) requiresPersistentCheckpoint=" + this.requiresPersistentCheckpoint + "(boolean) transactionReference=" + this.transactionReference + "(TransactionReference)");
        printWriter.println("Included Objects...");
        for (ManagedObject managedObject : this.includedManagedObjects.values()) {
            Token token = managedObject.getToken();
            printWriter.print(managedObject.toString());
            Long logSequenceNumber = (Long)this.logSequenceNumbers.get(token);
            Long managedObjectSequenceNumber = (Long)this.managedObjectSequenceNumbers.get(token);
            printWriter.print(" LSN=" + logSequenceNumber + " MSN=" + managedObjectSequenceNumber);
            ObjectManagerByteArrayOutputStream serializedBytes = (ObjectManagerByteArrayOutputStream)this.loggedSerializedBytes.get(token);
            if (serializedBytes == null) {
                printWriter.print(" serializedBytes=null");
            } else {
                printWriter.print(serializedBytes);
            }
            if (this.callbackTokens.contains(token)) {
                printWriter.println(" Callback");
                continue;
            }
            printWriter.println();
        }
    }

    private void testState(int[] nextState) throws InvalidStateException {
        int newState;
        String methodName = "testState";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "testState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
        }
        if ((newState = nextState[this.state]) == 0) {
            InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "testState", new Object[]{invalidStateException, new Integer(newState), stateNames[newState]});
            }
            throw invalidStateException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "testState");
        }
    }

    private void setState(int[] nextState) throws ObjectManagerException {
        String methodName = "setState";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
        }
        this.previousState = this.state;
        this.state = nextState[this.state];
        if (this.state == 0) {
            StateErrorException stateErrorException = new StateErrorException((Object)this, this.previousState, stateNames[this.previousState]);
            ObjectManager.ffdc.processException(this, cclass, "setState", stateErrorException, "1:2672:1.41");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setState", new Object[]{stateErrorException, new Integer(this.state), stateNames[this.state]});
            }
            throw stateErrorException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setState", new Object[]{new Integer(this.state), stateNames[this.state]});
        }
    }

    public String toString() {
        if (this.logicalUnitOfWork == null) {
            return new String("InternalTransaction(null)." + this.useCount + "/" + stateNames[this.state] + "/" + Integer.toHexString(this.hashCode()) + "/" + this.logSpaceReserved);
        }
        return new String("InternalTransaction(" + this.logicalUnitOfWork.identifier + "." + this.useCount + ")/" + stateNames[this.state] + "/" + Integer.toHexString(this.hashCode()) + "/" + this.logSpaceReserved);
    }

    protected class TransactionReference
    extends WeakReference {
        protected InternalTransaction internalTransaction;

        TransactionReference(InternalTransaction internalTransaction, Transaction externalTransaction) {
            super(externalTransaction, InternalTransaction.this.objectManagerState.orphanTransactionsQueue);
            this.internalTransaction = internalTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() throws ObjectManagerException {
            String methodName = "complete";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "complete");
            }
            InternalTransaction internalTransaction = this.internalTransaction;
            synchronized (internalTransaction) {
                if (this == this.internalTransaction.transactionReference) {
                    switch (this.internalTransaction.state) {
                        case 1: 
                        case 2: 
                        case 3: {
                            Transaction transaction = new Transaction(this.internalTransaction);
                            transaction.setTerminationReason(4);
                            trace.warning((Object)this, cclass, "complete", "InternalTransaction_BackoutOrphan", transaction);
                            this.internalTransaction.backout(false, transaction);
                        }
                    }
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "complete");
            }
        }
    }
}

