/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitors;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.monitors.helper.JvmMonitorHelper;
import com.ibm.ws.monitors.helper.JvmStats;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.stat.SPIBoundedRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIDoubleStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

@Monitor(group={"JVM"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class JVM
extends StatisticActions {
    public static final int HeapSize = 1;
    public static final int FreeMemory = 2;
    public static final int UsedMemory = 3;
    public static final int UpTime = 4;
    public static final int ProcessCPU = 5;
    public static final int GCCount = 6;
    public static final int GCTime = 7;
    private static final String template = "/com/ibm/ws/monitors/JVMMonitorStats.xml";
    private SPICountStatistic usedMemory;
    private SPICountStatistic freeMemory;
    private SPIBoundedRangeStatistic heap;
    private SPICountStatistic upTime;
    private SPIDoubleStatistic processCPU;
    private SPICountStatistic gcCount;
    private SPICountStatistic gcTime;
    private final TraceComponent tc = Tr.register(JVM.class);
    @PublishedMetric
    private final JvmStats PerformanceData;
    private static JvmMonitorHelper jHelper;
    static final long serialVersionUID = -1358033097474568512L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JVM() {
        try {
            StatsFactory.createStatsInstance("JVM", template, null, (StatisticActions)this);
        }
        catch (StatsFactoryException e) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"JVM Module is not registered with PMI", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)".JVM");
        }
        this.PerformanceData = new JvmStats(jHelper);
    }

    @Override
    public void statisticCreated(SPIStatistic s) {
        if (s.getId() == 1) {
            this.heap = (SPIBoundedRangeStatistic)s;
            this.heap.setLowerBound(jHelper.getInitHeapMemorySettings());
            this.heap.setUpperBound(jHelper.getMaxHeapMemorySettings());
        } else if (s.getId() == 3) {
            this.usedMemory = (SPICountStatistic)s;
        } else if (s.getId() == 2) {
            this.freeMemory = (SPICountStatistic)s;
        } else if (s.getId() == 4) {
            this.upTime = (SPICountStatistic)s;
        } else if (s.getId() == 5) {
            this.processCPU = (SPIDoubleStatistic)s;
        } else if (s.getId() == 6) {
            this.gcCount = (SPICountStatistic)s;
        } else if (s.getId() == 7) {
            this.gcTime = (SPICountStatistic)s;
        } else if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("Invlid stats found " + s), (Object[])new Object[0]);
        }
    }

    @Override
    public void updateStatisticOnRequest(int dataId) {
        if (dataId == 1) {
            this.heap.set(jHelper.getCommitedHeapMemoryUsage());
        }
        if (dataId == 3) {
            this.usedMemory.setCount(jHelper.getUsedHeapMemoryUsage());
        }
        if (dataId == 2 && this.heap != null && this.usedMemory != null) {
            this.freeMemory.setCount(jHelper.getCommitedHeapMemoryUsage() - jHelper.getUsedHeapMemoryUsage());
        }
        if (dataId == 6) {
            this.gcCount.setCount(jHelper.getGCCollectionCount());
        }
        if (dataId == 7) {
            this.gcTime.setCount(jHelper.getGCCollectionTime());
        }
        if (dataId == 4) {
            this.upTime.setCount(jHelper.getUptime());
        }
        if (dataId == 5) {
            this.processCPU.setDouble(jHelper.getCPU());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JVM.class);
        jHelper = new JvmMonitorHelper();
    }
}

