/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAfterCall;
import com.ibm.websphere.monitor.annotation.ProbeAtCallError;
import com.ibm.websphere.monitor.annotation.ProbeBeforeCall;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeFilter;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class ProbeMethodCallMethodAdapter
extends ProbeMethodAdapter {
    private static final String BEFORE_CALL_FILTER;
    private static final String AFTER_CALL_FILTER;
    private static final String AT_CALL_ERROR_FILTER;
    private static final Type THROWABLE_TYPE;
    private final Map<ProbeListener, ProbeFilter> beforeListeners = new HashMap<ProbeListener, ProbeFilter>();
    private final Map<ProbeListener, ProbeFilter> afterListeners = new HashMap<ProbeListener, ProbeFilter>();
    private final Map<ProbeListener, ProbeFilter> errorListeners = new HashMap<ProbeListener, ProbeFilter>();
    private boolean methodEntryFired = false;
    String methodName = null;
    String argsDescriptor = null;
    String methodOwner = null;
    Constructor<?> targetConstructor = null;
    Method targetMethod = null;
    static final long serialVersionUID = 2001034905408934105L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeMethodCallMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ProbeAtCallError probeAtCallError;
            ProbeAfterCall probeAfterCall;
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeBeforeCall probeBeforeCall = config.getProbeBeforeCall();
            if (probeBeforeCall != null) {
                ProbeFilter filter = (ProbeFilter)config.getTransformerData(BEFORE_CALL_FILTER);
                if (filter == null) {
                    filter = new ProbeFilter(probeBeforeCall.clazz(), probeBeforeCall.method(), probeBeforeCall.args(), null, null);
                    config.setTransformerData(BEFORE_CALL_FILTER, filter);
                }
                this.beforeListeners.put(listener, filter);
            }
            if ((probeAfterCall = config.getProbeAfterCall()) != null) {
                ProbeFilter filter = (ProbeFilter)config.getTransformerData(AFTER_CALL_FILTER);
                if (filter == null) {
                    filter = new ProbeFilter(probeAfterCall.clazz(), probeAfterCall.method(), probeAfterCall.args(), null, null);
                    config.setTransformerData(AFTER_CALL_FILTER, filter);
                }
                this.afterListeners.put(listener, filter);
            }
            if ((probeAtCallError = config.getProbeAtCallError()) == null) continue;
            ProbeFilter filter = (ProbeFilter)config.getTransformerData(AT_CALL_ERROR_FILTER);
            if (filter == null) {
                filter = new ProbeFilter(probeAtCallError.clazz(), probeAtCallError.method(), probeAtCallError.args(), null, null);
                config.setTransformerData(AT_CALL_ERROR_FILTER, filter);
            }
            this.errorListeners.put(listener, filter);
        }
    }

    @Override
    protected void onMethodEntry() {
        this.methodEntryFired = true;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.methodEntryFired || this.beforeListeners.isEmpty() && this.afterListeners.isEmpty() && this.errorListeners.isEmpty()) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        this.methodName = name;
        this.argsDescriptor = null;
        this.methodOwner = null;
        this.targetConstructor = null;
        this.targetMethod = null;
        Set<ProbeListener> matchingBeforeListeners = this.getMatchesByMethodName(this.beforeListeners);
        Set<ProbeListener> matchingAfterListeners = this.getMatchesByMethodName(this.afterListeners);
        Set<ProbeListener> matchingErrorListeners = this.getMatchesByMethodName(this.errorListeners);
        if (!matchingBeforeListeners.isEmpty() || !matchingAfterListeners.isEmpty()) {
            this.argsDescriptor = ProbeFilter.buildArgsDescriptor(Type.getArgumentTypes((String)desc));
            this.filterByArgsDescriptor(this.beforeListeners, matchingBeforeListeners);
            this.filterByArgsDescriptor(this.afterListeners, matchingAfterListeners);
            this.filterByArgsDescriptor(this.errorListeners, matchingErrorListeners);
        }
        if (!matchingBeforeListeners.isEmpty() || !matchingAfterListeners.isEmpty()) {
            this.methodOwner = Type.getObjectType((String)owner).getClassName();
            this.filterByMethodOwner(this.beforeListeners, matchingBeforeListeners);
            this.filterByMethodOwner(this.afterListeners, matchingAfterListeners);
            this.filterByMethodOwner(this.errorListeners, matchingErrorListeners);
        }
        if (!(matchingBeforeListeners.isEmpty() && matchingAfterListeners.isEmpty() || !this.hasAdvancedFilter(this.beforeListeners, matchingBeforeListeners) && !this.hasAdvancedFilter(this.afterListeners, matchingAfterListeners) && !this.hasAdvancedFilter(this.errorListeners, matchingErrorListeners))) {
            Class<?> targetClass = this.getOwningClass(owner);
            if ("<init>".equals(name)) {
                this.targetConstructor = this.getTargetConstructor(targetClass, desc);
                this.filterByConstructor(this.beforeListeners, matchingBeforeListeners);
                this.filterByConstructor(this.afterListeners, matchingAfterListeners);
                this.filterByConstructor(this.errorListeners, matchingErrorListeners);
            } else {
                this.targetMethod = this.getTargetMethod(targetClass, name, desc);
                this.filterByMethod(this.beforeListeners, matchingBeforeListeners);
                this.filterByMethod(this.afterListeners, matchingAfterListeners);
                this.filterByMethod(this.errorListeners, matchingErrorListeners);
            }
        }
        if (!(matchingBeforeListeners.isEmpty() && matchingAfterListeners.isEmpty() && matchingErrorListeners.isEmpty())) {
            this.processMethodInsn(opcode, owner, name, desc, matchingBeforeListeners, matchingAfterListeners, matchingErrorListeners);
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    Set<ProbeListener> getMatchesByMethodName(Map<ProbeListener, ProbeFilter> listeners) {
        Set<ProbeListener> matches = null;
        for (ProbeListener listener : listeners.keySet()) {
            ProbeFilter filter = listeners.get(listener);
            if (!filter.basicMemberNameMatches(this.methodName)) continue;
            if (matches == null) {
                matches = new HashSet<ProbeListener>();
            }
            matches.add(listener);
        }
        if (matches == null) {
            matches = Collections.emptySet();
        }
        return matches;
    }

    void filterByArgsDescriptor(Map<ProbeListener, ProbeFilter> listeners, Set<ProbeListener> matches) {
        if (matches.isEmpty()) {
            return;
        }
        Iterator<ProbeListener> it = matches.iterator();
        while (it.hasNext()) {
            ProbeListener listener = it.next();
            ProbeFilter filter = listeners.get(listener);
            if (filter.basicArgsDescriptorMatches(this.argsDescriptor)) continue;
            it.remove();
        }
    }

    void filterByMethodOwner(Map<ProbeListener, ProbeFilter> listeners, Set<ProbeListener> matches) {
        if (matches.isEmpty()) {
            return;
        }
        Iterator<ProbeListener> it = matches.iterator();
        while (it.hasNext()) {
            ProbeListener listener = it.next();
            ProbeFilter filter = listeners.get(listener);
            if (filter.basicClassNameMatches(this.methodOwner)) continue;
            it.remove();
        }
    }

    boolean hasAdvancedFilter(Map<ProbeListener, ProbeFilter> listeners, Set<ProbeListener> matches) {
        if (matches.isEmpty()) {
            return false;
        }
        for (ProbeListener listener : matches) {
            ProbeFilter filter = listeners.get(listener);
            if (!filter.isAdvancedFilter()) continue;
            return true;
        }
        return false;
    }

    void filterByConstructor(Map<ProbeListener, ProbeFilter> listeners, Set<ProbeListener> matches) {
        if (matches.isEmpty()) {
            return;
        }
        Iterator<ProbeListener> it = matches.iterator();
        while (it.hasNext()) {
            ProbeListener listener = it.next();
            ProbeFilter filter = listeners.get(listener);
            if (filter.matches(this.targetConstructor)) continue;
            it.remove();
        }
    }

    void filterByMethod(Map<ProbeListener, ProbeFilter> listeners, Set<ProbeListener> matches) {
        if (matches.isEmpty()) {
            return;
        }
        Iterator<ProbeListener> it = matches.iterator();
        while (it.hasNext()) {
            ProbeListener listener = it.next();
            ProbeFilter filter = listeners.get(listener);
            if (filter.matches(this.targetMethod)) continue;
            it.remove();
        }
    }

    void processMethodInsn(int opcode, String owner, String name, String desc, Set<ProbeListener> matchingBeforeListeners, Set<ProbeListener> matchingAfterListeners, Set<ProbeListener> matchingErrorListeners) {
        boolean nullTarget;
        boolean enabledBefore = !matchingBeforeListeners.isEmpty();
        boolean enabledAfter = !matchingAfterListeners.isEmpty();
        boolean enabledError = !matchingErrorListeners.isEmpty();
        this.setProbeInProgress(true);
        boolean bl = nullTarget = opcode == 184;
        if (enabledBefore || enabledAfter && !nullTarget) {
            this.replaceArgsWithArray(desc);
        }
        if (enabledAfter && !nullTarget) {
            this.visitInsn(92);
            this.visitInsn(87);
            this.visitInsn(95);
        }
        if (enabledBefore) {
            this.beforeVisitMethodInsn(matchingBeforeListeners, opcode, owner, name, desc, nullTarget);
        }
        if (enabledBefore || enabledAfter && !nullTarget) {
            this.restoreArgsFromArray(desc);
        }
        this.setProbeInProgress(false);
        super.visitMethodInsn(opcode, owner, name, desc, false);
        if (enabledAfter) {
            this.setProbeInProgress(true);
            this.afterVisitMethodInsn(matchingAfterListeners, opcode, owner, name, desc, nullTarget);
            this.setProbeInProgress(false);
        }
    }

    void beforeVisitMethodInsn(Set<ProbeListener> listeners, int opcode, String owner, String name, String desc, boolean nullTarget) {
        String key = this.createKey("BEFORE", owner, name, desc);
        ProbeImpl probe = this.getProbe(key);
        long probeId = probe.getIdentifier();
        if (nullTarget || opcode == 183 && "<init>".equals(name)) {
            this.visitInsn(89);
            this.visitInsn(1);
            this.visitInsn(95);
        } else {
            this.visitInsn(92);
        }
        this.visitLdcInsn(probeId);
        this.visitInsn(94);
        this.visitInsn(88);
        if (this.isStatic()) {
            this.visitInsn(1);
        } else {
            this.visitVarInsn(25, 0);
        }
        this.visitInsn(91);
        this.visitInsn(87);
        this.visitFireProbeInvocation();
        this.setProbeListeners(probe, listeners);
    }

    void afterVisitMethodInsn(Set<ProbeListener> listeners, int opcode, String owner, String name, String desc, boolean nullTarget) {
        String key = this.createKey("AFTER", owner, name, desc);
        ProbeImpl probe = this.getProbe(key);
        long probeId = probe.getIdentifier();
        Type returnType = Type.getReturnType((String)desc);
        if (returnType.getSort() == 0) {
            if (nullTarget) {
                this.visitInsn(1);
                this.visitInsn(1);
            } else {
                this.visitInsn(1);
            }
        } else if (returnType.getSize() == 2) {
            if (nullTarget) {
                this.visitInsn(92);
                this.box(returnType);
                this.visitInsn(1);
                this.visitInsn(95);
            } else {
                this.visitInsn(93);
                this.box(returnType);
            }
        } else if (nullTarget) {
            this.visitInsn(89);
            this.box(returnType);
            this.visitInsn(1);
            this.visitInsn(95);
        } else {
            this.visitInsn(90);
            this.box(returnType);
        }
        this.visitLdcInsn(probeId);
        this.visitInsn(94);
        this.visitInsn(88);
        if (this.isStatic()) {
            this.visitInsn(1);
        } else {
            this.visitVarInsn(25, 0);
        }
        this.visitInsn(91);
        this.visitInsn(87);
        this.visitFireProbeInvocation();
        this.setProbeListeners(probe, listeners);
    }

    String createKey(String stem, String owner, String methodName, String desc) {
        StringBuilder sb = new StringBuilder("METHOD_CALL: ").append(stem).append(" ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        sb.append(" calls ");
        sb.append(owner).append(".").append(methodName).append(desc);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeMethodCallMethodAdapter.class);
        BEFORE_CALL_FILTER = ProbeBeforeCall.class.getSimpleName() + ":Filter";
        AFTER_CALL_FILTER = ProbeAfterCall.class.getSimpleName() + ":Filter";
        AT_CALL_ERROR_FILTER = ProbeAtCallError.class.getSimpleName() + ":Filter";
        THROWABLE_TYPE = Type.getType(Throwable.class);
    }
}

