/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.monitor.meters;

import com.ibm.websphere.monitor.meters.StatisticsMXBean;
import com.ibm.websphere.monitor.meters.StatisticsReading;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

@Trivial
public class StatisticsMeter
extends com.ibm.websphere.monitor.jmx.StatisticsMeter
implements StatisticsMXBean {
    private final AtomicReference<StatsData> terminatedThreadStats = new AtomicReference<StatsData>(new StatsData());
    private final Set<StatsDataReference> allReferences = Collections.synchronizedSet(new HashSet());
    private final ReferenceQueue<ThreadStats> statisticsReferenceQueue = new ReferenceQueue();
    private final StatsThreadLocal threadStats = new StatsThreadLocal();

    public void addDataPoint(long value) {
        this.threadStats.getStatsData().addDataPoint(value);
    }

    @Override
    public long getMinimumValue() {
        return this.getAggregateStats().min;
    }

    @Override
    public long getMaximumValue() {
        return this.getAggregateStats().max;
    }

    @Override
    public double getTotal() {
        return this.getAggregateStats().total;
    }

    @Override
    public double getMean() {
        return this.getAggregateStats().mean;
    }

    @Override
    public double getVariance() {
        return this.getAggregateStats().getVariance();
    }

    @Override
    public double getStandardDeviation() {
        return Math.sqrt(this.getAggregateStats().getVariance());
    }

    @Override
    public long getCount() {
        return this.getAggregateStats().count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatsData getAggregateStats() {
        HashSet<StatsData> dataSet = new HashSet<StatsData>();
        Set<StatsDataReference> set = this.allReferences;
        synchronized (set) {
            dataSet.add(this.terminatedThreadStats.get().getCopy());
            for (StatsDataReference ref : this.allReferences) {
                dataSet.add(ref.statsData.getCopy());
            }
        }
        this.cleanup();
        return StatisticsMeter.aggregateStats(dataSet);
    }

    static StatsData aggregateStats(StatsData ... dataSet) {
        return StatisticsMeter.aggregateStats(Arrays.asList(dataSet));
    }

    static StatsData aggregateStats(Collection<StatsData> dataSet) {
        StatsData combined = new StatsData();
        for (StatsData stats : dataSet) {
            if (stats.count == 0L) continue;
            if (combined.total == 0.0) {
                combined.min = stats.min;
                combined.max = stats.max;
            }
            combined.total += stats.total;
            combined.count += stats.count;
            combined.mean = combined.total / (double)combined.count;
            combined.min = Math.min(combined.min, stats.min);
            combined.max = Math.max(combined.max, stats.max);
            double meanDifference = stats.mean - combined.mean;
            combined.varianceNumeratorSum += stats.varianceNumeratorSum + (double)stats.count * meanDifference * meanDifference;
        }
        return combined;
    }

    private void cleanup() {
        StatsDataReference ref = null;
        while ((ref = (StatsDataReference)this.statisticsReferenceQueue.poll()) != null) {
            StatsData oldStats = null;
            StatsData updatedStats = null;
            do {
                oldStats = this.terminatedThreadStats.get();
            } while (!this.terminatedThreadStats.compareAndSet(oldStats, updatedStats = StatisticsMeter.aggregateStats(oldStats, ref.statsData)));
            this.allReferences.remove(ref);
        }
    }

    @Override
    public StatisticsReading getReading() {
        StatsData sd = this.getAggregateStats();
        return new StatisticsReading(sd.count, sd.min, sd.max, sd.total, sd.mean, sd.getVariance(), Math.sqrt(sd.getVariance()), this.getUnit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.terminatedThreadStats == null ? "is not initialized" : this.getAggregateStats());
        return sb.toString();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private final class StatsThreadLocal
    extends ThreadLocal<ThreadStats> {
        static final long serialVersionUID = -8913652297926950101L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StatsThreadLocal() {
        }

        @Override
        public ThreadStats initialValue() {
            ThreadStats threadStats = new ThreadStats();
            StatisticsMeter.this.allReferences.add(new StatsDataReference(threadStats));
            StatisticsMeter.this.cleanup();
            return threadStats;
        }

        public StatsData getStatsData() {
            return ((ThreadStats)this.get()).statsData;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StatsThreadLocal.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private final class StatsDataReference
    extends WeakReference<ThreadStats> {
        final StatsData statsData;
        static final long serialVersionUID = 1688825054826113462L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        StatsDataReference(ThreadStats threadStats) {
            super(threadStats, StatisticsMeter.this.statisticsReferenceQueue);
            this.statsData = threadStats.statsData;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(StatsDataReference.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    private final class ThreadStats {
        final StatsData statsData = new StatsData();
        static final long serialVersionUID = 125603064543200407L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ThreadStats() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ThreadStats.class);
        }
    }

    @Trivial
    static final class StatsData {
        long count;
        long min;
        long max;
        double total;
        double mean;
        double varianceNumeratorSum;

        StatsData() {
        }

        synchronized double getVariance() {
            return this.count <= 1L ? 0.0 : this.varianceNumeratorSum / (double)(this.count - 1L);
        }

        synchronized void addDataPoint(long value) {
            if (this.count == 0L) {
                this.min = value;
                this.max = value;
            }
            double delta = (double)value - this.mean;
            ++this.count;
            this.total += (double)value;
            this.mean += delta / (double)this.count;
            this.varianceNumeratorSum += delta * ((double)value - this.mean);
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
        }

        synchronized StatsData getCopy() {
            StatsData copy = new StatsData();
            copy.count = this.count;
            copy.min = this.min;
            copy.max = this.max;
            copy.total = this.total;
            copy.mean = this.mean;
            copy.varianceNumeratorSum = this.varianceNumeratorSum;
            return copy;
        }

        public String toString() {
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            StringBuilder sb = new StringBuilder();
            StatsData stats = this.getCopy();
            sb.append("count=").append(stats.count);
            sb.append(" total=").append(Math.round(stats.total));
            sb.append(" mean=").append(decimalFormat.format(stats.mean));
            sb.append(" variance=").append(decimalFormat.format(stats.getVariance()));
            sb.append(" stddev=").append(decimalFormat.format(Math.sqrt(stats.getVariance())));
            sb.append(" min=").append(stats.min);
            sb.append(" max=").append(stats.max);
            return sb.toString();
        }
    }
}

